C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c
c
c     program module compsort  -  multicomponent sort
c
c**********************************************************************c
c
c     compsort reads a siesmic trace from the command line,
c     and creates an output in the order of entries in
c     a table to create an output stream ordered on the
c     gi, si, di or distance with component selection/ordering
c
c subroutine calls: rtape, hlh, wrtape, save, dagc, odd
c
c**********************************************************************c
c
c     declare variables
c
#include <localsys.h>
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
      integer     itr ( SZLNHD )
      integer     ltr ( SZLNHD )
      integer     lhed( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform, rind, tind
      integer     luin , luout, lbytes, nbytes
      integer     istart,iend, nsampo,obytes
#include <f77/pid.h>
      integer     reccnt(4),trccnt(4),mpair(SZSPRD),mdis(SZSPRD)
      integer     trc,rec,ntuple,pair(9),npair(9),mcomp
      integer     currec, curtrc,newdis,olddis
      integer     gimin, gidel,recind,gival
      real        tri ( SZLNHD )
      real        lri ( SZLNHD )
      character   name * 8,   ntap * 256, otap * 256, tnam * 256
      character   TrWrdr * 6, TrWrds * 6
      logical     verbos, query, G, S, D, R, X, leave, first
      integer     argis

c     equivalence ( itr(129), tri (1) )
c     equivalence ( ltr(129), lri (1) )
      equivalence ( itr(  1), lhed(1), tri(1) )
      data name     /'COMPSORT'/
      data lbytes / 0 /, nbytes / 0 /, leave / .false. /
      data ltr / SZLNHD * 0 /
      data first/.true./

c-----
c
c     read program parameters from command line card image file
c
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif

c-----
c     open printout file
c-----
#include <f77/open.h>

      call gcmdln(ntap,otap,tnam,G,S,D,R,X,verbos,leave,
     &             istart,iend,nsampo,TrWrdr,TrWrds)

c-----
c     get logical unit numbers for input and output
c-----
      call getln(luin , ntap,'r', 0)
      if (luin .eq. 0) then
         write(LERR,*)'Cannot pipe into compsort'
         write(LERR,*)'Use -Nindata on command line where indata'
         write(LERR,*)'refers to a disk file (including full path)'
         write(LERR,*)'if data not in current working directory'
         stop
      endif

      call getln(luout, otap,'w', 1)
      call sislgbuf( luin, 'off' )

c-----
c     guarantee that we can work with the files
c-----
       if(tnam(1:1).eq.' ')then
              luns = LIN
       else
              luns = 22
              open(luns,file=tnam,status='old',
     1                     form='formatted',access='sequential')
              rewind luns
       endif
       if(luin.eq.0)then
              write(LER,*)'DATA FILE must be given as -Nntap'
              write(LER,*)'FATAL ERROR'
              stop
       endif
c logical units in effect
      write(LERR,*)'LER=  ',LER,'  LERR=  ',LERR
      write(LERR,*)'luin=  ',luin,'  luout=  ',luout,'  luns=  ',luns

c-----
c     read line header of input
c     save certain parameters
c-----
      call rtape  ( luin, itr, lbytes                  )
      write(LERR,*)'lbytes= ',lbytes
      if(lbytes .eq. 0) then
             write(LOT,*)'gsort: no header read from unit ',luin
             write(LOT,*)'FATAL'
             stop
      endif

      call hlhprt ( itr , lbytes, name, 8, LERR        )

c-----
c     get line header information
c-----
#include <f77/saveh.h>
c------
c     save certain parameters
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
 
      call savelu('TrcNum',ifmt,l_TrcNum,length,TRACEHEADER)
      call savelu('RecNum',ifmt,l_RecNum,length,TRACEHEADER)
      call savelu('SrcLoc',ifmt,l_SrcLoc,length,TRACEHEADER)
      call savelu('RecInd',ifmt,l_RecInd,length,TRACEHEADER)
      call savelu('DphInd',ifmt,l_DphInd,length,TRACEHEADER)
      call savelu('DstSgn',ifmt,l_DstSgn,length,TRACEHEADER)
      call savelu('DstUsg',ifmt,l_DstUsg,length,TRACEHEADER)
      call savelu('StaCor',ifmt,l_StaCor,length,TRACEHEADER)

      call savelu( TrWrdr ,ifmt,l_TrWrdr,length,TRACEHEADER)
      call savelu( TrWrds ,ifmt,l_TrWrds,length,TRACEHEADER)

      nsampo = nsampo/nsi
      if(nsampo .le. 0) nsampo = nsamp
      obytes = SZTRHD + SZSMPD * nsampo
      lbytes4 = lbytes + SZSAMP
      nbytes4 = SZDTHD + SZSAMP * nsamp + SZSAMP
c-----
c     modify line header to reflect actual number of traces output
c-----
c  check for old table & abort if necessary
      read(luns,*,end=7) itype
      if(itype .ne. -1) then
c  old table
      write(LERR,*)'Sort table is old: run presort step again'
      stop
      endif
      go to 9
c  new table
    7 continue
      write(LERR,*)'Premature end of file on sort table'
      write(LERR,*)'check presort run & repeat if necessary'
      stop
    9 continue
      read(luns,*,end=11)ndat,ntuple
      go to 12
   11 continue
      write(LERR,*)'sort table incorrect: number components missing'
      write(LERR,*)'Need to run presortc to build multicomponent'
      write(LERR,*)'table'
      stop
   12 continue
      write(LERR,*)'number entries in sort table= ',ndat
      write(LERR,*)'number receiver/source components= ',ntuple
      read(luns,*)(pair(i),i=1,ntuple)
      write(LERR,*)'component pairs=  ',(pair(i),i=1,ntuple)
      read(luns,*)(reccnt(i),trccnt(i),i=1,4)
      write(LERR,*)(reccnt(i),trccnt(i),i=1,4)
      read(luns,*)gimin,gidel
      if(G)then
            nrecc = reccnt(1)
            jtr   = trccnt(1)
      elseif(S)then
            nrecc = reccnt(2)
            jtr   = trccnt(2)
      elseif(D)then
            nrecc = reccnt(3)
            jtr   = trccnt(3)
      elseif(R)then
            nrecc = reccnt(4)
            jtr   = reccnt(1)
      elseif(X)then
            nrecc = reccnt(4)
            jtr   = trccnt(4)
      endif
      if(iend .ne. 0) then
         nrecc = iend - istart + 1
      else
         iend = 1000000
      endif
      call savew(itr, 'NumRec', nrecc, LINHED)
      call savew(itr, 'NumTrc', jtr  , LINHED)
      call savew(itr, 'NumSmp', nsampo,LINHED)
c-----
c     put in number of traces per ntuple; write out line header
c-----
      call savew( itr, 'RATTrc',  ntuple , LINHED)
      call savhlh( itr, lbytes, lbyout)
      call wrtape ( luout, itr, lbyout                 )
c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
c     if( verbos ) then
            call verbal(nsamp, nsi, ntrc, nrec, 
     1           ntap,otap,tnam,G,S,D,R,X,istart,iend,nsampo,
     2           l_TrWRdr,l_TrWrds)
c     end if
c-----
c     BEGIN PROCESSING
c     process desired trace records
c-----

      mcomp = 0
      currec = 1
      curtrc = 1
      gival  = gimin

      if(verbos)write(LERR,*)'# recs= ',nrecc, ' # trc/rec= ',jtr,
     1           ' istart= ',istart,' iend= ',iend

c----------
c  read each line of presort table
c  pick off appropriate index and its associated rec & trc #'s
c  these #'s are then used to pick off the correct sorted trace
c  from somewhere in the input disk data set
c----------

      do 1000 jjj = 1, ndat

      if (verbos) then
         write(LERR,*)' '
         write(LERR,*)' '
         write(LERR,*)'New presort line  ',jjj
         write(LERR,*)' '
      endif

      read(luns,*,end=9999)i1,i2,i3,i4,i5,i6,i7,i8,i9,i10,i11,i12
            if(R)then
                  jj  = i10
                  rec = i11
                  trc = i12
            elseif(S)then
                  rec = i6
                  trc = i7
                  jj = i2
 
          if (i6 .eq. 0 .or. i7 .eq. 0) then
             write(LERR,*)'Source indx at line ',jjj,' of presort table'
             write(LERR,*)'has rec# or trc# of zero -- FATAL ERROR:'
             write(LERR,*)'Check your data for zero Source indices'
             write(LERR,*)'Fix up using ufh script or re-prep'
             stop
          endif

            elseif(G)then
                  rec = i4
                  trc = i5
                  jj = i1
          if (i4 .eq. 0 .or. i5 .eq. 0) then
             write(LERR,*)'Group index at line ',jjj,' of presort table'
             write(LERR,*)'has rec# or trc# of zero -- FATAL ERROR:'
             write(LERR,*)'Check your data for zero Group indices'
             write(LERR,*)'Fix up using ufh script or re-prep'
             stop
          endif

            elseif(D)then
                  rec = i8
                  trc = i9
                  jj = i3
 
          if (i8 .eq. 0 .or. i9 .eq. 0) then
             write(LERR,*)'Depth index at line ',jjj,' of presort table'
             write(LERR,*)'has rec# or trc# of zero -- FATAL ERROR:'
             write(LERR,*)'Check your data for zero Depth indices'
             write(LERR,*)'Fix up using ufh script or re-prep'
             stop
          endif

            elseif(X)then
                  rec = i11
                  trc = i12
                  jj  = i10
 
          if (i11 .eq. 0 .or. i12 .eq. 0) then
             write(LERR,*)'Offset indx at line ',jjj,' of presort table'
             write(LERR,*)'has rec# or trc# of zero -- FATAL ERROR:'
             write(LERR,*)'Check your data for zero Offst indices'
             write(LERR,*)'Fix up using ufh script or re-prep'
             stop
          endif

            endif

c-------------
c  is the sort index within the user
c  specified range?
c-------------
         IF (jj .ge. istart .and. jj .le. iend) THEN

            call dif(irccnt,itrcnt,jjj,jj,jump,first)
            if(verbos) then
                      write(LERR,*)' '
                      write(LERR,*)' '
                      write(LERR,*)'irccnt= ',irccnt,'  itrcnt= ',
     1                itrcnt,'  jjj= ',jjj,'  jj= ',jj,'  jump= ',jump
                      write(LERR,*)' '
            endif

c-----
c      if we have jumped to a new record or if we are at
c      the end of a data set, output necessary blank
c      traces at the end to fill in the record
c-----
            if(jump.eq.1 )then
              if(verbos)
     1        write(LERR,*)'Start new record: jtr= ',jtr
              if(jj .ge. istart .and. jj .le. iend) then
                  if(curtrc.ge.1 .and. curtrc.le.jtr)then
                  if(verbos)
     1            write(LERR,*)'currec= ',currec,' curtrc= ',curtrc
                  call nultrc(ltr,lri,verbos,obytes,luout,
     1                  currec,curtrc-1,jtr,nsamp,iform,
     2                  mcomp,mpair,mdis,pair,ntuple,
     3                  l_TrcNum,l_RecNum,l_SrcLoc,l_RecInd,l_DphInd,
     4                  l_DstSgn,l_DstUsg,l_StaCor,l_TrWRdr,l_TrWrds)

                  endif
              endif
                  currec = currec + 1
                  curtrc = 1
                  gival = gimin
              endif

            if(verbos)write(LERR,*)i1,i2,i3,i4,i5,i6,i7,
     1            i8,i9,i10,i11,i12

c           ioff = lbytes4 + ((rec-1)*ntrc + (trc-1))*nbytes4
c           call seekt ( luin, ioff )
            ioff = (rec-1)*ntrc + trc
            call sisseek (luin, ioff)

            nbytes = 0
            call rtape( luin, itr, nbytes)
            if(nbytes .eq. 0) then
              write(LERR,*)' '
              write(LERR,*)'read failed at rec, trc= ',rec,trc
              write(LERR,*)' '
              write(LERR,*)'presort table line...'
              write(LERR,*)i1,i2,i3,i4,i5,i6,i7,i8,i9,i10,i11,i12
              write(LERR,*)' '
              write(LERR,*)'Try rerunning presortc on data to build'
              write(LERR,*)'a new table.  Has your data changed since'
              write(LERR,*)'sort table was built?'
              stop
            endif
            recind = itr(l_RecInd)
            rind   = itr(l_RecNum)
            tind   = itr(l_TrcNum)

            if(verbos)write(LERR,*)'recind=',recind,' rind= ',rind,
     &                             ' tind= ',tind,' nbytes= ',nbytes
            if(.not. leave) then
               itr(l_RecNum) = currec
               itr(l_TrcNum) = curtrc
            endif
            curtrc = curtrc + 1
            call miscmp(itr,curtrc,newdis,olddis,pair,npair,mpair,mdis,
     1                  mcomp,nd,ntuple,
     2                  l_TrcNum,l_RecNum,l_SrcLoc,l_RecInd,l_DphInd,
     3                  l_DstSgn,l_DstUsg,l_StaCor,l_TrWRdr,l_TrWrds)


            call wrtape( luout, itr, obytes)
            gival = gival + 1
            if(verbos)write(LERR,*)'rec trc gival',currec, 
     1            curtrc, gival,recind

         ENDIF

 1000       continue
            currec = currec + 1
            if(curtrc.lt.jtr)then
                  if(verbos)
     1            write(LERR,*)'End of line:  currec= ',currec,
     2                          ' curtrc= ',curtrc
                  call nultrc(ltr,lri,verbos,obytes,luout,
     1                  currec-1,curtrc-1,jtr,nsamp,iform,
     2                  mcomp,mpair,mdis,pair,ntuple,
     2                  l_TrcNum,l_RecNum,l_SrcLoc,l_RecInd,l_DphInd,
     3                  l_DstSgn,l_DstUsg,l_StaCor,l_TrWRdr,l_TrWrds)
            endif
 9999 continue
c-----
c     close data files
c-----
      call lbclos ( luin )
      call lbclos ( luout )
      if(verbos) then
            write(LERR,*)'end of gsort, processed',nrec,' record(s)',
     1            ' with ',ntrc, ' traces'
      endif
      end

       subroutine dif(ir,it,i,j,jump,first)
c-----
c      increment record count (ir) and trace count (it)
c      whenever j changes
c      i is the initialization flag
c      jump indicates that a transition to a new record has occurred
c-----
       logical first
c      static  oldj, nt, nr
       save    oldj, nt, nr

       if(first)then
              ir = 1
              it = 1
              nt = 1
              nr = 1
              oldj = j
              jump = 0
              first = .false.
       else
c--------------------------------------------
c  oldj is last
c  sort index #
c  nt = new trc seq
c  nr = new rec seq

              if(j .le. oldj)then
                     nt = nt + 1
                     it = it + 1
                     jump=0
              else
                     nr = nr + 1
                     if(nt.gt.it)it=nt
                     nt = 1
                     it = 1
                     ir = nr
                     oldj = j
                     jump = 1
              endif
       endif
       return
       end

      subroutine nultrc(itr,tri,verbos,nbytes,luout,
     1               currec,j1,j2,nsamp,iform,
     2               mcomp,mpair,mdis,pair,ntuple,
     2                  l_TrcNum,l_RecNum,l_SrcLoc,l_RecInd,l_DphInd,
     3                  l_DstSgn,l_DstUsg,l_StaCor,l_TrWRdr,l_TrWrds)
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
      integer     nsamp, iform, j1, j2, i15, i16, i1516, ic
      integer * 2 itr ( SZLNHD )
      real        tri ( SZLNHD )
      integer     currec,mcomp,mpair(*),mdis(*),pair(*),ntuple
      integer     luout, dis
      logical     verbos

            itr(l_StaCor) = 30000
            ic = mcomp
            im = 0
            do 1002 j = j1+1+mcomp, j2
                        im = im + 1
                        ic = ic + 1
                        if(im .gt. ntuple) im=1
                        mpair(ic) = pair(im)
 1002       continue
            ic = 0
c     write(LERR,*)'mcomp= ',mcomp,' mpair= ',(mpair(l),l=1,mcomp)
c     write(LERR,*)'mdis= ',(mdis(l),l=1,mcomp)
            do 1001 i=j1+1,j2
                  ic = ic + 1
                  dis = mdis(ic)
                  i1516 = mpair(ic)
                  call decode(i15,i16,i1516)
                  if(verbos)write(LERR,*)'Null outputting rec='
     1                  ,currec,' trace=',i
c                 write(LERR,*)'dis= ',dis,' comp= ',i1516
                  itr(l_RecNum)  = currec
                  itr(l_TrcNum)  = i
                  itr(l_TrWRdr)  = i15
                  itr(l_TrWrds)  = i16
                  itr(l_DstUsg)  = iabs(dis)
                  itr(l_DstSgn)  = dis
                  call wrtape( luout, itr, nbytes)
 1001       continue
            mcomp = 0
      return
      end

      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     1'***************************************************************'
      write(LER,*)
     1'execute gsort by typing compsort and  list of program parameters'
      write(LER,*)
     1'note that each parameter is proceeded by -a where "a" is '
      write(LER,*)
     1'a character(s) corresponding to some parameter.'
        write(LER,*)' '
        write(LER,*)
     1'users enter the following parameters, or use the default values'
        write(LER,*)
     1' -N [ntap]    (no default)       : input data file name'
        write(LER,*)
     1' -O [otap]    (default = stdout ): output data file name'
       write(LER,*)
     1' -n [tnam]    (default = stdin)  : sort table name'
        write(LER,*)' '
        write(LER,*)
     1' -Hwr [TrWrdr](default = ToStUn ) : rcvr component header word'
        write(LER,*)
     1' -Hws [TrWrds](default = ToTmAU ) : src component header word'
        write(LER,*)
     1' -e [time]    (default = input )  : output trace length (ms)'
        write(LER,*)
     1' -l [istart]  (default = first )  : starting record to sort'
        write(LER,*)
     1' -m [iend]    (default = last )   : ending record to sort'
        write(LER,*)' '
       write(LER,*)
     1' -L           (default = false)  : leave original rec/trc nos.'
       write(LER,*)
     1' -G           (default = false)  : sort on receiver index'
       write(LER,*)
     1' -S           (default = false)  : sort on source index  '
       write(LER,*)
     1' -D           (default = false)  : sort on depth index'
       write(LER,*)
     1' -R           (default = false)  : sort on distance-zero pad'
       write(LER,*)
     1' -X           (default = false)  : sort on distance-no pad'
        write(LER,*)
     1' NOTE only one of -G -R -S or -D can be given'
        write(LER,*)' '
       write(LER,*)
     1'usage:   gsort -N[ntap] -O[otap] -e[] -G -R -S -D -X',
     2' -n[tnam] -Hwr[] -Hws[] -V'
         write(LER,*)
     1'***************************************************************'
      return
      end

      subroutine gcmdln(ntap,otap,tnam,G,S,D,R,X,verbos, leave,
     &                       istart, iend, nsampo,TrWrdr,TrWrds)
c-----
c     get command arguments
c
c     ntap  - C*100     input file name
c     otap  - C*100     output file name
c     tnam  - C*100     sort table file name
c   istart  - I         start sort record
c    iend   - I         stop sort record
c   leave   - L         leave trace & record number the same as input
c     G     - L         Sort on receiver index
c     S     - L         Sort on source index
c     D     - L         Sort on depth index
c     R     - L         Sort on distance
c     X     - L         Sort on distance - no null trace padding
c     verbos- L   verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*), tnam*(*)
      character   TrWrdr * 6, TrWrds * 6
      logical     verbos, leave, G, S, D, R, X
      integer     argis,istart,iend

            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argstr( '-n', tnam, ' ', ' ' )
            call argstr( '-Hwr', TrWrdr, 'ToStUn', 'ToStUn' )
            call argstr( '-Hws', TrWrds, 'ToTmAU', 'ToTmAU' )
            call argi4('-e',nsampo,0,0)
            call argi4('-l',istart,1,1)
            call argi4('-m',iend,0,0)
            verbos = ( argis( '-V' ) .gt. 0 )
            leave = ( argis( '-L' ) .gt. 0 )
            G = ( argis( '-G' ) .gt. 0 )
            D = ( argis( '-D' ) .gt. 0 )
            S = ( argis( '-S' ) .gt. 0 )
            R = ( argis( '-R' ) .gt. 0 )
            X = ( argis( '-X' ) .gt. 0 )
c-----
c     ensure than no more than one processing option is taken
            icmd = 0
            if(G)icmd=icmd+1
            if(D)icmd=icmd+1
            if(R)icmd=icmd+1
            if(S)icmd=icmd+1
            if(X)icmd=icmd+1
            if(icmd.ne.1)then
                  write(LER,*)'FATAL ERROR'
                  call help()
                  stop
            endif
      return
      end

      subroutine verbal(nsamp, nsi, ntrc, nrec, 
     1        ntap,otap,tnam,G,S,D,R,X,istart,iend,nsampo,
     2           l_TrWRdr,l_TrWrds)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4 number of samples in trace
c     nsi   - I*4 sample interval in ms
c     ntrc  - I*4 traces per record
c     nrec  - I*4 number of records per line
c     iform - I*4 format of data
c     ntap  - C*100     input file name
c     otap  - C*100     output file name
c     tnam  - C*100     sort table name
c     G     - L     arrange by receiver index
c     S     - L     arrange by source index
c     D     - L     arrange by CDP index
c     R     - L     arrange by distance
c     X     - L     arrange by distance no trace padding
c-----
#include <f77/iounit.h>
      integer*4 nsamp, nsi, ntrc, nrec, istart, iend
      character ntap*(*), otap*(*), tnam*(*)
      logical D, S, R, G, X

            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' output data set name=  ', otap
            write(LERR,*) ' sort table name     =  ',tnam
            write(LERR,*) ' output trace lenght =  ',nsampo
            write(LERR,*) ' start record        =  ',istart
            write(LERR,*) ' end record          =  ',iend
            write(LERR,*) ' receiver component  =  ',l_TrWRdr
            write(LERR,*) ' source component    =  ',l_TrWRds
            write(LERR,*) ' sort by receiver ind=  ',G
            write(LERR,*) ' sort by source index=  ',S
            write(LERR,*) ' sort by depth index =  ',D
            write(LERR,*) ' sort by distance    =  ',R
            write(LERR,*) ' sort by dist-no fill=  ',X
            write(LERR,*)' '
            write(LERR,*)' '

      return
      end
c
      subroutine miscmp(itr,curtrc,newdis,olddis,pair,npair,
     1                   mpair,mdis,mcomp,nd,ntuple,
     2                  l_TrcNum,l_RecNum,l_SrcLoc,l_RecInd,l_DphInd,
     3                  l_DstSgn,l_DstUsg,l_StaCor,l_TrWRdr,l_TrWrds)
#include <f77/sisdef.h>
      integer curtrc,newdis,olddis,mcomp,nd,key(9)
      integer * 2 itr(*)
      integer pair(*),npair(*),mpair(*),mdis(*),i15,i16,i1516
c
      newdis = itr( l_DstSgn)
      i15    = itr( l_TrWRdr)
      i16    = itr( l_TrWrds)
c
      if(curtrc .eq. 1) then
        olddis = newdis
        nd = 0
      endif
      if(newdis .eq. olddis) then
        call encode(i15,i16,i1516)
        nd = nd+1
        npair(nd) = i1516
      else
        call sort(npair,key,nd)
        k = 1
        do 1 j = 1, ntuple
           call find(pair(j),npair,nd,ipos)
           if(ipos .eq. 0) then
              npair(nd+k) = pair(j)
              k = k + 1
           endif
    1   continue
        do 2 j = nd+1, ntuple
           mcomp = mcomp + 1
           mpair(mcomp) = npair(j)
           mdis(mcomp) = olddis
    2   continue
        olddis = newdis
        nd = 1
        call encode(i15,i16,npair(nd))
      endif
      return
      end
      subroutine sort(ix,key,no)
c-----
c     This provides a sort of items
c     x(i) is the array to be sorted
c     key(i) is the pointer array
c     no is the number of points to be sorted
c     After the sort x(i) will be ordered from least to
c           greatest
c     key(1) will point to the position in the original array
c     with the least value
c-----
      dimension ix(1),key(1)
      do 1 i=1,no
    1 key(i)=i
      mo=no
    2 if(mo-15)21,21,23
   21 if(mo-1)29,29,22
   22 mo=2*(mo/4)+1
      goto 24
   23 mo=2*(mo/8)+1
   24 ko=no-mo
      jo=1
   25 i=jo
   26 if(ix(i)-ix(i+mo))28,28,27
   27 temp=ix(i)
      ix(i)=ix(i+mo)
      ix(i+mo)=temp
      kemp=key(i)
      key(i)=key(i+mo)
      key(i+mo)=kemp
      i=i-mo
      if(i-1)28,26,26
   28 jo=jo+1
      if(jo-ko)25,25,2
   29 return
      end

