C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
**********************************************************************c

c     gthrplot prepares plotfiles (shot and/or receiver) for aqplot

c**********************************************************************c
c        LER  is the current window.
c        LERR is a standard output file; will appear in directory as
c             SPSAPS.prcid.
c
c     declare variables
c
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c declare standard usp variables
      character*7   name
      character*255 srcaqp, rcvaqp, relsps, gthaqp
      integer       argis, lusrc, lurcv, lurel
      logical       verbos, query, gotshot

c declare program-specific variables
      character*1   S, R, L
      character*9   dum9
      character*13  dum13
      character*12  pcodes
      character*80  card

      integer  strint, length
      integer  lindx, lindxs, lindxr
      integer  isrc, jsrc, ksrc
      integer  jrcvr

c initialize variables

      data name/'GTHRPLO'/,pcodes/'     0     0'/,S/'S'/,R/'R'/,L/'L'/

c issue command line help if requested 

      query = ( argis( '-?' ) .gt. 0 .or. argis( '-h' ) .gt. 0 )
      if ( query ) then
         call help()
         stop
      endif
 
c open printout files

#include <f77/open.h>
 
c read command line arguments
      call cmdln(srcaqp, rcvaqp, relsps, ksrc, verbos)

*      write(LER,*) ksrc, relsps
      if (ksrc .eq. 0) then
         write(LER,*) 'You must specify a shot point index.'
         write(LER,*) 'Use  gthrplot -h  for help.'
         stop
      endif

*     open input files
      call alloclun(lusrc)
      length = lenth(srcaqp)
      open ( lusrc, file=srcaqp(1:length), status='old', err=980)
      if ( verbos ) write(LER, 21)  srcaqp
      write(LERR,21)  srcaqp
 21   format(/' Source aqp input: ',a80)

      call alloclun(lurcv)
      length = lenth(rcvaqp)
      open ( lurcv, file=rcvaqp(1:length), status='old', err=980)
      if ( verbos ) write(LER, 23)  rcvaqp
      write(LERR,23)  rcvaqp
 23   format(/' Receiver aqp input: ',a80)

      call alloclun(lurel)
      open (lurel, file=relsps, status='old', err=960)
      write(LER ,33)  relsps
      write(LERR,33)  relsps
 33   format(/' Relation sps input: ',a80)

*     open output file

 80   format(1a80)
      gthaqp = srcaqp
      length = nblen(srcaqp)
      gthaqp(length+1:length+5)='.gaqp'
      call alloclun(lugth) 
      open (lugth, file=gthaqp(1:length+5),status='new',err=910)
      if (verbos) write(LER ,35)  gthaqp
      write(LERR,35)  gthaqp
 35   format(/' Source-gather aqp output: ',a80)
      rewind(lusrc)

      write(LERR,45) ksrc
 45   format(' Seeking shot ',i5)

*     read input sps relation file
      rewind (lurel)
      call skip (lurel,0)
      gotshot = .false.

      rewind (lugth)
*     read, write INIT card
      read(lusrc,205) card
      write(lugth,205) card

*     start relation loop
*        sps relation format has:
*        col  1    : type X      
*        col  2-7  : field tape #
*        col  8-11 : field record #
*        col 12    : field record incr
*        col 13    : instrument code
*        col 14-29 : shot line #
*        col 30-37 : shot point #
*        col 38    : shot point index
*        col 39-42 : FROM rcvr channel #
*        col 43-46 : TO   rcvr channel #
*        col 47    : channel incr
*        col 48-63 : rcvr line #
*        col 64-71 : FROM rcvr #
*        col 72-79 : TO   rcvr #
*        col 80    : receiver point index

 100     read (lurel, 125, end=910) dum13, lindxs, isrc,
     &        dum9, irincr, lindxr, ircvfr, ircvto
 125     format(a13, i16, i8, a9, i1, i16, 2i8)
*        check if this is the one we want, otherwise loop
         if (isrc .ne. ksrc) then
            if(gotshot) go to 900
            go to 100
         endif

*        source relation found

         write(LERR,145) lindxr, ircvfr, ircvto
 145     format(' Seeking receivers on line ', i5,  ' from points ',
     &          i5, ' to ', i5)

*        get source point
         if ( gotshot ) go to 290
         rewind (lusrc)
*        start source loop
 200        read(lusrc,205, end=920) card
 205        format(1a80)
*           read(lusrc,257,end=920) srctyp, jsrc, xsrc, ysrc, azmsrc, 
*     &                      azmlin,lindx
* 257        format(1a1, i9, 2f10.1, a10, 15x, f10.1, 8x, i5)
*           read(lusrc,257,end=920) type,jsrc,x0,y0, azmlin, 
*    &                              koded, kodep, azmlin
* 257        format(1a1, i9, 3f15.1, 3x,2i6,f10.1)
*|        |              |              |              |  |     |     |
*1       10             25             40             55 58    64    70
            if (card(1:1) .ne. S) go to 200

*           check if this is the shot we want, otherwise loop
            jsrc = strint(card,2,10)
            if (jsrc .ne. ksrc) go to 200

C            DISABLE LINE CHECK
**           with shot #'s matching, check shot line #'s
*            lindx = strint(card,74,78)
*            if (lindx .eq. lindxs) then
*               write(LERR,215) jsrc, lindx
* 215           format(' Shot point ',i5, ' found on shot line ', i5)
*            else
*               write (LERR,*) 
*     &         ' Requested source line, number:', lindxs, isrc
*               write (LERR,*) 
*     &         ' do not match found line, number:', lindx,  jsrc
**               stop
*            endif 

*           write to output file
            card(59:70) = pcodes
            write(lugth,205) card

*           is there another, with another polarization?
 220        read(lusrc,205, end=920) card
            if (card(1:1) .eq. L) go to 290
            jsrc = strint(card,2,10)
            if (jsrc .eq. ksrc) then
*              write again
               card(59:70) = pcodes
               write(lugth,205) card
               go to 220
            endif
*        end source loop
         gotshot = .true.

*        get receiver points
 290     rewind (lurcv)
         read(lurcv,205) card
*        start receiver line loop
 300     read(lurcv,205, end=940) card
         if (card(1:1) .ne. R) go to 300

C        DISABLE RECEIVER LINE CHECK
**        check if this is the line we want, otherwise loop
*         lindx = strint(card,74,78)
*         if (lindx .ne. lindxr) go to 300
*         write(LERR,315) lindx
* 315     format(' Receiver line ',i5,' found.')

*        with receiver lines matching, get receiver points
 320     jrcvr = strint(card,2,10)
         if (jrcvr .ne. ircvfr) then
*           read another record
 330        read(lurcv,205, end=940) card
            if (card(1:1) .ne. R) go to 330
            go to 320
         else
C        DISABLE RECEIVER LINE CHECK
*            lindx = strint(card,74,78)
*            if (lindx .ne. lindxr) then
* 340           read(lurcv,205, end=940) card
*               if (card(1:1) .ne. R) go to 340
*               go to 320
*            endif
         endif

*        with receiver point matching FROM request,
         write(LERR,*) 'Receivers found starting at ', jrcvr
*        start loop
*         irincr = 2
         jr = ircvfr
 400        continue
            if (card(1:1) .ne. R) go to 409
*           since there may be more than one component, 
*           incrementing by more than 1 is tricky...
 402        jrmod = mod(jr-ircvfr,irincr)
C        DISABLE RECEIVER LINE CHECK
*            lindx = strint(card,74,78)
*            write(LERR,*) ksrc, lindx, ircvfr, jr, jrmod
            if (jrmod .ne. 0) go to 409

            jrcvr = strint(card,2,10)
C        DISABLE RECEIVER LINE CHECK
*            if (jrcvr .ne. jr .or.
*     &          lindx .ne. lindxr ) then
*            write (LERR,*) 
*     &         ' Requested receiver line, number: ', lindxr, jr
*               write (LERR,*) 
*     &         ' do not match found line, number: ', lindx,  jrcvr
*               stop
*            endif  
            if (jrcvr .ne. jr) then
            write (LERR,*) 
     &         ' Requested receiver number: ', jr
               write (LERR,*) 
     &         ' does not match found line, number: ', jrcvr
               stop
            endif 

*           write to output file
            card(59:70) = pcodes
            write(lugth,205) card

*        is there another, with another polarization?
 420        read(lurcv,205, end=940) card

         if (card(1:1) .ne. R) go to 420
         jrcvr = strint(card,2,10)
C        DISABLE RECEIVER LINE CHECK
*         lindx = strint(card,74,78)
*         if (jrcvr .eq. jr .and.
*     &       lindx .eq. lindxr  ) then
         if (jrcvr .eq. jr) then
*           write again
            card(59:70) = pcodes
            write(lugth,205) card
            go to 420
         else
            jr = jr + 1
            if (jr .le. ircvto) then
*              loop back
            go to 402
            endif
         endif

 409     continue

      write(LERR,*) 'Receivers found ending at   ', jr - 1

*     check if other receiver lines are requested
      go to 100

 900  close(lusrc)
      close(lurcv)
      close(lurel)
      close(lugth)

      write( LERR, * ) ' '
      write( LERR, * ) ' Normal end of gthrplot.'
      write( LER , * ) ' Normal end of gthrplot.'
      stop

 910  write(LER,915) relsps, isrc
      write(LERR,915) relsps, isrc
 915  format(/' GTHRPLOT: Error reading relation sps input file ',a80/
     &        '           Could not find requested shot point.', i5)
      stop

 920  write(LER,925) srcaqp, isrc
      write(LERR,925) srcaqp, isrc
 925  format(/' GTHRPLOT: Error reading aqp source input file ',a80/
     &        '           Could not find requested shot point.',i5)
      stop

 930  write(LER,935) lurcv, lindxr
      write(LERR,935) lurcv, lindxr
 935  format(/' GTHRPLOT: Error reading aqp receiver input file ',a80/
     &        '           Could not find requested receiver line.',i5)
      stop

 940  write(LER,945) lurcv
      write(LERR,945) lurcv
 945  format(/' GTHRPLOT: Error reading receiver input file ',a80/
     &        '           Could not find requested receiver point.')
      stop

 960  write(LER,965) relsps
      write(LERR,965) relsps
 965  format(/' GTHRPLOT: Error opening sps relation input file ',a80/
     &        '           Check for prior existence; move/rm as nec.')

 970  write(LER,975) otap
      write(LERR,975) otap
 975  format(/' GTHRPLOT: Error opening aqplot output file ',a80/
     &        '           Check for prior existence; move/rm as nec.')
      stop

 980  write(LER,985) lurcv
      write(LERR,985) lurcv
 985  format(/' GTHRPLOT: Error opening receiver input file ',a80/
     &        '           Check for prior existence; move/rm as nec.')
      stop

      end
*****************************************************************
*****************************************************************
*****************************************************************
*****************************************************************
      subroutine skip (lu, nskip)
*     skips S, R, or X header records

      character*1 card1, H
      character*80 card
      equivalence (card1, card(1:1))
      data  H/'H'/

      if (nskip .eq. 0) then
 100     read(lu,105)  card
 105     format(1a80)
         nskip = nskip + 1
         if (card1 .eq. H) go to 100
         backspace lu
         nskip = nskip - 1
      else
 200     do 209 i=1,nskip
            read(lu,*)
 209     enddo
      endif

      return
      end
