C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine eigen2(quad,eig,mv)
      dimension quad(*),eig(*)
      real lmda1,lmda2
c
c   quad - original matrix (symmetric), destroyed in computation.
c          Resultant eigenvalues are placed in diagonal of matrix
c          in descending order.
c    eig - resultant matrix of eigenvectros (stored columnwise, in
c          same order as eigenvalues.
c     mv - input code:  0 = compute eigenvalues & eigenvectors
c                       1 = compute eigenvalues only
c
c  section for 2-component data
        a=quad(1)
        c=quad(2)
        b=quad(3)
c       an=amax1(a,b,c)
      if(abs(c) .ne. 0.) then
c          a=a/an
c          c=c/an
c          b=b/an
           bb=(a+b)
           cc=a*b-c*c
           sq=sqrt(bb*bb-4.*cc)
           lmda1=(bb + sq)/2.
           lmda2=(bb - sq)/2.
           if(lmda1 .lt. 1.e-10) then
              lmda1=0.
              lmda2=0.
           endif
           quad(1)=lmda1
           quad(3)=lmda2
      else
           quad(1) = amax1(a,b)
           quad(3) = amin1(a,b)
           eig(1) = 0.
           eig(2) = 0.
           return
      endif
c
c  section 2 compute eiganvector
      if(mv .eq. 0) then
           bc=(lmda1-b)/c
           bc2 = bc*bc
           e2 = 1./sqrt (1. + bc2)
           eig(1) = bc * e2
           eig(2) = e2
      endif
c
c  adjust eigenvalues for scale factor and put into quad
      return
      end

