C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C**********************************************************************C
C
C     PROGRAM MODULE INSTPL
C
C**********************************************************************C
C
C INSTFR READS SEISMIC TRACE DATA FROM AN INPUT FILE,
C and computes instantaneous frequency and polarization
C
C SUBROUTINE CALLS: RTAPE, WRTAPE, HLH, SAVE
C
C**********************************************************************C
C
C     DECLARE VARIABLES
C
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
      integer    itr1 (SZLNHD), itr2 (SZLNHD)
      integer    luin, luout1, luout2, lbytes, nbytes
      real       tri1 (SZLNHD), tri2 (SZLNHD)
      real       trismp(SZLNHD), tripha(SZLNHD)
      integer    nsamp, nsi, ntrc, nrec, iform,lbyout1,lbyout2
      character  name * 6
#include <f77/pid.h>
      integer    ns, ne, rs, re
      character  ntap*512,  otap1*512, otap2*512
      logical    verbos
      logical    query, IKP
      integer    argis, pipe, ordfft
 
      data name /'INSTPL'/, nbytes / 0 /, lbytes / 0 /
      data verbos/.true./, pipe/3/
      data IKP/.false./
c-----
c      read program parameters from command line
c-----
      query = (argis('-?') .gt. 0)
      if(query) then
            call help()
            stop
      endif
c-----
c      open printout file
c-----
#include <f77/open.h>
c-----
c      parse command line arguments
c-----
      call gcmdln(ns,ne,rs,re,ntap,otap1,otap2,verbos,fl,fh)
c-----
c      get logical unit numbers for input
c-----
      if (in_ikp() .eq. 1) IKP = .true.
      call getln(  luin, ntap , 'r', 0)
      call getln(luout1, otap1, 'w', 1)
      luout2 = -1
      if (IKP) then
          write(LERR,*)'instpl assumed to be running inside IKP'
          call sisfdfit (luout2, pipe)
      else
          call getln(luout2, otap2, 'w', -1)
      endif
      if (luin .lt. 0 ) then
         write(LERR,*)'Unable to open input data stream -- FATAL'
         stop
      endif
      if (luout1 .lt. 0 ) then
         write(LERR,*)'Unable to open output data stream 1 -- FATAL'
         stop
      endif
c-----
c     read line header of input
c     save certain parameters
c-----
      call rtape (luin, itr1, lbytes)
      if(lbytes .eq. 0) then
         write(LER,*)'INSTPL: no header read fron unit ',luin,ntap
         write(LER,*)'FATAL'
         stop
      endif
      call saver(itr1, 'RATTrc', ntuple, LINHED)
      if(ntuple .ne. 2) then
         write(LERR,*)'Input not 2 component data: check data flow'
         stop
      endif
      call vmov(itr1,1,itr2,1,SZLNHD)
      call hlhprt(itr1, lbytes, name, 6, LERR)
      call saver(itr1, 'NumSmp', nsamp , LINHED)
      call saver(itr1, 'SmpInt', nsi   , LINHED)
      call saver(itr1, 'NumTrc', ntrc  , LINHED)
      call saver(itr1, 'NumRec', nrec  , LINHED)
      call saver(itr1, 'Format', iform , LINHED)
      call saver(itr1, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr1, 'UnitSc', unitsc, LINHED)
      endif
      dt = float(nsi) * unitsc

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('SoPtNm',ifmt_SoPtNm,l_SoPtNm,ln_SoPtNm,TRACEHEADER)

c-----
c      ensure that command line values are compatible with data set
c-----
      call cmdchk(ns,ne,rs,re,ntrc,nrec)
c-----
c     initialize headers of output files
c-----
      nrecc = re - rs + 1
      jtr = ne - ns + 1
      if(mod(jtr,2) .ne. 0) then
         write(LERR,*)'Range of traces specified must be multiple of 2'
         write(LERR,*)'Check -ns & -ne entries on command line; rerun'
         stop
       endif
       jtr = jtr/2
       call savew( itr1, 'NumTrc',  jtr , LINHED)
       call savew( itr2, 'NumTrc',  jtr , LINHED)
       call savew( itr1, 'NumRec', nrec , LINHED)
       call savew( itr2, 'NumRec', nrec , LINHED)
       call savhlh(itr1, lbytes, lbyout1)
       call savhlh(itr2, lbytes, lbyout2)
            call wrtape(luout1, itr1, lbyout1)
       if (luout2 .gt. 0) then
            call wrtape(luout2, itr2, lbyout2)
       endif

c-----
c       get power of two
c       set up number of points for FFT
c------
       nu = ordfft (nsamp)
       npts = 2 **nu
       npts21 = npts/2 + 1
       fnyq = .5 / dt
       fls = fl / fnyq
       fhs = fh / fnyq
       ifl = int ( fls * float(npts21) ) + 1
       ifh = int ( fhs * float(npts21) )
c-----
c      verbose output of all pertinent information before
c      processing begins
c-----
c     if(verbos )then
            call verbal(lbytes,nsamp,nsi,ntrc,nrec,iform,ntap,
     1           otap1,otap2,luin,luout1,luout2,
     2           ns,ne,rs,re,verbos,fl,fh,npts,ifl,ifh)
c     endif
c-----
c      BEGIN PROCESSING
c      read trace
c----
c-----
c     skip unwanted records
c-----
      call recskp(1,rs-1,luin,ntrc,itr1)
c-----
c     process desired trace records
c-----
      DO  1000  jj = rs, re

c-------------
c skip to start
c of cur rec
c-------------
            call trcskp(jj,1,ns-1,luin,ntrc,itr1)

            do  1001  kk = ns, ne, 2

                  nbytes = 0
                  call rtape(luin,itr1,nbytes)
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 999
                  endif
                  call vmov (itr1(ITHWP1), 1, tri1, 1, nsamp)

                  nbytes = 0
                  call rtape(luin,itr2,nbytes)
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 999
                  endif
                  call vmov (itr2(ITHWP1), 1, tri2, 1, nsamp)

                  call saver2(itr1,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        istat1, TRACEHEADER)
                  call saver2(itr2,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        istat2, TRACEHEADER)

c-------------------
c calc polarization
c & phase
c zero if dead
                  if(istat1 .ne. 30000 .and. istat2 .ne. 30000)then
                     call filtit(tri1,tri2,trismp,tripha,
     1                      nsamp,nsi,ifl,ifh,npts,npts21,dt,SZSMPD)
                  else
                     call vclr(trismp,1,nsamp)
                     call vclr(tripha,1,nsamp)
                  endif

c-------------------
c write out inst pol
c & inst phase diff
c to 2 output streams
                       call vmov (tripha, 1, itr1(ITHWP1), 1, nsamp)
                       call wrtape(luout1, itr1, nbytes)
	
                  if (luout2 .gt. 0) then
                       call vmov (trismpa, 1, itr2(ITHWP1), 1, nsamp)
                       call wrtape(luout2, itr2, nbytes)
                  endif

 1001       continue

c-------------
c skip to end
c of cur rec
c-------------
            call trcskp(jj,ne+1,ntrc,luin,ntrc,itr1)

 1000 CONTINUE

  999 continue
      call lbclos(luin)
      call lbclos(luout1)
      if (luout2 .gt. 0) then
         call lbclos(luout2)
      endif
      stop
      end

        subroutine filtit(tri1,tri2,trismp,tripha,nsamp,nsi,ifl,ifh,
     1                    npts,npts21,dt,SZSMPD)
#include <f77/iounit.h>
        real     tri1(1), tri2(1), trismp(1), tripha(1)
        real     work
        pointer  (wkwork , work (1))
        complex  data1, data2
        pointer  (wkdata1, data1(1))
        pointer  (wkdata2, data2(1))
        integer  ierr, ierrs, iabort, npts, npts21, ifl, ifh, SZSMPD
        real     pi, raddeg

        pi = 3.14159265
        raddeg = 180/pi
        iabort = 0
        ierrs = 0

        item = npts * SZSMPD
        call galloc (wkwork , item, ierr, iabort)
        ierrs = ierrs + ierr
        item = 2 * npts * SZSMPD
        call galloc (wkdata1, item, ierr, iabort)
        ierrs = ierrs + ierr
        call galloc (wkdata2, item, ierr, iabort)
        ierrs = ierrs + ierr
        if (ierrs .ne. 0) then
           write(LER,*)'FATAL ERROR in instpl:'
           write(LER,*)'Unable to allocate memory - trace too long?'
           call ccexit (666)
        endif

        call quad(tri1, data1, npts, npts21, dt, nsamp, ifl, ifh)
        call quad(tri2, data2, npts, npts21, dt, nsamp, ifl, ifh)
c-----
c     get instantaneous phase difference from Rene et al Geophysics
c     June 1986, pp 1235-1251
c
c     compute RMS envelop and store into data(i)
c-----
        do 4000 i=1,nsamp
               rv = real(data1(i))
               rh = real(data2(i))
               qv = aimag(data1(i))
               qh = aimag(data2(i))
               tripha(i) = atan2( (rh*qv-rv*qh),(rv*rh+qv*qh) )
c-----
c	map only 0 -> pi/2 / pi/2
c-----
               work (i) = abs(tripha (i))*2.0/3.1415927
               if(work (i) .gt. 1.0)work (i) = 2.0 - work (i)
               e = sqrt( cabs(data1(i)) * cabs(data2(i)) )
               data1(i) = cmplx(e,0.0)
 4000   continue
c-----
c       weighted average of instantaneous polarity
c       use a NPOINT smoothing operator
c-----
        NPOINT = 10
        do 6000 i=1,nsamp
                sumn = 0.0
                sumd = 0.0
                jlow = i - NPOINT/2
                jup  = i + NPOINT/2
                if(jlow.lt.1)jlow = 1
                if(jup .gt.nsamp)jup=nsamp
                do 6001 j=jlow,jup
                        sumn = sumn + real(data1(j))*work(j)
                        sumd = sumd + real(data1(j))
 6001           continue
                trismp(i) = sumn/sumd
 6000   continue

        do  i = 1, nsamp
            tripha(i) = -raddeg * tripha(i)
        enddo

        call gfree (wkwork)
        call gfree (wkdata1)
        call gfree (wkdata2)
                        
        return
        end

        subroutine quad(tri,data,npts,npts21,dt,nsamp,ifl,ifh)
c-----
c    given a real time series obtain the complex series 
c    consisting of the original time series real(data)
c    and the quadrature series aimag(data)
c
c    tri     - R*4 array of real values
c    data    - R*4 complex array
c    npts    - I*4 number of points in array power of 2
c    dt      - R*4 sampling interval in seconds
c    nsamp   - I*4 number of samples in time series
c-----
#include <f77/iounit.h>
      real    tri(1), dt
      complex data(1)
      integer npts,npts21, nsamp

        do 2000 i=1,npts
                if(i.le.nsamp)then
                        data(i) = cmplx(tri(i),0.0)
                else
                        data(i) = cmplx(0.0,0.0)
                endif
 2000   continue
        call four(data,npts,-1,dt,df)
c-----
c       form spectra to get quadrature
c-----
        do 3000 i=1, npts
c               if(i .lt. npts21) then
                if(i .ge. ifl .AND. i .le. ifh) then
                        data(i) = 2.0*data(i)
                else
                        data(i) = cmplx(0.0,0.0)
                endif
 3000   continue
        call four(data,npts,+1,dt,df)
c-----
c       now real(data) is the original time series
c       and aimag(data) is the quadrature series
c-----
        return
        end


      subroutine help
#include <f77/iounit.h>
      write(LER,*)
     1'***************************************************************'
      write(LER,*)
      write(LER,*)
     1'Execute instpl by typing instfr with the following arguments'
      write(LER,*)
     1' -N [ntap]                : Input data file name'
      write(LER,*)
     1' -OF [otap1]                : output file for phase diff'
      write(LER,*)
     1' -OP [otap2]                : output file for polarity  '
      write(LER,*)
     1' -rs [ir],    (default=1)         : beginning record number'
      write(LER,*)
     1' -re [re],    (default=last)      : ending record number'
      write(LER,*)
     1' -ns [ns],    (default=1)          : beginning trace number'
      write(LER,*)
     1' -ne [ne],    (default=last)       : ending trace number'
      write(LER,*)
     1' -V                                : verbose output'
      write(LER,*)
     1' -fl [fl]     : Lower hard limit for output freqneucy '
      write(LER,*)
     1' -fh [fh]     : Upper hard limit for output frequency '
      write(LER,*)
     1'Usage: instpl -N[ntap] -OF[otap1] -OP[otap2]  -ns[] -ne[]'
     2,'  -rs[] -re[] '
     3,' -fl[fl] -fh[fh] -V'
      write(LER,*)
     1'***************************************************************'
      return
      end

      subroutine gcmdln(ns,ne,rs,re,ntap,otap1,otap2,
     1         verbos,fl,fh)
#include <f77/iounit.h>
      integer*4 ns, ne, rs, re
      character ntap*(*), otap1*(*), otap2*(*)
      integer argis
      logical verbos
            call argstr('-N', ntap, ' ', ' ' )
            call argstr('-OF', otap1, ' ', ' ')
            call argstr('-OP', otap2, ' ', ' ')
            call argi4 ('-ns' , ns, 0, 0)
            call argi4 ('-ne' , ne, 0, 0)
            call argi4 ('-rs',rs,1,1)
            call argi4 ('-re',re,0,0)
            call argr4( '-fl', fl, 10.0, 10.0 )
            call argr4( '-fh', fh, 40.0, 40.0 )
            verbos = ( argis ('-V') .gt. 0 )
      return
      end

      subroutine verbal(lbytes, nsamp, nsi, ntrc, nrec, iform, ntap,
     1 otap1, otap2, luin, luout1, luout2, ns, ne, rs, 
     2 re, verbos,fl,fh,npts,ifl,ifh)
c-----
c     verbose output of processing parameters
c
c     lbytes- I*4 number of bytes in line header
c     nsamp - I*4 number of samples in trace
c     nsi   - I*4 sample interval in ms
c     ntrc  - I*4 traces per record
c     nrec  - I*4 number of records per line
c     iform - I*4 format of data
c     ntap  - C*120     input file name
c     otap1 - C*120     instantaneous frequency output file name
c     otap2 - C*120     instantaneous polarity output file name
c     luin  - I*4 input file unit number
c     luout1- I*4 instantaneous frequency unit number
c     luout2- I*4 instantaneous polarity unit number
c     ns    - I*4 starting trace
c     ne    - I*4 ending trace in each record
c     rs    - I*4 starting record
c     re    - I*4 ending record
c     verbos- L   verbose information
c-----
#include <f77/iounit.h>
      integer*4 lbytes, nsamp, nsi, ntrc, nrec, iform
      integer *4 luin, luout1, luout2
      character ntap*(*), otap1*(*), otap2*(*)
      integer*4 ns, ne, rs, re, ifl, ifh
      logical verbos
      integer*4 lenstr
            ln1 = lenstr(ntap)
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of bytes in line header=',lbytes
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' luin               =  ', luin
            write(LERR,*) ' luout1             =  ', luout1
            write(LERR,*) ' luout2             =  ', luout2
            write(LERR,*) ' input 1 data set name = ',ntap(1:ln1)
            write(LERR,*) ' ns (starting trace)    =  ',ns
            write(LERR,*) ' ne (ending trace  )    =  ',ne
            write(LERR,*) ' rs (starting record)   =  ',rs
            write(LERR,*) ' re (ending record)     =  ',re
            write(LERR,*) ' verbose output         =  ',verbos
            write(LERR,*) ' Low cut frequency      =  ',fl
            write(LERR,*) ' Low cut frequency      =  ',ifl,' samps'
            write(LERR,*) ' High cut frequency     =  ',fh
            write(LERR,*) ' High cut frequency      =  ',ifh,' samps'
            write(LERR,*) ' Power-of-2 number samps=  ',npts
            write(LERR,*)' '
      return
      end

      function lenstr(str)
c-----
c     determine length of a string. Note f77 len gives declaration
c     we want length up to last non blank
c-----
      integer*4 lenstr
      character str*(*)
      l = len(str)
      do 100 i=l,1,-1
            lenstr = i
            if(str(i:i) .ne. ' ')return
  100 continue
      return
      end

