C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine FindStaticToApply ( Index, Trace, Sample, DphInd, 
     :     NumSegs, NumPicks, dt, dt_xgraph, DatumTime, HorizonTime )

#include <f77/lhdrsz.h>

c Routine to calculate the delta-time to be applied at this trace based
c on DphInd entry and two segments in the xsd pickfile files.

      integer Index(2*SZSMPM,3), DphInd, NumSegs, NumPicks
      
      real Trace(NumSegs*NumPicks), Sample(NumSegs*NumPicks), dt
      real record, TopTime, HorizonTime, dt_xgraph

c initialize variables

      dt = 0.0
      dt_xgraph = 0.0

      record = float(DphInd)

c Interpolate/extrapolate time for segment 1 at this DphInd

      if ( record .le. Trace(1) ) then

         DatumTime = Sample(1)

      elseif ( record .gt. Trace(1) .and. record .lt. Trace(Index(1,1) )
     :        ) then

         do i = 1, index(1,1) - 1

            if ( record .le. Trace(i+1) ) then
               DatumTime = Sample(i) + 
     :              ( Sample(i+1) - Sample(i) ) * 
     :              ( record - Trace(i) ) / 
     :              (Trace(i+1) - Trace(i) )
               goto 10
            endif

         enddo

      elseif ( record .ge. Trace(Index(1,1) ) ) then

         DatumTime = Sample(Index(1,1))

      endif
c Interpolate/extrapolate time for segment 2 at this DphInd

 10    continue

      if ( record .le. Trace(Index(1,1)+1) ) then

         HorizonTime = Sample(Index(1,1)+1)
         dt = DatumTime - HorizonTime

c load dt to dt_xgraph so that output plot shows actual
c time shift calculated from the input data prior to 
c adjusting the sign.  This was requested by Tom Chaimov

         dt_xgraph = dt

c i have commented the following out as the user should not have 22 being
c faster than 11 is the rotation(x) was done properly in rottnsr
c         if ( dt .gt. 0.0) dt = 0.0 - dt
         return

      elseif ( record .gt. Trace(1) .and. record .lt. Trace(Index(1,1) )
     :        ) then

         do i = index(1,1)+1, index(1,1) + index(2,1) - 1

            if ( record .le. Trace(i+1) ) then
               HorizonTime = Sample(i) + 
     :              ( Sample(i+1) - Sample(i) ) * 
     :              ( record - Trace(i) ) / 
     :              (Trace(i+1) - Trace(i) )

c determine delta - time

               dt = DatumTime - HorizonTime
               dt_xgraph = dt

c i have commented the following out as the user should not have 22 being
c faster than 11 is the rotation(x) was done properly in rottnsr
c               if ( dt .gt. 0.0) dt = 0.0 - dt
               return

            endif

         enddo

      elseif ( record .ge. Trace(Index(1,1)+Index(2,1) ) ) then

         HorizonTime = Sample(Index(1,1)+Index(2,1) )
         dt = DatumTime - HorizonTime
         dt_xgraph = dt
c i have commented the following out as the user should not have 22 being
c faster than 11 is the rotation(x) was done properly in rottnsr
c         if ( dt .gt. 0.0) dt = 0.0 - dt
         return

      endif

      end
