C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine MctMap ( itr, DatumTime, HorizonTime, MapTrace, nsamp, 
     :     nsi, fmax, AliasFlag, PassFlag )

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>

c declare variables passed from calling routine

      integer itr(SZLNHD)
      integer nsamp, nsi

      real    MapTrace(nsamp), fmax, DatumTime, HorizonTime

      logical AliasFlag
      
c declare local variables

      integer pointer, l_TVPT, l_TVPV, ifmt, length, ivalue
      integer counter, countertest

      real    DatumStorage(SZSMPM), HorizonStorage(SZSMPM), SI

      logical PassFlag

c initialize variables

      counter = 0
      SI = float(nsi)
      PassFlag = .false.

c retrieve horizon and datum information from trace header 
c Horizon is stored in TVPT entry while associated datum is
c stored in associated TVPV entry.  In MctSqueeze it is desired
c that the squeeze only occur over the portion of the data from 
c the last level to the end of data.  For this reason the last
c datum [which was the last 11 time] will be used as  both the
c horizon and datum above the current point.

c a zero datum will cause the trace header search to end.
      
      counter = counter + 1

      call savelu('TVPV01',ifmt,l_TVPV,length,TRACEHEADER)
      call saver2(itr,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
      HorizonStorage(counter) = float(ivalue)
      DatumStorage(counter) = float(ivalue)

      if ( DatumStorage(counter) .lt. 1 ) goto 10
      counter = counter + 1
    
      call savelu('TVPV02',ifmt,l_TVPV,length,TRACEHEADER)
      call saver2(itr,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
      DatumStorage(counter) = float(ivalue)
      HorizonStorage(counter) = float(ivalue)

      if ( DatumStorage(counter) .lt. 1 ) goto 10
      counter = counter + 1
     
      call savelu('TVPV03',ifmt,l_TVPV,length,TRACEHEADER)
      call saver2(itr,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
      DatumStorage(counter) = float(ivalue)
      HorizonStorage(counter) = float(ivalue)
      
      if ( DatumStorage(counter) .lt. 1 ) goto 10
      counter = counter + 1
      
      call savelu('TVPV04',ifmt,l_TVPV,length,TRACEHEADER)
      call saver2(itr,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
      DatumStorage(counter) = float(ivalue)
      HorizonStorage(counter) = float(ivalue)
      
      if ( DatumStorage(counter) .lt. 1 ) goto 10
      counter = counter + 1
      
      call savelu('TVPV05',ifmt,l_TVPV,length,TRACEHEADER)
      call saver2(itr,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
      DatumStorage(counter) = float(ivalue)
      HorizonStorage(counter) = float(ivalue)
      
      if ( DatumStorage(counter) .lt. 1 ) goto 10
      counter = counter + 1

      call savelu('TVPV06',ifmt,l_TVPV,length,TRACEHEADER)
      call saver2(itr,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
      DatumStorage(counter) = float(ivalue)
      HorizonStorage(counter) = float(ivalue)

      if ( DatumStorage(counter) .lt. 1 ) goto 10
      counter = counter + 1

      call savelu('TVPV07',ifmt,l_TVPV,length,TRACEHEADER)
      call saver2(itr,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
      DatumStorage(counter) = float(ivalue)
      HorizonStorage(counter) = float(ivalue)

      if ( DatumStorage(counter) .lt. 1 ) goto 10
      counter = counter + 1

      call savelu('TVPV08',ifmt,l_TVPV,length,TRACEHEADER)
      call saver2(itr,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
      DatumStorage(counter) = float(ivalue)
      HorizonStorage(counter) = float(ivalue)

      if ( DatumStorage(counter) .lt. 1 ) goto 10
      counter = counter + 1

      call savelu('TVPV09',ifmt,l_TVPV,length,TRACEHEADER)
      call saver2(itr,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
      DatumStorage(counter) = float(ivalue)
      HorizonStorage(counter) = float(ivalue)

      if ( DatumStorage(counter) .lt. 1 ) goto 10
      counter = counter + 1

      call savelu('TVPV10',ifmt,l_TVPV,length,TRACEHEADER)
      call saver2(itr,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
      DatumStorage(counter) = float(ivalue)
      HorizonStorage(counter) = float(ivalue)

      if ( DatumStorage(counter) .lt. 1 ) goto 10
      counter = counter + 1
      
      call savelu('TVPV11',ifmt,l_TVPV,length,TRACEHEADER)
      call saver2(itr,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
      DatumStorage(counter) = float(ivalue)
      HorizonStorage(counter) = float(ivalue)

      if ( DatumStorage(counter) .lt. 1 ) goto 10
      counter = counter + 1

      call savelu('TVPV12',ifmt,l_TVPV,length,TRACEHEADER)
      call saver2(itr,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
      DatumStorage(counter) = float(ivalue)
      HorizonStorage(counter) = float(ivalue)

      if ( DatumStorage(counter) .lt. 1 ) goto 10
      counter = counter + 1

      call savelu('TVPV13',ifmt,l_TVPV,length,TRACEHEADER)
      call saver2(itr,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
      DatumStorage(counter) = float(ivalue)
      HorizonStorage(counter) = float(ivalue)

      if ( DatumStorage(counter) .lt. 1 ) goto 10
      counter = counter + 1

      call savelu('TVPV14',ifmt,l_TVPV,length,TRACEHEADER)
      call saver2(itr,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
      DatumStorage(counter) = float(ivalue)
      HorizonStorage(counter) = float(ivalue)

      if ( DatumStorage(counter) .lt. 1 ) goto 10
      counter = counter + 1

      call savelu('TVPV15',ifmt,l_TVPV,length,TRACEHEADER)
      call saver2(itr,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
      DatumStorage(counter) = float(ivalue)
      HorizonStorage(counter) = float(ivalue)

      if ( DatumStorage(counter) .lt. 1 ) goto 10
      counter = counter + 1
      
      call savelu('TVPV16',ifmt,l_TVPV,length,TRACEHEADER)
      call saver2(itr,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
      DatumStorage(counter) = float(ivalue)
      HorizonStorage(counter) = float(ivalue)

      if ( DatumStorage(counter) .lt. 1 ) goto 10
      counter = counter + 1

      call savelu('TVPV17',ifmt,l_TVPV,length,TRACEHEADER)
      call saver2(itr,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
      DatumStorage(counter) = float(ivalue)
      HorizonStorage(counter) = float(ivalue)

      if ( DatumStorage(counter) .lt. 1 ) goto 10
      counter = counter + 1

      call savelu('TVPV18',ifmt,l_TVPV,length,TRACEHEADER)
      call saver2(itr,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
      DatumStorage(counter) = float(ivalue)
      HorizonStorage(counter) = float(ivalue)

      if ( DatumStorage(counter) .lt. 1 ) goto 10
      counter = counter + 1

      call savelu('TVPV19',ifmt,l_TVPV,length,TRACEHEADER)
      call saver2(itr,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
      DatumStorage(counter) = float(ivalue)
      HorizonStorage(counter) = float(ivalue)
      
      if ( DatumStorage(counter) .lt. 1 ) goto 10
      counter = counter + 1

      call savelu('TVPV20',ifmt,l_TVPV,length,TRACEHEADER)
      call saver2(itr,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
      DatumStorage(counter) = float(ivalue)
      HorizonStorage(counter) = float(ivalue)

      if ( DatumStorage(counter) .lt. 1 ) goto 10
      counter = counter + 1

      call savelu('TVPV21',ifmt,l_TVPV,length,TRACEHEADER)
      call saver2(itr,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
      DatumStorage(counter) = float(ivalue)
      HorizonStorage(counter) = float(ivalue)

c decrement counter unless 21 picks encountered 
c then decrement counter only if 21st picks are zero

 10   continue

c determine correct count for entries read

      if ( counter .lt. 21) then
         counter = counter - 1
      elseif( DatumStorage(counter) .lt. 1 )then
         counter = counter - 1
      endif

c add current DatumTime and HorizonTime to the fray
c debug: horizon and datum times better be times at this
c        point and not samples

      if ( abs( HorizonTime - DatumTime ) .gt. 1.e-30 )then

         countertest = counter
         if ( counter .eq. 0 ) countertest = 1
         
         if ( DatumTime .gt. DatumStorage(countertest) ) then
            counter = counter + 1
            HorizonStorage(counter) = HorizonTime
            DatumStorage(counter) = DatumTime
         else
            write(LERR,*)' '
            write(LERR,*)'MCTSQUEEZE: You have asked to apply'
            write(LERR,*)'            a correction at level'
            write(LERR,*)'            above the last correction'
            write(LERR,*)'            listed in the trace header'
            write(LERR,*)'FATAL'
            write(LER,*)' '
            write(LER,*)'MCTSQUEEZE: You have asked to apply'
            write(LER,*)'            a correction at level'
            write(LER,*)'            above the last correction'
            write(LER,*)'            listed in the trace header'
            write(LER,*)'FATAL'
            stop
         endif 
      else
         PassFlag = .true.
      endif

c store current horizon and datum info in next trace header entry

      if ( counter .gt. 21 ) then
         write(LERR,*)'MCTSQUEEZE: Too many horizon entries to'
         write(LERR,*)'            be contained in trace header'
         write(LERR,*)'            Operation will be performed'
         write(LERR,*)'            but will NOT be stored in header'
         write(LERR,*)'WARNING'
      else

         if ( counter .eq. 1 ) then
            ivalue = nint ( HorizonStorage(counter) )
            call savelu('TVPT01',ifmt,l_TVPT,length,TRACEHEADER)
            call savew2(itr,ifmt,l_TVPT,length,ivalue,TRACEHEADER)
            ivalue = nint ( DatumStorage(counter) ) 
            call savelu('TVPV01',ifmt,l_TVPV,length,TRACEHEADER)
            call savew2(itr,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
         elseif ( counter .eq. 2 ) then
            ivalue = nint ( HorizonStorage(counter) )
            call savelu('TVPT02',ifmt,l_TVPT,length,TRACEHEADER)
            call savew2(itr,ifmt,l_TVPT,length,ivalue,TRACEHEADER)
            ivalue = nint ( DatumStorage(counter) ) 
            call savelu('TVPV02',ifmt,l_TVPV,length,TRACEHEADER)
            call savew2(itr,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
         elseif ( counter .eq. 3 ) then
            ivalue = nint ( HorizonStorage(counter) )
            call savelu('TVPT03',ifmt,l_TVPT,length,TRACEHEADER)
            call savew2(itr,ifmt,l_TVPT,length,ivalue,TRACEHEADER)
            ivalue = nint ( DatumStorage(counter) ) 
            call savelu('TVPV03',ifmt,l_TVPV,length,TRACEHEADER)
            call savew2(itr,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
         elseif ( counter .eq. 4 ) then
            ivalue = nint ( HorizonStorage(counter) )
            call savelu('TVPT04',ifmt,l_TVPT,length,TRACEHEADER)
            call savew2(itr,ifmt,l_TVPT,length,ivalue,TRACEHEADER)
            ivalue = nint ( DatumStorage(counter) ) 
            call savelu('TVPV04',ifmt,l_TVPV,length,TRACEHEADER)
            call savew2(itr,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
         elseif ( counter .eq. 5 ) then
            ivalue = nint ( HorizonStorage(counter) )
            call savelu('TVPT05',ifmt,l_TVPT,length,TRACEHEADER)
            call savew2(itr,ifmt,l_TVPT,length,ivalue,TRACEHEADER)
            ivalue = nint ( DatumStorage(counter) ) 
            call savelu('TVPV05',ifmt,l_TVPV,length,TRACEHEADER)
            call savew2(itr,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
         elseif ( counter .eq. 6 ) then
            ivalue = nint ( HorizonStorage(counter) )
            call savelu('TVPT06',ifmt,l_TVPT,length,TRACEHEADER)
            call savew2(itr,ifmt,l_TVPT,length,ivalue,TRACEHEADER)
            ivalue = nint ( DatumStorage(counter) ) 
            call savelu('TVPV06',ifmt,l_TVPV,length,TRACEHEADER)
            call savew2(itr,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
         elseif ( counter .eq. 7 ) then
            ivalue = nint ( HorizonStorage(counter) )
            call savelu('TVPT07',ifmt,l_TVPT,length,TRACEHEADER)
            call savew2(itr,ifmt,l_TVPT,length,ivalue,TRACEHEADER)
            ivalue = nint ( DatumStorage(counter) ) 
            call savelu('TVPV07',ifmt,l_TVPV,length,TRACEHEADER)
            call savew2(itr,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
         elseif ( counter .eq. 8 ) then
            ivalue = nint ( HorizonStorage(counter) )
            call savelu('TVPT08',ifmt,l_TVPT,length,TRACEHEADER)
            call savew2(itr,ifmt,l_TVPT,length,ivalue,TRACEHEADER)
            ivalue = nint ( DatumStorage(counter) ) 
            call savelu('TVPV08',ifmt,l_TVPV,length,TRACEHEADER)
            call savew2(itr,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
         elseif ( counter .eq. 9 ) then
            ivalue = nint ( HorizonStorage(counter) )
            call savelu('TVPT09',ifmt,l_TVPT,length,TRACEHEADER)
            call savew2(itr,ifmt,l_TVPT,length,ivalue,TRACEHEADER)
            ivalue = nint ( DatumStorage(counter) ) 
            call savelu('TVPV09',ifmt,l_TVPV,length,TRACEHEADER)
            call savew2(itr,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
         elseif ( counter .eq. 10 ) then
            ivalue = nint ( HorizonStorage(counter) )
            call savelu('TVPT10',ifmt,l_TVPT,length,TRACEHEADER)
            call savew2(itr,ifmt,l_TVPT,length,ivalue,TRACEHEADER)
            ivalue = nint ( DatumStorage(counter) ) 
            call savelu('TVPV10',ifmt,l_TVPV,length,TRACEHEADER)
            call savew2(itr,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
         elseif ( counter .eq. 11 ) then
            ivalue = nint ( HorizonStorage(counter) )
            call savelu('TVPT11',ifmt,l_TVPT,length,TRACEHEADER)
            call savew2(itr,ifmt,l_TVPT,length,ivalue,TRACEHEADER)
            ivalue = nint ( DatumStorage(counter) ) 
            call savelu('TVPV11',ifmt,l_TVPV,length,TRACEHEADER)
            call savew2(itr,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
         elseif ( counter .eq. 12 ) then
            ivalue = nint ( HorizonStorage(counter) )
            call savelu('TVPT12',ifmt,l_TVPT,length,TRACEHEADER)
            call savew2(itr,ifmt,l_TVPT,length,ivalue,TRACEHEADER)
            ivalue = nint ( DatumStorage(counter) ) 
            call savelu('TVPV12',ifmt,l_TVPV,length,TRACEHEADER)
            call savew2(itr,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
         elseif ( counter .eq. 13 ) then
            ivalue = nint ( HorizonStorage(counter) )
            call savelu('TVPT13',ifmt,l_TVPT,length,TRACEHEADER)
            call savew2(itr,ifmt,l_TVPT,length,ivalue,TRACEHEADER)
            ivalue = nint ( DatumStorage(counter) ) 
            call savelu('TVPV13',ifmt,l_TVPV,length,TRACEHEADER)
            call savew2(itr,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
         elseif ( counter .eq. 14 ) then
            ivalue = nint ( HorizonStorage(counter) )
            call savelu('TVPT14',ifmt,l_TVPT,length,TRACEHEADER)
            call savew2(itr,ifmt,l_TVPT,length,ivalue,TRACEHEADER)
            ivalue = nint ( DatumStorage(counter) ) 
            call savelu('TVPV14',ifmt,l_TVPV,length,TRACEHEADER)
            call savew2(itr,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
         elseif ( counter .eq. 15 ) then
            ivalue = nint ( HorizonStorage(counter) )
            call savelu('TVPT15',ifmt,l_TVPT,length,TRACEHEADER)
            call savew2(itr,ifmt,l_TVPT,length,ivalue,TRACEHEADER)
            ivalue = nint ( DatumStorage(counter) ) 
            call savelu('TVPV15',ifmt,l_TVPV,length,TRACEHEADER)
            call savew2(itr,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
         elseif ( counter .eq. 16 ) then
             ivalue = nint ( HorizonStorage(counter) )
            call savelu('TVPT16',ifmt,l_TVPT,length,TRACEHEADER)
            call savew2(itr,ifmt,l_TVPT,length,ivalue,TRACEHEADER)
            ivalue = nint ( DatumStorage(counter) ) 
            call savelu('TVPV16',ifmt,l_TVPV,length,TRACEHEADER)
            call savew2(itr,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
         elseif ( counter .eq. 17 ) then
            ivalue = nint ( HorizonStorage(counter) )
            call savelu('TVPT17',ifmt,l_TVPT,length,TRACEHEADER)
            call savew2(itr,ifmt,l_TVPT,length,ivalue,TRACEHEADER)
            ivalue = nint ( DatumStorage(counter) ) 
            call savelu('TVPV17',ifmt,l_TVPV,length,TRACEHEADER)
            call savew2(itr,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
         elseif ( counter .eq. 18 ) then
            ivalue = nint ( HorizonStorage(counter) )
            call savelu('TVPT18',ifmt,l_TVPT,length,TRACEHEADER)
            call savew2(itr,ifmt,l_TVPT,length,ivalue,TRACEHEADER)
            ivalue = nint ( DatumStorage(counter) ) 
            call savelu('TVPV18',ifmt,l_TVPV,length,TRACEHEADER)
            call savew2(itr,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
         elseif ( counter .eq. 19 ) then
            ivalue = nint ( HorizonStorage(counter) )
            call savelu('TVPT19',ifmt,l_TVPT,length,TRACEHEADER)
            call savew2(itr,ifmt,l_TVPT,length,ivalue,TRACEHEADER)
            ivalue = nint ( DatumStorage(counter) ) 
            call savelu('TVPV19',ifmt,l_TVPV,length,TRACEHEADER)
            call savew2(itr,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
         elseif ( counter .eq. 20 ) then
            ivalue = nint ( HorizonStorage(counter) )
            call savelu('TVPT20',ifmt,l_TVPT,length,TRACEHEADER)
            call savew2(itr,ifmt,l_TVPT,length,ivalue,TRACEHEADER)
            ivalue = nint ( DatumStorage(counter) ) 
            call savelu('TVPV20',ifmt,l_TVPV,length,TRACEHEADER)
            call savew2(itr,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
         elseif ( counter .eq. 21 ) then
            ivalue = nint ( HorizonStorage(counter) )
            call savelu('TVPT21',ifmt,l_TVPT,length,TRACEHEADER)
            call savew2(itr,ifmt,l_TVPT,length,ivalue,TRACEHEADER)
            ivalue = nint ( DatumStorage(counter) ) 
            call savelu('TVPV21',ifmt,l_TVPV,length,TRACEHEADER)
            call savew2(itr,ifmt,l_TVPV,length,ivalue,TRACEHEADER)
         endif
      endif

c if pass flag is set then nothing need be squeezed on this trace

      if ( PassFlag ) return

c examine squeeze function for squeeze Nyquist violations

      call RedFlag ( itr, HorizonStorage, DatumStorage, counter, nsi, 
     :     fmax, AliasFlag)

c build the map for application of squeeze.  The map will be contained in 
c the MapTrace array.

      pointer = 1

      DO i=1,nsamp
         
         tsamp = float(i)*SI

c stretch/sqeeze is being applied
 
         if( tsamp .lt. DatumStorage(pointer)
     :        .and.
     :        tsamp .lt. DatumStorage(counter)
     :        .and.
     :        pointer .eq. 1 ) then
            
            DatumLast = SI
            DatumNext = DatumStorage(pointer)
            HorizonLast = DatumLast
            HorizonNext = HorizonStorage(pointer)
            MapTrace(i) = ( HorizonLast +  (HorizonNext - HorizonLast)*
     :           (tsamp - DatumLast)/(DatumNext-DatumLast) ) / SI
            
         elseif( tsamp .lt. DatumStorage(pointer)
     :           .and.
     :           tsamp .lt. DatumStorage(counter) ) then
            
            DatumLast = DatumStorage(pointer-1)
            DatumNext = DatumStorage(pointer)
            HorizonLast = HorizonStorage(pointer-1)
            HorizonNext = HorizonStorage(pointer)
            MapTrace(i) = ( HorizonLast +  (HorizonNext - HorizonLast)*
     :           (tsamp - DatumLast)/(DatumNext-DatumLast) ) / SI
            
         elseif( tsamp .ge. DatumStorage(pointer)
     :           .and.
     :           pointer .lt. counter ) then
            
            pointer = pointer + 1
            DatumLast = DatumStorage(pointer-1)
            DatumNext = DatumStorage(pointer)
            HorizonLast = HorizonStorage(pointer-1)
            HorizonNext = HorizonStorage(pointer)
            MapTrace(i) = ( HorizonLast +  (HorizonNext - HorizonLast)*
     :           (tsamp - DatumLast)/(DatumNext-DatumLast) ) / SI
            
         elseif( tsamp .ge. DatumStorage(pointer)
     :           .and.
     :           pointer.eq.counter ) then

c at this point a static shift is required to the end of the trace.  To accomplish
c this just take the last squeezed sample location and add 1.0 from here on out.
            
            MapTrace(i) =  MapTrace(i-1) + 1.0
            
         endif
            
      ENDDO

      return
      end
