C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine gcmdln(ntap, ns, ne, irs, ire, verbos, islo, ptap, 
     :     protap1, protap2, header, otap, fmax, IKP )

#include <f77/iounit.h>

      integer     ns, ne, irs, ire, islo
      integer     argis

      real fmax

      character   ntap*(*), ptap*(*)
      character   protap1*(*), protap2*(*), otap*(*)

      logical     picktest, header, verbos, IKP

c ntap- C*100      root for case name 
c ns    - I*4      starting trace index
c ne    - I*4      ending trace index
c irs   - I*4      starting record index
c ire   - I*4      ending record index
c verbos  L        verbose output or not
c islo  - I*4      slow component (default: yy = 22)
 
      call argr4( '-fmax' , fmax , 0. , 0. )
      IKP    = (argis('-IKP') .gt. 0)
      call argstr( '-N', ntap, ' ', ' ' )
      call argi4 ( '-ns', ns ,   0  ,  0)
      call argi4 ( '-ne', ne ,   0  ,  0)
      call argstr( '-O', otap, ' ', ' ' )
      picktest = (argis('-pick') .gt. 0)
      call argstr( '-PF', protap1, ' ', ' ' )
      call argstr( '-PS', protap2, ' ', ' ' )
      call argstr( '-P', ptap, ' ', ' ' )
      call argi4 ( '-rs', irs ,  0  ,  0)
      call argi4 ( '-re', ire ,  0  ,  0)
      call argi4 ( '-s', islo,   0  , 22)
      verbos = (argis('-V') .gt. 0)

c check if user is using an xsd default pickfile format
c or an xsd header value file [the default]

      if ( picktest .or. protap1 .ne. ' ' ) header = .false.

      return
      end
