C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c
c
c     program module presortc
c
c**********************************************************************c
c
c     presortc reads seismic traces from the standard input,
c     or from the command line and compiles a list
c     of gi, si, di or distance indices for use by the
c     program compsort
c
c**********************************************************************c
c
c     declare variables
c-----
#include <localsys.h>
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      integer * 2 itr ( SZLNHD )
      integer     lhed( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform 
      integer     luin, luout, lbytes, nbytes

c-----
c  static memory
c     parameter  (MBIG=500000)
c     integer     inrec(MBIG),insrc(MBIG),incdp(MBIG),
c    1            indst(MBIG)
c     integer     jnrec(MBIG),jntrc(MBIG),jndst(MBIG),srttmp(MBIG)
c     integer     kyrec(MBIG),kysrc(MBIG),kycdp(MBIG),kydst(MBIG),
c    1            kygi(MBIG)
c-----
c  dynamic memory
      integer   inrec, insrc, incdp, indst
      integer   jnrec, jntrc, jndst, srttmp
      integer   kyrec, kysrc, kycdp, kydst, kygi

      pointer   (ainrec, inrec(1))
      pointer   (ainsrc, insrc(1))
      pointer   (aincdp, incdp(1))
      pointer   (aindst, indst(1))
      pointer   (ajnrec, jnrec(1))
      pointer   (ajntrc, jntrc(1))
      pointer   (ajndst, jndst(1))
      pointer   (asrtmp, srttmp(1))
      pointer   (akyrec, kyrec(1))
      pointer   (akysrc, kysrc(1))
      pointer   (akycdp, kycdp(1))
      pointer   (akydst, kydst(1))
      pointer   (akygi,  kygi(1))
c-----

      integer     ic,nrecvr,nsrc,ntuple,imin,imax,jmin,jmax
      integer     itwd1, itwd2, itwd3, itwd4, itwdr, itwds
      character   TrWrd1 * 6, TrWrd2 * 6, TrWrd3 * 6, TrWrd4 * 6
      character   TrWrdr * 6, TrWrds * 6
      integer     recind, srcloc, dphind, recnum, trcnum, dstsgn
      real        off, grp
      integer     pair(9), si, di, gi, idsi, stacor
      real        spread ( SZSMPM )
#include <f77/pid.h>
      character   name * 8,   ntap * 120, otap * 120
      logical     verbos, query, renum, heap, heapin, keep, ten
      logical     round, model
      integer     argis

c     equivalence ( itr(129), tri (1) )
      equivalence ( itr(  1), lhed(1) )
      data name     /'PRESORTC'/
      data lbytes / 0 /, nbytes / 0 /

c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif

c-----
c     open printout file
c-----
#include <f77/open.h>

      call gcmdln(ntap,otap,verbos,renum,itwd1,itwd2,itwd3,itwd4,
     1            keep,ten,round, model, off, grp,
     2            TrWrd1, TrWrd2, TrWrd3, TrWrd4, TrWrdr, TrWrds)
c-----
c     get logical unit numbers for input and output
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c-----
c     we will let FORTRAN handle the output
      itype=-1
c-----
      if(luout.eq.1)then
            luns = LOT
            write(luns,*) itype
      else
            call lbclos(luout)
            luns = 26
            open(luns,file=otap,status='unknown',form='formatted',
     1                  access='sequential')
            rewind luns
            write(luns,*) itype
      endif

c-----
c     read line header of input
c     save certain parameters
c-----
      call rtape  ( luin, itr, lbytes                  )
      if(lbytes .eq. 0) then
            write(LOT,*)'PRESORTC: no header read from unit ',luin
            write(LOT,*)'FATAL'
            stop
      endif

      call hlhprt ( itr , lbytes, name, 8, LERR        )

c------
c     save certain parameters
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header

#include <f77/saveh.h>

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

c     call savelu('TrcNum',ifmt,l_TrcNum,length,TRACEHEADER)
c     call savelu('RecNum',ifmt,l_RecNum,length,TRACEHEADER)
c     call savelu('StaCor',ifmt,l_StaCor,length,TRACEHEADER)

      call savelu(TrWrdr,ifmt_TrWrdr,l_TrWrdr,ln_TrWrdr,TRACEHEADER)
      call savelu(TrWrds,ifmt_TrWrds,l_TrWrds,ln_TrWrds,TRACEHEADER)

c     call savelu( TrWrdr ,ifmt,l_TrWrdr,length,TRACEHEADER)
c     call savelu( TrWrds ,ifmt,l_TrWrds,length,TRACEHEADER)

      if (itwd1 .eq. 0) then
c        call savelu( TrWrd1 ,ifmt,l_TrWrd1,length,TRACEHEADER)
         call savelu(TrWrd1,ifmt_TrWrd1,l_TrWrd1,ln_TrWrd1,TRACEHEADER)
      else
         l_TrWrd1 = itwd1
         ifmt_TrWrd1 = 4
         ln_TrWrd1 = 1
      endif
 
      if (itwd2 .eq. 0) then
c        call savelu( TrWrd2 ,ifmt,l_TrWrd2,length,TRACEHEADER)
         call savelu(TrWrd2,ifmt_TrWrd2,l_TrWrd2,ln_TrWrd2,TRACEHEADER)
      else
         l_TrWrd2 = itwd2
         ifmt_TrWrd2 = 4
         ln_TrWrd2 = 1
      endif
 
      if (itwd3 .eq. 0) then
c        call savelu( TrWrd3 ,ifmt,l_TrWrd3,length,TRACEHEADER)
         call savelu(TrWrd3,ifmt_TrWrd3,l_TrWrd3,ln_TrWrd3,TRACEHEADER)
      else
         l_TrWrd3 = itwd3
         ifmt_TrWrd3 = 4
         ln_TrWrd3 = 1
      endif
 
      if (itwd4 .eq. 0) then
c        call savelu( TrWrd4 ,ifmt,l_TrWrd4,length,TRACEHEADER)
         call savelu(TrWrd4,ifmt_TrWrd4,l_TrWrd4,ln_TrWrd4,TRACEHEADER)
      else
         l_TrWrd4 = itwd4
         ifmt_TrWrd4 = 4
         ln_TrWrd4 = 1
      endif
 
      write(LERR,*)' '
      write(LERR,*)'First sort mnemonic= ',TrWrd1
      write(LERR,*)'Second sort mnemonic= ',TrWrd2
      write(LERR,*)'Third sort mnemonic= ',TrWrd3
      write(LERR,*)'Fourth sort mnemonic= ',TrWrd4
      write(LERR,*)'Receiver component mnemonic= ',TrWrdr
      write(LERR,*)'Source component mnemonic= ',TrWrds
      write(LERR,*)' '


c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
c     if( verbos ) then
            call verbal(nsamp, nsi, ntrc, nrec, iform, 
     1                  ntap,otap,renum,
     2                  l_TrWrd1, l_TrWrd2, l_TrWrd3, l_TrWrd4,
     3                  l_TrWrdr, l_TrWrds)
c     end if

c------------
c     if(ntrc*nrec .gt. MBIG)then
c           write(LER,*)'ntrc*nrec exceeds array dimension of',
c    1                  MBIG
c           write(LER,*)'FATAL - recompile'
c           stop
c     endif
c------------

c------------
c  do dynamic memory alloc
      heap   = .true.
      heapin = .true.
      items = ntrc*nrec*SZSMPD

      call galloc (ainrec, items, errcd1, abort1)
      if (errcd1 .ne. 0.) heapin = .false.
      call heaps ("inrec index vector  ", heapin, heap)

      call galloc (ainsrc, items, errcd1, abort1)
      if (errcd1 .ne. 0.) heapin = .false.
      call heaps ("insrc index vector  ", heapin, heap)

      call galloc (aincdp, items, errcd1, abort1)
      if (errcd1 .ne. 0.) heapin = .false.
      call heaps ("incdp index vector  ", heapin, heap)

      call galloc (aindst, items, errcd1, abort1)
      if (errcd1 .ne. 0.) heapin = .false.
      call heaps ("indst index vector  ", heapin, heap)

      call galloc (ajnrec, items, errcd1, abort1)
      if (errcd1 .ne. 0.) heapin = .false.
      call heaps ("jnrec index vector  ", heapin, heap)

      call galloc (ajntrc, items, errcd1, abort1)
      if (errcd1 .ne. 0.) heapin = .false.
      call heaps ("jntrc index vector  ", heapin, heap)

      call galloc (ajndst, items, errcd1, abort1)
      if (errcd1 .ne. 0.) heapin = .false.
      call heaps ("jndst index vector  ", heapin, heap)

      call galloc (asrtmp, items, errcd1, abort1)
      if (errcd1 .ne. 0.) heapin = .false.
      call heaps ("srtmp index vector  ", heapin, heap)

      call galloc (akyrec, items, errcd1, abort1)
      if (errcd1 .ne. 0.) heapin = .false.
      call heaps ("kyrec index vector  ", heapin, heap)

      call galloc (akysrc, items, errcd1, abort1)
      if (errcd1 .ne. 0.) heapin = .false.
      call heaps ("kysrc index vector  ", heapin, heap)

      call galloc (akycdp, items, errcd1, abort1)
      if (errcd1 .ne. 0.) heapin = .false.
      call heaps ("kycdp index vector  ", heapin, heap)

      call galloc (akydst, items, errcd1, abort1)
      if (errcd1 .ne. 0.) heapin = .false.
      call heaps ("kydst index vector  ", heapin, heap)

      call galloc (akygi, items, errcd1, abort1)
      if (errcd1 .ne. 0.) heapin = .false.
      call heaps ("kygi index vector  ", heapin, heap)

      if (.not.heap) then
         write(LERR,*)' '
         write(LERR,*)'Memory allocation failure -- FATAL'
         write(LERR,*)'Data set contains ',items,' traces'
         write(LERR,*)'Is this maybe too large for this'
         write(LERR,*)'machine?'
         go to 999
      endif

c-----
c     model trace distances if asked
c-----
      off = off + grp
      if (model) then
         x = 0.
         do  20  j = 1, SZSMPM
 
             x = x + grp
             if (x .gt. off) then
                 ngrp2 = j-1
                 go to 21
             else
                 spread(j) = x
             endif
20       continue
21       continue
 
         x = 0.
         do  24  j = 1, ngrp2
             x = x - grp
             spread(ngrp2 + j) = x
24       continue
 
         ngrp = 2 * ngrp2
         call rsort (spread, srttmp, ngrp)
         call vrvrs (spread, 1, ngrp)
 
         write(LERR,*)' '
         write(LERR,*)'Modeled Trace DIstances'
         write(LERR,*)(spread(i),i=1,ngrp)
         write(LERR,*)' '
      endif


c-----
c     BEGIN PROCESSING
c     process entire input data set
c-----
      imin=3
      jmin=3
      imax=1
      jmax=1
      ic = 0

      if (verbos) then
                  write(LERR,*)' '
                  write(LERR,105)
105               format('   rec ',2x,' trc  ',2x,'gi ',2x,'  di ',2x,
     1               '  si ',2x,' src pt above di ',1x,' dist ',2x,
     2               ' static ',5x,' components')
                  write(LERR,*)' '
      endif

      do 1000 jj=1,nrec
            do 1001 kk =1,ntrc
                  nbytes = 0
                  call rtape(luin, itr, nbytes)
                  if(nbytes.le.0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',i,'  trace= ',k
                     write(LERR,*)'Last rec# on data set=  ',recnum
                     write(LERR,*)'Last trc# on data set=  ',trcnum
                     go to 1002
                  endif
                  call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                        istatic, TRACEHEADER)
                  stacor = istatic

              IF(istatic .ne. 30000 .OR. keep) THEN
                  ic = ic + 1

                  call saver2(lhed,ifmt_TrWrdr,l_TrWrdr, ln_TrWrdr,
     1                        itwdr  , TRACEHEADER)
                  call saver2(lhed,ifmt_TrWrds,l_TrWrds, ln_TrWrds,
     1                        itwds  , TRACEHEADER)
                  call saver2(lhed,ifmt_TrWrd1,l_TrWrd1, ln_TrWrd1,
     1                        recind , TRACEHEADER)
                  call saver2(lhed,ifmt_TrWrd2,l_TrWrd2, ln_TrWrd2,
     1                        srcloc , TRACEHEADER)
                  call saver2(lhed,ifmt_TrWrd3,l_TrWrd3, ln_TrWrd3,
     1                        dphind , TRACEHEADER)
                  call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                        recnum , TRACEHEADER)
                  call saver2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                        trcnum , TRACEHEADER)
                  call saver2(lhed,ifmt_TrWrd4,l_TrWrd4, ln_TrWrd4,
     1                        dstsgn , TRACEHEADER)

c                 itwdr  = itr( l_TrWrdr )
c                 itwds  = itr( l_TrWrds )
c                 recind = itr( l_TrWrd1 )
c                 srcloc = itr( l_TrWrd2 )
c                 dphind = itr( l_TrWrd3 )
c                 recnum = itr( l_RecNum )
c                 trcnum = itr( l_TrcNum )
c                 dstsgn = itr( l_TrWrd4 )
c                 stacor = itr( l_StaCor )

                  if ( round ) then
                     dstsgna = abs (dstsgn)
                     if (dstsgn .ne. 0.0) then
                        sgn = 1.001 * dstsgn / dstsgna
                        idx = 10 * int (dstsgna/10. + 0.50)
                        idx = int(sgn) * int(idx)
                     else
                        idx = 0
                     endif
                     dstsgn = float (int(idx))
                     call savew2(lhed,ifmt_TrWrd4,l_TrWrd4, ln_TrWrd4,
     1                           dstsgn , TRACEHEADER)
c                    itr(l_TrWrd4) = dstsgn
                  endif

                  if (model) then
                     do  22  J = 2, ngrp
                         x1 = spread(j-1)
                         x2 = spread(j)
                         if (dstsgn .le. x1 .AND. dstsgn .gt. x2) then
                             dstsgn = x1
                             go to 23
                         endif
22                   continue
23                   continue
                  endif

                  if (verbos) then
                       si = srcloc
                       di = dphind
                       gi = recind
                       irec = recnum
                       itrc = trcnum
                       idsi = itr( l_SrcLoc )
                       write(LERR,106) irec,itrc,gi,di,si,idsi,dstsgn,
     1                                stacor,itwdr,itwds
106                    format(i5,2x,i5,2x,i5,2x,i5,2x,i5,10x,i5,5x,i5,
     1                        5x,i5,5x,2i5)
                  endif

                  if(itwdr .ge. imax) imax = itwdr
                  if(itwdr .le. imin) imin = itwdr
                  if(itwds .ge. jmax) jmax = itwds
                  if(itwds .le. jmin) jmin = itwds
c-----
c      indices to sort on
c-----
                  inrec(ic) = recind
                  if (ten) then
                      insrc(ic) = srcloc/10
                  else
                      insrc(ic) = srcloc
                  endif
                  incdp(ic) = dphind
c                 incdp(ic) = recind + srcloc/10
c                 indst(ic) = recind - srcloc/10
                  indst(ic) = dstsgn
c-----
c      permanent trace identification
c-----
                  if(renum)then
                        jntrc(ic)=kk
                        jnrec(ic)=jj
                  else
                        jnrec(ic)=recnum
                        jntrc(ic)=trcnum
                  endif
                  jndst(ic) = dstsgn
            ENDIF

 1001            continue
 1000      continue
 1002      continue

      ndat = ic
      nrecvr = imax-imin+1
      nsrc   = jmax-jmin+1
      ntuple = nrecvr * nsrc
      do 6 i = imin, imax
         do 5 j = jmin, jmax
            n = n+1
            call encode(i, j, pair(n))
    5    continue
    6 continue

      write(LERR,*)'no. rcvr comps= ',nrecvr,' no. src comps= ',nsrc,
     1                ' ntuple= ',ntuple
      write(LERR,*)'components=  ',(pair(i),i=1,ntuple)

c-----
c     sort the data set
c-----
      call trsort(ndat,ntuple,inrec,insrc,incdp,indst,jnrec,jntrc,
     1            jndst,kyrec,kysrc,kycdp,kydst,kygi,srttmp,ntrc,nrec,
     2            luns,pair)
c-----
c     terminate the program
c----
999   continue
      call lbclos( luin )
      if(luns .eq. 1)close (luns)
      close (LERR)
      stop
      end
      
      subroutine trsort(ndat,ntuple,inrec,insrc,incdp,indst,jnrec,jntrc,
     1            jndst,kyrec,kysrc,kycdp,kydst,kygi,srttmp,ntrc,nrec,
     2            luns,pair)

c-----
c     subroutine to do sorting of indices
c
c     the object of the sort routine is
c     to order these for use with  the gsort program
c
c     the table output will consist of 13 columns, of which
c     12 have useful information. In order of output, they are:
c
c      COLUMN NAME       DESCRIPTION
c
c      1      inrec      The (rec,trc) pair in columns 4,5 have
c                        this receiver index
c      2      insrc      The (rec,trc) pair in columns 6,7 have
c                        this source index
c      3      incdp      The (rec,trc) pair in columns 8,9 have
c                        this cdp index
c      4      rec        Record corresponding to the sorted receiver
c                        index
c      5      trc        Trace  corresponding to the sorted receiver
c                        index
c      6      rec        Record corresponding to the sorted source
c                        index
c      7      trc        Trace  corresponding to the sorted source
c                        index
c      8      rec        Record corresponding to the sorted cdp
c                        index
c      9      trc        Trace  corresponding to the sorted cdp
c                        index
c     10      indst      The (rec,trc) pair in columns 11,12 have
c                        this distance index
c     11      rec        Record corresponding to the sorted distance
c                        index
c     12      trc        Trace  corresponding to the sorted distance
c                        index
c     13      dist       Actual signed distance corresponding to
c                        the (rec,trc) pair in columns 11,12
c                        Note the sort in done on the quantity
c                        RecInd - SrcLoc/10 
c
c-----
c      ndat      I*4      - total number of points in the arrays
c      nrec      I*4      - number of records in original data set
c      ntrc      I*4      - number of traces  in original data set
c      luns      I*4      - FORTRAN output logical unit number
c
c-----
 
#include <f77/iounit.h>

      integer*4 inrec(1),insrc(1),incdp(1),indst(1)
      integer*4 jnrec(1),jntrc(1),jndst(1)
      integer*4 kyrec(1), kysrc(1), kycdp(1), kydst(*),kygi(1)
      integer*4 srttmp(1), pair(1)
      integer*4 ndat, nrec, ntrc,luns,ntuple
      integer*4 reccnt,trccnt,rec(4),trc(4)
c-----
c     note that I sort real numbers rather than integers
c     for compatibility with the subroutine sort -- this
c     could be easily changed
c-----
            do 100 j=1,4
                  do 200 i=1,ndat
                        if(j.eq.1)then
                              srttmp(i) = inrec(i)
                        elseif(j.eq.2)then
                              srttmp(i) = insrc(i)
                        elseif(j.eq.3)then
                              srttmp(i) = incdp(i)
                        elseif(j.eq.4)then
                              srttmp(i) = indst(i)
                        endif
  200                  continue
                  if(j.eq.1)then
                        call sort(srttmp,kyrec,ndat)
                  elseif(j.eq.2)then
                        call sort(srttmp,kysrc,ndat)
                  elseif(j.eq.3)then
                        call sort(srttmp,kycdp,ndat)
                  elseif(j.eq.4)then
                        call sort(srttmp,kydst,ndat)
                  endif
  100            continue
c-----
c      go through the sorted data set to determine
c      the effective number of records and traces
c      corresponding to each unique sort
c-----
       write(LERR,*)' '
       write(LERR,*)' '

       do 2000 n=1,4

 
             write(LERR,*)' '
             write(LERR,*)' '
              if     (n .eq. 1) then
                 write(LERR,*)'Receiver or First Primary Index: '
              elseif (n .eq. 2) then
                 write(LERR,*)'Source or Second Primary Index: '
              elseif (n .eq. 3) then
                 write(LERR,*)'Depth or Third Primary Index: '
              elseif (n .eq. 4) then
                 write(LERR,*)'Offset or First Secondary Index: '
              endif
              write(LERR,*)' '
              write(LERR,*)'gather index             # trcs/gath'
              write(LERR,*)' '

              reccnt = 0
              trccnt = 0
              maxcnt = 0
              do 2010 i=1,ndat
                     if(n.eq.1)then
                            j = inrec(kyrec(i))
                     elseif(n.eq.2)then
                            j = insrc(kysrc(i))
                     elseif(n.eq.3)then
                            j = incdp(kycdp(i))
                     elseif(n.eq.4)then
                            j = indst(kydst(i))
                     endif
                     call dif(reccnt,trccnt,i,j,jump,ndat)
                     if (trccnt .ge. maxcnt .and. jump .eq. 1) then
                        maxcnt = trccnt
                     endif
                     if (jump .eq. 1)
     1               write(LERR,*)j,'                        ',trccnt
 2010         continue
              if (maxcnt .eq. 0) maxcnt = trccnt
              write(LERR,*)' '
              write(LERR,*)'Max number trcs/gather =  ',maxcnt
              rec(n) = reccnt
              trc(n) = trccnt

              if (reccnt .eq. 0 .OR. maxcnt .eq. 0) then
 
                 write(LERR,*)' '
                 write(LERR,*)'presort:  FATAL ERROR'
                 write(LER,*)'presort:  FATAL ERROR: check printout'
                 if (n .eq. 1)
     1           write(LERR,*)'in receiver (group) primary sort ---'
                 if (n .eq. 2)
     1           write(LERR,*)'in shot primary sort ---'
                 if (n .eq. 3)
     1           write(LERR,*)'in common depth primary sort ---'
                 if (n .eq. 4)
     1           write(LERR,*)'in offset secondary sort ---'
                 if (reccnt .eq. 0)
     1           write(LERR,*)'zero gathers found'
                 if (trccnt .eq. 0)
     1           write(LERR,*)'zero length gather found'
                 write(LERR,*)'Check indexing of data or rerun presort'
                 write(LERR,*)'with -V and look at indeces read.'
                 write(LERR,*)' '
                 stop 666
 
              endif

 2000  continue


       write(luns,'(2i10)')ndat,ntuple
       write(luns,'(9i5)') (pair(i),i=1,9)
       write(luns,'(8i10)')(rec(i),trc(i),i=1,4)
c-----
c      for use by common offset receiver statics
c      output the very first GI in the data set
c      and also the GI difference
c-----

       do 1000 n=1,4
              reccnt = 0
              kold = 1
              do 1100 i=1,ndat
                     if(n.eq.1)then
                            j = inrec(kyrec(i))
                     elseif(n.eq.2)then
                            j = insrc(kysrc(i))
                     elseif(n.eq.3)then
                            j = incdp(kycdp(i))
                     elseif(n.eq.4)then
                            j = indst(kydst(i))
                     endif
                     call dif(reccnt,trccnt,i,j,jump,ndat)
                     if(i.eq.ndat)then
                            knew = i 
                     else
                            knew = i - 1
                     endif
                     if( jump.eq.1 .or. i.eq.ndat)then
                     do 1101 k=kold,knew
                            ii = k - kold +1
                            if(n.eq.1)then
                                   ll=indst(kyrec(k))
                            elseif(n.eq.2)then
                                   ll=indst(kysrc(k))
                            elseif(n.eq.3)then
                                   ll=indst(kycdp(k))
                            elseif(n.eq.4)then
                                   ll=inrec(kydst(k))
                            endif
                            srttmp(ii)=ll
 1101                continue
                     call sort(srttmp,kygi,knew-kold+1)
                     do 1102 k=kold,knew
                            ii = k - kold +1
                            if(n.eq.1)then
                                   ll=kyrec(k)
                            elseif(n.eq.2)then
                                   ll=kysrc(k)
                            elseif(n.eq.3)then
                                   ll=kycdp(k)
                            elseif(n.eq.4)then
                                   ll=kydst(k)
                            endif
                            srttmp(ii)=ll
 1102                continue
                     do 1103 k=kold,knew
                            ii = k - kold +1
                            if(n.eq.1)then
                                   kyrec(k) = srttmp(kygi(ii))
                            elseif(n.eq.2)then
                                   kysrc(k) = srttmp(kygi(ii))
                            elseif(n.eq.3)then
                                   kycdp(k) = srttmp(kygi(ii))
                            elseif(n.eq.4)then
                                   kydst(k) = srttmp(kygi(ii))
                            endif
 1103                continue
                     kold = i
                     endif
 1100         continue
 1000  continue
       write(luns,'(i6,1x,i6)')inrec(kyrec(1)),inrec(kydst(2))-
     1                         inrec(kydst(1))
c-----
c     output the sorted information
c-----
            do 400 i=1,ndat
                  j = kyrec(i)
                  k = kysrc(i)
                  l = kycdp(i)
                  m = kydst(i)
                  write(luns,'(9(i6,1x),i10,1x,2(i6,1x),i10)')
     1                        inrec(j),insrc(k),incdp(l),
     2                        jnrec(j),jntrc(j),
     3                        jnrec(k),jntrc(k),
     4                        jnrec(l),jntrc(l),
     5                        indst(m),jnrec(m),jntrc(m),jndst(m)
  400            continue
      return
      end

      subroutine dif(ir,it,i,j,jump,ndat)
c-----
c     increment record count (ir) and trace count (it)
c     whenever j changes
c     i is the initialization flag
c     jump indicates that a transition to a new record has occurred

c     for i = 1 we initialize the counters ir,it,nr,nt,oldj,jump

c     for 1<i<ndat we check to see if the sorted index j  changes
c         if it does we set jump=0, check to see if the cummulative
c         # traces for this index is the largest so far (set "it" if so),
c         set ir to be the new sequential gather counter, reset nt=1, &
c         reset oldj to be the new sorted index

c     for i=ndat we have reached the end of the data and we must make sure
c         1) there is suddenly a new index starting, or 2) still the last indx
c         for (2) we need to bump nt by one (one more trc in the current gather
c            and check to see if this is now the largest gather
c         for (1) we bump the gather counter by 1 & reset the trc counter to 1

c-----
c     static oldj, nt, nr
      save oldj, nt, nr
      if(i .eq. 1) then
            ir = 1
            it = 1
            nt = 1
            nr = 1
                  oldj = j
                  jump = 0
      elseif (i .gt. 1 .and. i .lt. ndat) then
                   if    (j .le. oldj) then
                         nt = nt + 1
                         jump=0
                  elseif(j .gt. oldj) then
                         nr = nr + 1
                         if(nt .gt. it) it=nt
                         nt = 1
                         ir = nr
                         oldj = j
                         jump = 1
                  endif
      elseif (i .eq. ndat) then
                  if    (j .le. oldj) then
                         jump = 0
                  elseif(j .gt. oldj) then
                         jump = 1
                  endif
                  if     (jump .eq. 0) then
                         nt = nt + 1
                         if (nt .gt. it) it = nt
                         nt = 1
                  elseif (jump .eq. 1) then
                         nt = 1
                         nr = nr + 1
                         ir = nr
                  endif
      endif

      return
      end

      subroutine sort(ix,key,no)
c-----
c     This provides a sort of items
c     x(i) is the array to be sorted
c     key(i) is the pointer array
c     no is the number of points to be sorted
c     After the sort x(i) will be ordered from least to
c           greatest
c     key(1) will point to the position in the original array
c     with the least value
c-----
      dimension ix(1),key(1)
      do 1 i=1,no
    1 key(i)=i
      mo=no
    2 if(mo-15)21,21,23
   21 if(mo-1)29,29,22
   22 mo=2*(mo/4)+1
      goto 24
   23 mo=2*(mo/8)+1
   24 ko=no-mo
      jo=1
   25 i=jo
   26 if(ix(i)-ix(i+mo))28,28,27
   27 temp=ix(i)
      ix(i)=ix(i+mo)
      ix(i+mo)=temp
      kemp=key(i)
      key(i)=key(i+mo)
      key(i+mo)=kemp
      i=i-mo
      if(i-1)28,26,26
   28 jo=jo+1
      if(jo-ko)25,25,2
   29 return
      end

      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     1'***************************************************************'
      write(LER,*)
     1'execute presortc by typing presortc and list of program controls'
      write(LER,*)
     1'note that each parameter is proceeded by -a where "a" is '
      write(LER,*)
     1'a character(s) corresponding to some parameter.'
        write(LER,*)
     1'users enter the following parameters, or use the default values'
      write(LER,*)' '
        write(LER,*)
     1' -N [ntap]    (default = stdin)   : input data file name'
        write(LER,*)
     1' -O [otap]    (default = stdout)  : output data file name'
      write(LER,*)' '
      write(LER,*)
     1' -Hw1 [TrWrd1] (def = RecInd [rcvr])  : primary sort word 1'
      write(LER,*)
     1' -Hw2 [TrWrd2] (def = SrcLoc [src])   : primary sort word 2'
      write(LER,*)
     1' -Hw3 [TrWrd3] (def = DphInd [cdp])   : primary sort word 3'
      write(LER,*)
     1' -Hw4 [TrWrd4] (def = DstSgn [offset]): secondary sort word'
      write(LER,*)
     1' -Hwr [TrWrdr] (def = ToStUn) : receiver component word'
      write(LER,*)
     1' -Hws [TrWrds] (def = ToTmAU) : source component word'
      write(LER,*)' '
      write(LER,*)
     1' -M           (default = false)  : model spread (i.e. bin)'
      write(LER,*)
     1' -off [off]   (default = none)   : largest absolute offset'
      write(LER,*)
     1' -grp [grp]   (default = none)   : group interval (ft,m)'
        write(LER,*)' '
      write(LER,*)
     1' -R           (default = false)  : round distances to 10'
      write(LER,*)
     1' -X           (default = true)   :  use PRI not record order'
      write(LER,*)
     1'Note: this is NOT recommended for normal processing'
      write(LER,*)
     1' -K           (default = false)  : use index info of dead traces'
      write(LER,*)
     1' -S           (default = false)  : src index/10'
      write(LER,*)
     1' -V           (default = false)  : verbose diagnostics'
      write(LER,*)' '
         write(LER,*)
     1'usage:  presortc -N[ntap] -O[otap] -Hw[1,2,3,4][TrWrd[1,2,3,4]]'
         write(LER,*)
     1'                 -Hw[rs][TrWrd[rs]]'
         write(LER,*)
     1'                 [-M -off[] -grp[] -R -K -X -S -V]'
         write(LER,*)
     1'***************************************************************'
      return
      end

      subroutine gcmdln(ntap,otap,verbos,renum,itwd1,itwd2,itwd3,itwd4,
     1                  keep,ten,round, model, off, grp,
     2            TrWrd1, TrWrd2, TrWrd3, TrWrd4, TrWrdr, TrWrds)
c-----
c     get command arguments
c
c     ntap  - C*100     input file name
c     otap  - C*100     output file name
c     itwd1 - I*4       optional trace header word 1
c     itwd2 - I*4       optional trace header word 2
c     itwd3 - I*4       optional trace header word 3
c     itwd4 - I*4       optional trace header word 4
c     round - L         round distances to nearest 10
c     keep  - L         use idex info of dead traces
c     verbos- L         verbose output or not
c-----
#include <f77/iounit.h>
      character ntap*(*), otap*(*)
      character TrWrd1 * 6, TrWrd2 * 6, TrWrd3 * 6, TrWrd4 * 6
      character TrWrdr * 6, TrWrds * 6
      logical   verbos,renum, keep, ten, round, model
      integer   argis, itwd1, itwd2, itwd3, itwd4

            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argi4 ( '-hw1',itwd1, 0 , 0 )
            call argi4 ( '-hw2',itwd2, 0 , 0 )
            call argi4 ( '-hw3',itwd3, 0 , 0 )
            call argi4 ( '-hw4',itwd4, 0 , 0 )

            if (itwd1 .eq. 0) then
               call argstr( '-Hw1', TrWrd1, ' ', ' ')
               if (TrWrd1(1:1) .eq. ' ') TrWrd1 = 'RecInd'
            endif
            if (itwd2 .eq. 0) then
               call argstr( '-Hw2', TrWrd2, ' ', ' ')
               if (TrWrd2(1:1) .eq. ' ') TrWrd2 = 'SrcLoc'
            endif
            if (itwd3 .eq. 0) then
               call argstr( '-Hw3', TrWrd3, ' ', ' ')
               if (TrWrd3(1:1) .eq. ' ') TrWrd3 = 'DphInd'
            endif
            if (itwd4 .eq. 0) then
               call argstr( '-Hw4', TrWrd4, ' ', ' ')
               if (TrWrd4(1:1) .eq. ' ') TrWrd4 = 'DstSgn'
            endif

            call argstr( '-Hwr', TrWrdr, 'ToStUn', 'ToStUn')
            call argstr( '-Hws', TrWrds, 'ToTmAU', 'ToTmAU')

            round  = ( argis( '-R' ) .gt. 0 )
            keep   = ( argis( '-K' ) .gt. 0 )
            verbos = ( argis( '-V' ) .gt. 0 )
            renum  = ( argis( '-X' ) .eq. 0 )

            model  = ( argis( '-M' ) .gt. 0 )
            if (model) then
               call argr4 ( '-off',off, 0., 0.)
               call argr4 ( '-grp',grp, 0., 0.)
               if (off .eq. 0.) then
                  write(LERR,*)'FATAL ERROR:'
                  write(LERR,*)'You must enter maximum absolute offset'
                  write(LERR,*)'Enter using -off[] on cms line & rerun'
                  stop
               endif
               if (grp .eq. 0.) then
                  write(LERR,*)'FATAL ERROR:'
                  write(LERR,*)'You must enter group interval'
                  write(LERR,*)'Enter using -grp[] on cms line & rerun'
                  stop
               endif
            endif

c-----
c   sort word defaults
c-----
            if (itwd1 .eq. 0) then
c               itwd1 = 118
            else
                if (itwd1 .lt. 1 .or. itwd1 .gt. 128) then
                  write(LERR,*)'Sort header 1/2 word must be betw 1-128'
                  stop
                endif
            endif
            if (itwd2 .eq. 0) then
c               itwd2 = 109
            else
                if (itwd2 .lt. 1 .or. itwd2 .gt. 128) then
                  write(LERR,*)'Sort header 1/2 word must be betw 1-128'
                  stop
                endif
            endif
            if (itwd3 .eq. 0) then
c               itwd3 = 122
            else
                if (itwd3 .lt. 1 .or. itwd3 .gt. 128) then
                  write(LERR,*)'Sort header 1/2 word must be betw 1-128'
                  stop
                endif
            endif
            if (itwd4 .eq. 0) then
c               itwd4 = 119
            else
                if (itwd4 .lt. 1 .or. itwd4 .gt. 128) then
                  write(LERR,*)'Sort header 1/2 word must be betw 1-128'
                  stop
                endif
            endif
 
      return
      end

      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     1            ntap,otap,renum,itwd1,itwd2,itwd3, itwd4,
     2            itwdr,itwds)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4 number of samples in trace
c     nsi   - I*4 sample interval in ms
c     ntrc  - I*4 traces per record
c     nrec  - I*4 number of records per line
c     iform - I*4 format of data
c     itwd1 - I*4       optional trace header word 1 
c     itwd2 - I*4       optional trace header word 2 
c     itwd3 - I*4       optional trace header word 3 
c     itwd4 - I*4       optional trace header word 4
c     ntap  - C*120     input file name
c     otap  - C*120     output file name
c     renum - L     renumber records
c-----
#include <f77/iounit.h>
      integer*4 nsamp, nsi, ntrc, nrec, iform
      logical   renum
      character ntap*(*), otap*(*)
      integer   itwd1, itwd2, itwd3, itwd4

            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace  =  ', nsamp
            write(LERR,*) ' sample interval     =  ', nsi
            write(LERR,*) ' traces per record   =  ', ntrc
            write(LERR,*) ' records per line    =  ', nrec
            write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' output data set name=  ', otap
            write(LERR,*) ' use relative record indx=',renum
            write(LERR,*) ' First sort header 1/2 word      =  ',itwd1
            write(LERR,*) ' Second sort header 1/2 word     =  ',itwd2
            write(LERR,*) ' Third sort header 1/2 word      =  ',itwd3
            write(LERR,*) ' Secondary sort header 1/2 word  =  ',itwd4
            write(LERR,*) ' Receiver component 1/2 word     =  ',itwdr
            write(LERR,*) ' Source component 1/2 word       =  ',itwds
            write(LERR,*)' '

      return
      end

      subroutine heaps ( msg, heapin, heap )
      character  msg*21
      logical    heap, heapin

#include <f77/iounit.h>

      if (heapin) then

         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*)msg

      else

         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*)msg
         heap = .false.

      endif


      return
      end

