C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine cmdln(casert, otap, phitap, ns, ne, irs, ire, verbos,
     :     isrc, iaxis, idgrs, iwd, IKP)

c     casert- C*255    root for case name 
c     phitap- C*255    angle(x) filename
c     iwd   - C*6      trace header mnemonic to associate with angle file
c     ns    - I*4      starting trace index
c     ne    - I*4      ending trace index
c     irs   - I*4      starting record index
c     ire   - I*4      ending record index
c     verbos  L        verbose output or not
c     isrc  - I*4      source component
c     iaxis - I*4      axis of rotation
c     idgrs - I*4      degrees for rotation (righthanded)
c     IKP   - L        IKP processing or not

#include <f77/iounit.h>

      integer     ns, ne, irs, ire, idgrs, iaxis, isrc
      integer     argis

      character   casert*(*), otap*(*), phitap*(*), iwd*6  
            
      logical     verbos, IKP
 
      call argi4 ( '-ax', iaxis, 3  , 3 )
      call argstr( '-hw', iwd, 'RecNum', 'RecNum' )
      IKP    = (argis('-IKP') .gt. 0) 
      call argi4 ( '-ne', ne ,   0  ,  0)
      call argi4 ( '-ns', ns ,   0  ,  0)
      call argstr( '-N', casert, ' ', 'AMC1a45' )
      call argstr( '-O', otap, ' ', ' ' )
      call argi4 ( '-re', ire ,  0  ,  0)
      call argi4 ( '-rs', irs ,  0  ,  0)
      call argstr( '-R', phitap, ' ', ' ' )
      call argi4 ( '-r', idgrs,  0  , 0)
      call argi4 ( '-s', isrc,   2  , 2 )
      verbos = (argis('-V') .gt. 0)

      return
      end
