C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine cmdln (srctap, rcvtap, reltap, otap, azmth0,
     &                  srcaz1, srcaz2, srcilp, srciln, srcxlp, srcxln,
     &                  rcvaz1, rcvaz2, rcvilp, rcviln, rcvxlp, rcvxln,
     &                  ksil, ksxl, kril, krxl, mclist,
     &                  ns1, ne1, ns2, ne2, ns3, ne3, verbos)

c     srctap-  C*255    source filename
c     rcvtap-  C*255    receiver filename
c     reltap-  C*255    relation filename
c     otap-    C*255    output tape containing aqplot input

*     azmth0   R        azimuth of +x axis (90=East) in sps point rcrds 
*     srcaz1   R        azimuth of designated source x-axes
*     srcaz2   R        azimuth of designated source y-axes
*     rcvaz1   R        azimuth of designated receiver x-axes
*     rcvaz2   R        azimuth of designated receiver y-axes

*     srcilp  L         true if all sources polarized inline +
*     srciln  L         true if all sources polarized inline -
*     ksil    I         1 if source-lines alternate inline, with odd +
*                       0 if disabled
*                      -1 if source-lines alternate inline, with odd -
*     srcxlp  L         true if all sources polarized crossline +
*     srcxln  L         true if all sources polarized crossline -
*     ksxl    I         1 if source-lines alternate x-line, with odd +

*     rcvilp  L         true if all receivers polarized inline +
*     rcviln  L         true if all receivers polarized inline -
*     kril    I         1 if receiver-lines alternate i-line, with odd +
*     rcvxlp  L         true if all receivers polarized crossline +
*     rcvxln  L         true if all receivers polarized crossline -
*     krxl    I         1 if receiver-lines alternate x-line, with odd +

*     mclist  C*27      sequence for source-receiver pairs
*     ns1     I         starting trace for component 1
*     ne1     I         ending trace for component 1
*     ns2     I         starting trace for component 2
*     ne2     I         ending trace for component 2
*     ns3     I         starting trace for component 3
*     ne3     I         ending trace for component 3

c     verbos  L         verbose output or not

c     IKP   - L         IKP processing or not

      integer     argis
      integer     ksil, ksxl, kril, krxl
      integer     ns1, ne1, ns2, ne2, ns3, ne3

      character   srctap*(*), rcvtap*(*), reltap*(*), otap*(*)
      character   mclist*(*)

      logical     verbos
      logical     srcilp, srciln, srcxlp, srcxln
      logical     rcvilp, rcviln, rcvxlp, rcvxln

      real azmth0, srcaz1, srcaz2, rcvaz1, rcvaz2

*     filenames
      call argstr( '-S', srctap, ' ', ' ' )
      call argstr( '-R', rcvtap, ' ', ' ' )
      call argstr( '-X', reltap,   ' ', ' ' )
      call argstr( '-O', otap,   ' ', ' ' )

*     absolute azimuths
      call argr4 ( '-A' , azmth0,  0.0,90.0)
      call argr4 ( '-s1', srcaz1,  7777.0, 7777.0)
      call argr4 ( '-s2', srcaz2,  7777.0, 7777.0)
      call argr4 ( '-r1', rcvaz1,  7777.0, 7777.0)
      call argr4 ( '-r2', rcvaz2,  7777.0, 7777.0)

*     relative azimuths
      srcilp = (argis ('-SIp') .gt. 0)
      srciln = (argis ('-SIn') .gt. 0)
      call argi4 ( '-SIa', ksil, 1, 0)

      srcxlp = (argis ('-SXp') .gt. 0)
      srcxln = (argis ('-SXn') .gt. 0)
      call argi4 ( '-SXa', ksxl, 1, 0)

      rcvilp = (argis ('-RIp') .gt. 0)
      rcviln = (argis ('-RIn') .gt. 0)
      call argi4 ( '-RIa', kril, 1, 0)

      rcvxlp = (argis ('-RXp') .gt. 0)
      rcvxln = (argis ('-RXn') .gt. 0)
      call argi4 ( '-RXa', krxl, 1, 0)

*     relations
      call argstr( '-MCL', mclist, '11,12,21,22', '33' )
      call argi4 ( '-1ns', ns1, 1, 1)
      call argi4 ( '-1ne', ne1, 999, 999)
      call argi4 ( '-2ns', ns2, 1, 1)
      call argi4 ( '-2ne', ne2, 999, 999)
      call argi4 ( '-3ns', ns3, 1, 1)
      call argi4 ( '-3ne', ne3, 999, 999)

      verbos   = (argis('-V') .gt. 0)

*      IKP      = (argis('-IKP') .gt. 0) 

      return
      end
