C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
**********************************************************************c

c     sps_aps adds orientation info to sps files (both point record 
c             and relation) making them "aps" files,
c             and prepares a plotfile for aqplot

c**********************************************************************c
c        LER  is the current window.
c        LERR is a standard output file; will appear in directory as
c             SPS_APS.prcid.
c
c     declare variables
c
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c declare standard usp variables
      character*7   name
      character*255 otap
      integer       argis
      logical       verbos, query

c declare program-specific variables
      character*1   dum1, srctyp, rcvtyp
      character*13  dum13
      character*15  dum015, dum115, dum215
      character*16  linnam, srlnm, rclnm, srlnm0, srlnm1, srlnm2,
     &                            noname,  rclnm0, rclnm1, rclnm2
      character*21  dum021, dum121,dum221
      character*27  mclist
      character*33  dum33

      character*255 srcsps, srcaps, srcaqp
      character*255 rcvsps, rcvaps, rcvaqp
      character*255 relsps, relaps
      integer  lusrci, lusrco, lurcvi, lurcvo, lureli, lurelo
      integer  lusaqp, luraqp, length, mcel(9), mcsrc(3), mcrcvr(3)
      integer  lenth, strint

      integer  jsrc0, jsrc1, jsrc2
      integer  jrcvr0, jrcvr1, jrcvr2
      integer  nsrc, nrcvr, nsline, nrline, newlin
      integer  msplot(1000), mrplot(1000)
      integer  ns1, ne1, ns2, ne2, ns3, ne3

      logical  srcilp, srciln, srcxlp, srcxln
      logical  rcvilp, rcviln, rcvxlp, rcvxln

      real     xsrc0, ysrc0, xrcvr0, yrcvr0
      real     xsrc1, ysrc1, xrcvr1, yrcvr1
      real     xsrc2, ysrc2, xrcvr2, yrcvr2
      real     azmth0, srcaz1, srcaz2, rcvaz1, rcvaz2

c initialize variables

      data name,        noname,         mcsrc, mcrcvr
     &   /'SPS_APS', '  NoName        ', 3*0,   3*0 /

c issue command line help if requested 

      query = ( argis( '-?' ) .gt. 0 .or. argis( '-h' ) .gt. 0 )
      if ( query ) then
         call help()
         stop
      endif

c open printout files

#include <f77/open.h>
 
c read command line arguments
      call cmdln (srcsps, rcvsps, relsps, otap, azmth0,
     &            srcaz1, srcaz2, srcilp, srciln, srcxlp, srcxln,
     &            rcvaz1, rcvaz2, rcvilp, rcviln, rcvxlp, rcvxln,
     &            ksil, ksxl, kril, krxl, mclist,
     &            ns1, ne1, ns2, ne2, ns3, ne3, verbos)

      if ( srcsps .eq. ' ' ) then
         write(LER,*) ' You must specify an SPS sources file.'
         stop
      endif
      if ( rcvsps .eq. ' ' ) then
         write(LER,*) ' You must specify an SPS receivers file.'
         stop
      endif
      if ( relsps .eq. ' ' ) then
         write(LER,*) ' You must specify an SPS relation file.'
         stop
      endif

*     open source files
      length = lenth(srcsps)
      call alloclun(lusrci)
      open ( lusrci, file=srcsps(1:length), status='old', err=980)
      write(LER ,21)  srcsps
      write(LERR,21)  srcsps
 21   format(/' Source sps input: ',a80)

      srcaps = srcsps
      srcaps(length+1:length+4)='.aps'
      call alloclun(lusrco)
      open (lusrco, file=srcaps(1:length+4), status='new', err=960)
      write(LER ,22)  srcaps
      write(LERR,22)  srcaps
 22   format(/' Source aps output: ',a80)

      length = length + 4
      srcaqp = srcaps

      srcaqp(length+1:length+4)='.aqp'
      call alloclun(lusaqp)
      open (lusaqp, file=srcaqp(1:length+4), status='new', err=970)
      write(LER ,23)  srcaqp
      write(LERR,23)  srcaqp
 23   format(/' Source aqplot output: ',a80)

*     open receiver files
      length = lenth(rcvsps)
      call alloclun(lurcvi)
      open (lurcvi, file=rcvsps(1:length), status='old', err=990)
      write(LER ,31)  rcvsps
      write(LERR,31)  rcvsps
 31   format(/' Receiver sps input: ',a80)

      rcvaps = rcvsps
      rcvaps(length+1:length+4)='.aps'

      call alloclun(lurcvo)
      open (lurcvo, file=rcvaps(1:length+4), status='new', err=950)
      write(LER ,32)  rcvaps
      write(LERR,32)  rcvaps
 32   format(/' Receiver aps output: ',a80)

      length = length + 4
      rcvaqp = rcvaps
      rcvaqp(length+1:length+4)='.aqp'
      call alloclun(luraqp)
      open (luraqp, file=rcvaqp(1:length+4), status='new', err=976)
      write(LER ,33)  rcvaqp
      write(LERR,33)  rcvaqp
 33   format(/' Receiver aqplot output: ',a80)

      length = lenth(relsps)
      call alloclun(lureli)
      open ( lureli, file=relsps(1:length), status='old', err=940)
      write(LER ,36)  relsps
      write(LERR,36)  relsps
 36   format(/' Relation sps input: ',a80)

      relaps = relsps
      relaps(length+1:length+4)='.aps'
      call alloclun(lurelo)
      open (lurelo, file=relaps(1:length+4), status='new', err=930)
      write(LER ,37)  relaps
      write(LERR,37)  relaps
 37   format(/' Relation aps output: ',a80)

*     confirm polarization input

      write(LER, 38) azmth0
      write(LERR, 38) azmth0
 38   format(' sps X-axis has azimuth N', f6.1, ' E.')

      nscomps = 0
      if (srcilp) then
         write (LER ,41) 
         write (LERR,41) 
 41      format(' All source points polarized positive in-line.')
         nscomps = nscomps + 1
      endif

      if (srciln) then
         write (LER ,42) 
         write (LERR,42) 
 42      format(' All source points polarized negative in-line.')
         nscomps = nscomps + 1
      endif

      if (srcxlp) then
         write (LER ,43) 
         write (LERR,43) 
 43      format(' All source points polarized positive cross-line.')
         nscomps = nscomps + 1
      endif

      if (srcxln) then
         write (LER ,44) 
         write (LERR,44) 
 44      format(' All source points polarized negative cross-line.')
         nscomps = nscomps + 1
      endif

      if (srcaz1 .ne. 7777.0) then
         write (LER ,45)  srcaz1
         write (LERR,45)  srcaz1
 45      format(' All source points: 1-azimuth ',f8.1,' degrees.')
         nscomps = nscomps + 1
      endif

      if (srcaz2 .ne. 7777.0) then
         write (LER ,46) srcaz2
         write (LERR,46)  srcaz2
 46      format(' All source points: 2-azimuth ',f8.1,' degrees.')
         nscomps = nscomps + 1
      endif

         nrcomps = 0
      if (rcvilp) then
         write (LER ,51) 
         write (LERR,51) 
 51      format(' All receiver points polarized positive in-line.')
         nrcomps = nrcomps + 1
      endif

      if (rcviln) then
         write (LER ,52) 
         write (LERR,52) 
 52      format(' All receiver points polarized negative in-line.')
         nrcomps = nrcomps + 1
      endif

      if (rcvxlp) then
         write (LER ,53) 
         write (LERR,53) 
 53      format(' All receiver points polarized positive cross-line.')
         nrcomps = nrcomps + 1
      endif

      if (rcvxln) then
         write (LER ,54) 
         write (LERR,54) 
 54      format(' All receiver points polarized negative cross-line.')
         nrcomps = nrcomps + 1
      endif

      if (rcvaz1 .ne. 7777.0) then
         write (LER ,55)  rcvaz1
         write (LERR,55)  rcvaz1
 55      format(' All receiver points: 1-azimuth ',f8.1,' degrees.')
         nrcomps = nrcomps + 1
      endif

      if (rcvaz2 .ne. 7777.0) then
         write (LER ,56)  rcvaz2
         write (LERR,56)  rcvaz2
 56      format(' All receiver points: 2-azimuth ',f8.1,' degrees.')
         nrcomps = nrcomps + 1
      endif

      if (ksil .gt. 0) then
         write (LER ,61) 
         write (LERR,61) 
 61      format(' Sources polarized inline, alternately + and -,'/
     &          '         with odd lines polarized +.')
         nscomps = nscomps + 1
      elseif (ksil .lt. 0) then
         write (LER ,62) 
         write (LERR,62) 
 62      format(' Sources polarized inline, alternately + and -,'/
     &          '         with even lines polarized +.')
         nscomps = nscomps + 1
      endif

      if (ksxl .gt. 0) then
         write (LER ,63) 
         write (LERR,63) 
 63      format(' Sources polarized crossline, alternately + and -,'/
     &          '         with odd lines polarized +.')
         nscomps = nscomps + 1
      elseif (ksxl .lt. 0) then
         write (LER ,64) 
         write (LERR,64) 
 64      format(' Sources polarized crossline, alternately + and -,'/
     &          '         with even lines polarized +.')
         nscomps = nscomps + 1
      endif

      if (kril .gt. 0) then
         write (LER ,71) 
         write (LERR,71) 
 71      format(' Receivers polarized inline, alternately + and -,'/
     &          '           with odd lines polarized +.')
         nrcomps = nrcomps + 1
      elseif (kril .lt. 0) then
         write (LER ,72) 
         write (LERR,72) 
 72      format(' Receivers polarized inline, alternately + and -,'/
     &          '           with even lines polarized +.')
         nrcomps = nrcomps + 1
      endif

      if (krxl .gt. 0) then
         write (LER ,73) 
         write (LERR,73) 
 73      format(' Receivers polarized crossline, alternately + and -,'/
     &          '           with odd lines polarized +.')
         nrcomps = nrcomps + 1
      elseif (krxl .lt. 0) then
         write (LER ,74) 
         write (LERR,74) 
 74      format(' Receivers polarized crossline, alternately + and -,'/
     &          '           with even lines polarized +.')
         nrcomps = nrcomps + 1
      endif

*     construct src and rcvr queue

      icmp = 0
      nscmps = 0
      nrcmps = 0
 80   icmp = icmp + 1
         istart = 3*(icmp-1) + 1
         if (mclist(istart:istart+1) .eq. '  ') then
            if (icmp .eq. 1) then
               write (LER,*) ' Specify -MCL correctly!'
               stop
            else
               go to 90
            endif
         endif

         mcel(icmp) = strint(mclist, istart, istart+1)
         ircmp = mod(mcel(icmp),10)
         iscmp = (mcel(icmp)-ircmp)/10
         if (nscmps .eq. 0) then
            nscmps =  1
            mcsrc(1) = iscmp
         else
            do jcmp = 1, nscmps
               if (mcsrc(jcmp) .eq. iscmp) go to 84
            enddo
            nscmps = nscmps + 1
            mcsrc(nscmps) = iscmp
         endif

 84      if (nrcmps .eq. 0) then
            nrcmps =  1
            mcrcvr(1) = ircmp
         else
            do jcmp = 1, nrcmps
               if (mcrcvr(jcmp) .eq. ircmp) go to 89
            enddo
            nrcmps = nrcmps + 1
            mcrcvr(nrcmps) = ircmp
         endif

 89    go to 80

 90    if (nscmps .eq. 0) then
           if (.not. srcilp .and. .not. srciln .and.
     &        .not. srcxlp .and. .not. srcxln .and.
     &        srcaz1 .eq. 0.0 .and. srcaz2 .eq. 0.0 .and.
     &        ksil   .eq. 0   .and. ksxl   .eq. 0        ) then
              write (LER ,91) 
              write (LERR,91) 
 91           format(' All source points polarized vertical.')
              nscmps = 1
              mcsrc(1) = 3
         else
              write(LER,92) mcsrc
              write(LERR,92) mcsrc
 92           format(/' Source component sequence is: ',3i2)
              write(LERR,93)
              write(LER ,93)
 93           format(' ; THIS IS NOT CONSISTENT WITH COMMANDLINE',
     &               ' SPECIFICATIONS!')
              stop
         endif
      else
         if(verbos) write(LER,92) mcsrc
         write(LERR,92) mcsrc
      endif
      if (nscmps .ne. nscomps) then
         write(LER,93)
         write(LERR,93)
         stop
      endif

      if (nrcmps .eq. 0) then
         if (.not. rcvilp .and. .not. rcviln .and.
     &       .not. rcvxlp .and. .not. rcvxln .and.
     &       rcvaz1 .eq. 0.0 .and. rcvaz2 .eq. 0.0 .and.
     &       kril   .eq. 0   .and. krxl   .eq. 0        )then
            write (LER ,94) 
            write (LERR,94) 
 94         format(' All receiver points polarized vertical.')
            nrcmps = 1
            mcrcvr(1) = 3
         else
            write(LER,95) mcrcvr
            write(LERR,95) mcrcvr
 95         format(/' Receiver component sequence is: ',3i2)
            write(LERR,93)
            write(LER ,93)
            stop
         endif
      else
         if(verbos) write(LER,95) mcrcvr
         write(LERR,95) mcrcvr
      endif
      if (nrcmps .ne. nrcomps) then
         write(LER,93)
         write(LER ,93)
         stop
      endif

      ntcomps = nscomps*nrcomps
      write(LER,98)  (mcel(icomp), icomp = 1, ntcomps)
      write(LERR,98) (mcel(icomp), icomp = 1, ntcomps)
 98   format(/' MCList: ',9i3)

*     get limits, totals
      xmin = 1.0e9
      xmax = -1.0e9
      ymin = 1.0e9
      ymax = -1.0e9
      nsrc = 0
      nsline = 0
      nrcvr = 0
      nrline = 0

*     sources first

      call hdradd (lusrci, lusrco, mcsrc, 7, nhsrec, verbos)
      linnam = noname

*     start loop
*     sps format has:
*     col  1    : type S or R          | dum1
*     col  2-17 : line name 
*     col 18-25 : point number 
*     col 26    : point index (1-9)    |  NB: should be used as comp?
*     col 27-28 : point code           |
*     col 29-32 : static correction    | 
*     col 33-36 : point depth          | dum21
*     col 37-40 : seismic datum        |
*     col 41-42 : uphole time          |
*     col 43-46 : water depth          |
*     col 47-55 : x-coordinate (map easting)
*     col 56-65 : y-coordinate (map northing)
*     col 66-71 : surface elevation    |
*     col 72-74 : day                  | dum15
*     col 75-80 : time                 |

 120     read (lusrci, 125, end=200) srctyp, srlnm, jsrc, 
     &                               dum021, xsrc, ysrc
 125     format(a1, a16, i8, a21, f9.1, f10.1, a15)

*        NOTE: POSITIONS in sps, aps, and usp contexts correspond to 
*        x = "easting"; y = "northing", ie the standard surveying
*        convention.  However, for ORIENTATIONS, we use the 
*        SEG convention: a right-handed coordinate system with
*        the 3-axis pointed down, so that if the 1-axis is 
*        pointing east, the 2-axis points south, not north. 
*        Hence aqplot also uses this SEG convention. Here (in rotaz0),
*        we convert ALL geometry to this convention, then convert 
*        back, at the writing aps stage, in gwazm.

         call rotaz0(xsrc, ysrc, azmth0)
         if (xsrc .lt. xmin) xmin = xsrc
         if (ysrc .lt. ymin) ymin = ysrc
         if (xsrc .gt. xmax) xmax = xsrc
         if (ysrc .gt. ymax) ymax = ysrc
         nsrc = nsrc + 1
         if (srlnm .ne. linnam) then
            linnam = srlnm
            nsline = nsline + 1
         endif
      go to 120
*     end source loop

*     receivers next
 200  linnam = noname
      call hdradd (lurcvi, lurcvo, mcrcvr, 4, nhrrec, verbos)
*     start receiver loop
 220     read (lurcvi, 125, end=300) rcvtyp, rclnm, jrcvr, 
     &                               dum021, xrcvr, yrcvr
         call rotaz0(xrcvr, yrcvr, azmth0)
         if (xrcvr .lt. xmin) xmin = xrcvr
         if (yrcvr .lt. ymin) ymin = yrcvr
         if (xrcvr .gt. xmax) xmax = xrcvr
         if (yrcvr .gt. ymax) ymax = yrcvr
         nrcvr = nrcvr + 1
         if (rclnm .ne. linnam) then
            linnam = rclnm
            nrline = nrline + 1
         endif
      go to 220
*     end receiver loop

 300  if (nhsrec .ne. nhrrec) then
         write(LER,*) ' Original SPS records must have identical sets',
     &                ' of header records!'
         write(LER,*) ' I count ', nhsrec, ' source headers and ',
     &                             nhrrec, ' receiver headers'
         stop
      endif
*      write(LER,*) 'nhsrec, nhrrec', nhsrec, nhrrec

*     sources and receivers now perhaps have different records; merge
      call hdrmrg(lusrco, lurcvo, lurelo, lusaqp, mhrec, verbos)

      dx = xmax - xmin
      xmax = xmax + dx*.03
      xmin = xmin - dx*.03
      dy = ymax - ymin
      ymax = ymax + dy*.03
      ymin = ymin - dy*.03

      msrc = 0
      if (nsline .ne. 0) then 
         msrc = nsrc/nsline    
         call getpts(msrc, msplot)
      endif
      mrcvr = 0
      if (nrline .ne. 0) then
         mrcvr = nrcvr/nrline
         call getpts(mrcvr, mrplot)
      endif

      rewind lusaqp
      write(lusaqp,*) 'INIT', xmin, xmax, ymin, ymax, ' 90.0'
      rewind luraqp
      write(luraqp,*) 'INIT', xmin, xmax, ymin, ymax, ' 90.0'

*     do sources first
      call skip(lusrci, nhsrec)
*     note: both lusrci and lusrco are positioned at end of header
1100  read (lusrci, 125, end=1190) srctyp, srlnm0, jsrc0, 
     &                             dum021, xsrc0, ysrc0, dum015
      read (lusrci, 125, end=1190) srctyp, srlnm1, jsrc1, 
     &                                dum121, xsrc1, ysrc1, dum115
*     start line-draw
      newlin = 1
      isrc  = 2
      call rotaz0(xsrc0, ysrc0, azmth0)
      call rotaz0(xsrc1, ysrc1, azmth0)
      call gwazm(srlnm0, jsrc0, xsrc0, ysrc0,
     &           srlnm1, jsrc1, xsrc1, ysrc1,
     &           srlnm1, jsrc1, xsrc1, ysrc1,
     &           srcilp, srciln, srcxlp, srcxln, srcaz1, srcaz2,
     &           ksil, ksxl, mcsrc, nscomps,
     &           srctyp, dum021, dum015, dum121, dum115,
     &           newlin, isrc, msplot, lusaqp, lusrco)

*     start loop
 1110 read (lusrci, 125, end=1190) srctyp, srlnm2, jsrc2, 
     &                             dum221, xsrc2, ysrc2, dum215
           call rotaz0(xsrc2, ysrc2, azmth0)
           if (srlnm2 .eq. srlnm1) then
*             this means same line
              newlin = 0
              isrc = isrc + 1
              call gwazm(srlnm0, jsrc0, xsrc0, ysrc0,
     &                   srlnm1, jsrc1, xsrc1, ysrc1,
     &                   srlnm2, jsrc2, xsrc2, ysrc2,
     &                   srcilp, srciln,srcxlp,srcxln,srcaz1,srcaz2, 
     &                   ksil, ksxl, mcsrc, nscomps,
     &                   srctyp, dum021, dum015, dum121,dum115,
     &                   newlin, isrc, msplot, lusaqp, lusrco)
*             reset markers
              xsrc0 = xsrc1
              ysrc0 = ysrc1
              jsrc0 = jsrc1
              srlnm0 = srlnm1
              xsrc1 = xsrc2
              ysrc1 = ysrc2
              jsrc1 = jsrc2
              srlnm1 = srlnm2
           else
*             this means end of line
              newlin = -1
              call gwazm(srlnm0, jsrc0, xsrc0, ysrc0,
     &                   srlnm1, jsrc1, xsrc1, ysrc1,
     &                   srlnm1, jsrc1, xsrc1, ysrc1,
     &                   srcilp, srciln,srcxlp,srcxln,srcaz1,srcaz2,
     &                   ksil, ksxl, mcsrc, nscomps,
     &                   srctyp, dum021, dum015, dum121,dum115,
     &                   newlin, isrc, msplot, lusaqp, lusrco)
*             start new line, reset markers
              xsrc0 = xsrc2
              ysrc0 = ysrc2
              jsrc0 = jsrc2
              srlnm0 = srlnm2
              read (lusrci, 125, end=1190) srctyp, srlnm1, jsrc1, 
     &                                  dum121, xsrc1, ysrc1, dum115
              call rotaz0(xsrc1, ysrc1, azmth0)
              newlin = 1
              isrc = 2
              call gwazm(srlnm0, jsrc0, xsrc0, ysrc0,
     &                   srlnm1, jsrc1, xsrc1, ysrc1,
     &                   srlnm1, jsrc1, xsrc1, ysrc1,
     &                   srcilp, srciln,srcxlp,srcxln,srcaz1,srcaz2,
     &                   ksil, ksxl, mcsrc, nscomps,
     &                   srctyp, dum021, dum015, dum121, dum115,
     &                   newlin, isrc, msplot, lusaqp, lusrco)
           endif

         go to 1110
c        end loop; exit when file ends

*     finish line-end
 1190 newlin = -1
      call gwazm(srlnm0, jsrc0, xsrc0, ysrc0,
     &           srlnm1, jsrc1, xsrc1, ysrc1,
     &           srlnm1, jsrc1, xsrc1, ysrc1,
     &           srcilp, srciln,srcxlp,srcxln,srcaz1,srcaz2, 
     &           ksil, ksxl, mcsrc, nscomps,
     &           srctyp, dum021, dum015, dum121, dum115,
     &           newlin, isrc, msplot, lusaqp, lusrco)


*     do receivers next
      call skip(lurcvi, nhrrec)
*     note: both lurcvi and lurcvo are positioned at end of header
1200  read (lurcvi, 125, end=1290) rcvtyp, rclnm0, jrcvr0, 
     &                             dum021, xrcvr0, yrcvr0, dum015
      read (lurcvi, 125, end=1290) rcvtyp, rclnm1, jrcvr1, 
     &                             dum121, xrcvr1, yrcvr1, dum115
*     start line-draw
      newlin = 1
      ircvr  = 2
      call rotaz0(xrcvr0, yrcvr0, azmth0)
      call rotaz0(xrcvr1, yrcvr1, azmth0)
      call gwazm(rclnm0, jrcvr0, xrcvr0, yrcvr0,
     &           rclnm1, jrcvr1, xrcvr1, yrcvr1,
     &           rclnm1, jrcvr1, xrcvr1, yrcvr1,
     &           rcvilp, rcviln,rcvxlp,rcvxln,rcvaz1,rcvaz2, 
     &           kril, krxl, mcrcvr, nrcomps,
     &           rcvtyp, dum021, dum015, dum121, dum115,
     &           newlin, ircvr, mrplot, luraqp, lurcvo)

*        start loop
 1210    read (lurcvi, 125, end=1290) rcvtyp, rclnm2, jrcvr2, 
     &                             dum221, xrcvr2, yrcvr2, dum215
           call rotaz0(xrcvr2, yrcvr2, azmth0)
           if (rclnm2 .eq. rclnm1) then
*             this means same line
              newlin = 0
              ircvr = ircvr + 1
              call gwazm(rclnm0, jrcvr0, xrcvr0, yrcvr0,
     &                   rclnm1, jrcvr1, xrcvr1, yrcvr1,
     &                   rclnm2, jrcvr2, xrcvr2, yrcvr2,
     &                   rcvilp, rcviln,rcvxlp,rcvxln,rcvaz1,rcvaz2, 
     &                   kril, krxl, mcrcvr, nrcomps,
     &                   rcvtyp, dum021, dum015, dum121,dum115,
     &                   newlin, ircvr, mrplot, luraqp, lurcvo)
*             reset markers
              xrcvr0 = xrcvr1
              yrcvr0 = yrcvr1
              jrcvr0 = jrcvr1
              rclnm0 = rclnm1
              xrcvr1 = xrcvr2
              yrcvr1 = yrcvr2
              jrcvr1 = jrcvr2
              rclnm1 = rclnm2
           else
*             this means end of line
              newlin = -1
              call gwazm(rclnm0, jrcvr0, xrcvr0, yrcvr0,
     &                   rclnm1, jrcvr1, xrcvr1, yrcvr1,
     &                   rclnm1, jrcvr1, xrcvr1, yrcvr1,
     &                   rcvilp, rcviln,rcvxlp,rcvxln,rcvaz1,rcvaz2,
     &                   kril, krxl, mcrcvr, nrcomps,
     &                   rcvtyp, dum021, dum015, dum121,dum115,
     &                   newlin, ircvr, mrplot, luraqp, lurcvo)
*             start new line, reset markers

              xrcvr0 = xrcvr2
              yrcvr0 = yrcvr2
              jrcvr0 = jrcvr2
              rclnm0 = rclnm2
              read (lurcvi, 125, end=1290) rcvtyp, rclnm1, jrcvr1, 
     &                             dum121, xrcvr1, yrcvr1, dum115
              call rotaz0(xrcvr1, yrcvr1, azmth0)
              newlin = 1
              ircvr = 2
              call gwazm(rclnm0, jrcvr0, xrcvr0, yrcvr0,
     &                   rclnm1, jrcvr1, xrcvr1, yrcvr1,
     &                   rclnm1, jrcvr1, xrcvr1, yrcvr1,
     &                   rcvilp, rcviln,rcvxlp,rcvxln,rcvaz1,rcvaz2, 
     &                   kril, krxl, mcrcvr, nrcomps,
     &                   rcvtyp, dum021, dum015, dum121,dum115,
     &                   newlin, ircvr, mrplot, luraqp, lurcvo)
           endif

         go to 1210
c        end loop; exit when file ends

*     finish line-end
 1290 newlin = -1
      call gwazm(rclnm0, jrcvr0, xrcvr0, yrcvr0,
     &           rclnm1, jrcvr1, xrcvr1, yrcvr1,
     &           rclnm1, jrcvr1, xrcvr1, yrcvr1,
     &           rcvilp, rcviln,rcvxlp,rcvxln,rcvaz1,rcvaz2, 
     &           kril, krxl, mcrcvr, nrcomps,
     &           rcvtyp, dum021, dum015, dum121, dum115,
     &           newlin, ircvr, mrplot, luraqp, lurcvo)

*     do relations next
*     sps format :
*     col  1    : type X               |
*     col  2-7  : field tape no.       |
*     col  8-11 : field record no.     | dum13
*     col 12    : field record incr.   |
*     col 13    : rcvr instrument code |
*     col 14-29 : shot line name        (a16)
*     col 30-37 : shot point no.        (i8)
*     col 38    : shot point index      (a1)
*     col 39-42 : from rcvr channel     (i4)
*     col 43-46 : to rcvr channel       (i4)
*     col 47    : rcvr channel incr     (i1)
*     col 48-63 : rcvr line name       |
*     col 64--71: from rcvr            |
*     col 72-79 : to rcvr              | dum33
*     col 80    : rcvr index           |

 2000 call skip (lureli, nhsrec)
*     note: both lureli and lurelo are positioned at end of header 

*     start relation loop
      nrel = 0
 2100 read (lureli, 2105, end=3000) dum13, srlnm, isrc, dum1,
     &                              ichfr, ichto, ichinc, dum33
 2105     format(a13, a16, i8, a1, 2i4, i1, a33, 2i3)
          nrel = nrel + 1
          
          do icomp = 1, ntcomps
             ircomp = mod(mcel(icomp),10)
             iscomp = (mcel(icomp)-ircomp)/10
*             write(LER,*) icomp, mcel(icomp), iscomp, ircomp
                if (ircomp .eq. 1) then
                   if (ichfr .ge. ns1 .and. ichto .le. ne1 ) then
                      write (lurelo, 2105) dum13, srlnm, isrc, dum1,
     &                       ichfr, ichto, ichinc, dum33, iscomp, 1
                   endif
                elseif (ircomp .eq. 2) then
                   if (ichfr .ge. ns2 .and. ichto .le. ne2) then
                      write (lurelo, 2105) dum13, srlnm, isrc, dum1,
     &                       ichfr, ichto, ichinc, dum33, iscomp, 2
                   endif
                elseif (ircomp .eq. 3) then
                   if (ichfr .ge. ns3 .and. ichto .le. ne3) then
                      write (lurelo, 2105) dum13, srlnm, isrc, dum1,
     &                       ichfr, ichto, ichinc, dum33, iscomp, 3
                   endif
                else
                   write (lurelo, 2105) dum13, srlnm, isrc, dum1,
     &                             ichfr, ichto, ichinc, dum33, 0, 0
                endif

           enddo
 
      go to 2100
*     end of relation loop
 3000 continue
*
      close(lusrci)
      close(lusrco)
      close(lusaqp)

      close(lurcvi)
      close(lurcvo)
      close(luraqp)

      close(lureli)
      close(lurelo)

      write( LERR, * ) ' '
      write( LERR, * ) ' Normal end of sps_aps.'
      write( LERR, * ) ' Processed ',nsline, ' shot lines, with',
     &                                  nsrc,' shots;'
      write( LERR, * ) '           ',nrline, ' receiver lines, with',
     &                                nrcvr, ' groups;'
      write( LERR, * ) '       and ',nrel,   ' relations, with',
     &                              ntcomps, ' components each.'

      write( LERR, * ) ' '
      write( LER, * ) ' '
      write( LERR, * ) ' Normal Termination'
      write( LER, * ) ' Normal Termination'
      write( LER, * ) ' '
      stop

 920  write(LER,925) isrc, srcaps
      write(LERR,925) isrc, srcaps
 925  format(/' SPS_APS: Could not find shot # ',i5,
     &        'in aps record file ',a80)
      stop

 930  write(LER,935) relaps
      write(LERR,935) relaps
 935  format(/' SPS_APS: Error opening aps relation output file ',a80/
     &        '         Check for prior existence; move/remove as nec.')
      stop

 940  write(LER,945) relsps
      write(LERR,945) relsps
 945  format(/' SPS_APS: Error opening sps relation input file ',a80/
     &        '         Check for prior existence; move/create as nec.')
      stop

 950  write(LER,955) rcvaps
      write(LERR,955) rcvaps
 955  format(/' SPS_APS: Error opening aps receiver output file ',a80/
     &        '         Check for prior existence; move/remove as nec.')
      stop

 960  write(LER,965) srcaps
      write(LERR,965) srcaps
 965  format(/' SPS_APS: Error opening aps source output file ',a80/
     &        '         Check for prior existence; move/remove as nec.')
      stop

 970  write(LER,975) srcaqp
      write(LERR,975) srcaqp
 975  format(/' SPS_APS: Error opening source aqplot output file ',a80/
     &        '         Check for prior existence; move/remove as nec.')
      stop

 976  write(LER,977) rcvaqp
      write(LERR,977) rcvaqp
 977  format(/' SPS_APS: Error opening receiver aqplot output file ',a80
     &       /'         Check for prior existence; move/remove as nec.')
      stop

 980  write(LER,985) srcsps
      write(LERR,985) srcsps
 985  format(/' SPS_APS: Error opening sps source input file ',a80/
     &        '         Check for prior existence; move/create as nec.')
      stop

 990  write(LER,995) rcvsps
      write(LERR,995) rcvsps
 995  format(/' SPS_APS: Error opening sps receiver input file ',a80/
     &        '         Check for prior existence; move/create as nec.')
      stop

      end
*****************************************************************
*****************************************************************
*****************************************************************
*****************************************************************
      subroutine skip (luin, nhrec)
*     skips headers.

      rewind luin
 100  do iread = 1, nhrec
         read(luin, *)
      enddo

      return
      end
*****************************************************************
*****************************************************************
*****************************************************************
*****************************************************************
      subroutine gwazm(linm0, j0, x0, y0,
     &                 linm1, j1, x1, y1,
     &                 linm2, j2, x2, y2,
     &                 ilp, iln, xlp, xln, az1, az2, 
     &                 kil, kxl, mcq, ncomps,
     &                 type, dum021, dum015, dum121, dum115,
     &                 newlin, ipoint, mplot, luaqp, luapso)

*     gets, writes azimuth, component label

*     linmi is line name (i=0, 1, 2) => (previous, current, next)
*     j     is point (shot or receiver) index
*     x, y are coords
*     ilp is true if this point has a polarization locally in-line +
*     iln is true if this point has a polarization locally in-line -
*     xlp is true if this point has a polarization locally x-line +
*     xln is true if this point has a polarization locally x-line -
*     az1, az2 give absolute azimuths
*     kil = 1 if alternating lines have + in-line polarity, with odds +
*           0 if disabled
*          -1 if alternating lines have + in-line polarity, with odds -
*     nline = 
*     kxl = 1 if alternating lines have + x-line polarity, with odds +
*           0 if not enabled
*          -1 if alternating lines have + x-line polarity, with odds -
*     mcq   gives sequence with which polarizations are to be written
*     ncomps is # of polarizations
*     type   = S or R
*     dumxxx   copies character data from sps file to aps file
*     newlin = 1 means new line (s or r) has started
*            = 0 means no line has started or ended within current +-1
*            =-1 means line has just ended
*     ipoint counts points on this line
*     mplot gives an index plotting code, calcd in getpts

#include <f77/iounit.h>

      character*1   type, just
      character*3   label
      character*15  dum015, dum115
      character*16  linm0, linm1, linm2
      character*21  dum021, dum121

      integer   newlin, luaqp, luapso
      integer   j0, j1, j2, kil, kxl, ncomps, jcomp, strint
      integer   mplot(*), mcq(*)
      logical   tilp, tiln, txlp, txln
      logical   ilp, iln, xlp, xln
      real      x0, y0, x1, y1, x2, y2

      data pio180/.0174533/
*     pi/180 converts degrees to radians

*     get local azimuth of the LINE (avgd fwd & back),
*     with E = 90 degrees

      if (x2 .eq. x0) then
         azmlin = 90.0
      else
         slope = (y2 - y0)/(x2 - x0)
         azmlin = atan(slope)/pio180
*        this puts azmlin in (-90,+90), like a graph,
*        where 0 degrees => x-axis, and degrs increase counter-clockwise
*        (right-handed system, with z up, and 0 along the x-axis)
         if (x2 .lt. x0) azmlin = azmlin + 180.
*        this puts azmlin in (0,+360)
         azmlin = 360.0 - azmlin
*        this makes degrees increase clockwise, like a compass
*        (right-handed system, with z down, and 0 along the x-axis (E))
*        unwrap if nec:
         if (azmlin .gt. 360.) azmlin = azmlin - 360.
         azmlin = azmlin + 90
*        this puts 90 degrees => x-axis pointing East

      endif

*     orient this towards INcreasing indices, regardless of order
      if (j0 .gt. j2) then
         azmlin = azmlin + 180.
         if (azmlin .gt. 360.) azmlin = azmlin - 360.
      endif

*     get draw, print code
      if (newlin .ne. 0) then
*        this means line end, either + or -
*        also write Line Label
         if (newlin .lt. 0) then
            just = 'L'
         else
            just = 'R'
         endif
         if (newlin .eq. 1) then
*           this means new line, so:  label, print, no draw
            koded = 0
            kodep = 1
            call  getlabl (linm0, 1, 16, 3, label)
            write(luaqp, 45) x0, y0, azmlin, 
     &                       type, label, just
 45         format('Label    ', 3f15.1, 2x,
     &             '"',1a1, 'L', a3,'"',2x, 1a1)

         else
*           this means old line ends, so print, draw (label later)
            koded = 1
            kodep = 1
         endif

      else
*        this means same line, so: draw, no print, no label
         koded = 1
*        get scaled-print code
         kodep = mplot(ipoint)

      endif 

*     if lines are alternating:
      if (kil .eq. 0) then
         tilp = ilp
         tiln = iln
      else
         kodd = mod(strint(linm1,1,16),2)
*        kodd  = 1 for nline odd, 0 for nline even
         if (kil .gt. 0) then
            if (kodd .eq. 1) then
               tilp = .true.
               tiln = .false.
            endif
            if (kodd .eq. 0) then
               tiln = .true.
               tilp = .false.
            endif
         else
            if (kodd .eq. 1) then
               tiln = .true.
               tilp = .false.
            endif
            if (kodd .eq. 0) then
               tilp = .true.
               tiln = .false.
            endif
         endif
      endif

      if (kxl .eq. 0) then
         txlp = xlp
         txln = xln
      else
         kodd = mod(strint(linm1,1,16),2)
         if (kxl .gt. 0) then
            if (kodd .eq. 1) then
               txlp = .true.
               txln = .false.
            endif
            if (kodd .eq. 0) then
               txln = .true.
               txlp = .false.
            endif
         else
            if (kodd .eq. 1) then
               txln = .true.
               txlp = .false.
            endif
            if (kodd .eq. 0) then
               txlp = .true.
               txln = .false.
            endif
         endif
      endif 

 200  do icomp = 1, ncomps
         jcomp = mcq(icomp)
*        formats for aqplot file
 205     format(1a1, i9, 3f15.1, 3x,2i6,f10.1)
*                ,' Line ',a16,' Comp ',i2)
*|        |              |              |              |  |     |     |
 225     format(1a1, i9, 2f15.1,'        Z    ',2i6,f10.1)
*     &          ,' Line ',a16,' Comp ',i2)
*        formats for aps file
 215     format(a1, a16, i8, a21, f9.1, f10.1, a15, i2, f8.1, f10.1)
 235     format(a1, a16, i8, a21, f9.1, f10.1, a15, i2, 1a8, f10.1)

*        NOTE: POSITIONS in sps, aps, and usp contexts correspond to 
*              x = "easting"; y = "northing", ie the standard surveying
*              convention.  However, for ORIENTATIONS, we use the 
*              SEG convention: a right-handed coordinate system with
*              the 3-axis pointed down, so that if the 1-axis is 
*              pointing east, the 2-axis points south, not north. 
*              Hence aqplot also uses this SEG convention.  Since all
*              orientations herein use this, we undo it here for the
*              positions only, printing -y (instead of y) in the aps 
*              files only.

         if (jcomp .eq. 1) then

            if (tilp) then
               if (newlin .eq. 1) then
                  write(luaqp, 205) type,j0,x0,y0, azmlin, 
     &                              koded, kodep, azmlin
*     &                              koded, kodep, azmlin, linm0, 1
                  write(luapso, 215) type, linm0, j0, dum021, x0, -y0, 
     &                               dum015, 1, azmlin, azmlin
               else
                  write(luaqp, 205) type,j1,x1,y1, azmlin, 
     &                              koded, kodep, azmlin
*     &                              koded, kodep, azmlin, linm1, 1
                  write(luapso, 215) type, linm1, j1, dum121, x1, -y1, 
     &                               dum115, 1, azmlin, azmlin
               endif
            endif

            if (tiln) then
               azmuth = azmlin + 180.
               if (azmuth .gt. 360.) azmuth = azmuth - 360.
               if (newlin .eq. 1) then
                  write(luaqp, 205) type,j0,x0,y0, azmuth, 
     &                              koded, kodep, azmlin
*     &                              koded, kodep, azmlin, linm0, 1
                  write(luapso, 215) type, linm0, j0, dum021, x0, -y0, 
     &                               dum015, 1, azmuth, azmlin
               else
                  write(luaqp, 205) type,j1,x1,y1, azmuth, 
     &                              koded, kodep, azmlin
*     &                              koded, kodep, azmlin, linm1, 1
                  write(luapso, 215) type, linm1, j1, dum121, x1, -y1, 
     &                               dum115, 1, azmuth, azmlin
               endif
            endif

            if (az1 .ne. 0.0) then
               if (newlin .eq. 1) then
                  write(luaqp, 205) type,j0,x0,y0, az1, 
     &                              koded, kodep, azmlin
*     &                              koded, kodep, azmlin, linm0, 1
                  write(luapso, 215) type, linm0, j0, dum021, x0, -y0, 
     &                               dum015, 1, az1, azmlin
               else
                  write(luaqp, 205) type,j1,x1,y1, az1, 
     &                              koded, kodep, azmlin
*     &                              koded, kodep, azmlin, linm1, 1
                  write(luapso, 215) type, linm1, j1, dum121, x1, -y1,
     &                               dum115, 1, az1, azmlin
               endif
            endif

          elseif (jcomp .eq. 2) then

            if (txlp) then
               azmuth = azmlin + 90.
               if (azmuth .gt. 360.) azmuth = azmuth - 360.
               if (newlin .eq. 1) then
                  write(luaqp, 205) type,j0,x0,y0, azmuth, 
     &                              koded, kodep, azmlin
*     &                              koded, kodep, azmlin, linm0, 2
                  write(luapso, 215) type, linm0, j0, dum021, x0, -y0, 
     &                               dum015, 2, azmuth, azmlin
               else
                  write(luaqp, 205) type,j1,x1,y1, azmuth, 
     &                              koded, kodep, azmlin
*     &                              koded, kodep, azmlin, linm1, 2
                  write(luapso, 215) type, linm1, j1, dum121, x1, -y1, 
     &                               dum115, 2, azmuth, azmlin
               endif
            endif

            if (txln) then
               azmuth = azmlin - 90.
               if (azmuth .lt. 0.) azmuth = azmuth + 360.
               if (newlin .eq. 1) then
                  write(luaqp, 205) type,j0,x0,y0, azmuth, 
     &                              koded, kodep, azmlin
*     &                              koded, kodep, azmlin, linm0, 2
                  write(luapso, 215) type, linm0, j0, dum021, x0, -y0, 
     &                               dum015, 2, azmuth, azmlin
               else
                  write(luaqp, 205) type,j1,x1,y1, azmuth, 
     &                              koded, kodep, azmlin
*     &                              koded, kodep, azmlin, linm1, 2
                  write(luapso, 215) type, linm1, j1, dum121, x1, -y1, 
     &                               dum115, 2, azmuth, azmlin
               endif
            endif

            if (az2 .ne. 0.0) then
               if (newlin .eq. 1) then
                  write(luaqp, 205) type,j0,x0,y0, az2, 
     &                              koded, kodep, azmlin
*     &                              koded, kodep, azmlin, linm0, 2
                  write(luapso, 215) type, linm0, j0, dum021, x0, -y0, 
     &                               dum015, 2, az2, azmlin
               else
                  write(luaqp, 205) type,j1,x1,y1, az2, 
     &                              koded, kodep, azmlin
*     &                              koded, kodep, azmlin, linm1, 2
                  write(luapso, 215) type, linm1, j1, dum121, x1, -y1,
     &                               dum115, 2, az2, azmlin
               endif
            endif

         else
*     default is Z polarization
            if (.not. tilp .and. .not. tiln .and.
     &          .not. txlp .and. .not. txln .and.
     &           az1 .eq. 0.0 .and. az2 .eq. 0.0 .and.
     &           kil .eq. 0   .and. kxl .eq. 0    ) then
               if (newlin .eq. 1) then
                  write(luaqp, 225) type,j0,x0,y0, koded, kodep, azmlin
*     &                 ,linm0, 3
                  write(luapso, 235) type, linm0, j0, 
     &                  dum021, x0, -y0, dum015, 3, '    Z   ', azmlin
               else
                  write(luaqp, 225) type,j1,x1,y1, koded, kodep, azmlin
*     &                 ,linm1, 3
                  write(luapso, 235) type, linm1, j1, 
     &                  dum121, x1, -y1, dum115, 3, '    Z   ', azmlin
               endif

            endif

         endif

      enddo

      if (newlin .eq. -1) then
            call  getlabl (linm1, 1, 16, 3, label)
         write(luaqp, 45) x1, y1, azmlin, type, label, just
      endif

      return
      end
*****************************************************************
*****************************************************************
*****************************************************************
*****************************************************************
      subroutine getpts(n,m)
*     gets print-points
      
      integer m(*)

 100  do 109 j=2,n
         m(j) = 0
 109  enddo

      nfold = alog(1.0*n)/alog(2.0)
      scale = n
*     for each two-fold division:
 200  do 209 k = 1,nfold
         kdivs = 2**(k-1)
 220     do 229 kk=0,kdivs
            jmid = scale*(kk + .5)
            if (m(jmid) .eq. 0) m(jmid) = 2**k
 229     enddo
         scale = scale/2.
 209  enddo

      return
      end
*****************************************************************
*****************************************************************
*****************************************************************
*****************************************************************
      subroutine rotaz0(x, y, azmth0)
*     inverts, rotates initial x, y by azmth0

      real x, y, azmth0, arg
      
      data pio180/.0174533/
*     pi/180 converts degrees to radians

*     so that right-handed +z points down, reverse y polarity
*     for ORIENTATION coordinate system only.
*     Note: this will be undone for POSITION coord sys, in gwazm
      y = -y

      if (azmth0 .eq. 90.0) return

      arg = (azmth0-90.0)*pio180
      sinaz = sin(arg)
      cosaz = cos(arg)

      xrotd = x*cosaz + y*sinaz
      y     =-x*sinaz + y*cosaz

      x = xrotd

      return
      end
*****************************************************************
*****************************************************************
*****************************************************************
*****************************************************************
      subroutine hdradd (luin, luout, mcq, srcode, nhrec, verbos)
*     adds mc info to sps headers.  Assumes that sps headers have only 
*     one Instrument code group, one Receiver code group, and 
*     one Source code group, and are identical sets for Source Point,
*     Receiver Point, and Relation files

#include <f77/iounit.h>

      character*1  char1, H
      character*2  H4, H5, H6, H7
      character*3  char3
      character*80 card, buffer(20)
      integer luin, luout, ir(3), mcq(3), srcode
      integer strint
      logical verbos

      data  H ,  H4,   H5,   H6,   H7
     &    /'H', 'H4', 'H5', 'H6', 'H7'/

 80   format(1a80)

      if (srcode .eq. 7) then
         do iscmp = 1,3
            if (mcq(iscmp) .eq. 0) go to 92
         enddo
 92      nscmp = iscmp - 1
         nrcmp = 0
      elseif (srcode .eq. 4) then
         do ircmp = 1,3
            if (mcq(ircmp) .eq. 0) go to 94
         enddo
 94      nrcmp = ircmp - 1
         nscmp = 0
      endif

      rewind luin
      rewind luout

      read(luin, 80, end=900) card
      nhrec = 1
      card(1:47) = 'H00 APS format version number   APS001,04.09.95'
      write(luout,80) card

 100  read(luin, 80, end=900) card
         nhrec = nhrec + 1
         if (nrcmp .eq. 0) then
*           this is an sps source file, so:
            if (card(1:2) .ne. H7) then
               write(luout,80) card
               go to 100
            else
               backspace luin
               nhrec = nhrec - 1
               go to 700
            endif
         elseif (nscmp .eq. 0) then
*           this is an sps receiver file, so:
            if (card(1:2) .ne. H4) then
               write(luout,80) card
               go to 100
            else
               ih4rec = 0
            endif
         endif

*     do instrument code group(s) H400-H419, ...
 400  ih4rec = ih4rec + 1
      if (card(3:4) .eq. '09') then
         iircmp = mcq(1)
         if(iircmp .eq. 1) card(35:45) = 'X;         '
         if(iircmp .eq. 2) card(35:45) = 'Y;         '
         if(iircmp .eq. 3) card(35:45) = 'Z;         '
         ih409rec = ih4rec
      endif
      card(33:34)='1,'
      buffer(ih4rec) = card   
      write(luout,80) card

*     read another H4? card
      read(luin, 80, end=900) card
      nhrec = nhrec + 1
      if (card(1:2) .eq. H4 .and. strint(card,3,3) .le. 1 ) go to 400
      backspace luin
      nhrec = nhrec - 1

*     end of H400-H419 instrument group
      if (nrcmp .gt. 1) then
*        check to see if another instrument group is already there
         if (card(1:2) .eq. H4 .or.
     &       card(1:2) .eq. H5     ) then
            write(LER,*) ' More than one instrument code group',
     &                 ' is specified; check sps_aps man page!'
            stop
         endif

*        if not, then put them in, one for each component
         do ircmp=2,nrcmp

*           first 9 possible records only have instrument code changed
            do ihrec = 1, 9
               int3 = strint(buffer(ihrec), 2, 4)
               if (int3 .eq. 409) go to 409
               write(char3,'(i3)') int3 + 20
               buffer(ihrec)(2:4) = char3
               write(char1,'(i1)') ircmp
               buffer(ihrec)(33:33) = char1
               buffer(ihrec)(34:34) = ','
               write(luout,80) buffer(ihrec)
            enddo

*           10th record has component designation changed also
 409        int3 = strint(buffer(ih409rec), 2, 4)
            write(char3,'(i3)') int3 + 20
            buffer(ihrec)(2:4) = char3
            write(char1,'(i1)') ircmp
            buffer(ih409rec)(33:33) = char1
            buffer(ih409rec)(34:34) = ','
            iircmp = mcq(ircmp)
            if (iircmp .eq. 1) buffer(ih409rec)(35:36) = 'X;'
            if (iircmp .eq. 2) buffer(ih409rec)(35:36) = 'Y;'
            if (iircmp .eq. 3) buffer(ih409rec)(35:36) = 'Z;'
            write(luout,80) buffer(ih409rec)

*           final records have only intrument code changed
            if (ih4rec .gt. ih409rec) then
               do ihrec = ih409rec+1,ih4rec
                  int3 = strint(buffer(ihrec), 2, 4)
                  write(char3,'(i3)') int3 + 20
                  buffer(ihrec)(2:4) = char3
                  write(char1,'(i1)') ircmp
                  buffer(ihrec)(33:33) = char1
                  buffer(ihrec)(34:34) = ','
                  write(luout,80) buffer(ihrec)
               enddo
            endif
         enddo
      endif
*     finished with instrument group

*     do receiver code group(s) H600-H609, ...
 600  read(luin, 80, end=900) card
      nhrec = nhrec + 1
      if (card(1:2) .ne. H6) then
         write(LER,*) 'Error in sps headers at H600'
         stop
      endif
      
      ih6rec = 0

 610  ih6rec =  ih6rec + 1
      card(33:35)='R1,'
      buffer(ih6rec) = card
      write(luout,80) card

*     read another H6? card
      read(luin, 80, end=900) card
      nhrec = nhrec + 1
      if (card(1:2) .eq. H6 .and. strint(card,3,3) .le. 1 ) go to 610
      backspace luin
      nhrec = nhrec - 1

*     end of H600-H609 receiver group
      if (nrcmp .gt. 1) then
*        check to see if another receiver group is already there
         if (card(1:2) .eq. H6) then
            write(LER,*) ' More than one receiver code group',
     &                 ' is specified; check sps_aps man page!'
            stop
         endif

*        if not, then put them in, one for each component
         do ircmp=2,nrcmp

            do ihrec = 1, ih6rec
               int3 = strint(buffer(ihrec), 2, 4)
               write(char3,'(i3)') int3 + 10
               buffer(ihrec)(2:4) = char3
               buffer(ihrec)(33:33) = 'R'
               write(char1,'(i1)') ircmp
               buffer(ihrec)(34:34) = char1
               buffer(ihrec)(35:35) = ','
               write(luout,80) buffer(ihrec)
            enddo

         enddo
      endif
*     finished with receiver group(s)
      go to 800

*     do source code group(s) H700-H709, ...
 700  read(luin, 80, end=900) card
      nhrec = nhrec + 1
      if (card(1:2) .ne. H7) then
         write(6,*) 'Error in sps headers at H700'
         stop
      endif

      if (nscmp .eq. 0) go to 750
      ih7rec = 0
 710  if(nscmp .ne. 0) card(33:35)='V1,'
      ih7rec =  ih7rec + 1
      buffer(ih7rec) = card
 750  write(luout,80) card

*     read another H7? card
      read(luin, 80, end=900) card
      nhrec = nhrec + 1
      if (card(1:2) .eq. H7 .and. strint(card,3,3) .le. 1) go to 710
      backspace luin
      nhrec = nhrec - 1

*     end of H700-H709 source group
      if (nscmp .gt. 1) then
*        check to see if another source group is alreay there
         if (card(1:2) .eq. H7) then
            write(LER,*) ' More than one source code group',
     &                 ' is specified; check sps_aps man page!'
            stop
         endif

*        if not, then put them in, one for each component
         do iscmp=2,nscmp

            do ihrec = 1, ih7rec
               int3 = strint(buffer(ihrec), 2, 4)
               write(char3,'(i3)') int3 + 20
               buffer(ihrec)(2:4) = char3
               buffer(ihrec)(33:33) = 'V'
               write(char1,'(i1)') iscmp
               buffer(ihrec)(34:34) = char1
               buffer(ihrec)(35:35) = ','
               write(luout,80) buffer(ihrec)
            enddo

         enddo
      endif
*     finished with source group(s)

*     finish copying header deck
 800  read(luin, 80, end=900) card
      if (card(1:1) .ne. H) go to 900
         nhrec = nhrec + 1
         write(luout,80) card
         go to 800

 900  backspace luin
      if (verbos) then
            write (LERR,*) 
         if (nscmp .gt. 0) then
            write (LERR,*) ' aps source headers written.'
         elseif (nrcmp .gt. 0) then
            write (LERR,*) ' aps receiver headers written.'
         endif
      endif

      if (nrcmp .gt. 1) then
         do ircmp = 1, nrcmp
            ir(ircmp) = mcq(ircmp)
            if (ir(ircmp) .eq. 3) then
               write(LERR,995) 
 995           format(' Instrument groups and receiver groups'/
     &                ' with vertical polarization'/
     &                ' have been assumed equal in characteristics'/
     &                ' to those of horizontal polarization,'/
     &                ' in the aps header updates.  Check this!')
            endif
         enddo
      endif

      return
      end
*****************************************************************
*****************************************************************
*****************************************************************
*****************************************************************
      subroutine hdrmrg(lusrco, lurcvo, lurelo, lutmp, mhrec, verbos)
*     merge source and receiver headers, 
*     using lutmp as temporary storage

#include <f77/iounit.h>

      character*80 cardr, cards
      integer      strint, indxs, indxr
      logical      srcend, rcvend, verbos

      rewind lusrco
      rewind lurcvo
      rewind lutmp

 80   format(1a80)

      mhrec = 0
      srcend = .false.
      rcvend = .false.
 100  read (lusrco, 80, end=900) cards
 110  read (lurcvo, 80, end=910) cardr

      if (.not. srcend) indxs = strint(cards, 2, 4)
      if (.not. rcvend) indxr = strint(cardr, 2, 4)
*      write(6,*) 'indxs, indxr', indxs, indxr

      if (indxs .eq. indxr) then

         if (indxs .lt. 700) then
            write (lutmp, 80) cardr
*            write(LER,*) cardr
         else
            write (lutmp, 80) cards
*            write(LER,*) cards
         endif
         mhrec = mhrec + 1

      elseif (indxr .lt. indxs) then
*        some rcvr cards(H4.. and/or H6..) have been inserted
 400     write (lutmp, 80) cardr
*        write(LER,*) cardr
         mhrec = mhrec + 1
         read (lurcvo, 80, end=910) cardr
         indxr = strint(cardr, 2, 4)
         if (indxr .lt. indxs) go to 400
         backspace lurcvo
         backspace lusrco

      elseif (indxs .lt. indxr) then
*        some src cards (H7..) have been inserted
 600     write (lutmp, 80) cards
*        write(LER,*) cards
         mhrec = mhrec + 1
         read (lusrco, 80, end=900) cards
         indxs = strint(cards, 2, 4)
         if (indxs .lt. indxr) go to 600
         backspace lusrco
         backspace lurcvo

      endif
      go to 100

 900  srcend = .true.
      if (rcvend) then
         go to 1000
      else
         go to 110
      endif

 910  rcvend = .true.
      if (srcend) then
         go to 1000
      else
         go to 100
      endif

*     lutmp now has merged headers.  
*     Copy these back into src, rcv, rel files
 1000 rewind lusrco
      rewind lurcvo
      rewind lurelo
      rewind lutmp
      do icopy = 1, mhrec
         read (lutmp, 80) cards
         write(lusrco, 80) cards
         write(lurcvo, 80) cards
         write(lurelo, 80) cards
      enddo

      if (verbos) then
         write(LERR,*) ' aps source and receiver headers merged,'
         write(LERR,*) '  and written in aps relation file as well.'
      endif
      return
      end
