C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************
c usp_sps  reads data from usp line headers and trace headers, and 
c          writes geometry files in sps-like format.  Works for 
c          single- or multi-component data.
c
c**********************************************************************
c
c USP system includes
c
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

#ifdef SUNSYSTEM
      implicit   none
#endif

      character name*100

c
c    USP dataset dimensions, variables
c
      integer numsmp, numtrc, numrec, ns, irs

      integer ifmt_RecNum, l_RecNum, ln_RecNum, recnum
      integer ifmt_TrcNum, l_TrcNum, ln_TrcNum, trcnum
      integer ifmt_SrcLoc, l_SrcLoc, ln_SrcLoc, srcloc
      integer ifmt_LinInd, l_LinInd, ln_LinInd, linind
      integer ifmt_SrPtXC, l_SrPtXC, ln_SrPtXC, srptxc
      integer ifmt_SrPtYC, l_SrPtYC, ln_SrPtYC, srptyc
      integer ifmt_RcPtXC, l_RcPtXC, ln_RcPtXC, rcptxc
      integer ifmt_RcPtYC, l_RcPtYC, ln_RcPtYC, rcptyc
*      integer ifmt_SoPtNm, l_SoPtNm, ln_SoPtNm, soptnm
      integer ifmt_RecInd, l_RecInd, ln_RecInd, recind

      real dt
c
c    Space for a line header
c
      integer lheader(SZLNHD)
      integer lhedlength, trlength, trdataoff
      integer itrace
c
c    Function subroutines
c
      integer argis, nblen, usprtrace, uspclose
c      integer uspseek
      character   getname * 100

      integer ierr, iabort
c
      integer jerr
c
c    Data trace (plus header)
c
      real        trace
      pointer     (ptrace, trace(2))
c
c    uspio argument declarations
c
      character mode*100
      character clparam*100
      character wclparam*100
      integer   ierror, maxfile, maxcomp
      integer   pt
      integer   dptw
      integer   ikpsock
      integer   seekalot, seekstat
      integer   incon

*     aps_usp declarations 

      character*27   mclist
      character*255  srcsps, rcvsps, relsps

      integer        lusrc, lurcv, lurel
      integer        istart, jcmp, icmp, numcmp
      integer        ircmp, nrcmps, nrcvr
      integer        iscmp, nscmps, nsrc
      integer        mcel(16), mcsrc(3), mcrcvr(3), nrel
      integer        str_int
      integer        srclist(1000), rcvrlist(1000)

      logical        verbos, all

      real           x, y

      data           all/.FALSE./

**********************************************************************
      name = getname()

c*********************************************************************
c
c    Self-doc
c
c*********************************************************************

      if ( argis ( '-?' ) .gt. 0 .or. 
     &     argis ( '-h' ) .gt. 0 .or.
     1     argis ( '-help' ) .gt. 0  ) then
 
          write(LER,14) name(1:nblen(name))
 14       format('***************************************************'//
     1           a80/
     2    ' writes info from usp headers into sps-like relation file.'//
     3    ' Usage: usp_sps -Nseismic_input'/
     4    '                -Ssps_src_file -Rsps_rcv_file'/
     4    '                -Xsps_reln_file -MCL[] -V')
          stop       

      endif

#include <f77/open.h>

*********************************************************************
*     get command line arguments

      call cmdln(srcsps, rcvsps, relsps, mclist, verbos)

*     open, check sps output files
 15   format(1a80)

*     open source file
      lusrc = 0
      if ( srcsps .ne. ' ' ) then
         call alloclun(lusrc)
         open (lusrc,file=srcsps(1:nblen(srcsps)),status='new',err=910)
         if (verbos) write(LER ,41)  srcsps
         write(LERR,41)  srcsps
 41      format(/' Relation sps output: ',a80)
      endif      

*     open receiver file
      lurcv = 0
      if ( rcvsps .ne. ' ' ) then
         call alloclun(lurcv)
         open (lurcv,file=rcvsps(1:nblen(rcvsps)),status='new',err=920)
         if (verbos) write(LER ,42)  rcvsps
         write(LERR,42)  rcvsps
 42      format(/' Receiver sps output: ',a80)
      endif      

*     open relation file
      lurel = 0
      if ( relsps .ne. ' ' ) then
         call alloclun(lurel)
         open (lurel,file=relsps(1:nblen(relsps)),status='new',err=930)
         if (verbos) write(LER ,45)  relsps
         write(LERR,45)  relsps
 45      format(/' Relation sps output: ',a80)
      endif      

      if ( relsps .eq. ' ') then
         write(LER,14) name(1:nblen(name))
         stop
      endif

*********************************************************************
c
c    uspioinit initializes the "uspinfo" structure used by the uspio
c    library. To allocate enough space, uspioinit needs to know the
c    maximum number of files and the maximum number of components
c    to allow for. For scalar I/O, maxcomp is 1.
c

      maxfile = 2
      maxcomp = 1
      call uspioinit(name, maxfile, maxcomp)
*      write(LERR,*) 'uspio initialized'

c**********************************************************************
c
c    uspsinput: "USP Scalar Input"
c
c**********************************************************************
c
c    Description of INPUT arguments to uspsinput
c
c**********************************************************************
c
c mode (read / write mode):
c 'r'   open an already existing file for reading only
c 'rw'  open an already existing file for reading and writing
c 'ra'  open an already existing file for reading, writing, and
c       appending. Output will start at the end of the file
c       (although nothing will prevent you from seeking back to the
c       beginning and overwriting the original traces if you wish!).

      mode = 'r'

c clparam ("Input file name command line parameter"): this string
c is appended to '-N' and looked for on the command line to find
c an input file name for this input. If clparam is whitespace,
c then uspinput will look for '-N' (as is usual practice for scalar
c USP programs that only need a single input). If instead clparam
c were, say, '1', then uspinput would look for '-N1' on the command
c line.
c
c If an input file name is specified, then uspinput will attempt
c to open that file for input.
c
c If no input file name is specified on the command line, the place
c uspinput next looks depends on whether the program is running
c under IKP or not. If not in IKP, the only possible fallback is to
c standard input. If in IKP, the fallback is to the "IKP single input"
c socket number specified by the argument "ikpsock" (this is quite
c likely 0, meaning standard input, but doesn't have to be).
c
c If you specify the same "clparam" for different inputs, uspinput
c will check the command line for repeated occurrences of the same
c argument. (For example, "-N file1 -N file2 -N file3".) Note this is
c very different from the behavior for "wclparam" (see below).

      clparam = ' '

c wclparam ("Windowing command line parameter"): This string is appended
c to '-ns', '-ne', '-rs', '-re', '-wi', and '-pt' and the result looked
c for on the command line to determine how to "window" the data. If
c wclparam is entirely whitespace you'll get the usual USP defaults.
c
c '-ns' and '-ne' are the standard start-trace, end-trace in a gather
c parameters; '-rs' and '-re' are the standard start-gather, end-gather
c in a line parameters.
c
c '-pt', if present, specifies that traces outside the window should
c be passed through; '-wi', if present, specifies that traces outside
c the window should be discarded.
c
c If you specify the same wclparam for multiple input files, uspinput
c will only look for the associated windowing parameters on the command
c line ONCE. After that it will re-use whatever values it found before.
c (The idea is that if you specify one '-rs', say, you'll want it to
c apply to ALL the associated '-N' input files, no matter how many
c there happen to have been.)

      wclparam = ' '

c dptw ("default pass through or window"): In the absence of anything
c to the contrary on the command line, 0 means DON'T pass through
c unused data, 1 means DO pass it through unchanged.
c '-wi(wclparam suffix)' on the command line overrides, and means
c to truncate anyway. '-pt(wclparam suffix)' overrides, and means
c to pass through anyway. If dptw is -1, that means don't even LOOK
c on the command line for any windowing parameters; the user program
c wants to handle ALL windowing / pass-through etc details for this
c file for itself.

      dptw = 0

c ikpsock is the ikp socket number to look for a single input on.
c Usually ikpsock will be 0, meaning standard input. (You are asked
c to specify ikpsock because you might want to have multiple inputs
c in ikpsock; at most one of those could be from standard input.)

      ikpsock = 0

c seekalot guides uspinput in deciding how to buffer the data.
c A value of 0 means "this program will mostly plod through the data
c reading in order (alternated perhaps with passes through the data
c writing in order)". A value of 1 means "this program will jump around
c within a gather a lot, but not often between different gathers". If
c the program is going to furiously alternate reading and writing
c nearby traces (for example, read a trace, write it back out, read
c the next trace, write it back out, etc) that also counts as 1.
c If the program will jump at random all over the data, even between
c different gathers and lines, then seekalot should be 2.

      seekalot = 0

      ierror = 0

      call uspsinput(mode, clparam, wclparam, 
     1      dptw, ikpsock, seekalot, seekstat,
     1      numsmp, numtrc, numrec, dt, ns, irs, pt,
     1      lheader, lhedlength, trlength, trdataoff,
     1      incon, ierror)

c**********************************************************************
c
c    Description of OUTPUT arguments of uspsinput
c
c**********************************************************************
c
c numsmp, numtrc, numrec, dt specify the dimensions of the dataset:
c
c  numsmp = number of samples in a trace (NumSmp),
c  numtrc = number of traces in a gather (NumTrc)
c  numrec = number of gathers in a line  (NumRec)
c
c  dt = sampling rate, in FLOATING-POINT SECONDS.
c       (uspinput / uspouput handle the conversion between
c       the sample rate stored as an integer in the usp line header
c       keyword 'SmpInt', and the floating-point number that most
c       programs that actually USE the sample rate as a physically
c       meaningful unit demand.)
c
c ns and irs return the trace number and gather number, respectively,
c of the first trace the user program sees. (These are not from any
c header; they are simply counted from the beginning of the file,
c starting with 1, 2, 3, etc.) Your program may need this information
c to modify values from the line header specifying things like initial
c trace offsets, etc. (They may no longer be what you expect after
c windowing.)
c
c pt tells your program whether the output will be windowed (0) or
c passed through (1). The user program may need to know this for
c modifying values in an outgoing line header. (The standard
c USP dimensional line-header keywords "NumTrc" and "NumRec" will
c automatically be set appropriately by "uspoutput".)
c
c lheader is the line header for this input.
c
c lhedlength is the length in bytes of this line header.
c
c trlength is the length in full words (floats) of a single trace,
c including the trace header. You'll need to allocate
c trlength * SZSMPD bytes to store a trace.
c
      iabort = 1
      call galloc (ptrace, trlength * SZSMPD,
     1                    ierr, iabort)
c
c trdataoff is the offset in full words (floats) from the start of
c the trace to the start of the trace data. (In other words, it's
c the trace header length.)
c
c For now this will always be ITRWRD, but if you write your code
c to use trdataoff then it will not have to be changed if we switch
c to variable-length trace headers later on, which is quite likely.
c
c incon is the "connection number", the number you'll have to use
c to refer to this connection later on. (It's like a sisio logical
c unit number, but not the same. It starts at 1 for the first
c connection, and counts up.)
c
c ierror will be incremented once for each error that was found.
c Unless ierror is zero this input cannot be used, and attempting
c to do so will result in an error.
c
**********************************************************************
*     construct src and rcvr queue

      icmp = 0
      nscmps = 0
      nrcmps = 0
 80   icmp = icmp + 1
         istart = 3*(icmp-1) + 1
         if (mclist(istart:istart+1) .eq. '  ') then
            if (icmp .eq. 1) then
               write (LER,*) ' Specify -MCL correctly!'
               stop
            else
               go to 90
            endif
         endif

         mcel(icmp) = str_int(mclist, istart, istart+1)
         ircmp = mod(mcel(icmp),10)
         iscmp = (mcel(icmp)-ircmp)/10
         if (nscmps .eq. 0) then
            nscmps =  1
            mcsrc(1) = iscmp
         else
            do jcmp = 1, nscmps
               if (mcsrc(jcmp) .eq. iscmp) go to 84
            enddo
            nscmps = nscmps + 1
            mcsrc(nscmps) = iscmp
         endif

 84      if (nrcmps .eq. 0) then
            nrcmps =  1
            mcrcvr(1) = ircmp
         else
            do jcmp = 1, nrcmps
               if (mcrcvr(jcmp) .eq. ircmp) go to 89
            enddo
            nrcmps = nrcmps + 1
            mcrcvr(nrcmps) = ircmp
         endif

 89   go to 80
*     end of component loop

 90   numcmp = icmp - 1

**********************************************************************
*  get trace header offsets
*     args:       mnemonic, type,      offset,   count,    buffer
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)

      call savelu('SrPtXC',ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,TRACEHEADER)
      call savelu('SrPtYC',ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,TRACEHEADER)
      call savelu('RcPtXC',ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,TRACEHEADER)
      call savelu('RcPtYC',ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,TRACEHEADER)

      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('LinInd',ifmt_LinInd,l_LinInd,ln_LinInd,TRACEHEADER)

***********************************************************************
*     do for every trace
      nsrc = 0
      nrcvr = 0
      nrel = numtrc * numrec
  2000 do 2099 itrace = 1, nrel
* 2000 do 2099 itrace = 1, 5
c     Arguments to usprtrace:
c
c**********************************************************************
c
c     The first argument is the integer connection number that you
c     got back from uspinput.
c
c     The second argument is the trace array for it to read from or
c     write to.
c
c     The third argument is the DIMENSIONED length of the trace.
c     If the trace it reads is too long to fit, you will get an error
c     message instead of a memory overrun and possibly a core dump.
c     In this example, since we allocated the trace to be just long
c     enough, the length is just trlength.
c
c     The return value is:
c
c     0: everything OK
c    -1: something very bad
c     1: you just went off the end of the data
c

         if (usprtrace(incon, trace, trlength) .ne. 0) then
            write (LER , *) 'Could not read trace ', itrace
            go to 2099
         endif

*         call saver2(trace,ifmt_SoPtNm,l_SoPtNm, ln_SoPtNm,
*     1               soptnm , TRACEHEADER)
          call saver2(trace,ifmt_SrcLoc,l_SrcLoc, ln_SrcLoc,
     1                srcloc, TRACEHEADER)

          call saver2(trace,ifmt_LinInd,l_LinInd, ln_LinInd,
     1                linind, TRACEHEADER)
         call saver2(trace,ifmt_RecInd,l_RecInd, ln_RecInd,
     1               recind , TRACEHEADER)
         call saver2(trace,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1               trcnum , TRACEHEADER)

 2100 if (lusrc .ne. 0) then
*        count distinct sources
         if (nsrc .eq. 0) then
            nsrc =  1
            srclist(1) = srcloc
         else
            do jcmp = 1, nsrc
               if (srclist(jcmp) .eq. srcloc) go to 2200
            enddo
            nsrc = nsrc + 1
            srclist(nsrc) = srcloc
         endif
         call saver2(trace,ifmt_SrPtXC,l_SrPtXC, ln_SrPtXC,
     1               srptxc , TRACEHEADER)
         call saver2(trace,ifmt_SrPtYc,l_SrPtYc, ln_SrPtYc,
     1               srptyc , TRACEHEADER)
         x = srptxc
         y = srptyc
         write(lusrc, 2105) srcloc, x, y
2105     format('S', 16x, i8, 21x, f9.1, f10.1)

*     sps format has:
*     col  1    : type S or R          | dum1
*     col  2-17 : line name              (16x)
*     col 18-25 : point number           (i8)
*     col 26    : point index (1-9)    |
*     col 27-28 : point code           |
*     col 29-32 : static correction    | 
*     col 33-36 : point depth          | (21x)
*     col 37-40 : seismic datum        |
*     col 41-42 : uphole time          |
*     col 43-46 : water depth          |
*     col 47-55 : x-coordinate (map easting) (f9.1)
*     col 56-65 : y-coordinate (map northing)(f10.1)
*     col 66-71 : surface elevation    |
*     col 72-74 : day                  |
*     col 75-80 : time                 |

      endif

 2200 if (lurcv .ne. 0) then
*        count distinct receivers
         if (nrcvr .eq. 0) then
            nrcvr =  1
            rcvrlist(1) = recind
         else
            do jcmp = 1, nrcvr
               if (rcvrlist(jcmp) .eq. recind) go to 2300
            enddo
            nrcvr = nrcvr + 1
            rcvrlist(nrcvr) = recind
         endif
         call saver2(trace,ifmt_RcPtXC,l_RcPtXC, ln_RcPtXC,
     1               rcptxc , TRACEHEADER)
         call saver2(trace,ifmt_RcPtYC,l_RcPtYC, ln_RcPtYC,
     1               rcptyc , TRACEHEADER)
         x = rcptxc
         y = rcptyc
         write(lurcv, 2205) linind, recind, x, y
2205     format('R', i16, i8, 21x, f9.1, f10.1)
      endif

 2300 if (lurel .ne. 0) then
*        write(lurel,2305) 'X  fldtapno', fldrecno, fldrecinc, instcode,
*     &                    srclinam, srcptno,  srcptind,
*     &                    frchnl, tochnl, chnlinc,
*     &                    rcvlinam, frrcv, torcv. rcvind

         write(lurel,2305) recnum,  1, mcrcvr(1), 
     &                     linind, srcloc,  1,
     &                     trcnum, trcnum,  1, 
     &                     linind, recind, recind, 1
 2305    format('X     0', i4, i1, i1,
     &          i16, i8, i1,
     &          i4,  i4, i1,    
     &          i16, i8, i8, i1)

*     sps format :
*     col  1    : type X               |
*     col  2-7  : field tape no.       |(a7)
*     col  8-11 : field record no.      (i4)
*     col 12    : field record incr.    (i1)
*     col 13    : rcvr instrument code  (i1)
*     col 14-29 : shot line name        (a16)
*     col 30-37 : shot point no.        (i8)
*     col 38    : shot point index      (i1)
*     col 39-42 : from rcvr channel     (i4)
*     col 43-46 : to rcvr channel       (i4)
*     col 47    : rcvr channel incr     (i1)
*     col 48-63 : rcvr line name        (a16)
*     col 64--71: from rcvr             (i8)
*     col 72-79 : to rcvr               (i8)
*     col 80    : rcvr index            (i1)

      endif

c    usprtrace and uspwtrace will print an error message if you
c    try to read or write outside the legal bounds of the data, with
c    one exception: if you increment ONCE off the end of the data
c    (while either reading or writing), they will give a nonzero
c    error code but will NOT print any message nor abort the program.
c
c    Thus if you don't want to keep track of how many traces there
c    are, you can just "keep going until you get a nonzero return
c    code", and that will work. (Keep in mind that if you allow
c    appending, then you can write anywhere! If it's off the current
c    end of the data, you'll just make the data that much bigger.
c    If you try to read beyond what's there, though, that will
c    always be an error.)
c
 2099 enddo
*     end of trace loop

 3000 continue

      write( LERR, * ) ' '
      write( LERR, * ) ' Normal end of sps_aps.'
      write( LERR, * ) ' Processed 1 shot line, with',
     &                                  nsrc,' shots;'
      write( LERR, * ) '           1 receiver line, with',
     &                                nrcvr, ' groups;'
      write( LERR, * ) '       and ',nrel,   ' relations, with',
     &                              numcmp, ' components each.'

      write( LERR, * ) ' '
      write( LER, * ) ' '
      write( LERR, * ) ' Normal Termination'
      write( LER, * ) ' Normal Termination'
      write( LER, * ) ' '

c    Finally, make SURE to call uspclose to close your connections
c    before exiting. Some of your data may end up missing if you forget
c    to do this.

      if (uspclose(incon)) then
          write (LER , *) 'Trouble closing input.'
      endif

      stop     

***********************************************************************
*     tape errors

 910  write(LER,915) srcsps
      write(LERR,915) srcsps
 915  format(/' USP_SPS: Error opening sps source file ',a80/
     &        '         Check for prior existence; move/remove as nec.')
      stop

 920  write(LER,925) rcvsps
      write(LERR,925) rcvsps
 925  format(/' USP_SPS: Error opening sps receiver file ',a80/
     &        '         Check for prior existence; move/remove as nec.')
      stop


 930  write(LER,935) relsps
      write(LERR,935) relsps
 935  format(/' USP_SPS: Error opening sps relation file ',a80/
     &        '         Check for prior existence; move/remove as nec.')
      stop
 
      end
