C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine vgetmax(vsc,nx,nvel,maxcrv,refs)
C ******************************************************************** C
C * Subprogram: getmax                              Entry: getmax    * C
C * Author: R.L. Crider                                              * C
C * Date: May, 1991                                                  * C
C * Subroutine to select the maximum semblance curve.  This curve is * C
C * later scanned (in pikmax) to get the actual picks.               * C
C *                                                                  * C
C * Usage:                                                           * C
C *  Call getmax(vsc, nx,nvel,maxcrv,refs)                           * C
C *  Input:                                                          * C
C *      vsc  - R*4 - matrix of semblance values dimensioned         * C
C *                   nx X nvel.                                     * C
C *       nx  - I*4 - length of a column in vsc (trace length)       * C
C *     nvel  - I*4 - length of a row in vsc (number velocity scans) * C
C *  Output:                                                         * C
C *    maxcrv - R*4 - Vector containing the max semblance "curve"    * C
C *      refs - R*4 - Vector containing the column (trace) location  * C
C *                   of each maximum.                               * C
C ******************************************************************** C
#include <f77/lhdrsz.h>
#include <f77/iounit.h>

      real vsc (*),maxcrv (*),refs (*)

C +------------------------------------------+
C | Find the maxima and save their positions |
C +------------------------------------------+
      do 100 i=1,nx
        call maxv(vsc(i),nx,vsmax,iref,nvel)
        if(vsmax.gt.1.0.or.vsmax.lt.0.0)then
         refs(i)=1.
         maxcrv(i)=0.
        else
         refs(i)=iref
         maxcrv(i)=vsmax
        endif
  100 continue
      return
      end

      subroutine vpikmax(vsc,maxcrv,refs,ns,dt,nvel,
     :thresh,vmin,vinc,pick,npicks,lpick,vpick)
C ******************************************************************** C
C *                                                                  * C
C * Subprogram: pikmax                              Entry: pikmax    * C
C * Author: R.L. Crider                                              * C
C * Date: May, 1991                                                  * C
C * Subroutine to pick the maximum semblance curve returned by       * C
C * GETMAX().                                                        * C
C *                                                                  * C
C * Usage:                                                           * C
C *   call pikmax(vsc,maxcrv,refs,ns,dt,nvel,thresh,                 * C
C *     vmin,vinc,pick,npicks.lpick)                                 * C
C *                                                                  * C
C *  Input:                                                          * C
C *      vsc  - R*4 - matrix of semblance values                     * C
C *    maxcrv - R*4 - Vector containing the max semblance "curve"    * C
C *                   from GETMAX subroutine.                        * C
C *      refs - R*4 - Vector containing the column location of       * C
C *                   each maximum (from getmax).                    * C
C *       ns  - I*4 - length of a column in vsc (trace length)       * C
C *       dt  - R*4 - Sample interval, in seconds.                   * C
C *     nvel  - I*4 - length of a row in vsc (number velocity scans) * C
C *   thresh  - R*4 - Semblance picking threshold (0<threshold<1)    * C
C *     vmin  - R*4 - Minimum velocity                               * C
C *     vinc  - R*4 - Change in v value.                             * C
C *                                                                  * C
C *  Output:                                                         * C
C *     pick  - R*4 - Matrix containing the picked values.           * C
C *                   Column 1: time of pick                         * C
C *                   Column 2: velocity of pick                     * C
C *                   Column 3: semblance at pick                    * C
C *                   Column 4: column location of pick              * C
C *   npicks  - I*4 - Number of picks                                * C
C *   lpick   - I*4 - Temporal index of picks                        * C
C *   vpick   - R*4 - Vector of picked velocities                    * C
C *                                                                  * C
C ******************************************************************** C
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
      real vsc(*),maxcrv(*),pick(ns,4),thresh,refs(*),vpick(*)
      real dt
      integer ns, nvel,lpick(*)

      nsr = dt * 1000. + .5
      npicks = 0
      ist = 1
  100 continue
C +--------------------------------------------------+
C | Search until find sembl value ge threshold, then |
C | find the encompassing "glob"                     |
C +--------------------------------------------------+
      IF(maxcrv(ist).ge.thresh)then
         big = maxcrv(ist)
         Lbig = ist
         do 110 i=ist+1,ns
           if(maxcrv(i).gt.big)then
             big = maxcrv(i)
             Lbig = i
           endif
           if(maxcrv(i).lt.thresh)then
              iend = i
              go to 120
           endif
  110    continue
         iend = ns
  120  continue
C +-----------------------------+
C | Increment the pick counter  |
C +-----------------------------+
        npicks = npicks + 1
        L = Lbig
        lpick(npicks) = L
C +---------------------------+
C | Save the time of the pick |
C +---------------------------+
        pick(L,1)= (L-1) * nsr
        iref = refs(L)
        iloc=(iref -1)*ns + L
C +---------------------------+
C | Save the semblance value  |
C +---------------------------+
        pick(L,3)=vsc(iloc)
C +------------------------------+
C | Save the semblance location, |
C | the velocity, and the time.  |
C +------------------------------+
        pick(L,4) = iref
C +---------------------------+
C | Compute the velocity here |
C +---------------------------+
        pt=pick(L,1)
        v = (iref-1)*vinc + vmin
        pick(L,2)=v
        jdx = pt/nsr + 1
        vpick(jdx)=v
C +----------------------------+
C | Increment the counter and  |
C | continue the search        |
C +----------------------------+
        ist = iend + 1
        if(ist.lt.ns)go to 100
      ELSE
        ist = ist + 1
        if(ist.lt.ns)go to 100
      ENDIF
      return
      end

      subroutine rdmute(mutef,lum, nsamp, mutes, jr, nsets)
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
      REAL mutes(*)
      INTEGER lum, nsamp, jr(*), nsets,osamp,base
      character card*80,mutef*100,id*5

C +--------------------------+
C |   Read the Units record  |
C +--------------------------+
   80 format(a80)
   81 format(a40)
      read(lum,34)id,card
      if(id.ne.'Units')then
        write(LERR,*)'Mute file format incorrect. Job aborted'
        call ccexit(100)
      endif
      read(card(1:80),35)recu, trcu, timeu,nrecs,np,ns
   34 format(t1,a5,t1,a80)
   35 format(t10,f9.0,t23,f9.0,t36,f9.0,t50,i4,t56,i5,t64,i4)
   36 format(t1,f12.0,1x,f12.0,1x,f12.0)
C +----------------------------------------------------+
C |   Read the data, using "Segment" card as separator |
C +----------------------------------------------------+
      nsets = 0
      irec = 1
  100 continue
      card = ' '
      read(unit=lum,fmt=34,end=500)id,card
      if(id.eq.'Segme')then
        if(nsets.ge.1.and.osamp.lt.nsamp)then
         loc = (nsets-1)*nsamp + osamp + 1
         lfill = nsamp - osamp
         call vfill(mutes(loc-1),mutes(loc),1,lfill)
        endif
        nsets = nsets + 1
        if(nsets.gt.70)then
          write(LERR,*)'The number of mute functions supplied',
     :    ' exceeds the maximum (70).  Job aborted.'
          call ccexit(100)
        endif
        k=0
        go to 100
      endif
      read(card(1:40),36)rec, trc, time
      k = k + 1
      jr(nsets)= rec
      isamp = time/timeu + 1
      loc = (nsets-1)*nsamp + isamp
      mutes(loc)=trc
      if(k.eq.1)then
       base = (nsets-1)*nsamp
       loc = base + 1
       lclr = isamp-1
       if(lclr.gt.0)then
        call vclr(mutes(loc),1,lclr)
       endif
       osamp = isamp
       otrc = trc
      else
       jend = isamp -1
       jlen = jend-osamp
       if(jlen.eq.0)then
         jlen = 1
       endif
       slope = (trc - otrc)/float(jlen)
       base = (nsets-1)*nsamp
       x = 0
       do 210 i=osamp, jend
        loc = base + i
        mutes(loc)=otrc + slope * x
        x = x + 1.
  210  continue
       otrc = trc
       osamp = isamp
      endif
      go to 100
  500 continue
      if(osamp.lt.nsamp.and.nsets.ge.1)then
       loc = (nsets-1)*nsamp + osamp + 1
       lfill = nsamp - osamp
       call vfill(mutes(loc-1),mutes(loc),1,lfill)
      endif
      return
      end

      SUBROUTINE getmute(IRI, JR, mutes, nsets, ns, cmute)
C ******************************************************************** C
C *   Subroutine to find the mute function for the current ri.       * C
C *                                                                  * C
C *   INPUT:                                                         * C
C *                                                                  * C
C *     IRI    - I*4   -  Current RI #                               * C
C *      JR    - I*4() -  Vector of RI #'s for mute functions        * C
C *   MUTES    - R*4() -  Matrix of mutes.                           * C
C *   NSETS    - I*4   -  Number of mute functions supplied.         * C
C *      ns    - I*4   -  Trace length.                              * C
C *                                                                  * C
C *   OUTPUT :                                                       * C
C *                                                                  * C
C *   CMUTE    - R*4() -  Current mute vector                        * C
C *                                                                  * C
C ******************************************************************** C
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
      REAL mutes(*), cmute(*)
      INTEGER  JR(*), nsets
C
      ns4 = ns * ISZBYT
      IF(nsets.gt.1)then
       if(iri.le.jr(1))then
        call move(1,cmute,mutes(1),ns4)
        return
       endif
       DO 210 I = 2,nsets
        IF(JR(I).GE.IRI.or.I.eq.nsets)THEN
          if(jr(i).eq.iri)then
           loc = (i-1)*ns + 1
           call move(1,cmute,mutes(loc),ns4)
           return
          endif
          if(i.eq.nsets.and.iri.gt.jr(i))then
           loc = (i-1)*ns + 1
           call move(1,cmute,mutes(loc),ns4)
           return
          endif
          k = i
          k1 = i-1
          loc1=(k1-1)*ns + 1
          loc2=(k-1)*ns + 1
          slope = float(iri-jr(k1))/float(jr(k)-jr(k1))
          loc1 = loc1 - 1
          loc2 = loc2 - 1
          do 100 L = 1,ns
           loc1 = loc1 + 1
           loc2 = loc2 + 1
           cmute(L)= mutes(loc1) + 
     :           (mutes(loc2)-mutes(loc1))*slope
  100     continue
         return
        ENDIF
  210  CONTINUE
      ELSE
       call move(1,cmute,mutes(1),ns4)
       return
      ENDIF
      END

      subroutine appmute(semb,nsamp,np,cmute)
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
      REAL semb(*), cmute(*)
      INTEGER nsamp, np

      ndo = 0
      do 100 i=1,nsamp
      imutst = cmute(i)
      if(imutst.gt.np)imutst=np
      if(imutst.gt.0)call vclr(semb(i), nsamp, imutst)
  100 continue
      return
      end

      subroutine sortmute(mutes,jr,ns,nsets)
#include <f77/lhdrsz.h>
#include <f77/iounit.h>
      real mutes(*),temp(1),recs(70)
      integer ns, nsets,jr(*),ir(70)
      integer kndx(70)
      POINTER (pt,temp)

      iget = ns * nsets*ISZBYT
      iabort = 0
      ierror=0
      call galloc(pt,iget,ierror,iabort)
      if(ierror.ne.0)then
        write(LERR,*)' Error in pt memory allocation'
        call ccexit(100)
      endif
      do 100 i=1,nsets
       kndx(i)=i
       recs(i)=jr(i)
  100 continue
      L1 = 0
      L2 = nsets - 1
c     call qksort2(L1,L2,recs,kndx)
      call hsorti(np,recs,kndx)
      do 200 i=1,nsets
        loc1 = kndx(i)
        ir(i)=jr(loc1)
        loc1 = (loc1-1)*ns + 1
        loc2 = (i-1)*ns + 1
        call vmov(mutes(loc1),1,temp(loc2),1,ns)
  200 continue
      lmove = nsets * ns
      call vmov(temp(1),1,mutes(1),1,lmove)
      call vmov(ir,1,jr,1,nsets)
      call gfree(pt)
      return
      end
