C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C ******************************************************************** C
C |                                                                    |
C |  Program to demultiplex the output of program opstf, which writes  |
C |  its scan and semblances traces in the order of scan, sembl, etc.  |
C |                                                                    |
C |   CODED BY R. CRIDER  1/92  HDC                                    |
C |                                                                    |
C ******************************************************************** C
c
c changed declarations for ntap and otap to be char*256 in all
c subroutines as well as main  -  jev - 4/9/97
c
#include <localsys.h>
#include <save_defs.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/pid.h>
#include <f77/iounit.h>

      integer maxsmp
      parameter (maxsmp = SZLNHD)
      CHARACTER PARR*26
      CHARACTER NAME*5,TITLE(66)*1
      REAL          work(SZLNHD),p(SZLNHD),cmute(SZLNHD)
      real Ritr(SZLNHD),cossq(51),HEAD(SZLNHD)
#ifdef hpux
      real          hold(:),shold(:),mutes(:),rhold(:)
      integer       trhd(:)
      allocatable hold,shold,mutes,rhold,trhd
#else
      real          hold(1),shold(1),mutes(1),rhold(1)
      integer       trhd(1)
      POINTER (pm,mutes),(ph,hold),(ps,shold),(pth,trhd)
      POINTER (pr,rhold)
#endif

C
      INTEGER   ITR (SZLNHD),jr(70),argis, pipe,rs,re
      INTEGER   ITR2(SZLNHD)
C
C
      character ntap*256, otap*256, stap*256,mutef*256
C
      LOGICAL open, there,log_opt,IKP
      logical sopen,swght,mute,filt
C
      EQUIVALENCE (ITR(1),ITR2(1),Ritr(1),HEAD(1))
C
      DATA NAME/'OPSTD'/,OPEN/.FALSE./
      DATA PARR/'OPTICAL STACK DEMULTIPLEX'/
      DATA LUIN/7/,LUOUT/8/,LUOUTV/9/
      DATA TITLE/66*' '/
      DATA pipe/3/

      ipr = LERR
      wrknt = 0
C +=========================+
* | Check for the HELP flag |
C +=========================+
      if (argis ('-?').gt.0 .OR. (argis('-H').gt.0)) then
         call help(LER)
         call ccexit(0)
      endif
      J=20
      DO I=1,26
         J=J+1
         TITLE(J)=PARR(I:I)
      END DO
#include <f77/open.h>
       ntap = ' '
       otap = ' '
       stap = ' '
       lum = 27
      call gcmdln(ntap,otap,stap,rs,re,swght,vmin,vmax,mutef,filt,
     1            IKP,lcos)
      if(lcos.gt.51)lcos=51
      if(mutef.eq.' ')then
        lum = 0
        mute=.false.
      else
        mute = .true.
        inquire(file = mutef, exist = there)
        if(there) then
          open(unit=LUM, file=mutef)
        else
          write(LERR,*)' Requested mute file ', mutef,
     :' not found.  Job aborted.'
        call ccexit(100)
        endif
      endif

C
      if(rs.eq.0)rs = 1
      if(re.eq.0)re = 32767
      if(ntap.ne.' ')then
      there = .false.
       inquire(file = ntap, exist = there)
       if(.not.there) then
        write(LER,*)'Requested input data set does not exist.',
     &'  Try again.'
        call ccexit(100)
       endif
      endif
      sopen = .true.
c     if(stap.eq.' ')then
c       write(LERR,*)'Semblance output is not saved.'
c       sopen = .false.
c     endif
      CALL GAMOCO(TITLE,1,IPR)
C +====================+
C |OPEN INPUT DATA SET |
C +====================+
      CALL openr(luin,itr,lbytes,nsamp,nsr,ntrc,nrcd,name,ntap,
     :np,pmin,pmax,v0,log_opt,ITHWP1,ITHWP2,noff,LERR,ithree,unitsc)

c------
c     save certain parameters
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
 

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('RcPtXC',ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,TRACEHEADER)
      call savelu('RcPtYC',ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,TRACEHEADER)

      pmin=pmin/1000.
      pmax=pmax/1000.

      call get_tp(pmin,pmax,np,log_opt,pinc,p,inv,ierr)

      if(ierr.ne.0)then
          write(LERR,*)' For the log-linear option, neither pmin ',
     :' nor pmax can be zero'
         call lbclos(luin)
         stop 100
      endif

      delp = pinc
      p1=p(1)
      nppos = np

      if(inv.ne.0)then

        inv1 = inv+1
        nm = np - inv1 + 1
        do i=1,nm
         work(i)=p(inv+i)
        end do
        j=1
        do i=inv,1,-1
         work(np+j-1)=p(inv+j-1)
         j=j+1
        end do
        do i=1,np
         p(i)=work(i)
        end do
*       call vmov(p(inv1),1,work,1,nm)
*       call vmov(p(inv),-1,work(np),-1,inv)
*       call vmov(work,1,p,1,np)
        p1=p(1)
        nppos = 0

        do i=1,np
          if(p(i).lt.0)then
            invpt=i-1
            leftovers = np-invpt
            pp1 = p(np)
            go to 50
          else
            nppos = nppos + 1
          endif
        end do

   50 continue
      endif

      sr=FLOAT(NSR) * unitsc
      mbytes = (nsamp + itrwrd)*ISZBYT
      nrecc = nrcd
      if(re.lt.32767.and.rs.ge.1)NRECC = re - rs + 1
      call savew(itr,'NumRec',nrecc,LINHED)
C      +----------------------+
*      |   WRITE LINE HEADER  |
C      +----------------------+
      nn = ntrc/2
      iby = lbytes
      call savhlh(itr,iby,lbytes)

      CALL openw(LUOUT,ITR,LBYTES,NRECC,nn,OPEN,otap,LERR,ithree)

c     if(sopen)then
      CALL open2(LUSEMB,ITR,LBYTES,NRECC,nn,SOPEN,stap,LERR,pipe,
     1           IKP,ithree)
c     endif

      call prparm(ntap,otap,stap,mutef,NP,re,rs,vmin,vmax,LERR)

#ifdef hpux
      ierror = 0
      iget=nn*nsamp
      allocate(hold(1:iget),stat=ierror)
      allocate(shold(1:iget),stat=ierror)
      allocate(rhold(1:iget),stat=ierror)
      iget=nn*ITRWRD
      allocate(trhd(1:iget),stat=ierror)
      if(ierror.ne.0)then
        write(LERR,*)' Unable to allocate storage'
        call lbclos(luin)
        call lbclos(luout)
        call ccexit(100)
      endif
      if(mute)then
       iget = 70*nsamp
       ierror = 0
       allocate(mutes(1:iget),stat=ierror)
       if(ierror.ne.0)then
        write(LERR,*)' Unable to allocate storage'
        call lbclos(luin)
        call lbclos(luout)
        call ccexit(100)
       endif
#else
      ierror = 0
      iabort = 0
      iget=nn*nsamp*ISZBYT
      call galloc(ph,iget,ierror,iabort)
      call galloc(ps,iget,ierror,iabort)
      call galloc(pr,iget,ierror,iabort)
      iget=nn*ITRWRD*ISZBYT
      call galloc(pth,iget,ierror,iabort)
      if(ierror.ne.0)then
        write(LERR,*)' Unable to allocate storage'
        call lbclos(luin)
        call lbclos(luout)
        call ccexit(100)
      endif
      if(mute)then
       iget = 70*nsamp*ISZBYT
       ierror = 0
       iabort = 0
       call galloc(pm,iget,ierror,iabort)
       if(ierror.ne.0)then
        write(LERR,*)' Unable to allocate storage'
        call lbclos(luin)
        call lbclos(luout)
        call ccexit(100)
       endif
#endif
       call rdmute(mutef,lum,nsamp,mutes,jr,nsets)
       call sortmute(mutes,jr,nsamp,nsets)
      endif
C +-------------------------------------------+
C | FIND AND READ FIRST TRACE OF FIRST RECORD |
C +-------------------------------------------+
      IREAD=0
  306 CONTINUE

      nbytes = 0
      CALL RTAPE(LUIN,ITR,nbytes)
      IF(nbytes.EQ.0)then
        write(LERR, *)'EOF on input data set.  OPST ending'
        go to 999
      endif

c     call saver(itr,'RecNum',irec,TRCHED)
c     irec = itr2(l_RecNum)
      call saver2(itr2,ifmt_RecNum,l_RecNum, ln_RecNum,
     1            irec , TRACEHEADER)

      IF(irec.ge.rs) THEN
        IREAD=1
      ELSE
        GO TO 306
      ENDIF
      iscnknt = 0
      isemknt = 0

      DO 101 NX = 1,NTRC
        IF(IREAD.EQ.0)THEN
          nbytes = 0
          CALL RTAPE(LUIN,ITR,nbytes)
        ENDIF
        IREAD=0
        IF(nbytes .EQ. 0) THEN
        WRITE(IPR,'(5X,A)')'END OF FILE ON INPUT:'
        WRITE(IPR,'(5X,A,1X,I4,A,1X,I4)')'  REC= ',IREC,'TRACE= ',NX
        GO TO 999
        ENDIF

c       irec = itr2(l_RecNum)
        call saver2(itr2,ifmt_RecNum,l_RecNum, ln_RecNum,
     1              irec , TRACEHEADER)
C +-------------------------------+
C |   Save trace headers and data |
C +-------------------------------+
        if((nx/2*2).ne.nx)then
          iscnknt = iscnknt + 1
          itr2(l_TrcNum) = iscnknt
          call savew2(itr2,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                iscnknt, TRACEHEADER)
          ndx=(iscnknt-1)*nsamp
          do k=1,nsamp
           hold(ndx+k)=Ritr(ITRWRD+k)
          end do
          ndx=(iscnknt-1)*ITRWRD
          do i=1,ITRWRD
           trhd(ndx+i)=itr(i)
          end do
        else
          isemknt = isemknt+1
c         itr2(l_TrcNum) = isemknt
          call savew2(itr2,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                isemknt, TRACEHEADER)
          ndx=(isemknt-1)*nsamp
          do i=1,nsamp
           shold(ndx+i)=Ritr(ITRWRD+i)
          end do
        endif
  101 CONTINUE

      if(filt)then
      do i=1,nsamp
        ssum=0.
        rsum=0.
        k=i
        do j=1,np
         ssum=ssum+hold(k)
         rsum=rsum+shold(k)
         k=k+nsamp
        end do
        ssum=ssum/float(np)
        rsum=rsum/float(np)
        k=i
        do j=1,np
         hold(k)=hold(k)-ssum
         shold(k)=shold(k)-rsum
         k = k+nsamp
        end do
      end do
      endif
      if(mute)then
        call getmute(irec,jr,mutes,nsets,nsamp,cmute)
        call appmute(shold,nsamp,np,cmute)
        call appmute(hold, nsamp,np,cmute)
      endif
      if(vmin.gt.0.0.or.vmax.gt.0.0)then
        call velmute(hold,nsamp,nppos,vmin,vmax,v0,sr,p,p1)
        call velmute(shold,nsamp,nppos,vmin,vmax,v0,sr,p,p1)
        if(inv.ne.0)then
          ist=(invpt*nsamp)+1
          call ivelmute(hold(ist),nsamp,leftovers,vmin,vmax,v0,
     :      sr,p,pp1)
          if(sopen)then
            call ivelmute(shold(ist),nsamp,leftovers,vmin,vmax,v0,
     :      sr,p,pp1)
          endif
        endif
      endif
      if (lcos.gt.0)then
       lcos2 = lcos/2+1
       pi = 4.*atan(1.0)
       pi8 = pi/2.
       j=lcos2
       do i=1,lcos2
        arg = (i-1)*pi8/lcos2
        cossq(j) = cos(arg)
        cossq(j)=cossq(j)*cossq(j)
        j=j-1
       end do
       j=lcos2-1
       do i=lcos2+1,lcos
        cossq(i)=cossq(j)
        j=j-1
       end do
       call semb_clean(shold,np,nsamp,cossq,lcos)
      end if
      do i=1,nn
       ndx = (i-1)*nsamp
       jdx = (i-1)*ITRWRD
       do k=1,ITRWRD
        itr(k)=trhd(jdx+k)
       end do
       do k=1,nsamp
        Ritr(ITRWRD+k)=hold(ndx+k)
       end do
       if(swght)then
        do k=1,nsamp
         Ritr(ITRWRD+k)=shold(ndx+k)*Ritr(ITRWRD+k)
        end do
       endif
c      itr2(l_TrcNum) = i
       call savew2(itr2,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1             i, TRACEHEADER)
       call wrtape(luout,itr,mbytes)
       if(sopen)then
        do k=1,nsamp
         Ritr(ITRWRD+k)=shold(ndx+k)
        end do
        if (lusemb .gt. 0)
     1  call wrtape(lusemb,itr,mbytes)
       endif
      end do
  950 CONTINUE
      rs=rs+1
      IF (rs.LE.re) GOTO 306
  999 CONTINUE
      CALL LBCLOS( LUIN)
      CALL LBCLOS(LUOUT)
      if(sopen)CALL LBCLOS(lusemb)
      stop
      END

      subroutine openw(LUOUT,ITR,LBYTES,NRECC,NP,OPEN,
     &otap,IPR,ithree)
* ******************************************************************** *
*                                                                      *
*  SUBROUTINE TO OPEN THE OUTPUT DATA SET                              *
*  LINE HEADER IS UPDATED FOR NUMBER OF TRACES PER RECORD ONLY.        *
*  INPUT:                                                              *
*   LUOUT  - I*4  -  LOGICAL UNIT FOR OUTPUT                           *
*    ITR   - I*4  -  LINE HEADER BUFFER                                *
*   LBYTES - I*4  -  LINE HEADER LENGTH IN BYTES                       *
*    MODE  - I*4  -  MODE OF PROCESSING                                *
*    NRECC - I*4  -  NUMBER OF RECORDS TO OUTPUT (*NOT USED*)          *
*    NP    - I*4  -  NUMBER OF TP'S PER ANALYSIS. NUMBER OF TRACES     *
*                    PER RECORD OUTPUT IF ANALYSIS MODE.               *
*  OUTPUT:                                                             *
*    OPEN  - L*4  -  FLAG TO SIGNIFY DATA SET OPENED                   *
*                                                                      *
* ******************************************************************** *
      INTEGER   ITR(*)
      character otap*256
      LOGICAL OPEN

      LINHED = 0
      if(otap.ne.' ')then
       call lbopen(luout,otap, 'w')
      else
       luout = 1
      endif
      lby = 0
      OPEN=.TRUE.
      call savew(itr,'Format',3,LINHED)
      call savew(itr, 'NumTrc', NP,   LINHED)
      call savew(itr,'NumRec',nrecc,linhed)
      call savew(itr,'MnLnIn',ithree,linhed)
      lby = lbytes
      CALL WRTAPE(LUOUT, ITR, LBY)
      RETURN
      END

      subroutine open2(LUOUT,ITR,LBYTES,NRECC,NP,OPEN,
     &otap,IPR,pipe,IKP,ithree)
* ******************************************************************** *
*                                                                      *
*  SUBROUTINE TO OPEN THE OUTPUT DATA SET                              *
*  LINE HEADER IS UPDATED FOR NUMBER OF TRACES PER RECORD ONLY.        *
*  INPUT:                                                              *
*   LUOUT  - I*4  -  LOGICAL UNIT FOR OUTPUT                           *
*    ITR   - I*4  -  LINE HEADER BUFFER                                *
*   LBYTES - I*4  -  LINE HEADER LENGTH IN BYTES                       *
*    MODE  - I*4  -  MODE OF PROCESSING                                *
*    NRECC - I*4  -  NUMBER OF RECORDS TO OUTPUT (*NOT USED*)          *
*    NP    - I*4  -  NUMBER OF TP'S PER ANALYSIS. NUMBER OF TRACES     *
*                    PER RECORD OUTPUT IF ANALYSIS MODE.               *
*  OUTPUT:                                                             *
*    OPEN  - L*4  -  FLAG TO SIGNIFY DATA SET OPENED                   *
*                                                                      *
* ******************************************************************** *

#include <f77/iounit.h>

      INTEGER   ITR(*)
      character otap*256
      LOGICAL   OPEN, IKP
      integer   pipe

      LINHED = 0
      OPEN = .false.
      if(otap(1:1) .ne.' ' .and. .not.IKP) then
        call lbopen(luout,otap, 'w')
      elseif (otap(1:1)  .eq. ' ' .and. IKP) then
        call sisfdfit (luout, pipe)
      else
        luout = -1
      endif

      if (luout .lt. 0) then
         write(LERR,*)'Cannot open output data set.'
         luout = -1
         OPEN = .false.
         return
      endif

      lby = 0
      OPEN=.TRUE.
      call savew(itr, 'NumTrc', NP,   LINHED)
      call savew(itr,'NumRec',nrecc,linhed)
      ithree1 = iabs(ithree)
      call savew(itr,'MnLnIn',ithree,linhed)
      lby = lbytes
      CALL WRTAPE(LUOUT, ITR, LBY)
      RETURN
      END

      subroutine gcmdln(ntap,otap,stap,rs,re,swght,vmin,vmax,mutef,filt,
     1            IKP,lcos)
c                                     
c     this routine processes the command line arguments for use in
c     program STKOP.
c                                                               
      integer rs, re, argis

      character ntap*256, otap*256,stap*256,mutef*256

      logical swght,filt, IKP

	  ntap = ' '
          stap= ' '
          otap = ' '
      call argstr ('-N',ntap,' ',' ')          
      call argstr ('-O2',stap,' ',' ')
      call argstr ('-O',otap,' ',' ')            
      mutef=' '
      call argstr ('-mf',mutef,' ',' ')
      call argi4('-rs',rs,0,0)
      call argi4('-re',re,0,0)
      swght = (argis('-W').gt.0)
      filt  = (argis('-F').gt.0)
      IKP   = (argis('-IKP').gt.0)
      call argr4('-vm',vmin,0.0,0.0)
      call argr4('-vx',vmax,0.0,0.0)
      call argi4('-nsm',lcos,0,0)
      return                                                  
      end

      subroutine help(LER)
          write(LER,*)  
     :'***************************************************************'
         write(LER,*)'Program OPSTD...........Optical Stack Demultiplex'
         write(LER,*)' '                                             
         write(LER,*)                                               
     :' -N [ntap]    (Default = stdin)   : Input Scan/Semblance file'   
         write(LER,*)                                               
     :' -O [otap]    (Default = stdout)  : Output scan data'
         write(LER,*)                                           
     :' -O2 [stap]     (optional)        : Output semblance data'
         write(LER,*)                                           
     :' -mf [mutef]    (optional)        : Mute functions to be applied'
         write(LER,*)                                               
     :' -rs [rs]      (default = 1)      : First Record to Process'   
         write(LER,*)                                               
     :' -re [re]      (default = last)   : Last Record to process'
         write(LER,*)                                           
     :' -vm [vmin]     (optional)        : Minimum velocity in data'
         write(LER,*)                                           
     :' -vx [mutef]    (optional)        : Maximum velocity in data'
         write(LER,*)                                           
     :' -nsm [nsm]     (optional)        : Length of smoothing operator'
       write(LER,*)                                        
     :'                                    for semblance'
       write(LER,*)                                        
     :' -W            (default = NO)     : If present, weight stack'
       write(LER,*)                                        
     :'                                     with semblance'
       write(LER,*)                                        
     :' -F            (default = NO)     : If present, apply spatial'
       write(LER,*)                                        
     :'                                    DC filter'
       write(LER,*)                                        
     :'Usage:  ',                                         
     :' opstd -N[ntap] -O[otap] -O2[stap] -mf[mutef] -rs[rs] -re[re]',
     :' -vm[vmin] -vx[vmax] -W -F'
       write(LER,*)                                     
     :'***************************************************************'
      return                                                          
      end                                                            

      subroutine openr(luin,itr,lbytes,nsamp,nsr,ntrc,nrcd,name,ntap,
     :np,pmin,pmax,v0,log_opt,ITHWP1, ITHWP2,noff,IPR,ithree,unitsc)
* ******************************************************************** *
*                                                                      *
*  SUBROUTINE TO OPEN THE INPUT DATA SET AND EXTRACT NECESSARY         *
*  HEADER INFORMATION.  HLH IS CALLED TO UPDATE THE PROGRAM NAME       *
*  ONLY.                                                               *
*  INPUT:                                                              *
*    LUIN  - I*4  -  LOGICAL UNIT FOR INPUT                            *
*    ITR   - I*4  -  INPUT BUFFER                                      *
*  OUTPUT:                                                             *
*   NSAMP  - I*4  -  NUMBER OF SAMPLES IN DATA TRACE                   *
*    NSR   - I*4  -  SAMPLE INTERVAL OF DATA                           *
*    NTRC  - I*4  -  NUMBER OF TRACES PER RECORD                       *
*    NRCD  - I*4  -  NUMBER OF RECORDS IN DATA SET (*NOT USED*)        *
*    V0    - R*4  -  Velocity of the medium                            *
*    NP    - I*4  -  Number of Tp's                                    *
*    PMIN  - R*4  -  Minimum Tp                                        *
*    PMAX  - R*4  -  MAXIMUM Tp                                        *
*                                                                      *
* ******************************************************************** *
      integer maxsmp
      parameter (maxsmp = 3000)
      INTEGER   ITR(*)
      CHARACTER NAME*5, ntap*256
      logical log_opt

      if(ntap.ne.' ')then
        call lbopen(luin, ntap, 'r')
      else
        luin = 0
      endif
      LINHED=0
C +----------------------------------------+
C | GET LINE HEADER, CHECK TO SEE IF EMPTY |
C +----------------------------------------+
      LBYTES = 0
      CALL RTAPE(LUIN, ITR, LBYTES)
      IF(LBYTES .EQ. 0) THEN
         WRITE(IPR,'(5X,A,1X,I3)')'OPST: NO HEADER READ ON UNIT ',LUIN
         WRITE(IPR,'(5X,A)')'FATAL ERROR.'
         WRITE(IPR,'(5X,A)')'CHECK EXISTENCE OF FILE & RERUN'
         CALL CCEXIT(100)
      ENDIF
      IFOUR=5
      call hlhprt(itr,lbytes,name,ifour,IPR)
      call saver(itr, 'NumSmp', NSAMP, LINHED)
      call saver(itr, 'SmpInt', nsr  , LINHED)
      call saver(itr, 'NumRec', NRCD , LINHED)
      call saver(itr, 'NumTrc', NP,   LINHED)
      call saver(itr, 'MutVel', V0,   LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(IPR,*)'********************************************'
          write(IPR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(IPR,*)'         will set to .001 (millisec default)'
          write(IPR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif
      log_opt = .false.
      if(V0.lt.0.0)then
        V0 = abs(V0)
        call savew(itr, 'MutVel', V0,   LINHED)
        log_opt = .true.
      endif
      call saver(itr, 'MnLnIn', ithree, LINHED)
      call saver(itr, 'ILClIn', pmin, LINHED)
      call saver(itr, 'CLClIn', pmax, LINHED)
      call saver(itr, 'NmSpMi', delp, LINHED)
      ntrc = np
      np = np/2
      if(ithree.lt.0)then
         noff = np
         ITHWP2  = ITHWP1
         ithree1 = -ithree
         call savew(itr, 'MnLnIn', ithree1, LINHED)
      else
         ITHWP2 = ITHWP1
         noff = 0
      endif
      if(iabs(ithree).ne.2)then
        write(IPR,*)'Data is NOT optical stack data.'
        write(IPR,*)' Unable to use it.'
        call ccexit(100)
      endif
      if (NSAMP.GE.3000) then
        WRITE(IPR,175)NSAMP, maxsmp
  175 FORMAT(/,14X,' ** M0175 ** ERROR IN PROGRAM OPST.',
     &/,14X,'Number of samples per trace ('I5') > ',i5,'.',
     &/,14X,'JOB ABENDED.')
         call ccexit(0)
         endif
C
      RETURN
      END

      SUBROUTINE prparm(ntap,otap,stap,mutef,NP,re,rs,vmin,vmax,LERR)
C
      INTEGER     rs,re
C
      character ntap*256, otap*256, stap*256,mutef*256
      character pipe*50
C
      pipe = 'pipe'
      IF(rs.EQ.0)rs=1
      WRITE(LERR,'(10X,A     )')' '
      WRITE(LERR,'(10X,A     )')'  Input Parameters After Defaults'
      if(ntap.ne.' ')then
      WRITE(LERR,'(10X,2A    )')'Input Scan/Semblance data.',
     :ntap(1:50)
      else
      WRITE(LERR,'(10X,2A    )')'Input Scan/Semblance data.',pipe
      endif
      if(mutef.ne.' ')
     :WRITE(LERR,'(10X,2A    )')'Input Mute File...........',
     :mutef(1:50)
      if(otap.ne.' ')then
      WRITE(LERR,'(10X,2A    )')'Output Scan data..........',
     :otap(1:50)
      else
      WRITE(LERR,'(10X,2A    )')'Output Scan data..........',pipe
      endif
      if(stap.ne.' ')
     :WRITE(LERR,'(10X,2A    )')'Output Semblance data.....',
     :stap(1:50)
      WRITE(LERR,'(10X,A,I6  )')'Start Record .............',rs
      WRITE(LERR,'(10X,A,I6  )')'End Record ...............',re
      WRITE(LERR,'(10X,A,F6.0)')'Minimum Velocity .........',VMIN
      WRITE(LERR,'(10X,A,F6.0)')'Maximum Velocity .........',VMAX
      RETURN
      END

