C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine rdmute(mutef,lum, nsamp, mutes, jr, nsets)
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/iounit.h>
      REAL mutes(*)
      INTEGER lum, nsamp, jr(*), nsets,osamp,base
c
c changed declarations for ntap and otap to be char*256 in all
c subroutines as well as main  -  jev - 4/9/97
c
      character card*80,mutef*256,id*5

C +--------------------------+
C |   Read the Units record  |
C +--------------------------+
   80 format(a80)
   81 format(a40)
      read(lum,34)id,card
      if(id.ne.'Units')then
        write(LERR,*)'Mute file format incorrect. Job aborted'
        call ccexit(100)
      endif
      read(card(1:80),35)recu, trcu, timeu,nrecs,np,ns
   34 format(t1,a5,t1,a80)
   35 format(t10,f9.0,t23,f9.0,t36,f9.0,t50,i4,t56,i5,t64,i4)
   36 format(t1,f12.0,1x,f12.0,1x,f12.0)
C +----------------------------------------------------+
C |   Read the data, using "Segment" card as separator |
C +----------------------------------------------------+
      nsets = 0
      irec = 1
  100 continue
      card = ' '
      read(unit=lum,fmt=34,end=500)id,card
      if(id.eq.'Segme')then
        if(nsets.ge.1.and.osamp.lt.nsamp)then
         loc = (nsets-1)*nsamp + osamp + 1
         lfill = nsamp - osamp
         call vfill(mutes(loc-1),mutes(loc),1,lfill)
        endif
        nsets = nsets + 1
        if(nsets.gt.70)then
          write(LERR,*)'The number of mute functions supplied',
     :    ' exceeds the maximum (70).  Job aborted.'
          call ccexit(100)
        endif
        k=0
        go to 100
      endif
      read(card(1:40),36)rec, trc, time
      k = k + 1
      jr(nsets)= rec
      isamp = time/timeu + 1
      loc = (nsets-1)*nsamp + isamp
      mutes(loc)=trc
      if(k.eq.1)then
       base = (nsets-1)*nsamp
       loc = base + 1
       lclr = isamp-1
       if(lclr.gt.0)then
        call vclr(mutes(loc),1,lclr)
       endif
       osamp = isamp
       otrc = trc
      else
       jend = isamp -1
       jlen = jend-osamp
       if(jlen.eq.0)then
         jlen = 1
       endif
       slope = (trc - otrc)/float(jlen)
       base = (nsets-1)*nsamp
       x = 0
       do 210 i=osamp, jend
        loc = base + i
        mutes(loc)=otrc + slope * x
        x = x + 1.
  210  continue
       otrc = trc
       osamp = isamp
      endif
      go to 100
  500 continue
      if(osamp.lt.nsamp.and.nsets.ge.1)then
       loc = (nsets-1)*nsamp + osamp + 1
       lfill = nsamp - osamp
       call vfill(mutes(loc-1),mutes(loc),1,lfill)
      endif
      return
      end

      SUBROUTINE getmute(IRI, JR, mutes, nsets, ns, cmute)
C ******************************************************************** C
C *   Subroutine to find the mute function for the current ri.       * C
C *                                                                  * C
C *   INPUT:                                                         * C
C *                                                                  * C
C *     IRI    - I*4   -  Current RI #                               * C
C *      JR    - I*4() -  Vector of RI #'s for mute functions        * C
C *   MUTES    - R*4() -  Matrix of mutes.                           * C
C *   NSETS    - I*4   -  Number of mute functions supplied.         * C
C *      ns    - I*4   -  Trace length.                              * C
C *                                                                  * C
C *   OUTPUT :                                                       * C
C *                                                                  * C
C *   CMUTE    - R*4() -  Current mute vector                        * C
C *                                                                  * C
C ******************************************************************** C
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/iounit.h>
      REAL mutes(*), cmute(*)
      INTEGER  JR(*), nsets
C
      ns4 = ns * ISZBYT
      IF(nsets.gt.1)then
       if(iri.le.jr(1))then
        call move(1,cmute,mutes(1),ns4)
        return
       endif
       DO 210 I = 2,nsets
        IF(JR(I).GE.IRI.or.I.eq.nsets)THEN
          if(jr(i).eq.iri)then
           loc = (i-1)*ns + 1
           call move(1,cmute,mutes(loc),ns4)
           return
          endif
          if(i.eq.nsets.and.iri.gt.jr(i))then
           loc = (i-1)*ns + 1
           call move(1,cmute,mutes(loc),ns4)
           return
          endif
          k = i
          k1 = i-1
          loc1=(k1-1)*ns + 1
          loc2=(k-1)*ns + 1
          slope = float(iri-jr(k1))/float(jr(k)-jr(k1))
          loc1 = loc1 - 1
          loc2 = loc2 - 1
          do 100 L = 1,ns
           loc1 = loc1 + 1
           loc2 = loc2 + 1
           cmute(L)= mutes(loc1) + 
     :           (mutes(loc2)-mutes(loc1))*slope
  100     continue
         return
        ENDIF
  210  CONTINUE
      ELSE
       call move(1,cmute,mutes(1),ns4)
       return
      ENDIF
      END
      subroutine appmute(semb,nsamp,np,cmute)
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/iounit.h>
      REAL semb(*), cmute(*)
      INTEGER nsamp, np

      ndo = 0
      do 100 i=1,nsamp
      imutst = cmute(i)
      if(imutst.gt.np)imutst=np
      if(imutst.gt.0)call vclr(semb(i), nsamp, imutst)
  100 continue
      return
      end
      subroutine sortmute(mutes,jr,ns,nsets)
#include <localsys.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/iounit.h>
      real mutes(*),temp(1),recs(70)
      integer ns, nsets,jr(*),ir(70)
      integer kndx(70)
      POINTER (pt,temp)

      iget = ns * nsets*ISZBYT
      iabort = 0
      ierror=0
      call galloc(pt,iget,ierror,iabort)
      if(ierror.ne.0)then
        write(LERR,*)' Error in pt memory allocation'
        call ccexit(100)
      endif
      do 100 i=1,nsets
       kndx(i)=i
       recs(i)=jr(i)
  100 continue
      L1 = 0
      L2 = nsets - 1
      call hsorti(nsets,recs,kndx)
      do 200 i=1,nsets
        loc1 = kndx(i)
        ir(i)=jr(loc1)
        loc1 = (loc1-1)*ns + 1
        loc2 = (i-1)*ns + 1
        call vmov(mutes(loc1),1,temp(loc2),1,ns)
  200 continue
      lmove = nsets * ns
      call vmov(temp(1),1,mutes(1),1,lmove)
      call vmov(ir,1,jr,1,nsets)
      call gfree(pt)
      return
      end
