C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine polfil2(n,x1,x2,vtrin,rtrin,iwin,th,nrect)
c
c  subroutine to compute & apply ground roll filter to 3 components
c
c  input:
c        n -- number of input data points
c     x1,2 -- 2 input channels, vert, radl, trans
c      thr -- threshold, determines zeroing of rect function
c      ist -- sample at which to start processing
c     iwin -- sliding window length
c    nrect -- power to raise rect function
c
c  output:
c   vtrin  -- vertical filtered output (ditto for rtrin)
c
#include <localsys.h>
#include <f77/lhdrsz.h>
      dimension   x1(*),x2(*),vtrin(*),rtrin(*)
      real        q11(SZSMPM),q12(SZSMPM),q22(SZSMPM)
      real        eig(4),quad(4)
      real        lmda1,lmda2,sum11,sum12,sum22
 
      ist=1
      iwin2=iwin/2
      ist0=ist
c   don't start pocessing unless we're at least 1/2 window length into trace
      if(iwin2 .gt. ist) ist0=iwin2
      ist1=ist0+1
c   stop processing when we're within 1/2 window length of end of trace
      nw=n-iwin2
c
c   Loop to calculate 0-lag cross correlation coefficients of  V, R, T
c
c   q11 = V * V; q22 = R * R 
c   q12 = V * R
c
       call vmul (x1,1,x1,1,q11,1,n)
       call vmul (x1,1,x2,1,q12,1,n)
       call vmul (x2,1,x2,1,q22,1,n)
c
c   Main DO LOOP for calculating filter
      DO 100 i=ist1,nw
c    start & end of current window position
             istart=i-iwin2+1
             iend  =i+iwin2
c    for first window position we need to compute complete correlation...
             if(i .eq. ist1) then
                  sum11=0.
                  sum12=0.
                  sum22=0.
c     ... i.e. sum over all values in window
                  do 10 j=istart,iend
                        sum11=sum11+q11(j)
                        sum12=sum12+q12(j)
                        sum22=sum22+q22(j)
   10             continue
c    BUT for all remaining window positions on trace NEW correlation value is
c    found by subtracting first value of previous position and adding last value
c    of new window position, since these are the only values to change for a 
c    shift of one sample
             else
                     sum11=sum11-q11(istart-1)+q11(iend)
                     sum12=sum12-q12(istart-1)+q12(iend)
                     sum22=sum22-q22(istart-1)+q22(iend)
             endif
c    fill up 4-entry EIGEN matrix
             quad(1)=sum11
             quad(2)=sum12
             quad(3)=sum22
             quad(4)=0.
c   get eigenvalues only
             call eigen2(quad,eig,1)
c            call eigen(quad,eig,2,1,.0001)
             lmda1=quad(1)
             lmda2=quad(3)
c   test for degenerate case, and fill up filter vector
             if(lmda1 .gt. 1.e-20) then
                    rsubi = 1. -  lmda2/lmda1
                    if(rsubi .gt. th) rsubi=1.
                    rsubi=rsubi**nrect
             else
                    rsubi=0.
             endif
             vtrin(i)=x1(i)*rsubi
             rtrin(i)=x2(i)*rsubi
  100 CONTINUE

c   End of Main DO LOOP

      return
      end
