c     program hspect   acoustic version of hspec8 (t. nekut 5/90)
c
c     modified version of hspec8 for acoustic, secondary response.
c     source and receiver assumed to be on surface; surface can
c     be non-reflecting or free; source is a point vertical dipole.
c     subroutines excit and rshof modified (see comments).
c     subroutines aten, cmult,dmult,dnka,hska,lmult,normc,scoef,var removed. 
c     input file same as for hspec8; all inputs referring to source depth
c     or shear wave parameters are ignored.
c
c---------------------------------------------------------------------c
c                                                                     c
c      COMPUTER PROGRAMS IN SEISMOLOGY                                c
c      VOLUME VI                                                      c
c                                                                     c
c      PROGRAM: HSPEC8                                                c
c                                                                     c
c      COPYRIGHT 1985                                                 c
c      R. B. Herrmann                                                 c
c      Department of Earth and Atmospheric Sciences                   c
c      Saint Louis University                                         c
c      221 North Grand Boulevard                                      c
c      St. Louis, Missouri 63103                                      c
c      U. S. A.                                                       c
c                                                                     c
c---------------------------------------------------------------------c
#include <localsys.h>
#include <f77/iounit.h>

c     parameter(LER=0, LIN=5, LOT=6)
      parameter(NL=100)
      common/source/depth,lmax,dph,vamin,vamax,vbmin,vbmax,hvert
      common/damp/alpha
      common/model/d(NL),a(NL),b(NL),rho(NL),mmax,qa(NL),qb(NL)
      common/jout/jsrc(10),jbdry
#include <f77/pid.h>
      character   name*17
      character*50 name2
      character*3 istat2
      dimension ffreq(8)
      integer   argis
      real      alpha,depth,fl,fu,dt,df
      integer   n,n1,n2,nyq2
      logical   prim, ixst2, query
      data    name/'OFFSET_MOD_HSPECT'/

C**********************************************************************C
C     get help if necessary
C**********************************************************************C
      query = ( argis ( '-?' ) .gt. 0 .or. argis ('-h') .gt. 0 )
      if ( query ) then
         call help()
         stop
      endif

c----------
c   open printout file
c----------
#include <f77/open.h>

c   do we want primaries only
c----------
      prim = (argis('-P') .gt. 0)

      read(LIN,18)name2
      read(LIN,18)istat2
      read(LIN,19)ierr,ifreq
   18 format(a)
   19 format(2i5)
      read(LIN,20) alpha,depth,fl,fu,dt,n,n1,n2,df,nyq2 ,mmax
   20 format(5e15.7/3i10,e15.7,i10,i10)
      read(LIN,21)jsrc , jbdry
   21 format(11i5)

      if (prim .and. jbdry .eq. 1) then
         write(LERR,*)'For primary -P option you must have jbdry=0'
         write(LERR,*)'Change this and rerun'
         stop
      endif

      read(LIN,22)(d(i),a(i),b(i),rho(i),qa(i),qb(i),i=1,mmax)
   22 format(6e11.4)
      read(LIN,23)lmax,dph,vamin,vamax,vbmin,vbmax,hvert
   23 format(i10,6e11.4)
      read(LIN,24)xleng, xfac
   24 format(2e15.7)

c-----assume it does not exist
      ixst2= .false.
      inquire(file=name2,exist=ixst2)

      if (ixst2 .and. istat2 .eq. 'new') then
         write(LERR,*)'Output file from hspect or hspec8 already exists'
         write(LERR,*)'Either remove (rm) it or rename (mv) it'
         write(LERR,*)'Then rerun this step'
         stop
      endif


c-----
      open(unit=2,file=name2,status=istat2,access='sequential',
     1 form='unformatted')
      rewind 2

      if (ierr .eq. 0) then
          write(LERR,*)'hspect output file exists and is complete'
          write(LERR,*)'If a new run is to be written to this file'
          write(LERR,*)'either remove (rm) it or rename (mv) it'
          goto 9999
      endif

      dti = 1./dt
      df  = dti/float(n)
      nyq = nyq2/2
      write(LERR,*)' '
      if (prim) then
         write(LERR,*)'*** PRIMARIES ONLY ***'
      else
         write(LERR,*)'*** PRIMARIES + MULTIPLES ***'
      endif
      write(LERR,*)' '
      write(LERR,2)  fl,fu,df,n1,n2,depth,n
    2 format(1h ,4hfl =,f10.5,5x,4hfu =,f10.5,5x,4hdf =,f10.5,/
     1       5x,4hn1 =,i4,5x,4hn2 =,i4,5x,7hdepth =,f10.2,4h n =,i5)
      write(LERR,5)alpha,dt
    5 format(1h ,7halpha =,f10.5,5x,4hdt =,f10.3)
      write(LERR,4)
    4 format(1h ,39hfrequencies for which response computed     )
      rewind 2
      if(ierr .lt. 4)then
         write(2) alpha,depth,fl,fu,dt,n,n1,n2,df,nyq2
         write(2)jsrc
         write(2)d,a,b,rho,mmax,qa,qb
      else
         read(2)alpha,depth,fl,fu,dt,n,n1,n2,df,nyq2
         read(2)jsrc
         read(2)d,a,b,rho,mmax,qa,qb
         call skip(n1,ifreq,jsrc)
      endif
      ilow=mod(n1,8)
       if(ilow.eq.0)ilow=8
      iup=mod(n2,8)
      if(iup.eq.0)iup=8
      do 101 i=1,8
  101 ffreq(i)=-1.0
      n11 = n1
      if(ifreq.gt.n1)n11 = ifreq + 1
      do 100 i = n11,n2
      freq=(i-1)*df
      if(freq.lt.0.001) freq = 0.001
      call excit(freq,xleng,xfac,prim)
      index=mod(i,8)
      if(index.eq.0)index=8
      ffreq(index)=freq
      if (index.eq.8) then
                write(LERR,3)ffreq
                do 102 ii=1,8
  102   ffreq(ii)=-1.
        endif
    3 format(1h ,8f10.5)
  100 continue
      write(LERR,3)ffreq
 9999 continue
      close(2)
      stop
      end
 
      subroutine excit(freq,xleng,xfac,prim)
#include <f77/iounit.h>

c-----
c     sample response for all wavenumbers at a given frequency
c     using Bouchon equal wavenumber sampling = dk
c     with offset of 0.218dk
c-----
c     parameter(LER=0,LIN=5,LOT=6)
      parameter(NL=100)
      common/source/depth,lmax,dph ,vamin,vamax,vbmin,vbmax,hvert
      common/model/d(NL),a(NL),b(NL),rho(NL),mmax,qa(NL),qb(NL)
      common/jout/jsrc(10) , jbdry
      common/damp/alpha
      complex wvn,om,gg(10)
      logical prim

      omega=6.2831853*freq
      dk = 6.2831853/xleng
c modified maximum wavenumber: uses minimum acoustic velocity and first layer thickness
c (t. nekut 5/90)
      wvmm = (3.0/d(1)) + xfac*omega/vamin
      nk = wvmm / dk
        mk=nk+2
      mk1=nk+1
      write(2)omega,mk
c-----output wavenumber in reverse order
c     also output first two wavenumbers to control
c     low frequency asymptotic integration
c-----to save space in sequential i/o buffer output stream
c cannot use asymptotic calculation in rhwvinta without modification;
c it is specifically for total fields of point source at finite depth.
c first two wavenumbers are changed so they are always less than wvmm
c which causes rhwvinta to bypass asyptotics. (t. nekut 5/90)
      call bufini(1,ierr)
      do 3998 ii=mk,1,-1
            if(ii.eq.mk)then
c                 wv = 6.0/depth
                  wv=2./d(1)
            elseif(ii.eq.mk1)then
c                 wv = 2.5/depth
                  wv=1./d(1)
            else
                  wv = (ii-1)*dk + 0.218*dk
            endif
            wvn=cmplx(wv,0.0)
            om=cmplx(omega,-alpha)
            call rshof(gg,om,wvn,jbdry,prim)
            call bufwr(wv)
            do 3998 j=1,10
                  if(jsrc(j).eq.1)then
                  call bufwr(real(gg(j)))
                  call bufwr(aimag(gg(j)))
            endif
 3998             continue
      call buflsh
      return
      end
 
      subroutine rshof(gg,om,wvno,jbdry,prim)
c output is put into gg(7) which corresponnds to vertical displacement due to
c compressional point source output for hspec8. q factor assumed to be
c frequency independent (leads to non-causal response but not significant for 
c high q; see hspec8 for quasi-freq. independent q treatment)  
c jbdry=0 used  for non-reflecting surface; jbdry=1 used for free surface.
c (t. nekut 5/90)
      parameter(NL=100)
      common/model/d(NL),a(NL),b(NL),rho(NL),mmax,qa(NL),qb(NL)
      common/source/depth,lmax,dph ,vamin,vamax,vbmin,vbmax,hvert
      common/damp/alpha
      complex wvno,om,kz,kzo,g,go,R,Ro,gg(10),fxp
      logical prim

c iterate thru layers for amplitude ratio R
      R = cmplx(0.,0.)
      kz=csqrt(wvno**2-(om/a(mmax)*cmplx(1.,-.5*qa(mmax)))**2)
      g=kz/rho(mmax)

      do 200 i=mmax-1,1,-1
      kzo=kz 
      go=g
      Ro=R
      kz=wvno**2-(om/a(i)*cmplx(1.,-.5*qa(i)))**2
      kz=csqrt(kz)                                            
      g=kz/cmplx(rho(i),0.)
      if (.not. prim) then
         R=((g+go)*Ro+(g-go))/((g-go)*Ro+(g+go))
      else
         R=Ro+(g-go)/(cmplx(2.,0.)*go)
      endif
      if(i .eq. 1)then
         di = -2. * d(i)
         fxp = kz * cmplx(di,0.)
         if (cabs(fxp) .lt. 50.) then
             R = R * cexp ( fxp )
         else
             R = cmplx(0.,0.)
         endif
c        R=R*cexp(-2*kz*d(i))
      else
         di = -2. * (d(i) - d(i-1))
         fxp = kz * cmplx(di,0.)
         if (cabs(fxp) .lt. 50.) then
             R = R * cexp ( fxp )
         else
             R = cmplx(0.,0.)
         endif
c        R=R*cexp(cmplx(-2.,0.)*kz*(d(i)-d(i-1)))
      endif
200   continue

      if(jbdry .eq. 1) then
      gg(7)=wvno*R/(12.57*(1.+R))
      else
      gg(7)=wvno*R/12.57
      endif
      return
      end
 
      subroutine skip(n1,ifreq,jsrc)
      complex gg(10)
      dimension jsrc(10)
      do 1300 i=n1,ifreq
          read(2)omega,nk
      call bufini(0,ierr)
          do 1400 mk=1,nk
            call bufrd(wvno,ierr)
             do 1500 j=1,10
                 if(jsrc(j).eq.1)then
            call bufrd(xr,ierr)
            call bufrd(xi,ierr)
            gg(j)=cmplx(xr,xi)
      endif
 1500        continue
 1400     continue
 1300 continue
      return
      end
 
      subroutine bufini(irdwr,ierr)
c------initialize buffer pointer
c------irdwr = 0 read initialize
c------irdwr = 1 write initialize
      integer BUFMAX
       parameter(BUFMAX=2000)
       common/buf/iptr,max,buffer(BUFMAX)
c       save /buf/
      iptr = 1
      if(irdwr.eq.0)call getbuf(ierr)
      return
      end
 
        subroutine buflsh
c------flush output buffer
      integer BUFMAX
      parameter(BUFMAX=2000)
        common/buf/iptr,max,buffer(BUFMAX)
c     save /buf/
      ipt = iptr -1
      if(ipt.gt.0)write(2)ipt,(buffer(i),i=1,ipt)
        iptr = 1
      return
      end
 
        subroutine bufwr(x)
c------fill buffer with floating point variable x,
c------flush buffer as necessary
      integer BUFMAX
      parameter(BUFMAX=2000)
      common/buf/iptr,max,buffer(BUFMAX)
c     save /buf/
      buffer(iptr) = x
      iptr = iptr + 1
      if(iptr.gt.BUFMAX)call buflsh
      return
      end
 
        subroutine getbuf(ierr)
c------read in file contents into buffer, taking care not to
c------read beyond the contents of the file
      integer BUFMAX
      parameter(BUFMAX=2000)
      common/buf/iptr,max,buffer(BUFMAX)
c     save /buf/
c------ierr = 0 successful read
c------     = 1 read error
c------     = 2 end of file
c------
      read(2,err=1000,end=2000)max,(buffer(i),i=1,max)
      iptr = 1
      ierr = 0
      return
 1000 ierr = 1
      return
 2000 ierr = 2
      return
      end
 
      subroutine bufrd(x,ierr)
c-----retrieve a value from buffer array, red in new array
c-----as necessary
c-----iptr is here the next array element to be read
c-----it is always >= 1. We do not worry the upper limit
c-----since the calling program must worry about this
c-----because read always follows a complete write
      integer BUFMAX
      parameter(BUFMAX=2000)
      common/buf/iptr,max,buffer(BUFMAX)
c     save /buf/
c       only yank in new data if actually required
      if(iptr.gt.max)call getbuf(ierr)
      x = buffer(iptr)
      iptr = iptr + 1
      return
      end

#ifdef SUNSYSTEM
      integer function ofclr(sig,code,sigcontext)
#include <f77/iounit.h>
      integer sig,code,sigcontext(5)
      write(LERR,*)'  ieeee exception code ',loc(code),
     1             '  cleared'
      
      return
      end
#endif

      subroutine help
#include <f77/iounit.h>
c-----------------------------------------------------------------------------
c     online help screen
c-----------------------------------------------------------------------------
c
       write(ler,*)' '
       write(ler,*)'Command Line Arguments for HSPECT: '
       write(ler,*)'    evaluate F(f,k) (acoustic) based on data ',
     1       'output of dspec8'
       write(ler,*)' '
       write(ler,*)'-P         -- generate primaries only'
       write(ler,*)' '
       write(ler,*)'Usage:'
       write(ler,*)'    hspect [-P] '
       write(ler,*)' '
      return
      end

