C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************C
c      create a velocity-time trace
c**********************************************************************C
       subroutine vel ( rt, rv, nsamp, si, maxnum, maxfunc, v)
       real    rt(maxnum), rv(maxnum)
       real    v(nsamp), getvel
       integer nn, nsamp

       nn = 0
       do  i = 1, maxnum

           if (rv(i) .eq. 0.0) then
              nn = i - 1
              go to 1
           endif
       enddo
       nn = maxnum
1      continue

       do 2000 i = 1,nsamp

              t  = si * float(i)

              if(t .le. rt(1))then

                getvel = rv(1)

              else if(t.ge.rt(nn))then

                getvel = rv(nn)

              else

                do 1000 j=2,nn

                   if(t.ge.rt(j-1) .and. t.le.rt(j))then

                       fac = (t-rt(j-1))/(rt(j)-rt(j-1))
                       getvel = rv(j-1)+fac*(rv(j)-rv(j-1))
                       go to 1002

                   endif

1000            continue

              endif

1002         continue

              v(i) = getvel

2000         continue

       return
       end
