C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine velgen (JJ, maxnum, maxfunc, nhor, ndi, divec,
     1                   horvec, times, velocities, horizons,
     2                   SZSMPD, ITHWP1, itr, tri, nsamp, si,
     3                   dimin, dimax, wrk1, wrkt, wrk2, nmax,
     4                   obytes, luout, name, tim1, timt, tim2,
     5                   thor1, thort, thor2, vhor1, vhort, vhor2,
     6                   vel1, velt, vel2, iz, zz)

#include <f77/iounit.h>

      real       times (maxnum, maxfunc), velocities (maxnum, maxfunc)
      real       horizons (ndi, nhor)
      integer    horvec (ndi), divec (maxfunc)
      real       tim1 (nsamp), timt (nsamp), tim2 (nsamp)
      real       thor1 (nhor+2), thort (nhor+2), thor2 (nhor+2)
      real       vhor1 (nhor+2), vhort (nhor+2), vhor2 (nhor+2)
      real       vel1 (nmax), velt (nmax), vel2 (nmax)
      real       wrk1 (nmax), wrkt (nmax), wrk2 (nmax)
      real       tri (nsamp), zz (4*nsamp)
      integer    itr (*), iz (nsamp)
      integer    JJ, maxnum, maxfunc, nhor, ndi, SZSMPD, ITHWP1
      integer    nsamp, dimin, dimax, obytes, luout
      real       si
      character  name*(*)
      logical    first
      common /hdrs/
     1        ifmt_RecNum,l_RecNum,ln_RecNum,
     2        ifmt_TrcNum,l_TrcNum,ln_TrcNum,
     3        ifmt_StaCor,l_StaCor,ln_StaCor,
     4        ifmt_DphInd,l_DphInd,ln_DphInd,
     5        ifmt_LinInd,l_LinInd,ln_LinInd

       write(LERR,*)' '
       write(LERR,*)'Time Velocity functions input to re-gridder'
       do  jj = 1, maxfunc
         write(LERR,*)'times: function ',jj
         write(LERR,*)(times(ii,jj),ii=1,maxnum)
         write(LERR,*)'velocities: function ',jj
         write(LERR,*)(velocities(ii,jj),ii=1,maxnum)
       enddo
       write(LERR,*)' '
       write(LERR,*)'Vector of DIs'
       write(LERR,*)(divec(ii),ii=1,maxfunc)
       write(LERR,*)' '

       first = .false.

       call savew2 ( itr, ifmt_TrcNum, l_TrcNum, ln_TrcNum,
     :               1, 1)
       call savew2 ( itr, ifmt_StaCor, l_StaCor, ln_StaCor,
     :               0, 1)

      idist = 0
      do  j = 1, maxfunc
          if (divec(j) .ge. dimin) then
              if (j .eq. 1) then
                 ivlocs = divec  (1)
                 idist = 2
              else
                 ivlocs = divec  (j-1)
                 idist = j
              endif
              go to 1
          endif
      enddo
1     continue
      idist1 = idist - 1
      if (idist .eq. 0) then
         write(LERR,*)'FATAL ERROR in slvr:'
         write(LERR,*)'Could not locate first velocity function within'
         write(LERR,*)'-dimin[] -dimax[] limits ',dimin,dimax
         write(LERR,*)'Check indexing of velocity functions.'
         write(LER ,*)'FATAL ERROR in slvr:'
         write(LER ,*)'Could not locate first velocity function within'
         write(LER ,*)'-dimin[] -dimax[] limits ',dimin,dimax
         write(LER ,*)'Check indexing of velocity functions.'
         call ccexit (666)
      endif

      idied = 0
      do  j = maxfunc, 1, -1
          if (divec(j) .le. dimax) then
              if (j .eq. maxfunc) then
                 ivloce = divec  (maxfunc)
                 idied = maxfunc
              else
                 ivloce = divec  (j+1)
                 idied = j+1
              endif
              go to 2
          endif
      enddo
2     continue
      if (idied .eq. 0) then
         write(LERR,*)'FATAL ERROR in slvr:'
         write(LERR,*)'Could not locate last velocity function within'
         write(LERR,*)'-dimin[] -dimax[] limits ',dimin,dimax
         write(LERR,*)'Check indexing of velocity functions.'
         write(LER ,*)'FATAL ERROR in slvr:'
         write(LER ,*)'Could not locate last velocity function within'
         write(LER ,*)'-dimin[] -dimax[] limits ',dimin,dimax
         write(LER ,*)'Check indexing of velocity functions.'
         call ccexit (666)
      endif


      irec   = dimin - 1

c----
c   expand the first velocity function to get us started
c----
      call vel (times(1,idist1), velocities(1,idist1), nsamp, si,
     1          maxnum, maxfunc, vel1)

c----
c   We are now at the first vel function ready to step into territory
c   between the first and second functions (interpolation)
c----

      DO  J = idist, idied

         call vclr (thor1, 1, nhor+2)
         call vclr (thor2, 1, nhor+2)
         call vclr (vhor1, 1, nhor+2)
         call vclr (vhor2, 1, nhor+2)

         ivloc1 = divec (J-1)
         ivec1  = ivloc1
         ivecs  = ivloc1
         if (J .eq. idist) then
             if (ivloc1 .lt. dimin) then
                 ivloc1 = dimin - 1
             elseif (ivloc1 .eq. dimin) then
                 ivloc1 = dimin - 1
             endif
         endif

         ivloc2 = divec (J)
         ivec2  = ivloc2
         ivece  = ivloc2
         if (J .eq. idied) then
            if (ivloc2 .gt. dimax) then
                ivloc2 = dimax
                ivece  = dimax
            endif
         endif

         dvloc  = ivec2 - ivec1

c----
c   extract the horizon times for the J-1 & J'th function locations. Fill in
c   start times (0ms) and end times. nt1 & nt2 are the number of nonzero entries
c   (excluding zero time) in the respective functions. Also extract the 
c   corrsponding velocities
c----
         if (times(1, J-1) .gt. 0.) then
             thor1 (1) = 0
             vhor1 (1) = velocities (1, J-1)
             nt1 = 1
         else
             nt1 = 0
         endif

         if (times(1, J) .gt. 0.) then
             thor2 (1) = 0
             vhor2 (1) = velocities (1, J)
             nt2 = 1
         else
             nt2 = 0
         endif

         do  ii = 1, maxnum
             if (velocities(ii,J-1) .gt. 0.0) then
                nt1 = nt1 + 1
                thor1 (nt1) = times (ii,J-1)
                vhor1 (nt1) = velocities (ii,J-1)
             else
                thor1 (ii+1) = 0.0
             endif
         enddo
         tend = si * (nsamp - 1)
         if ( thor1(nt1) .ge. tend ) then
              thor1 (nt1) = tend
         else

              nt1 = nt1 + 1
              thor1 (nt1) = tend
              vhor1 (nt1) = velocities (nt1-2,J-1)
         endif

         do  ii = 1, maxnum
             if (velocities(ii,J  ) .gt. 0.0) then 
                nt2 = nt2 + 1
                thor2 (nt2) = times (ii,J  )
                vhor2 (nt2) = velocities (ii,J  )
             else
                thor2 (ii+1) = 0.0
             endif
         enddo
         if ( thor2(nt2) .ge. tend ) then
              thor2 (nt2) = tend
         else

              nt2 = nt2 + 1
              thor2 (nt2) = tend
              vhor2 (nt2) = velocities (nt2-2,J  )
         endif

c----
c   equally sample velocity functions 1 & 2 with sample interval = si
c----
      call vel (thor1, vhor1, nsamp, si, nt1, maxfunc, vel1)
      call vel (thor2, vhor2, nsamp, si, nt2, maxfunc, vel2)

c----
c   Given the current spatial location, I,  (betw. functions J-1 & J) we now loop
c   down horizons. In some cases the upper & lower horizons will be converging
c   in which case we will need to resample the left T-V function to a coarser
c   sample interval and leave the right function sampled at "si". In other cases
c   the upper & lower horizons will be diverging in which case we will need to
c   resample the right T-V function to a coarser sample interval and leave the
c   left function sampled at "si". The aim here is to have the same number of
c   samples between horizon boundaries for both function J-1 & function J (and
c   all functions in between as we interpolate). The velocity then at any output
c   function location J-1 < JJ < J can be generated by simple linear interpolation
c   of the resampled V(J-1)'s & V(J)'s 

c   We make sure that there is a "zero" horizon and a "last sample" horizon
c----
         do  i = 1, nhor
             thor1 (i+1) = horizons (ivecs, i)
             thor2 (i+1) = horizons (ivece, i)
         enddo
         thor1 (1) = 0
         thor2 (1) = 0
         thor1 (nhor+2) = si * (nsamp-1)
         thor2 (nhor+2) = si * (nsamp-1)

         do  I = ivloc1+1, ivloc2

             delx1 = I - ivec1
             delx2 = ivec2 - I
             s1 = delx2 / dvloc
             s2 = delx1 / dvloc

c----
c   For spatial location "I" we loop down the horizons building an interpolated
c   velocity trace, after which we output it. Kp1 points at the current lower
c   horizon.
c----
             vlast = 0.

             do  K = 1, nhor+1

                 K1 = K + 1

                 call vbuild (s1, s2, si, nsamp, nhor, ndi, nmax, K1, I,
     1                        thor1, thort, thor2, vhor1, vhort, vhor2,
     2                        tim1, timt, tim2, vel1, velt, vel2,
     3                        wrk1, wrkt, wrk2, vlast, iz, zz)
         
             enddo

c----
c   deal with last sample that didn't make it throught the cubic spline
c   interpolation
c----
             velt (nsamp) = velt (nsamp-1)
c----
c   If 1st velocity function lies down the line somewhere we just repeat
c   the first function
c----
             IF ( .not.first .AND. (dimin .lt. I) ) THEN
 
                nv = I - dimin
                call vmov (vel1, 1, itr(ITHWP1), 1, nsamp)
                do  iv = 1, nv
 
                    irec = irec + 1
                    call savew2 ( itr, ifmt_RecNum, l_RecNum, ln_RecNum,
     :                            irec, 1)
                    call wrtape (luout, itr, obytes)
                enddo
 
             ENDIF
             first = .true.

             IF (I .ge. dimin .AND. I .le. dimax) THEN
                irec = irec + 1

                call vmov (velt, 1, itr(ITHWP1), 1, nsamp)
                call savew2 ( itr, ifmt_RecNum, l_RecNum, ln_RecNum,
     :                        irec, 1)
                call wrtape (luout, itr, obytes)
                if (I .eq. dimax) go to 3

             ENDIF

         enddo

      ENDDO

3     continue

c----
c   We are now at the last vel function. If this is not the end of the
c   data set we need to dup the last velocity the proper number of times
c----

      IF (irec .lt. dimax) THEN

         nv = dimax - irec
         call vmov (velt, 1, itr(ITHWP1), 1, nsamp)
         do  iv = 1, nv
 
             irec = irec + 1
             call savew2 ( itr, ifmt_RecNum, l_RecNum, ln_RecNum,
     :                     irec, 1)
             call wrtape (luout, itr, obytes)
         enddo

      ENDIF

      return
      end
