C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C
C   PROGRAM TO COMPUTE NORMAL INCIDENCE SYNTHETIC AMS
C   USING THE Z-MATRIX FORMULATION.  THE PROGRAM CAN HANDLE
C   ARBITRARY SOURCE AND RECEIVER DEPTHS USING THEORY DEVELOPED
C   BY P. GUTOWSKI (AUG. 1977).  FURTHER DETAILED COMMENTS ON THE
C   THEORETICAL ASPECTS ARE TO BE FOUND IN OUR REPORT AND IN THE
C   COMMENTS OF SUBROUTINE SNTHET.
C
C   INPUTS:
C          NUM--LENGTH OF AM IN SAMPLES (MAX=1500)
C          XA--DEPTH OF SOURCE IN FEET
C          XB--DEPTH OF RECEIVER IN FEET
C          C0--SURFACE REFLECTION COEFFICIENT (USUALLY -1)
C          NOW ENTER LINE-BY-LINE....
C          LAYER THICKNESS(FT.), VELOCITY('/SEC), DENSITY
C          MODEL TERMINATED BY ENTERING A NEGATIVE THICKNESS
C          (ANY NEGATIVE NUMBER) ALONG WITH THE VELOCITY AND
C          DENSITY OF THE HALF-SPACE UNDERLYING THE LAYERED MODEL.
C
C   OUTPUTS:
C          LISTING OF THE DEPTH, TIME(MS), VELOCITY, AND DENSITY
C          DISPLAY OF THE DIGITIZED REFLECTION COEFFICIENT MODEL
C          DISPLAY OF THE CONSTITUENT POLYNOMIALS INHERENT IN THE
C          COMPUTATIONS AND AN OPTIONAL PLOT OF THE DENOMINATOR
C          POLYNOMIAL (CONTAINS ALL REVERBERATIONS)
C          CHOICE OF PLOTS OF THE UPGOING WAVE, THE DOWNGOING
C          WAVE, OR THE SUM OF THE TWO(TOTAL MOTION)
C
C   SUBROUTINES CALLED:
C                         SNTHET
C                         XNDEX
C                         MOV
C
C

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

      integer   SZSWRK
      parameter (SZSWRK = 10 * SZSMPM)

      real  V(SZSWRK),C(SZSWRK),CP(SZSWRK)
      real  Z(SZSWRK),RHO(SZSWRK),cc(SZSWRK)
      real  PG(SZSWRK),QG(SZSWRK),PD(SZSWRK)
      real  QD(SZSWRK),TIME(SZSWRK)
      real  XU(SZSWRK), XD(SZSWRK), Y(SZSWRK), PMCQ(SZSWRK)
      real  P(SZSWRK),Q(SZSWRK),xtr(2*SZLNHD),xpr(SZSWRK)
      real  tj(100)
      character title(20)

      integer   luout(4),iwr(10),lbytes,nbytes
      integer   argis, pipes(4), npipes, pipcnt
      logical   verbos, query, fttom, mtoft, slow, dept, prim,cmdln
      logical   below, primod, logdmp, gma, micro
      character input * 512, otap(4) *512, name*5, input1 * 512
      character fmt*80, vmod * 512
#include <f77/pid.h>
      integer   itr(SZLNHD)
      DATA  verbos/.false./, name/'SYNTH'/
      DATA  luout /4*0/
      DATA  iwr /10*0/
      DATA  pipes / 1,3,4,5/, npipes /0/, cmdln /.false./
      DATA  below /.false./, primod /.false./, logdmp/.false./
      DATA  micro /.false./

c----------------------------------
c  get online help if necessary
c----------------------------------
      query = (argis('-?') .gt. 0 .or. argis('-h') .gt.0)
      if( query ) then
           call help()
           stop
      endif

c----------------------------------
c  open printout file
c----------------------------------
#include <f77/open.h>

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('CabDep',ifmt_CabDep,l_CabDep,ln_CabDep,TRACEHEADER)
      call savelu('ShtDep',ifmt_ShtDep,l_ShtDep,ln_ShtDep,TRACEHEADER)

C
C   READ IN THE LENGTH OF THE AM, THE SAMPLE INTERVAL
C   AND THE SURFACE REFLECTION COEFFICIENT
C   READ IN ALSO THE UP & DOWN SOURCE STRENGTHS:
C              FOR THE MARINE CASE ENTER EP=1.0  EM=1.0
C              FOR THE LAND CASE (1.,-1.) = COMPRESSION BOTH UP & DOWN
C                                (1.,1.) = COMPRN UP, RAREFACTION DOWN
C   READ IN THE NUMBER OF SOURCE/rcvr DEPTHS (MUST BE >= 1)
C   READ IN THE NUMBER OF LAYERS IN GEOLOGIC MODEL
C
      call topn(input,ntpr,otap,slow,dept,fttom,mtoft,prim,
     1            logdmp,verbos,gma,input1,rhogma,fmt,micro)

C      IWR(1) = 1/0 -- DO/DON'T COMPUTE PRIMARIES TRACE
C      IWR(2) = 1/0 -- DO/DON'T COMPUTE UPGOING TRACE
C      IWR(3) = 1/0 --          COMPUTE DOWNGOING TRACE
C      IWR(4) = 1/0 --          COMPUTE TOTAL RESPONSE, I.E. U + D

      lfmt = lenth(fmt)

      if(input .ne. ' ') then
         write(LERR,*)'Using card file input'
         write(LER ,*)'Using card file input'
         lum = lun
         open(unit=lum,file=input,status='old')
      else
         cmdln = .true.
         write(LERR,*)'Input file of all params not found'
         write(LERR,*)'Will try to use cmd line input mode'
         write(LER ,*)'Input file of all params not found'
         write(LER ,*)'Will try to use cmd line input mode'
      endif

      if (gma) then
         lum1 = lum + 1
         open(unit=lum1,file=input1,status='old')
         rewind lum1
         read (lum1, 109) dstart, dend, dz
109      format(29x,f6.0,1x,f6.0,4x,f6.0)
         read (lum1, 113) zj,(tj(i),i=1,10),nt
c111      format(fmt(1:lfmt))
         write(LERR,*)' '
         write(LERR,*)'Using Amoco GMA well data format:'
         write(LERR,*)'Starting depth           = ',dstart
         write(LERR,*)'Ending depth             = ',dend
         write(LERR,*)'Depth increment          = ',dz
         write(LERR,*)'Number travel times/line = ',nt
         write(LERR,*)'Constant density         = ',rhogma
         write(LERR,*)' '
         rewind lum1
         read (lum1, '(29x,f6.0,1x,f6.0,4x,f6.0)') dstart, dend, dz
      endif

c------------------------
c  decide on command line
c  input or card image
c------------------------
      if (.not. cmdln) cmdln = (argis('-L') .gt. 0)

      if (cmdln) then
          call argstr('-N',vmod,' ',' ')
          call argstr('-T',title,' ',' ')
          call argi4('-ls',num,8000,8000)
          call argi4('-dt',idelt,4,4)
          call argi4('-c0',ic0,-1,-1)
          call argi4('-eu',iep,1,1)
          call argi4('-ed',iem,1,1)
          call argi4('-od',ndepth,1,1)
          call argi4('-ol',nlayer,0,0)
          if (nlayer .eq. 0) then
             write(LER ,*)'Error in synth:'
             write(LER ,*)'Must enter # of interfaces in model -ol[]'
             stop 666
          endif
          below = (argis('-B') .gt. 0)
          if (below) then
             iwr(5) = -1
          else
             iwr(5) = 1
          endif
          primod = (argis('-M') .gt. 0)
          if (primod) then
             iwr(6) = 1
          else
             iwr(6) = 0
          endif
          if (vmod(1:1) .eq. ' ') then
              lum = LIN
          else
              write(LERR,*)'Opening velocity model file= ',vmod
              write(LER ,*)'Opening velocity model file= ',vmod
              lum = lun
              open(unit=lum,file=vmod,status='old')
          endif
      else
          read(lum,105) (title(i),i=1,20)
105       format(20a4)
          read(lum,*) NUM,IDELT,IC0,Iep,Iem,ndepth,nlayer
          read(lum,*,end=106) (iwr(i),i=1,6)
106       continue
          if (iwr(5) .ge. 0) then
             below = .false.
          else
             below = .true.
          endif
      endif

      if (gma) nlayer = 10000
c--------------
c  open output data streams
c--------------
      nu = 0
      do 29 i=1,4
         iwr(i) = 1
         luout(i) = 0
         if(otap(i) .ne. ' ') then
            nu = nu + 1
         endif
   29 continue
      write(LERR,*)'Number output files= ',nu
      write(LER ,*)'Number output files= ',nu

      IF (nu .ne. 0) THEN
         do 101 i=1,nu
            call getln(luout(i),otap(i),'w',1)
            iwr(i) = 1
            if(luout(i) .eq. 1) then
               write(LERR,*)'Output data set ',otap(i),
     1                       ' cannot be a pipe'
               write(LERR,*)'check command line & rerun'
               write(LER ,*)'Output data set ',otap(i),
     1                       ' cannot be a pipe'
               write(LER ,*)'check command line & rerun'
               stop
            endif
101      continue
      ELSE
         nu = pipcnt (pipes,4)
         if (nu .gt. 4) then
               write(LERR,*)'Cannot have more then 4 outputs'
               write(LERR,*)'You have  ',nu,'  outputs'
               write(LER ,*)'Cannot have more then 4 outputs'
               write(LER ,*)'You have  ',nu,'  outputs'
               stop
         endif
         do 102 i = 1, nu
            call sisfdfit (luout(i), pipes(i))
            write(LERR,*)'Opened output unit= ',luout(i)
            write(LER ,*)'Opened output unit= ',luout(i)
            iwr(i) = 1
102      continue
      ENDIF


       write(LERR,*)(iwr(i),i=1,10)

      delt = idelt
      if (.not. micro) then
          tfact = 1000.
      else
          tfact = 1000000.
      endif
      num = num/idelt
      unitsc = 1/tfact

      if (num .gt. SZLNHD) then
          write(LERR,*)'Trace too long.  You have a max of  ',
     1                  SZLNHD,'  points'
          write(LERR,*)'Trim the trace length in ms & rerun'
          write(LER ,*)'Trace too long.  You have a max of  ',
     1                  SZLNHD,'  points'
          write(LER ,*)'Trim the trace length in ms & rerun'
          stop
      endif

      c0 = ic0
      ep = iep
      em = iem

      if (ndepth .eq. 0) ndepth = 1
      if(ntpr .eq. 0) ntpr=1
      ntrc = ntpr * ndepth
      iwr(7)=ndepth
      if (prim) iwr(10) = 1

      write(LERR,*)' '
      write(LERR,*)' Number trace   =  ',ntrc
      if (idelt .lt. 32)
     1write(LERR,*)' Sample interval=  ',idelt,'  ms'
      if (idelt .ge. 32)
     1write(LERR,*)' Sample interval=  ',idelt,'  micro secs'
      write(LERR,*)' Number samples =  ',num
      write(LERR,*)' Number model layers =  ',nlayer
      write(LERR,*)' Number depths  =  ',ndepth
      write(LERR,*)' Convert slowness to velocity=  ',slow
      write(LERR,*)' Depth instead of thickness=  ',dept
      write(LERR,*)' Convert ft/s to m/s=  ',fttom
      write(LERR,*)' Convert m/s to ft/s=  ',mtoft
      write(LERR,*)' Primaries only=  ',prim
      write(LERR,*)' Dump log to SIS disk file= ',logdmp
      write(LERR,*)' '
      IF(C0 .GT. 0.) EM=EP
      WRITE(LERR,310) EP,EM
  310 FORMAT(' UPGOING SOURCE= ',F5.2,', DOWNGOING SOURCE= ',F5.2)
      write(LERR,*)' '
      write(LER ,*)' '
      write(LER ,*)' Number trace   =  ',ntrc
      if (idelt .lt. 32)
     1write(LER ,*)' Sample interval=  ',idelt,'  ms'
      if (idelt .ge. 32)
     1write(LER ,*)' Sample interval=  ',idelt,'  micro secs'
      write(LER ,*)' Number samples =  ',num
      write(LER ,*)' Number model layers =  ',nlayer
      write(LER ,*)' Number depths  =  ',ndepth
      write(LER ,*)' Convert slowness to velocity=  ',slow
      write(LER ,*)' Depth instead of thickness=  ',dept
      write(LER ,*)' Convert ft/s to m/s=  ',fttom
      write(LER ,*)' Convert m/s to ft/s=  ',mtoft
      write(LER ,*)' Primaries only=  ',prim
      write(LER ,*)' Dump log to SIS disk file= ',logdmp
      write(LERR,*)' '
      WRITE(LER ,310) EP,EM
      write(LER ,*)' '

C
C   FOR A HYDROPHONE (C0=1) WE MUST CHANGE SIGN OF REFLECTION COEFFS
C
      IF(C0 .LE. 0.) SN=1.
      IF(C0 .GT. 0.) SN=-1.
C
C   READ IN PROGRAM FLAGS IN VECTOR IWR:
C      IWR(5) = 1/-1-- FOR RECEIVER AT FREE SURFACE: +1 = RCVR JUST ABOVE F.S.
C                                                    -1 = RCVR JUST BELOW F.S.
C      IWR(6) = 1/0 -- DO/DON'T PRINT EQUAL TRAVEL TIME MODEL( DEF = DON'T)
C
C
C   ENTER LINE-BY-LINE:
C
C     LATER THICKNESS, VELOCITY, DENSITY
C
      write(LERR,*)' '
      write(LERR,*)' '
      write(LER ,*)' '
      write(LER ,*)' '
      DEPTH=0.
      TT=0.

      IL = 0
      DO 1  I = 1, nlayer

         IF (gma) THEN

            read (lum1,113) zj,
     1            (tj(l),l=1,nt),mj
113         format(f7.0,10(f7.0),i3)

            do  l = 1, nt
                IL = IL + 1
                Z(IL) = zj + (l-1) * dz
                V(IL) = tj(l)
                RHO(IL) = rhogma
                if (V(IL) .eq. 0.0) then
                    V(IL) = V(IL-1)
                    go to 2
                endif
            enddo
                
            
         ELSE

            READ(lum,*,end=1) Z(I),V(I),RHO(I)
            IL = IL + 1
            if (Z(i) .eq. 0.0) then
              write(LERR,*)'FATAL ERROR in synth reading model:'
              write(LERR,*)'read zero thickness (depth). Check model'
              write(LER ,*)'FATAL ERROR in synth reading model:'
              write(LER ,*)'read zero thickness (depth). Check model'
              stop 666
            endif
            if (v(i) .eq. 0.0) then
              write(LERR,*)'FATAL ERROR in synth reading model:'
              write(LERR,*)'read zero velocity (slowness). Check model'
              write(LER ,*)'FATAL ERROR in synth reading model:'
              write(LER ,*)'read zero velocity (slowness). Check model'
              stop 666
            endif
            if (rho(i) .eq. 0.0) then
              write(LERR,*)'FATAL ERROR in synth reading model:'
              write(LERR,*)'read zero density. Check model'
              write(LER ,*)'FATAL ERROR in synth reading model:'
              write(LER ,*)'read zero density. Check model'
              stop 666
            endif

                if (z(i) .lt. 0.) then
                   IL = IL - 1
                   go to 2
                endif
         ENDIF


    1 CONTINUE

      if (cmdln) then
         IL = IL -1
         write(LERR,*)'No negative thickness detected:'
         write(LERR,*)'premature end of velocity model found'
         write(LERR,*)'Will assume model complete - check printout'
      else
         write(LERR,*)'FATAL ERROR in synth:'
         write(LERR,*)'premature end of parameter file. Incorrect'
         write(LERR,*)'number of layers given?'
         stop 666
      endif

c   2 N = IL - 1
    2 N = IL

      DO  i = 1, N+1

         if (slow) then
             v(i) = 1000000./v(i)
         endif
         if (fttom) then
             v(i) = v(i) * .3048
         elseif (mtoft) then
             v(i) = v(i) * 3.28084
         endif
         write(LERR,*)'I= ',i,' z= ',z(i),' v= ',v(i),' rho= ',rho(i)
         write(LER ,*)'I= ',i,' z= ',z(i),' v= ',v(i),' rho= ',rho(i)

      ENDDO

      write(LERR,*)' '
      write(LERR,*)'Asked for ',nlayer,' Found ',n
      write(LERR,*)' '
C
C
C   write out line header

      if (logdmp) then
          num = n
      endif


      lbytes = HSTOFF
      nbyt = 2 * SZHFWD
      nbytes = SZTRHD + SZSMPD * num
      write(LER,*)'Number of traces to be written= ',ntrc
      write(LER,*)'Number of samples to be written= ',num
      call savew( itr, 'HlhEnt',  0   , LINHED)
      call savew( itr, 'HlhByt', nbyt , LINHED)
      call savhlh( itr, lbytes, lbyout)

      call put(itr,ntrc,1,idelt,num,unitsc)

      do 32 i = 1, 4
        if(luout(i) .ge. 1) then
           write(LERR,*)' '
           write(LER ,*)' '
           call wrtape(luout(i),itr,lbyout)
           write(LERR,*)'writing header on unit ',luout(i)
           write(LER ,*)'writing header on unit ',luout(i)
        endif
   32 continue

             call vclr(xtr,1,num)
C
C   DISPLAY INPUT DEPTH MODEL WITH CUMULATIVE 2-WAY TIME
  202 FORMAT('I  DEPTH       TIME   THICKNESS  VELOCITY     DENSITY      
     1  REFLECTION COEFF')

      DO 3 I=1,N

          if (.not.dept) then
              DEPTH=DEPTH + Z(I)
              thick = z(i)
              QD(I)=DEPTH
          else
              if (i .eq. 1) then
                 depth = z(1)
                 thick = z(1)
              else
                 thick = z(i) - depth
                 depth = z(i)
                 z(i) = thick
              endif
              qd(i) = depth
          endif

          TT=TT + 2.*tfact* thick/V(I)
          TIME(I)=TT
  203     FORMAT(I5,1x,F9.2,3X,F9.2,3X,F9.2,5X,F8.2,2X,F7.2,5x,e12.3)
C
C   COMPUTE REFLECTION COEFFICIENT AT INTERFACES:
C
C           RHO(I)*V(I)-RHO(I+1)*V(I+1)
C     C(I)= ---------------------------- * SN
C           RHO(I)*V(I)+RHO(I+1)*V(I+1)
C
          ZN=RHO(I)*V(I)-RHO(I+1)*V(I+1)
          ZD=RHO(I)*V(I)+RHO(I+1)*V(I+1)
          PD(I)=SN*ZN/ZD
          if (verbos)
     1    WRITE(LERR,203) I,DEPTH,TIME(I),Z(I),V(I),RHO(I),pd(i)
          if (logdmp) then
             ist = 1
             if (ist .le. 0) ist = 1
             xtr(i+ist-1) = pd(i)
          endif

    3 CONTINUE
      depmax = depth
      write(LERR,*)' '
      write(LERR,*)' '

      if (logdmp) go to 50
C
C   COMPUTE THE DIGITIZED REFLECTION COEFFICIENT MODEL USING THE
C   INPUT SAMPLE INTERVAL.  HOPEFULLY INTERFACES WILL FALL ON SAMPLES
C   WHEN AN INTERFACE COMES TO WITHIN A SAMPLE INTERVAL
C   FIX THE REFLECTION COEFFICIENT AT THE NEXT GREATEST INDEX
C   ALSO, IF SOURCE OR RECEIVER DEPTHS CORRESPOND TO AN INPUT DEPTH
C   FIX SOURCE OR RECEIVER INDICES AT THAT DEPTH
C
C   SET IFLAG=0 FOR FIRST SET OF IA AND IB VALUES
C
      IFLAG=0
      IFA=0
      IFB=0
      IT=0
      J=1
      DO 5 I=1,SZSWRK
      C(I)=0.
      IT=IT+IDELT
      IF(IT .LT. IFIX(TIME(J) + .1)) GO TO 6
      C(I)=PD(J)
      IF(XA .NE. QD(J)) GO TO 8
      IA=I
      IFA=1
    8 IF(XB .NE. QD(J)) GO TO 9
      IB=I
      IFB=1
    9 J=J+1
      IF(J .GT. N) GO TO 7
    6 CONTINUE
    5 CONTINUE
    7 CONTINUE
C
C   WE NOW HAVE NT LAYERS EACH HAVING A TW0-WAY THICKNESS OF
C   ONE SAMPLE INTERVAL
C
      NT=I
C
C   STORE DEPTHS TO MODEL INTERFACES IN VECTOR RHO(I)
C   WE WILL NOT NEED THE DENSITIES AGAIN
C
      call vmov(qd,1,rho,1,n)
C
C   IF EITHER SOURCE OR RECEIVER DO NOT LIE ON INTERFACES (I.E.
C   NONZERO C'S) GIVEN AS INPUT, COMPUTE LOCATION INDEX, IA IB,
C   OF SOURCE  AND RECEIVER
      IF(IFA .EQ. 0) then
         CALL XNDEX(V,Z,N,XA,DELT,IA,tfact)
         write(LERR,*)'src index not on bdry:  ia= ',ia
         if (ia .gt. n) then
            write(LERR,*)'Warning: src index exceeds # unit layers'
            write(LERR,*)'Resetting index to = layer number'
            ia = n
         endif
      ENDIF
      IF(IFB .EQ. 0) then
         CALL XNDEX(V,Z,N,XB,DELT,IB,tfact)
         write(LERR,*)'rcvr index not on bdry:  ib= ',ib
         if (ib .gt. n) then
            write(LERR,*)'Warning: rcvr index exceeds # unit layers'
            write(LERR,*)'Resetting index to = layer number'
            ib = n
         endif
      ENDIF
C
C   FOR EACH SOURCE/RCVR POSITION COMPUTE AMS
      iflag=0
C
      if (cmdln) then
         call argr4('-sd',xa0,0.,0.)
         call argr4('-rd',xb0,0.,0.)
         call argr4('-dels',dxa,0.,0.)
         call argr4('-delr',dxb,0.,0.)
      else
         read(lum,*) xa0,xb0, dxa,dxb
      endif

      write(LERR,*)' '
      write(LERR,*)'Initial src depth=  ',xa0
      write(LERR,*)'src depth increment (if any)=  ',dxa
      write(LERR,*)'Initial rcvr depth=  ',xb0
      write(LERR,*)'rcvr depth increment (if any)=  ',dxb
      write(LERR,*)' '
      write(LERR,*)' '
      write(LER ,*)' '
      write(LER ,*)'Initial src depth=  ',xa0
      write(LER ,*)'src depth increment (if any)=  ',dxa
      write(LER ,*)'Initial rcvr depth=  ',xb0
      write(LER ,*)'rcvr depth increment (if any)=  ',dxb
      write(LER ,*)' '
      do 45 jd=1,ndepth
      write(LER ,*)'working on depth ',jd
      xa = xa0 + (jd-1)*dxa
      xb = xb0 + (jd-1)*dxb

      if (xa .ge. depmax .or. xb .ge. depmax) then
         write(LERR,*)'Source depth=  ',xa
         write(LERR,*)'Receiver depth=  ',xb
         write(LERR,*)'one of these > max depth= ',depmax
         write(LERR,*)'Skipping this depth'
         write(LER ,*)'Source depth=  ',xa
         write(LER ,*)'Receiver depth=  ',xb
         write(LER ,*)'one of these > max depth= ',depmax
         write(LER ,*)'Skipping this depth'
         go to 45
      endif
      IFA=0
      IFB=0
      IT=0
      J=1
      DO 15 I=1,NT
      IT=IT + IDELT
      IF(IT .LT. IFIX(TIME(J) + .1)) GO TO 15
      IF(XA .NE. RHO(J)) GO TO 11
      IA=I
      IFA=1
   11 IF(XB .NE. RHO(J)) GO TO 12
      IB=I
      IFB=1
   12 J=J+1
   15 CONTINUE
      IF(IFA .EQ. 0) CALL XNDEX(V,Z,N,XA,DELT,IA,tfact)
      IF(IFB .EQ. 0) CALL XNDEX(V,Z,N,XB,DELT,IB,tfact)
   30 CONTINUE
      write(LERR,*)' '
      write(LERR,*)' '
      WRITE(LERR,211) IA,IB
  211 FORMAT(' SOURCE INDEX= ',I5,5X,'RECEIVER INDEX= ',I5)
      write(LERR,*)' '
C
C   COMPUTE SYNTHETIC AMS
C
      CALL SNTHET(DELT,NUM,NT,IA,IB,C0,C,XU,XD,Y,PG,QG,PD,QD,PMCQ,IWR,
     1EP,EM,CP,P,Q,NG,TS,iflag,title,xa,xb,cc)



      ixa = xa
      ixb = xb
      call savew2(itr,ifmt_ShtDep,l_ShtDep,ln_ShtDep,ixa,TRACEHEADER)
      call savew2(itr,ifmt_CabDep,l_CabDep,ln_CabDep,ixb,TRACEHEADER)
      call savew2(itr,ifmt_DstSgn,l_DstSgn,ln_DstSgn,ixb,TRACEHEADER)
      call savew2(itr,ifmt_DstUsg,l_DstUsg,ln_DstUsg,ixb,TRACEHEADER)
      call savew2(itr,ifmt_TrcNum,l_TrcNum,ln_TrcNum, jd,TRACEHEADER)
      call savew2(itr,ifmt_RecNum,l_RecNum,ln_RecNum,  1,TRACEHEADER)
      call savew2(itr,ifmt_StaCor,l_StaCor,ln_StaCor,  0,TRACEHEADER)
      if(luout(1) .ge. 1) then
      if(iflag .eq. 0) call vmov(cc,1,xpr,1,num)
      write(LERR,*)' '
        do 71 l=1,ntpr
           if(ntpr .gt. 1)
     1     call savew2(itr,ifmt_TrcNum,l_TrcNum,ln_TrcNum, l,
     2                 TRACEHEADER)
           call vmov(xpr,1,itr(ITHWP1),1,num)
           call wrtape(luout(1),itr,nbytes)
           write(LERR,*)'Primary trace: source depth= ',xa,
     &                   '  receiver depth= ',xb
           write(LER ,*)'Primary trace: source depth= ',xa,
     &                   '  receiver depth= ',xb
   71   continue
      endif
      if(luout(2) .ge. 1) then
        do 72 l=1,ntpr
           if(ntpr .gt. 1)
     1     call savew2(itr,ifmt_TrcNum,l_TrcNum,ln_TrcNum, l,
     2                 TRACEHEADER)
           call vmov(xu,1,itr(ITHWP1),1,num)
           call wrtape(luout(2),itr,nbytes)
           write(LERR,*)'Upgoing trace: source depth= ',xa,
     &                   '  receiver depth= ',xb
           write(LER ,*)'Upgoing trace: source depth= ',xa,
     &                   '  receiver depth= ',xb
   72   continue
      endif
      if(luout(3) .ge. 1) then
        do 73 l=1,ntpr
           if(ntpr .gt. 1)
     1     call savew2(itr,ifmt_TrcNum,l_TrcNum,ln_TrcNum, l,
     2                 TRACEHEADER)
           call vmov(xd,1,itr(ITHWP1),1,num)
           call wrtape(luout(3),itr,nbytes)
           write(LERR,*)'Downgoing trace: source depth= ',xa,
     &                   '  receiver depth= ',xb
           write(LER ,*)'Downgoing trace: source depth= ',xa,
     &                   '  receiver depth= ',xb
   73   continue
      endif
      if(luout(4) .ge. 1) then
        do 74 l=1,ntpr
           if(ntpr .gt. 1)
     1     call savew2(itr,ifmt_TrcNum,l_TrcNum,ln_TrcNum, l,
     2                 TRACEHEADER)
           call vmov(y,1,itr(ITHWP1),1,num)
           call wrtape(luout(4),itr,nbytes)
           write(LERR,*)'Total respose trace: source depth= ',xa,
     &                   '  receiver depth= ',xb
           write(LER ,*)'Total respose trace: source depth= ',xa,
     &                   '  receiver depth= ',xb
   74   continue
      endif
      iflag=1
   45 CONTINUE

50    continue

      if (logdmp) then
          call savew2(itr,ifmt_RecNum,l_RecNum,ln_RecNum,  1,
     1                TRACEHEADER)
          call savew2(itr,ifmt_StaCor,l_StaCor,ln_StaCor,  0,
     1                TRACEHEADER)
          do  75  l = 1, ntpr
              call savew2(itr,ifmt_TrcNum,l_TrcNum,ln_TrcNum, l,
     1                    TRACEHEADER)
              write(LERR,*)'dumping log to disk: bytes= ',nbytes
              write(LER ,*)'dumping log to disk: bytes= ',nbytes
              call wrtape (luout,itr,nbytes)
75        continue
      endif

      do 331 i = 1, 4
         if(luout(i) .ge. 1) then
            call lbclos(luout(i))
         endif
  331 continue
      STOP
      END

c---------------------------------
c  get command line arguments
c---------------------------------
      subroutine topn(input,ntpr,otap,slow,dept,fttom,mtoft,prim,
     1                  logdmp,verbos,gma,input1,rhogma,fmt,micro)

#include <f77/iounit.h>

      integer    argis
      character  input*512,otap(4)*512, input1*512, fmt*80
      logical    verbos,slow,dept,fttom,mtoft,prim,logdmp,gma,micro

           call argstr('-OP',otap(1),' ',' ')
           call argstr('-OU',otap(2),' ',' ')
           call argstr('-OD',otap(3),' ',' ')
           call argstr('-OT',otap(4),' ',' ')
           call argstr('-C',input,' ',' ')
           call argstr('-G',input1,' ',' ')
           call argi4('-n',ntpr,1,1)

           micro  =  (argis('-micro') .gt. 0)
           slow   =  (argis('-s') .gt. 0)
           dept   =  (argis('-d') .gt. 0)
           fttom  =  (argis('-ft_to_m') .gt. 0)
           mtoft  =  (argis('-m_to_ft') .gt. 0)
           prim   =  (argis('-P') .gt. 0)
           logdmp =  (argis('-D') .gt. 0)
           gma    =  (argis('-gma') .gt. 0)
           call argr4('-p',rhogma,1.,1.)
           call argstr('-F',fmt,'f7.0,10(f7.0),i3','f7.0,10(f7.0),i3')

           if (gma .AND. input1(1:1) .eq. ' ') then
              write(LERR,*)'For Amoco well data format (GMA) you'
              write(LERR,*)'must enter a file name for the log data'
              write(LERR,*)'set using the -G[] command line arg'
              write(LER ,*)'For Amoco well data format (GMA) you'
              write(LER ,*)'must enter a file name for the log data'
              write(LER ,*)'set using the -G[] command line arg'
              stop 911
           endif
           
           verbos =  (argis('-V') .gt. 0)

      return
      end

c------------------------------
c  put stuff in line header
c------------------------------
      subroutine put(itr,ntrc,nrec,nsi,nsamp,unitsc)
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
      integer   itr(*)
      integer   ntrc,nrec,nsi,nsamp
      real      unitsc


         call savew(itr, 'NumSmp', nsamp , LINHED)
         call savew(itr, 'SmpInt', nsi   , LINHED)
         call savew(itr, 'NumTrc', ntrc  , LINHED)
         call savew(itr, 'NumRec', nrec  , LINHED)
         call savew(itr, 'Format',   3   , LINHED)
         call savew(itr, 'UnitSc', unitsc, LINHED)

      return
      end

c-------------------------------
c  online help section
c-------------------------------
      subroutine help
#include <f77/iounit.h>

        write(LER,*)' '
        write(LER,*)'Command Line Arguments for SYNTH: 1-d synthetic'
        write(LER,*)'                           trace/vsp generation'
        write(LER,*)' '
        write(LER,*)'Input....................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[vmod]    -- input velocity model (cmd line opt)'
        write(LER,*)'               (use -L cmd line input below'
        write(LER,*)'-OP[otapP]  -- primaries only data set'
        write(LER,*)'-OU[otapU]  -- upgoing wavefield data set'
        write(LER,*)'-OD[otapD]  -- downgoing wavefield data set'
        write(LER,*)'-OT[otapT]  -- total respose data set'
        write(LER,*)' '
        write(LER,*)'Parameter Input Method 1'
        write(LER,*)'-C[input]   -- name of model data file, containing'
        write(LER,*)'               all params. Else use cmd line opt.'
        write(LER,*)' '
        write(LER,*)'Parameter Input Method 2'
        write(LER,*)'-T[title]   -- optional title string'
        write(LER,*)'-ls[num]    -- length of trace (ms or us)'
        write(LER,*)'-dt[dt]     -- sample interval (ms or us) (4)'
        write(LER,*)'-c0[c0]     -- surface reflection coefficient:'
        write(LER,*)'               -1 = marine; 1 = land  (1)'
        write(LER,*)'-eu[eu]     -- upgoing src strength (1)'
        write(LER,*)'-ed[ed]     -- downgoing src strength (1)'
        write(LER,*)'-od[ndepth] -- # vsp depths (1)'
        write(LER,*)'-ol[nlayer] -- # interfaces in model'
        write(LER,*)'-sd[xa0]    -- initial src depth (ft or m) (0)'
        write(LER,*)'-dd[xb0]    -- initial rcvr depth (ft or m) (0)'
        write(LER,*)'-dels[dxa]  -- vsp src depth invcrement (0)'
        write(LER,*)'-delr[dxb]  -- vsp rcvr depth invcrement (0)'
        write(LER,*) ' '
        write(LER,*)'-n[ntpr]    -- if number depths = 1, override no.'
        write(LER,*)'                traces per record'
        write(LER,*)'-micro      -- times in micro second (milli secs)'
        write(LER,*)'-s          -- convert slowness to velocity'
        write(LER,*)'-d          -- depth instead of thickness'
        write(LER,*)'-ft_to_m    -- convert ft/s to m/s'
        write(LER,*)'-m_to_ft    -- convert m/s to ft/s'
        write(LER,*)'-P          -- primaries only'
        write(LER,*)'-D          -- dump refl coeffs vs depth to disk'
        write(LER,*)' '
        write(LER,*)'-gma        -- use Amoco GMA welll data format'
        write(LER,*)'-G[input1]  -- GMA well data file name (no def)'
        write(LER,*)'-p[rhogma]  -- GMA constant density       (1.0)'
        write(LER,*)' '
        write(LER,*)'-V          -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'      synth -OP[] -OU[] -OD[] -OT[] -n[]'
        write(LER,*)'            [-P -D -s -d -ft_to_m -m_to_ft -gma'
        write(LER,*)'             -G[] -p[] -micro] -V ]'
        write(LER,*)'            [ -C[] -L [ -T[] -ls[] -dt[] -c0[]'
        write(LER,*)'              -eu[] -ed[] -od[] -ol[] -sd[] -rd[]'
        write(LER,*)'              -dels[] -delr[] ]'
        write(LER,*)' '

      return
      end
