C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c-----------
c do ray param to angle (forward transform)
c interpolation or its inverse (reverse transform)

c two major modes: 
c  (1) time varying which in forward direction takes tau-p data
c      from taupf or radonf -L and simulates angst output
c  (2) time invariant which just resamples based on the emergence
c      angle

c within (1) and (2) care must be taken about whether the spread
c was a single ender or split - they must be treated separately.
c also if it was split the two sides must be treated separately
c-----------

      subroutine rectrp (ntrc, ntrco, ntrcm, nsamp, bigar1, vel,
     1                   tabl1, tabl2, zz, iz, icinit, TV, rev, p,
     2                   iax, split, neg, pmax, key, first, lapmin)

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

      
      real       bigar1(nsamp,ntrcm)
      real       zz(*), tabl1(*), tabl2(*), vel (*), p (*)
      integer    iz(*), key(*)
      integer    iax
      real       work1 (SZLNHD)
      real       work2 (SZLNHD)
      real       tmp   (SZLNHD)
      logical    TV, rev, split, neg, first

      deg = 180. / 3.14159265
      rad = 1. / deg

      V0 = 1 / pmax
c****
c   interpolate record at using the reflection angle at depth
c****
      IF (TV) THEN

         icinit = 1

         if (first) then
            fac = V0 / vel (1)
            do  i = 1, nsamp
                vel (i) = vel (i) * fac
            enddo
         endif

         angs = deg * asin ( p(1)    * V0 )
         ange = deg * asin ( p(ntrc) * V0 )
         dang = (ange - angs) / float(ntrc-1)

         IF (neg) THEN
c----
c   neg side: single ender
c----
         DO  i = 1, nsamp

             do  j = 1, ntrc
                 work1 (j) = bigar1(i,key(ntrc-j+1))
             enddo

             do  k = 1, ntrc
                 ang = (angs + (k-1) * dang)
                 tabl2 (k) = sin ( rad * ang ) / vel (i)
             enddo
             call vrvrs (tabl2, 1, ntrc)
             tabl21 = - (tabl2 (1) )
             do  k = 1, ntrc
                 tabl2 (k) = tabl2 (k) + tabl21
             enddo
             call vabs  (tabl2, 1, tabl2, 1, ntrc)

             call vclr (work2, 1, ntrc)
             icinit = 1
             if (rev) then
                call fcuint (tabl2, work1, ntrc, tabl1, work2, ntrc,
     1                                  iz, zz, icinit)
             else
                call fcuint (tabl1, work1, ntrc, tabl2, work2, ntrc,
     1                                  iz, zz, icinit)
             endif

             do  j = 1, ntrc
                 bigar1(i,key(ntrc-j+1)) = work2(j)
             enddo

         ENDDO

         ELSEIF (split) THEN
c----
c   pos & neg side: treated separately
c----
         lapmn1 = lapmin + 1
         mtrc1  = lapmin
         ange = abs (deg * asin ( p(1)     * V0 ) )
         angs = abs (deg * asin ( p(mtrc1) * V0 ) )
         dang = (ange - angs) / float(mtrc1-1)

         do  j = 1, mtrc1
             tmp (j) = tabl1 (j)
         enddo
         call vrvrs (tmp, 1, mtrc1)
         call vabs  (tmp, 1, tmp, 1, mtrc1)

         DO  i = 1, nsamp
 
             jj = 0
             do  j = 1, mtrc1
                 jj = jj + 1
                 work1 (jj) = bigar1(i,key(mtrc1-j+1))
             enddo
 
             do  k = 1, mtrc1
                 ang = (angs + (k-1) * dang)
                 tabl2 (k) = sin ( rad * ang ) / vel (i)
             enddo
             call vrvrs (tabl2, 1, mtrc1)
             tabl21 = - (tabl2 (1) )
             do  k = 1, mtrc1
                 tabl2 (k) = tabl2 (k) + tabl21
             enddo
             call vabs  (tabl2, 1, tabl2, 1, mtrc1)
 
             call vclr (work2, 1, mtrc1)
             icinit = 1
             if (rev) then
                call fcuint (tabl2, work1, mtrc1, tmp, work2, mtrc1,
     1                                  iz, zz, icinit)
             else
                call fcuint (tmp, work1, mtrc1, tabl2, work2, mtrc1,
     1                                  iz, zz, icinit)
             endif
 
             jj = 0
             do  j = 1, mtrc1
                 jj = jj + 1
                 bigar1(i,key(mtrc1-j+1)) = work2(jj)
             enddo
 
         ENDDO

         mtrc2 = ntrc - lapmin
         angs = deg * asin ( p(lapmn1) * V0 )
         ange = deg * asin ( p(ntrc)   * V0 )
         dang = (ange - angs) / float(mtrc2-1)

         jj = 0
         do  j = 1, mtrc2
             jj = jj + 1
             tmp (jj) = tabl1 (lapmin + j)
         enddo

         DO  i = 1, nsamp
 
             jj = 0
             do  j = 1, mtrc2
                 jj = jj + 1
                 work1 (jj) = bigar1(i,key(mtrc1+j))
             enddo
 
             do  k = 1, mtrc2
                 ang = (angs + (k-1) * dang)
                 tabl2 (k) = sin ( rad * ang ) / vel (i)
             enddo
             call vrvrs (tabl2, 1, mtrc2)
             tabl21 = - (tabl2 (1) )
             do  k = 1, mtrc2
                 tabl2 (k) = tabl2 (k) + tabl21
             enddo
             call vabs  (tabl2, 1, tabl2, 1, mtrc2)
 
             call vclr (work2, 1, mtrc2)
             icinit = 1
             if (rev) then
                call fcuint (tabl2, work1, mtrc2, tmp, work2, mtrc2,
     1                                  iz, zz, icinit)
             else
                call fcuint (tmp, work1, mtrc2, tabl2, work2, mtrc2,
     1                                  iz, zz, icinit)
             endif
 
             jj = 0
             do  j = 1, mtrc2
                 jj = jj + 1
                 bigar1(i,key(mtrc1+j)) = work2(jj)
             enddo
 
         ENDDO

         ELSE

c----
c   pos side: single ender
c----
         DO  i = 1, nsamp
 
             do  j = 1, ntrc
                 work1 (j) = bigar1(i,key(j))
             enddo
 
             do  k = 1, ntrc
                 ang = (angs + (k-1) * dang)
                 tabl2 (k) = sin ( rad * ang ) / vel (i)
             enddo
             call vrvrs (tabl2, 1, ntrc)
             tabl21 = - (tabl2 (1) )
             do  k = 1, ntrc
                 tabl2 (k) = tabl2 (k) + tabl21
             enddo
             call vabs  (tabl2, 1, tabl2, 1, ntrc)
 
             call vclr (work2, 1, ntrc)
             icinit = 1
             if (rev) then
                call fcuint (tabl2, work1, ntrc, tabl1, work2, ntrc,
     1                                  iz, zz, icinit)
             else
                call fcuint (tabl1, work1, ntrc, tabl2, work2, ntrc,
     1                                  iz, zz, icinit)
             endif
 
             do  j = 1, ntrc
                 bigar1(i,key(j)) = work2(j)
             enddo
 
         ENDDO

         ENDIF

c****
c   interpolate record at using the emergence angle at surface
c****
      ELSE

         IF (split) THEN

c----
c   pos & neg side: treated separately
c----
         lapmn1 = lapmin + 1
         mtrc1  = lapmin
         ange = abs (deg * asin ( p(1)     * V0 ) )
         angs = abs (deg * asin ( p(mtrc1) * V0 ) )
         dang = (ange - angs) / float(mtrc1-1)
 
         do  j = 1, mtrc1
             tmp (j) = tabl1 (j)
         enddo
         call vrvrs (tmp, 1, mtrc1)
         call vabs  (tmp, 1, tmp, 1, mtrc1)
         do  k = 1, ntrc
             ang = angs + (k-1) * dang
             tabl2 (k) = sin ( rad * ang ) / V0
         enddo

         icinit = 1
         DO     i = 1, nsamp
 
             jj = 0
             do  j = 1, mtrc1
                 jj = jj + 1
                 work1 (jj) = bigar1(i,key(mtrc1-j+1))
             enddo
 
             call vclr (work2, 1, mtrc1)
             if (rev) then
                call fcuint (tmp, work1, mtrc1, tabl2, work2, mtrc1,
     1                                  iz, zz, icinit)
             else
                call fcuint (tabl2, work1, mtrc1, tmp, work2, mtrc1,
     1                                  iz, zz, icinit)
             endif
 
             icinit = 0
 
             jj = 0
             do  j = 1, mtrc1
                 jj = jj + 1
                 bigar1(i,key(mtrc1-j+1)) = work2(key(jj))
             enddo
 
         ENDDO

         mtrc2 = ntrc - lapmin
         angs = deg * asin ( p(lapmn1) * V0 )
         ange = deg * asin ( p(ntrc)   * V0 )
         dang = (ange - angs) / float(mtrc2-1)

         jj = 0
         do  j = 1, mtrc2
             jj = jj + 1
             tmp (jj) = tabl1 (lapmin + j)
         enddo

         do  k = 1, mtrc2
             ang = (angs + (k-1) * dang)
             tabl2 (k) = sin ( rad * ang ) / V0
         enddo

         icinit = 1
         DO     i = 1, nsamp
 
             jj = 0
             do  j = 1, mtrc2
                 jj = jj + 1
                 work1 (j) = bigar1(i,key(mtrc1+j))
             enddo
 
             call vclr (work2, 1, mtrc2)
             if (rev) then
                call fcuint (tmp, work1, mtrc2, tabl2, work2, mtrc2,
     1                                  iz, zz, icinit)
             else
                call fcuint (tabl2, work1, mtrc2, tmp, work2, mtrc2,
     1                                  iz, zz, icinit)
             endif
 
             icinit = 0
 
             jj = 0
             do  j = 1, mtrc2
                 jj = jj + 1
                 bigar1(i,key(mtrc1+j)) = work2(key(jj))
             enddo
 
         ENDDO


         ELSE
c----
c   pos or neg side: single ender
c----

         DO     i = 1, nsamp

             do  j = 1, ntrc
                 work1 (j) = bigar1(i,key(j))
             enddo

             call vclr (work2, 1, ntrco)
             if (rev) then
                call fcuint (tabl1, work1, ntrc, tabl2, work2, ntrc,
     1                                  iz, zz, icinit)
             else
                call fcuint (tabl2, work1, ntrc, tabl1, work2, ntrc,
     1                                  iz, zz, icinit)
             endif

             icinit = 0

             do  j = 1, ntrco
                 bigar1(i,j) = work2(key(j))
             enddo

         ENDDO

         ENDIF

      ENDIF


      return
      end
