C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c**********************************************************************c
c
c taumute reads seismic trace data from an input file,
c does a ray parameter determined mute on tau-p traces, &
c writes the results to an output file
c
c
c**********************************************************************c
c
c     declare variables
c
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
 
      integer     itr ( SZLNHD )
      integer     lhed( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform, obytes
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     irs,ire,ns,ne
#include <f77/pid.h>
      integer     recnum, trcnum, static, nramp, idist
      real        rayp, vref
      real        tri ( SZLNHD ), vel ( SZLNHD )
      character   ntap * 256, otap * 256, name*7
      logical     verbos, query, slnt
      integer     argis
 
c     equivalence ( itr(129), tri (1) )
      equivalence ( itr(  1), lhed(1) )
      data lbytes / 0 /, nbytes / 0 /, name/'TAUMUTE'/
 
c-----
c     read program parameters from command line card image file
c-----
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query )then
            call help()
            stop
      endif
 
c-----
c     open printout files
c-----
#include <f77/open.h>
 
      call gcmdln(ntap,otap,ns,ne,irs,ire,
     1             nramp,vel1,vel2,verbos,slnt)
c-----
c     get logical unit numbers for input and output
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)

c-----
c     read line header of input
c     save certain parameters
c-----
      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LOT,*)'TAUMUTE: no header read from unit ',luin
         write(LOT,*)'FATAL'
         stop
      endif
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('SGRNum',ifmt_SGRNum,l_SGRNum,ln_SGRNum,TRACEHEADER)


      call hlhprt (itr, lbytes, name, 7, LERR)
c-----
c     ensure that command line values are compatible with data set
c-----
      call cmdchk(ns,ne,irs,ire,ntrc,nrec)

c-----
c     modify line header to reflect actual number of traces output
c-----
      nrecc=ire - irs+1
      call savew(itr, 'NumRec', nrecc, LINHED)
      jtr=ne-ns+1
      call savew(itr, 'NumTrc', jtr  , LINHED)

c----------------------
c  number output bytes
      obytes = SZTRHD + nsamp * SZSMPD
c----------------------
      call savhlh(itr,lbytes,lbyout)
      call wrtape ( luout, itr, lbyout                 )

c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
      if( verbos ) then
            call verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  nramp,vel1,vel2,ntap,otap)
      end if

c--------------------------------------------------
c  compute linear interp of velocities betw ends

      nramp = nramp/nsi
      if (nramp .lt. 1) nramp = 1
      delv = abs(vel2 - vel1)/(float(nsamp-1))
      do  10  ii = 1, nsamp

              vel(ii) = vel1 + float(ii-1)*delv

10    continue

c--------------------------------------------------
c-----
c     BEGIN PROCESSING
c     read trace, do terrible things to data, write to output file
c-----
c-----
c     skip unwanted records
c-----
      call recskp(1,irs-1,luin,ntrc,itr)
c-----
c     process desired trace records
c-----
      do 1000 jj = irs, ire
 
c----------------------
c  skip to start trace
            call trcskp(jj,1,ns-1,luin,ntrc,itr)
c----------------------
 
            do 1001 kk=ns,ne

                  nbytes = 0
                  call rtape( luin, itr, nbytes)
                  if(nbytes .eq. 0) then
                     write(LERR,*)'End of file on input:'
                     write(LERR,*)'  rec= ',jj,'  trace= ',kk
                     go to 999
                  endif
                  call vmov (lhed(ITHWP1), 1, tri, 1, nsamp)

                  if (slnt) then
                     call saver2(lhed,ifmt_DstUsg,l_DstSgn, ln_DstUsg,
     1                           ivref , TRACEHEADER)
                     call saver2(lhed,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                           idist , TRACEHEADER)

                      rayp = sin (float(idist) * pi/180.) / vref
                  else
                     call saver2(lhed,ifmt_DstUsg,l_DstUsg, ln_DstUsg,
     1                           irayp , TRACEHEADER)

                      rayp   = abs( irayp/10000000.)
                  endif

                  recnum = itr(l_RecNum)
                  trcnum = itr(l_TrcNum)

                  IF(static .ne. 30000)then

c-----------------------
c  calculate cosine (p)
c  time; mute after this

                     call pwmute (tri,rayp,vel,nsamp,nramp)
c-----------------------

c---------------------
c  write output data
                     call vmov (tri, 1, lhed(ITHWP1), 1, nsamp)
                     call wrtape (luout, itr, obytes)

                  ENDIF

 1001             continue
                  if(verbos)write(LERR,*)'ri ',recnum
 
c----------------------
c  skip to end of record
            call trcskp(jj,ne+1,ntrc,luin,ntrc,itr)
c----------------------
 
 1000       continue
c-----
c     close data files
c-----
  999 continue

      call lbclos ( luin )
      call lbclos ( luout )

            write(LERR,*)'end of taumute, processed',nrec,' record(s)',
     :               ' with ',ntrc, ' traces'
      end
 
C***********************************************************************
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
        write(LER,*) ' '
        write(LER,*)
     :'taumute does dark and terrible things to seismic data:'
        write(LER,*)
     :'see manual pages for details ( online by typing uman prg )'
        write(LER,*)' '
        write(LER,*)
     :'execute taumute by typing taumute and the of program parameters'
        write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
        write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
        write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (no default)      : input data file name'
        write(LER,*)
     :' -O [otap]    (no default)      : output data file name'
        write(LER,*)
     :' -ns[ns]      (default = first) : start trace number'
        write(LER,*)
     :' -ne[ne]      (default = last)  : end trace number'
        write(LER,*)
     :' -rs[irs]     (default = first) : start record number'
        write(LER,*)
     :' -ne[ire]     (default = last)  : end record number'
        write(LER,*) ' '
        write(LER,*)
     :' -v1[vel1] (default = flat) :  reference (surface) velocity (ft,m
     :/s)'
        write(LER,*)
     :' -v2[vel2] (default = flat) :  reference (lower  ) velocity (ft,m
     :/s)'
        write(LER,*)
     :' -t[nramp] (default = 20)   :  linear mute taper (ms)'
        write(LER,*) ' '
        write(LER,*)
     :' -M  include on command line if plane wave from program slnt'
        write(LER,*)
     :' -V  include on command line if verbose printout is desired'
        write(LER,*) ' '
        write(LER,*)
     :'usage:   taumute -N[ntap] -O[otap] -ns[ns] -ne[ne] -rs[irs] '
        write(LER,*)
     :'                 -re[ire] -v1[vel1] -v2[vel2] -t[nramp] [-M -V]'
        write(LER,*) ' '
        write(LER,*)
     :'***************************************************************'
      return
      end
 
C***********************************************************************
      subroutine gcmdln(ntap,otap,ns,ne,irs,ire,
     1                  nramp,vel1,vel2,verbos,slnt)
c-----
c     get command arguments
c
c     ntap  - C*100    input file name
c     otap  - C*100    output file name
c     vel1  - R*4      surface velocity
c     vel2  - R*4      basement velocity
c     nramp - I*4      number points in linear mute ramp
c     ns    - I*4      starting trace index
c     ne    - I*4      ending trace index
c     irs   - I*4      starting record index
c     ire   - I*4      ending record index
c     slnt    L        input data is from program slnt
c     verbos  L        verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*)
      integer * 4 ns, ne, irs, ire, nramp
      real    * 4 vel1, vel2
      logical     verbos, slnt
      integer     argis
 
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argi4 ( '-ns', ns ,   0  ,  0    )
            call argi4 ( '-ne', ne ,   0  ,  0    )
            call argi4 ( '-rs', irs ,   0  ,  0    )
            call argi4 ( '-re', ire ,   0  ,  0    )
            call argi4 ( '-t', nramp ,  20  , 20    )
            call argr4( '-v1', vel1, 0., 0. )
            call argr4( '-v2', vel2, 0., 0. )
            slnt   = (argis('-M') .gt. 0)
            verbos = (argis('-V') .gt. 0)

            if (vel1 .eq. 0.) then
               write(LERR,*)'Must enter reference velocity on cmd line'
               write(LERR,*)'Rerun using  -v[]  entry'
               stop
            endif
            if (vel2 .eq. 0.0) vel2 = vel1
 
      return
      end
 
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform,
     1                  nramp,vel1,vel2,ntap,otap)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4     number of samples in trace
c     vel1  - R*4     surface velocity
c     vel2  - R*4     basement velocity
c     nramp - I*4      number points in linear mute ramp
c     nsi   - I*4     sample interval in ms
c     ntrc  - I*4     traces per record
c     nrec  - I*4     number of records per line
c     iform - I*4     format of data
c     ntap  - C*120   input file name
c     otap  - C*120   output file name
c-----
#include <f77/iounit.h>
      integer * 4 nsamp, nsi, ntrc, nrec
      character   ntap*(*), otap*(*)
      real        vel1, vel2
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' surface window velocity =  ', vel1
            write(LERR,*) ' basement window velocity =  ', vel2
            write(LERR,*) ' linear mute taper (ms)   =  ', nramp
            write(LERR,*) ' input data set name =  ', ntap
            write(LERR,*) ' output data set name=  ', otap
            write(LERR,*)' '
            write(LERR,*)' '
 
      return
      end
 
