C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C***********************************************************************
      SUBROUTINE RDCRD(vref,irs,ire,dxrec,fmax,npad,nwt1,nwt2,
     1                 p,pmin,pmax,numtp,cfile,crdin)

#include <f77/iounit.h>

      integer     irs,ire,lucrd, copen,numtp,nwt1,nwt2,npad
      real        fmax,dxrec,vref,pstrt,pinc
      real        p(*),pmin,pmax
      character   cfile*(*)
      CHARACTER*1 CARD(80)
      logical     crdin

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C     VREF  = REFERENCE VELOCITY
C      irs  = STARTING RECORD
C      ire  = ENDING RECORD
C     DXREC = SPATIAL RECORD INCREMENT
C     NPAD  = EXTRA ZEROES TO PAD
C     FMAX  = MAXIMUM FREQUENCY TO USE
C     numtp = NUMBER OF ANGLES (P'S)
C     P(1)  = STARTING ANGLE
C     INC   = ANGLE INCREMENT
c     pmin  = start ray parameter
c     pmax  = end ray parameter
C     lucrd = temporary card image file
C     ntap  = input data set
c     otap  = output data set name
c     cfile = card file name
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC

    5 format(80a1)

      write(LERR,*)'crdin= ',crdin,' cfile= ',cfile

c-----------------------------------------------------
c  read parameters from cards (file or jobstream) 
c-----------------------------------------------------
      IF(crdin) then

         if(cfile(1:1) .ne. '1') then
             lucrd = LUN
             open(unit=LUN, file=cfile)
         else
             lucrd = LUN
             iflag = copen('-taupf.crd',lucrd)
             if(iflag .eq. 0) then
                 write(LERR,*)'Program  taupf:'
                 write(LERR,*)'No cards in job stream - '
                 write(LERR,*)'consult man page'
                 stop 911
             endif
         endif
         read(lucrd,5)   card
         READ(lucrd,*)   VREF,IRS,IRE,DXREC,FMAX,NPAD,NWT1,NWT2
c---------------------
C     READ ANGLE CARDS
c---------------------

          READ(lucrd,5)CARD
          NP=0

    1     READ(lucrd,*,END=2)NP1,PSTRT,PINC
          IF(NP1.LE.0) GO TO 2

          P(NP+1)  = PSTRT

          WRITE(LERR,*) 'ANGLE(',NP+1,')=',P(NP+1)

          IF(NP1.GT.1) THEN
               DO 35 I=NP+2,NP+NP1
                 P(I)=P(I-1)+PINC
                 WRITE(LERR,*) 'ANGLE(',I,')=',P(I)
   35          CONTINUE
          ENDIF

          NP=NP+NP1
          GO TO 1

    2     CONTINUE

          numtp = np

c-------------------------------------
c  read parameters from command line
c-------------------------------------
      ELSE

            call argr4('-v',vref,0.,0.)
            call argi4('-rs',irs,0,0)
            call argi4('-re',ire,0,0)
            call argr4('-dx',dxrec,0.,0.)
            call argr4('-fmax',fmax,0.,0.)
            call argi4('-ot',nwt1,0,0)
            call argi4('-it',nwt2,0,0)
            call argr4('-p',pmin,0.,0.)
            call argr4('-P',pmax,1.,1.)
            call argi4('-J',numtp,0,0)
            call argi4('-np',npad,0,0)

      ENDIF



      RETURN
      END
C
