C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE PREDIK(LB,B,LPR,LA,A,ASE,PREW, space, weight)
C     THIS IS A CONFIDENTIAL PAN AMERICAN PETROLEUM CORPORATION SUBROUTI

#include <localsys.h>
#include <f77/lhdrsz.h>

      DIMENSION B(*),A(*)                                               
      DIMENSION SPACE(*), weight(*)
      real      c(4*SZSMPM)
C                                                                       
C     THIS SUBROUTINE COMPUTES THE LA-LENGTH SINGLE CHANNEL WIENER      
C     PREDICTION FILTER FOR PREDICTION DISTANCE LPR I.E., IT SOLVES     
C     THE SYSTEM OF NORMAL EQUATIONS,                                   
C                                                                       
C                                                                       
C         R(1),R(2),...R(LA)   A(1)     R(1+LPR)                        
C         R(2)          .      A(2)     R(2+LPR),  (R=AUTOPRODUCT OF A) 
C          .            .       .    =   .                              
C          .            .       .        .                              
C          .            .       .        .                              
C         R(LA),...,   R(1)    A(LA)    R(LA+LPR)                       
C                                                                       
C     AUTHOR--S.TREITEL, 10/5/1965                                      
C                                                                       
C     INPUTS ARE                                                        
C        LB=LENGTH OF INPUT B                                           
C         B=INPUT B                                                     
C       LPR=PREDICTION DISTANCE (MUST BE .GE. 0)                        
C        LA=LENGTH OF PREDICTION FILTER A                               
C      PREW=PREWHITENING LEVEL OF AUTO-CORR MATRIX (B X B)              
C     OUTPUTS ARE                                                       
C        A=PREDICTION FILTER A                                          
C        ASE=AVERAGE SQUARE PREDICTION ERROR FOR PRED. DIST. LPR        
C        SPACE=4*LA CELLS OF WORKING SPACE                              
C           FIRST LA CELLS CONTAIN  R(1),...R(LA)                       
C           NEXT  LA CELLS CONTAIN  R(1+LPR),...R(LA+LPR)               
C           NEXT  LA CELLS CONTAIN  THE NEGATIVE UNIT RETROSPECTION     
C             ERROR OPERATOR, STORED IN REVERSE ORDER                   
C           NEXT  LA CELLS CONTAIN  THE NEGATIVE UNIT PREDICTION        
C             ERROR OPERATOR, STORED IN REVERSE ORDER                   
C                                                                       
C     IF LPR .GT. LB, A IS THE NULL FILTER A(1)=A(2)=...A(LA)=0         
C                                                                       
C                                                                       

      IF (LB-LPR)1,1,2                                                  
    1 call vclr(a,1,la)
      GO TO 20                                                          
    2 call vclr(space,1,2*la)
      CALL CROSS(LB,B,LB,B,MIN0(LA,LB),SPACE)                           
      SPACE(1)=SPACE(1)+PREW*SPACE(1)                                   
      call vmul (space, 1, weight, 1, space, 1, MIN0(LA,LB))
      LP=LPR+1                                                          
      IF (LP-LA)3,3,6                                                   
    3 call vmov(space(lp),1,space(la+1),1,la-lpr)
      IF (LPR)20,9,4                                                    
    4 ISP=2*LA-LPR+1                                                    
      LST=LPR                                                           
      LAG=LA                                                            
      GO TO 7                                                           
    6 ISP=LA+1                                                          
      LST=LA                                                            
      LAG=LPR                                                           
    7 IF (LB-LAG)9,9,8                                                  
    8 CALL CROSS(LB-LAG,B(LAG+1),LB,B,LST,SPACE(ISP))                   

9     continue

c--------------------------------
c  old robinson & treitel decon
c     CALL EUREKb(LA,SPACE,SPACE(LA+1),A,SPACE(2*LA+1))                 
c--------------------------------

c------------------------------
c  call math adv decon routine

      call wiener(la,space,space(la+1),a,c,1,ierr)
c------------------------------

c--------------------------------------
c  for spiker grab the p.e.f directly

      if (lpr .le. 1) then

          do  10  i = 1, la
              a(i) = c(i)
10        continue

c------------------------------------------
c  for gapped decon grab the coeffcicients

      else

          do  11  i = la, 1, -1
              a(lpr+i) = -a(i)
11        continue
          call vclr(a,1,lpr)
          a(1)=1.                                                       

      endif


   20 RETURN                                                            
      END 
