C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine approx1(cdata,vz,f1,f2,t1sub,t1dia,t1sup,t2sub,t2dia,
     +                        t2sup,t3sub,t3dia,t3sup,cw,cydata,cyd1,
     +                        nx,nomega,teta,gamma,nap,cputim,waltim)
C/---------------------------------------------------------------------
C/REM/              Proprietary of CONSORTIUM P.S.I.
C/REM/               Institut Francais du Petrole
C/REM/               92500 Rueil Malmaison FRANCE
C/REM/
C/REM/                  All rights reserved
C/
C/HIST/  creation    author: Andreas Ehinger
C/HIST/              date:   28.07.1993
C/
C/PURP/  solve the perturbation (diffraction) problem
C/
C/DESC/  - computation of T-matrices
C/DESC/  - loop over number of approximations
C/DESC/    - solve the marix equation
C/
C/ARG/   in    : f1,f2    arrays of approximation functions [nomega,nap]
C/ARG/           vz       velocity field in fixed depth [nx]
C/ARG/           t1sub    sub-diagonal of matrix t1 [nx]
C/ARG/           t1dia    diagonal of matrix t1 [nx]
C/ARG/           t1sub    sup-diagonal of matrix t1 [nx]
C/ARG/           t.....   similar  expressions for the matrices t2 and t3
C/ARG/           cw       local array for subroutine solve1 [nomega,nx]
C/ARG/           cydata   local array for subroutine solve1 [nomega]
C/ARG/           cyd1     local array for subroutine solve1 [nomega]
C/ARG/           nx,nomega,teta,gamma,nap
C/ARG/   in-out: cdata    complex data matrix [nomega,nx]
C/ARG/   out   : -
c
      integer nx,nomega,nap
      complex cdata(nomega,nx)
      real    vz(nx)
      real    t1sub(nx), t1dia(nx), t1sup(nx)
      real    t2sub(nx), t2dia(nx), t2sup(nx)
      real    t3sub(nx), t3dia(nx), t3sup(nx)
      complex cw(nomega,nx),cydata(nomega),cyd1(nomega)
      complex f1(nomega,nap), f2(nomega,nap)
      real    teta,gamma
      real    cputim(*),waltim(*)
c__________________________________________________________________ 
c     precompute the frequency- and
c     number_of_approximation-independent vectors of the three
c     T matrices 
c__________________________________________________________________ 
      call timstr(v1,w1)
      call tmat(t1sub,t1dia,t1sup,t2sub,t2dia,t2sup,
     +               t3sub,t3dia,t3sup,vz,nx,gamma)
      call timend(cputim(6),v1,v2,waltim(6),w1,w2)
c__________________________________________________________________ 
c     loop over approximations is performed
c     solving the tri-diagonal system
c__________________________________________________________________ 
      call timstr(v1,w1)
      do 10000 iap=1,nap
       call solve1(cdata,t1sub,t1dia,t1sup,t2sub,t2dia,t2sup,
     1             t3sub,t3dia,t3sup,f1,f2,iap,cw,cydata,cyd1,
     2             nx,nomega,teta,nap)
10000 continue
c
      call timend(cputim(7),v1,v2,waltim(7),w1,w2)
c
      return
      end
