C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine cmdlin(luvgrid,lugeom,lugreen,luzeta,lutwt,
     1                  verbose,stdout,stderr,lerr,
     2                  nodenumber,totalnodes)
C
      character*(80) file_green,file_twt,file_zeta                          
      character*(80) file_vsamp                       
      character*(80) file_prepmig
      character*(80) filename       
      character*(2)  int2str
C
      integer        nodenumber,totalnodes
      integer        argis
      integer        stderr
c
      logical        verbose         
c
      ierror=0
c_______________________________________________________________________
C     input  data sets
c_______________________________________________________________________
      call argstr('-N',file_vsamp,' ',' ')
      call argstr('-P',file_prepmig,' ',' ')
c_______________________________________________________________________
c     output data sets
c_______________________________________________________________________
      call argstr('-O',file_green,' ',' ')
      call argstr('-T',file_twt,' ',' ')
      call argstr('-Z',file_zeta,' ',' ')
      if(file_twt .ne. ' ') then
         call lbopen(lutwt,file_twt,'w')
      else
         write(lerr,*)'must supply twt file name!'
         write(lerr,*)'enter file name after -T option'
         ierror=ierror+1
      endif
c_______________________________________________________________________
c     note: multiple processor output files cannot be piped!
c_______________________________________________________________________
      if(file_green .ne. ' ') then
         filename=file_green(1:lnst(file_green))//'_'
     1                     //int2str(nodenumber,'_')
         write(lerr,*) 'file = ',filename
         call lbopen(lugreen,filename,'r')
      elseif(totalnodes .eq. 1) then
         lugreen=stdout
      else
         write(lerr,*) 'error in routine sammig'
         write(lerr,*) 'multi pass solution cannot have a piped'
     1                 //' output file!'
         write(lerr,*) 'rerun with -O option'
         call exit(13666)
      endif
c_______________________________________________________________________
C     other command line arguments.
c_______________________________________________________________________
      verbose=(argis('-V') .gt. 0)
C***********************************************************************
C     open formatted files
C***********************************************************************
      if (file_prepmig .ne. ' ') then
         open(lugeom,file=file_prepmig,status='OLD',
     1         iostat=ioerror,form='FORMATTED')
         if(ioerror .ne. 0) then
            write(lerr,*) 'error in cmdlin'
            write(lerr,*) 'file_prepmig = ',file_prepmig
            write(lerr,*) 'cannot access/read file'                       
            ierror=ierror+1 
         endif
      else
          write(lerr,*)'must supply geometry prepmig file!'      	
          write(lerr,*)'enter file name after -P option'    	
          ierror=ierror+1
      endif
c
      if (file_zeta .ne. ' ') then
         open(luzeta,file=file_zeta,status='OLD',
     1         iostat=ioerror,form='FORMATTED')
         if(ioerror .ne. 0) then
            write(lerr,*) 'error in cmdlin'
            write(lerr,*) 'file_zeta = ',file_zeta
            write(lerr,*) 'cannot access/read file'
            ierror=ierror+1
         endif
      else
          write(lerr,*)'must supply irregular depth  zeta file!'
          write(lerr,*)'enter file name after -Z option'
          ierror=ierror+1
      endif
c_______________________________________________________________________
C     open input velocity model.         
c_______________________________________________________________________
      call getln(luvgrid,file_vsamp,'r',0) 
c
      write(lerr,'(A20,A10,t40,a50)') 'FILE UNIT', 'VALUE','FILE NAME'
      write(lerr,'(A20,I10,t40,a50)') 
     1     'luvgrid',luvgrid,file_vsamp,
     2     'luzeta',luzeta,file_zeta,
     3     'lugeom',lugeom,file_prepmig,
     4     'lutwt',lutwt,file_twt,
     5     'lugreen',lugreen,file_green 
c
      if(ierror .gt. 0) then
         write(lerr,*) 'abort program from routine cmdlin'
         call exit(666)
      endif
c
      return
      end
