C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine getg(g,cdata,vinterp,xg,zg,
     1                zeta,nz,lenap,nt,nomega,order_pade,nxtaper,
     2                maxorder_pade,domega,teta,gamma,
     3                tap,f1,f2,f2coeff,
     4                vfac,cphi1,cphi2,cphi,
     5                bcos,cw,cydata,cyd1,
     6                t1sub,t1dia,t1sup,
     7                t2sub,t2dia,t2sup,
     8                t3sub,t3dia,t3sup,
     9                firstg,lastg,lerr,luse,
     a                minap,maxap,mincrp,maxcrp,dcrp,cputim,waltim,
     b                swgt,rwgt,cwgt,cmute,nkx,
     c                alphat,dt,ifl,ifh,ifreq,tdelay,jzmax)
c
      integer firstg,lastg
      integer order_pade,maxorder_pade
      real    xg(firstg:lastg),zg(firstg:lastg)
      real    swgt(minap:maxap,ifl:ifh)
      real    rwgt(nkx)  
      complex cwgt(nkx/2)  
      complex cmute(nkx/2)
c
      real    zeta(0:nz)
      complex cdata(ifl:ifh,minap:maxap)
      complex g(minap:maxap,firstg:lastg)
      real    vinterp(mincrp:maxcrp,nz) 
      real    tap(lenap)
      complex f1(ifl:ifh,order_pade),f2(ifl:ifh,order_pade)
      complex f2coeff(ifl:ifh,order_pade)
      real    vfac(lenap),bcos(lenap)
      complex cphi1(lenap),cphi2(lenap),cphi(lenap)
      complex cw(ifl:ifh,lenap),cydata(ifl:ifh),cyd1(ifl:ifh)
      real    t1sub(lenap),t1dia(lenap),t1sup(lenap)
      real    t2sub(lenap),t2dia(lenap),t2sup(lenap)
      real    t3sub(lenap),t3dia(lenap),t3sup(lenap)
c
      complex omega,ci,arg
      parameter (ci=(0.,1.))
      logical initialized
c
      real cputim(*),waltim(*)
c
      nomega=1
c_______________________________________________________________________
c     loop over all frequencies:   
c_______________________________________________________________________
      irec=0
      do 90000 jg=firstg,lastg
       write(luse,*) 'jg,xg,zg: ',jg,xg(jg),zg(jg)
       do 13000 k=minap,maxap
        cdata(ifreq,k)=(0.,0.)
13000  continue
       initialized=.false.
c_______________________________________________________________________
c      loop over all other depth levels.
c_______________________________________________________________________
       do 80000 iz=1,jzmax
        jxg_crp=nint(xg(jg)/dcrp)  
c_______________________________________________________________________
c       calculate the extrapolation depth step.
c       disallow extremely small steps between the shot and the first
c       non-zero output level.
c_______________________________________________________________________
        delz=zeta(iz)-zeta(iz-1)
        if(initialized) then
           dz=delz            
        elseif(zeta(iz)-zg(jg) .lt. 1.1*delz) then
           go to 70000
           write(luse,*) 'skip level iz,zeta(iz),zg(jg) ',
     1                    iz,zeta(iz),zg(jg) 
        else
           dz=zeta(iz)-zg(jg)
           initialized=.true.
c______________________________________________________________________
c          calculate the spatially band passed impulsive load.
c______________________________________________________________________
           vcut=vinterp(jxg_crp,iz)
           call getload(swgt,rwgt,cwgt,cmute,minap,maxap,
     1                  vcut,ifreq,ifreq,domega,nkx,dcrp,lerr)
c______________________________________________________________________
c          initialize cdata.
c______________________________________________________________________
           omega=cmplx(ifreq*domega,alphat)
           arg=ci*omega*.001*tdelay
           do 20000 k=minap,maxap
            cdata(ifreq,k)=cmplx(swgt(k,ifreq),0.)
20000      continue
        endif
c______________________________________________________________________
c       calculate function f2
c______________________________________________________________________
        call timstr(v1,w1)
        do 50000 iap=1,order_pade
         f2(ifreq,iap)=f2coeff(ifreq,iap)*dz
50000   continue
        call timend(cputim(1),v1,v2,waltim(1),w1,w2)  
c______________________________________________________________________
c       perform phase shift.           
c______________________________________________________________________
        call timstr(v1,w1)
        omegamin=ifreq*domega
        call shift1(cdata(ifreq,minap),vinterp(jxg_crp+minap,iz),
     1              vfac,cphi1,cphi2,cphi,bcos,
     2              dz,lenap,omegamin,domega,nomega,alphat)
        call timend(cputim(2),v1,v2,waltim(2),w1,w2)  
c______________________________________________________________________
c       add diffraction/snell's law term.
c______________________________________________________________________
        call timstr(v1,w1)
        call approx1(cdata(ifreq,minap),vinterp(jxg_crp+minap,iz),
     1               f1(ifreq,1),f2(ifreq,1),t1sub,t1dia,t1sup,
     2               t2sub,t2dia,t2sup,t3sub,t3dia,t3sup,
     3               cw,cydata,cyd1,
     4               lenap,nomega,teta,gamma,order_pade,cputim,waltim)
        call timend(cputim(3),v1,v2,waltim(3),w1,w2)  
c______________________________________________________________________
c       taper at the edges.               
c______________________________________________________________________
        call timstr(v1,w1)
        call border(cdata(ifreq,minap),tap,lenap,nomega)
        call timend(cputim(4),v1,v2,waltim(4),w1,w2)  
c
70000   continue
80000  continue
c_______________________________________________________________________
c       copy into the Green's function array.                   
c_______________________________________________________________________
        gmax =0.      
        do 85000 icrp=minap,maxap
         g(icrp,jg)=conjg(cdata(ifreq,icrp))
         gmax =max(gmax ,abs(cdata(ifreq,icrp)))
85000  continue
       write(lerr,*) 'max g ',gmax  
90000 continue
c
      return
      end
