C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine getsw(g,r,rc,r2,rinv,z,
     1                 iperm,rcond,sigma,re,
     2                 ru,rv,rwork,w,
     2                 ncrp,prew,svd,adjoint,luse,lerr,
     3                 minap,maxap,firstg,lastg,
     4                 firstp,lastp,firstcrp,lastcrp,
     5                 xwgt,u,xsmin,xsmax,xs,ns,nshot,
     6                 fwgt,ifreq,ntcalc,omega,dxg,dcrp,dp)
c_________________________________________________________________
c     calculate least square inverse of matrix [G] 
c_________________________________________________________________
      integer  firstcrp,lastcrp
      integer  firstp,lastp
      integer  firstg,lastg
      complex  g(minap:maxap,firstg:lastg)
      complex  r(ns,firstcrp:lastcrp)
      complex  rc(firstcrp:lastcrp,ns)
      complex  r2(firstcrp:lastcrp,firstcrp:lastcrp)
      complex  rinv(firstcrp:lastcrp,ns)
      integer  iperm(firstcrp:lastcrp)
      complex  z(firstcrp:lastcrp)
      complex  sigma(*),re(*),rwork(*)
      complex  ru(ns,firstcrp:lastcrp)
      complex  rv(firstcrp:lastcrp,ns)
      complex  w(ns,firstp:lastp)       
      complex  u(firstcrp:lastcrp)
      real     xwgt(firstcrp:lastcrp)
      real     xs(nshot) 
      real     fwgt(0:ntcalc/2-1)
c
      complex  omega,ci
      logical  svd,adjoint
      parameter (ci=(0.,-1))
c
      js=0
      do 20000 jshot=1,nshot             
       if(xs(jshot) .lt. xsmin .or. xs(jshot) .gt. xsmax) then
          go to 20000
       endif
       js=js+1
c_________________________________________________________________
c      pick off that Green's function, g, that is closest to the shot 
c      point, xs.
c_________________________________________________________________
       jscrp=nint(xs(jshot)/dcrp)
       jg=nint(xs(jshot)/dxg)
c_________________________________________________________________
c      copy the aperture limited Greens's function, g into the spatially
c      fixed array, r.
c_________________________________________________________________
       rmax=0.
       write(lerr,*) 'firstcrp,jscrp+minap-1'
       write(lerr,*) firstcrp,jscrp+minap-1
       do 11000 ji=firstcrp,jscrp+minap-1
        r(js,ji)=(0.,0.)
11000  continue
       do 12000 ji=max(firstcrp,jscrp+minap),min(lastcrp,jscrp+maxap)
        r(js,ji+jscrp)=g(ji,jg)
        rmax=max(rmax,abs(r(js,ji+jscrp)))
12000  continue
       write(lerr,*) 'jscrp+maxap+1,lastcrp'
       write(lerr,*)  jscrp+maxap+1,lastcrp
       do 13000 ji=jscrp+maxap+1,lastcrp
        r(js,ji)=(0.,0.)
13000  continue
20000 continue
      write(lerr,*) 'rmax = ',rmax
c_________________________________________________________________
c                                         + 
c     calculate the pseudo-inverse of R, R .
c_________________________________________________________________
      call invert(r,rc,r2,rinv,z,iperm,rcond,
     1            sigma,re,ru,rv,rwork,
     2            ns,ncrp,prew,svd,adjoint,luse,lerr)
c_________________________________________________________________
c     loop over the number of plane waves.
c_________________________________________________________________
      do 50000 jp=firstp,lastp
       p=jp*dp
c_________________________________________________________________
c      calculate the plane wave delay function, u.  
c_________________________________________________________________
       do 25000 ji=firstcrp,lastcrp
        xi=ji*dcrp
        u(ji)=xwgt(ji)*exp(-ci*omega*p*xi)*fwgt(ifreq)
25000  continue
c_________________________________________________________________
c                                        +
c      calculate the source weights w = R u             
c_________________________________________________________________
       do 35000 js=1,ns               
        w(js,jp)=(0.,0.)
        do 33000 ji=firstcrp,lastcrp
         w(js,jp)=w(js,jp)+rinv(js,ji)*u(ji)
33000   continue
35000  continue
50000 continue
c
      return
      end
