C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine interpv(v,vinterp,dxgrid,dcrp,xvo,
     1                   nz,nxgrid,mincrp,maxcrp)                   
C
      integer   firstv,lastv,mincrp,maxcrp
      real      v(0:nz,nxgrid)
      real      vinterp(mincrp:maxcrp,nz)    
c_______________________________________________________________________
c     interpolate/extrapolate velocity model to span from mincrp to
c     maxcrp at dcrp intervals.
c     v is defined on z grid nodes (fence posts)
c     vinterp is defined on elements (fences)
c_______________________________________________________________________
      firstv=xvo/dcrp+1.
      lastv=(xvo+nxgrid*dxgrid)/dcrp
c_______________________________________________________________________
c     extrapolate velocity model to the left of the input velocity grid.
c_______________________________________________________________________
      do 20000 icrp=mincrp,firstv
       do 10000 iz=1,nz
        vinterp(icrp,iz)=.5*(v(iz,1)+v(iz-1,1))
10000  continue
20000 continue
c_______________________________________________________________________
c     resample the velocity grid.
c_______________________________________________________________________
      do 60000 icrp=max(mincrp,firstv),min(lastv,maxcrp)
       xv=icrp*dcrp-xvo
       ix1=xv/dxgrid
       ix1=max(ix1,1)
       ix1=min(ix1,nxgrid)
       ix2=ix1+1
       ix2=max(ix2,1)
       ix2=min(ix2,nxgrid)
       wgt2=(xv-ix1*dxgrid)/dxgrid
       wgt1=1.-wgt2
       do 50000 iz=1,nz
        vinterp(icrp,iz)=.5*(wgt1*(v(iz,ix1)+v(iz-1,ix1))
     1                      +wgt2*(v(iz,ix2)+v(iz-1,ix2)))  
50000  continue
60000 continue
c_______________________________________________________________________
c     extrapolate velocity model to the right of the input velocity grid.
c_______________________________________________________________________
      do 90000 icrp=lastv,maxcrp 
       do 80000 iz=1,nz
        vinterp(icrp,iz)=.5*(v(iz,nxgrid)+v(iz-1,nxgrid))
80000  continue
90000 continue
C
      return
      end 
