C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine rdgeom(xs,zs,xr,zr,
     1                  minr,maxr,nshot,zmin,zmax,
     2                  verbose,lugeom,lerr,
     3                  xg,zg,dxg,ming,maxg,
     4                  sfans,rfans,xgmin,xgmax,ns)
C
      real    xs(nshot)
      real    zs(nshot)
c
      real    xr(minr:maxr)
      real    zr(minr:maxr)
      real    xg(ming:maxg)
      real    zg(ming:maxg)
c
      logical verbose
      logical sfans,rfans
C__________________________________________________________________
c     read in summary information of the seismic recording geometry.
C___________________________________________________________________
      read(lugeom,*)
      do 5000 ishot=1,nshot
       read(lugeom,*) xs(ishot),ys,zs(ishot),
     1                distmin,distmax,nlive
5000  continue
      read(lugeom,*)
      read(lugeom,*) (irecind,xr(ig),yr,zr(ig),zw,
     1                 ig=minr,maxr)
C__________________________________________________________________
c     check for errors in receiver and source positions.
C__________________________________________________________________
      ierror=0        
      do 10000 ishot=1,nshot
       if(zs(ishot) .lt. zmin) then
          write(lerr,*) 'shot lies above model: '
          write(lerr,*)' ishot =',ishot,' zs = ',zs(ishot),
     1                 ' zmin  =',zmin
          ierror=ierror+1
       elseif(zs(ishot) .gt. zmax) then
          write(lerr,*) 'shot lies below model ' 
          write(lerr,*)' ishot =',ishot,' zs = ',zs(ishot),
     1                 ' zmax  =',zmax
          ierror=ierror+1
       endif
10000 continue
c
      do 20000 ig=minr,maxr    
       if(zr(ig) .lt. zmin) then
          write(lerr,*) 'group lies above model: '
          write(lerr,*) 'ig = ',ig, 
     1                  ' zr = ',zr(ig),' zmin = ',zmin
          ierror=ierror+1
       elseif(zr(ig) .gt. zmax) then
          write(lerr,*) 'group lies below model '
          write(lerr,*) 'ig = ',ig, 
     1                  ' zr = ',zr(ig),' zmax = ',zmax
          ierror=ierror+1
       endif
20000 continue
      if(ierror .ne. 0) then
         write(lerr,*) 'program aborted in routine rdgeom'
         write(lerr,*) 'probable cause:'
         write(lerr,*) 'failure to supply elevation datum to vsamp'
         call exit(2666)
      endif
      ns=0
      do 22000 ishot=1,nshot
       if(xs(ishot) .ge. xgmin .and. xs(ishot) .le. xgmax) then
          ns=ns+1
       endif 
22000 continue
c__________________________________________________________________
c     calculate (x,z) coordinates of the ray fans.                   
c__________________________________________________________________
      if(sfans) then
c__________________________________________________________________
c        shoot at each shot points.
c__________________________________________________________________
         call vmov(xs,1,xg,1,maxg-ming+1)
         call vmov(zs,1,zg,1,maxg-ming+1)
      elseif(rfans) then
c__________________________________________________________________
c        shoot at each receiver points.
c__________________________________________________________________
         call vmov(xr,1,xg,1,maxg-ming+1)
         call vmov(zr,1,zg,1,maxg-ming+1)
      else
c__________________________________________________________________
c        shoot fans between xmin and xmax, dxg apart.
c__________________________________________________________________
         igroup=minr+1
         do 50000 ig=ming,maxg
          xg(ig)=ig*dxg
          if(xg(ig) .lt. xr(minr)) then
             zg(ig)=zr(minr)
          elseif(xg(ig) .gt. xr(maxr)) then
             zg(ig)=zr(maxr)
          else
45000        igroup=igroup+1
             if(xr(igroup) .gt. xg(ig)) then
                slope=(zr(igroup)-zr(igroup-1))
     1                   /(xr(igroup)-xr(igroup-1))
                zg(ig)=zr(igroup-1)
     1                +(xg(ig)-xr(igroup-1))*slope
             elseif(igroup .ge. maxr) then
                zg(ig)=zr(maxr)
             else
                go to 45000
             endif
          endif
50000    continue
      endif
c
      if(verbose) then
         write(lerr,'(//,3a20)') 'ig','xg','zg'
         write(lerr,'(i20,2f20.3)') (ig,xg(ig),zg(ig),ig=ming,maxg)
      endif
c
      return
      end
