/*
 *	Copyright (c) 1990 by Columbia University.
 */

#ifndef __IKP_DEFINES__
#define __IKP_DEFINES__

#include <sys/types.h>
#include <sys/wait.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <lxt.h>
#include <Panel.h>

#define boolean			int

#define AUTOMOUNT_PREFIX	"/tmp_mnt"

#define ERRBUFSZ		(1024)
#define FATAL			(0)
#define NONFATAL		(1)

#define IOBUFSZ			(1024)
#define MAXFILENMSZ		(255)
#define MAXTOKENSZ		(255)
#define MAXARGSZ		(1023)
#define MAXEXECARGS		(256)
#define LIBCOMMBLKSZ		(64)
#define TXTENCAPSULATOR		'\t'
#define COMMENCAPSULATOR	'\''
#define COMMESCAPE		'\\'

#define INTERACTIVE		(0)
#define BATCH			(1)

#define NULL_FD			(-1)
#define STDIO_FDS		(3)
#define MISC_FDS		(7)
#define RESERVED_FDS		(STDIO_FDS+MISC_FDS)
#define POLL_LIMIT		(20)

#define IKP_TEE			"ikp_tee"
#define IKP_TEEMEM		(0)
#define IKP_TEEFILE		(1)
#define TEE_FDIN		(0)
#define TEE_FDOUT1		(1)
#define TEE_FDOUT2		(3)

#define IKP_LOCALEXEC		(0)
#define IKP_REMOTEEXEC		(1)

#define IKP_SUCCESS		(0)
#define IKP_FAILURE		(1)
#define IKP_CLOSE		(2)
#define IKP_DUP			(3)
#define IKP_DUP2		(4)
#define IKP_PIPE		(5)
#define IKP_FORK		(6)
#define IKP_EXEC		(7)
#define IKP_FSTAT		(8)
#define IKP_OPEN		(9)
#define IKP_SEEK		(10)
#define IKP_CHDIR		(11)
#define IKP_READ		(12)
#define IKP_WRITE		(13)
#define IKP_SELECT		(14)
#define IKP_SOCKET		(15)
#define IKP_BINDSOCK		(16)
#define IKP_LISTEN		(17)
#define IKP_ACCEPT		(18)
#define IKP_CONNSOCK		(19)
#define IKP_GETSOCKNAME		(20)
#define IKP_GETHOSTBYNAME	(21)
#define IKP_GETHOSTBYADDR	(22)
#define IKP_MEMALLOC		(23)
#define IKP_SETUID		(24)
#define IKP_KILL		(25)
#define IKP_WAIT3		(26)
#define IKP_PERMISSION		(27)
#define IKP_ILLRPCOMM		(28)
#define IKP_UNCONNECTED		(29)
#define IKP_NULLNET		(30)
#define IKP_NULLPST		(31)
#define IKP_NULLPRC		(32)
#define IKP_NULLCNT		(33)
#define IKP_EMPTYNET		(34)
#define IKP_NOFDS		(35)
#define IKP_NOSLOTS		(36)
#define IKP_BADPRCARGV		(37)
#define IKP_RUNNINGNET		(38)
#define IKP_RPSTOPPED		(39)
#define IKP_RPRUNNING		(40)
#define IKP_RPEXITED		(41)
#define IKP_RPKILLED		(42)

#define DEFAULT_SITELIB		"/usr/lib/ikp/sitelib"

#define MDLIO_INPUT		(0)
#define MDLIO_OUTPUT		(1)
#define MDLIO_DIAG		(2)

typedef struct Mdlio_struct {
	int mdlio_fd;
	struct Mdlio_struct *mdlio_next;
} Mdlio;

#define ENUM_HORIZONTAL		(1)
#define ENUM_VERTICAL		(2)

#define TXT_NONNULL		(0x00000001)
#define TXT_INTEGER		(0x00000002)
#define TXT_REAL		(0x00000004)
#define TXT_OPTVALCONTIG	(0x00000008)
#define TXT_ENCAPSULATE		(0x00000010)

#define MDLI_ACTIVE		(0x00000001)
#define MDLI_PREVOPTCONTIG	(0x00000002)

typedef struct Mdli_struct {
	caddr_t mdli_module;
	int mdli_id;
	int mdli_type;
	float mdli_row, mdli_col;
	int mdli_xoff, mdli_yoff;
	char *mdli_string;
	int mdli_flags;
	caddr_t mdli_itemdata;
	struct Mdli_struct *mdli_items;
	struct Mdli_struct *mdli_next;
} Mdlitem;

typedef struct Mdl_struct {
	caddr_t mdl_library;
	caddr_t mdl_process;
	char *mdl_prog;
	char *mdl_label;
	char *mdl_path;
	Widget mdl_path_text;
	char *mdl_dir;
	Widget mdl_dir_text;
	char *mdl_helpfile;
	Mdlio *mdl_input;
	Mdlio *mdl_output;
	Mdlio *mdl_diag;
	int mdl_nitems;
	int mdl_commlen;
	Mdlitem *mdl_items;
	Window mdl_twin;
	struct Mdl_struct *mdl_next;
} Module;

typedef struct Lib_struct {
	char *lib_name;
	Module *lib_modules;
	struct Lib_struct *lib_next;
} Library;

#define PST_RDACTIVE		(0x00000001)
#define PST_WRACTIVE		(0x00000002)
#define PST_SOCKET		(0x00000004)
#define PST_SOCKACTIVE		(0x00000008)

typedef struct Pst_struct {
	int pst_fd[2];
	int pst_flags;
} Pipeslot;

#define SEG_DRAWN		(0x00000001)

typedef struct Seg_struct {
	int seg_orient;
	int seg_x, seg_y;
	int seg_x1, seg_y1;		/* temporary */
	int seg_len;
	int seg_flags;
	struct Seg_struct *seg_prev;
	struct Seg_struct *seg_next;
} Segment;

#define CNT_INPUT		(0)
#define CNT_OUTPUT		(1)
#define CNT_DIAG		(2)

#define CNT_ALL			(0)

#define CNT_FILE		(0x00000001)
#define CNT_APPEND		(0x00000002)
#define CNT_GRNDDRAWN		(0x00000004)
#define CNT_LOCKED		(0x00000008)
#define CNT_EDITOPEN		(0x00000010)

typedef struct Cnt_struct {
	caddr_t cnt_process;
	int cnt_iodir;
	int cnt_class;
	int cnt_desc;
	int cnt_orient;
	int cnt_x, cnt_y;
	int cnt_tag;
	Pipeslot *cnt_pipe;
	char *cnt_filename;
	Segment *cnt_seglist;
	struct Cnt_struct *cnt_conn;
	int cnt_conntag;
	int cnt_flags;
	struct Cnt_struct *cnt_next;
} Connector;

#define PRC_CONNECTED		(0x00000001)
#define PRC_FORKED		(0x00000002)
#define PRC_RUNNING		(0x00000004)
#define PRC_STOPPED		(0x00000008)
#define PRC_EXITED		(0x00000010)
#define PRC_IKPSTOPPED		(0x00000020)
#define PRC_IKPKILLED		(0x00000040)
#define PRC_VARPROC		(0x00000080)
#define PRC_NETMEMBER		(0x00000100)
#define PRC_REMOTE		(0x00000200)
#define PRC_SOCKOPEN		(0x00000400)
#define PRC_EDITOPEN		(0x00000800)

#define PRC_SOURCE		(1)
#define PRC_SINK		(2)
#define PRC_FILTER		(3)
#define PRC_TEE			(4)
#define PRC_CUSTOM		(5)
#define PRC_LIBRARY		(6)
#define PRC_SCRIPT		(7)

typedef struct Prc_struct {
	caddr_t prc_net;
	char *prc_host;
	char *prc_tmp_host;
	Widget prc_host_text;
	char *prc_user;
	Widget prc_user_text;
	char *prc_comm;
	Widget prc_comm_text;
	char *prc_label;
	Widget prc_label_text;
	char **prc_argv;
	char *prc_dir;
	Widget prc_dir_text;
	int prc_pid;
	int prc_type;
	int prc_flags;
	Connector *prc_input;
	Connector *prc_output;
	Connector *prc_diag;
	int prc_socket;
/* SOLARIS
	union wait prc_wstatus;
*/
	int prc_wstatus;
	XImage *prc_image;
	char *prc_imagefile;
	int prc_x, prc_y;
	int prc_w, prc_h;
	Module *prc_module;
	struct Prc_struct *prc_next;
	Panel *prc_panel;
	Widget prc_window;
} Process;

#define NET_SELECTED		(0x00000001)
#define NET_CONNECTED		(0x00000002)
#define NET_RUNNING		(0x00000004)

typedef struct Net_struct {
	Process *net_prclist;
	Pipeslot *net_pst;
	int net_npipes;
	int net_flags;
	char *name;
	struct Net_struct *net_next;
} Net;

typedef struct Waitproc_struct {
	int wtp_pid;
	struct Waitproc_struct *wtp_next;
} Waitproc;

typedef struct Cntlock_struct {
	Connector *cntl_cnt;
	struct Cntlock_struct *cntl_next;
} Cntlock;

#define REG_FONT		"8x13"
#define SMALL_FONT		"6x10"
#define MAX_GEOM_LEN		(35)
#define	GEOMETRY		"=600x600+100+100"
#define	BORDER_WIDTH		(2)

#define CNT_WIDTH		(11)
#define CNT_LIP			(3)

#define PRCSSF_WIDTH		(121)
#define PRCSSF_HEIGHT		(51)

#define CTLFRAME_WIDTH		(400)
#define CTLFRAME_HEIGHT		(120)

#define NETFRAME_WIDTH		(600)
#define NETFRAME_HEIGHT		(600)
#define NETCANVAS_WIDTH		(1600)
#define NETCANVAS_HEIGHT	(1600)
#define NET_MARGIN		(25)

#define HELPFRAME_WIDTH		(500)
#define HELPFRAME_HEIGHT	(400)

#define UP			(0)
#define DOWN			(1)
#define LEFT			(2)
#define RIGHT			(3)

#define NULL_OP			(0)
#define MAIN_MENU		(1)
#define NET_SELECT		(2)
#define NET_NAME		(21)
#define NET_RUN		        (22)
#define NET_COPY		(3)
#define NET_DESTROY		(4)
#define NET_READ		(5)
#define NET_WRITE		(6)
#define NET_APPEND              (23)
#define PRC_CREATE		(7)
#define PRC_EDIT		(8)
#define PRC_COPY		(9)
#define PRC_MOVE		(10)
#define PRC_STOP		(11)
#define PRC_RESTART		(12)
#define PRC_ABORT		(13)
#define PRC_DESTROY		(14)
#define CNT_LINK		(15)
#define CNT_UNLINK		(16)
#define CNT_EDIT		(17)
#define CNT_MOVE		(18)
#define CNT_GRNDFILE		(19)
#define CNT_GRNDNULL		(20)

#define PRC_FREENET		(0)
#define PRC_RETAINNET		(1)

#define PRC_STANDALONE		(0)
#define PRC_NETCONNECT		(1)

#endif __IKP_DEFINES__
