/*
 *	Copyright (c) 1990 by Columbia University.
 */

#ifndef __IKP_REMOTE__
#define __IKP_REMOTE__

#include <signal.h>
#include <sys/types.h>
#include <sys/file.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>

#define ROOT_UID		(0)
#define MAXSOCKADDRLEN		(64)
#define SOCKIO_TIMEOUT		(180)		/* was 30 - chg 3/28/96 jmw */
#define EXECVP_EXITCODE		(-99)
#define DIAGBUFSZ		(2048)
#define ARCHPATTERN		"IKPRARCH"
#define HOMEPATTERN		"IKPRHOME"

/* ikpd modes */
#define IKPD_SETUP		(1)
#define IKPD_EXEC		(2)
#define IKPD_RUNNING		(3)
#define IKPD_STOPPED		(4)
#define IKPD_KILLED		(5)
#define IKPD_EXITED		(6)
#define IKPD_CLOSEDOWN		(7)


/*
   The following two groups of #define's declare the format of messages
   which may be passed over the bidirectional communications channel between
   ikp and ikpd. The actual #define declares the value of the command byte,
   while the end of line comment describes the size and content of the message
   bytes which immediately follow the command byte. All numeric values are
   passed in network byte order. Strings are not terminated by NULLs as
   the actual string length is always supplied immediately prior to the
   string itself.
*/

/* ikp -> ikpd channel */
#define IKPRP_USERNAME		((char) 1)	/* u_long (strlen(uname),
						   str (uname),
						   u_long (strlen(remuname)),
						   str (remuname) */
#define IKPRP_DIR		((char) 2)	/* u_long (strlen(dir),
						   str (dir) */
#define IKPRP_ARGV		((char) 3)	/* u_long (nargs),
						   u_long (strlen(arg0)), str (arg0),
						   u_long (strlen(arg1)), str (arg1),						   ... */
#define IKPRP_ENVV		((char) 4)	/* u_long (nvars),
						   u_long (strlen(env0)), str (env0),
						   u_long (strlen(env1)), str (env1),
						   ... */
#define IKPRP_LOCKFD		((char) 5)	/* u_long (fd) */
#define IKPRP_SERVERSOCK	((char) 6)	/* u_long (fd) */
#define IKPRP_CLIENTSOCK	((char) 7)	/* u_long (fd),
						   u_long (strlen(addr)),
						   str (addr),
						   u_short (port) */
#define IKPRP_FILERD		((char) 8)	/* u_long (fd),
						   u_long (strlen(filenm)),
						   str (filenm) */
#define IKPRP_FILEWRTRUNC	((char) 9)	/* u_long (fd),
						   u_long (strlen(filenm)),
						   str (filenm) */
#define IKPRP_FILEWRAPP		((char) 10)	/* u_long (fd),
						   u_long (strlen(filenm)),
						   str (filenm) */
#define IKPRP_DIAG		((char) 11)	/* u_long (fd) */
#define IKPRP_EXEC		((char) 12)	/* */
#define IKPRP_STATUS		((char) 13)	/* */
#define IKPRP_STOP		((char) 14)	/* */
#define IKPRP_CONT		((char) 15)	/* */
#define IKPRP_KILL		((char) 16)	/* */
#define IKPRP_CLOSEDOWN		((char) 17)	/* */

/* ikpd -> ikp channel */
#define IKPRP_SUCCESS		((char) 51)	/* */
#define IKPRP_FAILURE		((char) 52)	/* u_long (ikp error code),
						   u_long (errno) */
#define IKPRP_SOCKADDR		((char) 53)	/* u_long (strlen(addr)),
						   str (addr),
						   u_short (port) */
#define IKPRP_PID		((char) 54)	/* u_long (pid) */
#define IKPRP_SETUP		((char) 55)	/* */
#define IKPRP_RUNNING		((char) 56)	/* */
#define IKPRP_EXITED		((char) 57)	/* u_long (exitcode) */
#define IKPRP_STOPPED		((char) 58)	/* u_long (sigtype) */
#define IKPRP_KILLED		((char) 59)	/* u_long (sigtype) */
#define IKPRP_DIAGMSG		((char) 60)	/* u_long (strlen(msg)),
						   str (msg),
						   char (status)[,
						   u_long (status-dependent code] */
#define IKPRP_HOSTNAME		((char) 61)	/* u_long (strlen(hostname),
						   str (hostname) */

#define IOC_FILERD		(0x00000001)
#define IOC_FILEWR		(0x00000002)
#define IOC_SOCKET		(0x00000004)
#define IOC_CONNECTED		(0x00000008)

typedef struct Ioc_struct {
	int ioc_fd;
	int ioc_socket;
	int ioc_flags;
	u_short ioc_port;		/* stored in network byte order! */
	struct Ioc_struct *ioc_next;
} Ioc;

typedef struct Diag_struct {
	int diag_fd;
	int diag_pipe[2];
	struct Diag_struct *diag_next;
} Diag;

#endif
/* end of __IKP_REMOTE__ */
