/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
#define SZGRWD 4
#define SZDHWD 2
#define SZDFWD 4
#define LINE_HDR_OFFSET 48
#define NUMBER_OF_TRACES_OFFSET 48
#define NUMBER_OF_RECORDS_OFFSET 52
#define SAMPLE_INTERVAL_OFFSET 56
#define NUMBER_OF_SAMPLES_OFFSET 60
#define FORMAT_OFFSET 64
#define FIRST_SLICE_OFFSET 152
#define SLICE_INTERVAL_OFFSET 156
#define FIRST_SAMPLE_TIME_OFFSET 160
#define HLHENT_OFFSET 1000
#define HLHBYT_OFFSET 1002
#define RECORD_NUMBER_OFFSET 210
#define TRACE_NUMBER_OFFSET 212
#define TRACE_HDR_SIZE 256

#ifdef CRAYSYSTEM
#define SZMHWD 8
#define SZMFWD 8
#else
#define SZMHWD 4
#define SZMFWD 4
#endif

#ifdef CRAYSYSTEM
union {
  struct {
    char dummy[4];
    char value[4];
    } fullword;
  struct {
    char dummy[6];
    char value[2];
    } halfword;
  int value;
  } buffer;
#else
union {
  struct {
    char value[4];
    } fullword;
  struct {
    char dummy[2];
    char value[2];
    } halfword;
  int value;
  } buffer;
#endif

typedef struct {
	int Format;
	int Number_of_Records;
	int Number_of_Traces;
	int Number_of_Samples;
	int Sample_Interval;
	int Hlh_Entries;
	int Hlh_Bytes;
	} line_header ;

typedef struct {
	int Record_Number;
	int Trace_Number;
	} trace_header ;

