C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************

c     program module adjsum
c
c**********************************************************************c
c
c adjsum reads seismic trace data from an input file,
c applies a user-specified agc, and
c writes the results to an output file
c
c
c**********************************************************************c
c
c     declare variables
c
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h>
 
 
      integer     itr ( SZLNHD )
      integer     lhed( SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform
      integer     luin , luout, lbytes, nbytes, lbyout
      integer     irs, ire, ns, ne
      integer     recnum, trcnum, static, iabort
      integer     ierr1, ierr2
      real        tri ( SZLNHD )
      real        data, sum
      pointer     (wkdata, data(1))
      pointer     (wksum , sum (1))
      character   ntap * 255, otap * 255, name*6
      logical     verbos
      integer     argis
 
      equivalence ( itr(  1), lhed(1))
      data lbytes / 0 /, nbytes / 0 /, name/'ADJSUM'/
      data iabort/0/
 
c-----
c     read program parameters from command line card image file
c-----
      if ( argis ( '-?' ) .gt. 0 .or.
     :     argis ( '-h' ) .gt. 0 .or.
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif
 
c-----
c     open printout files
c-----
#include <f77/open.h>
 
      call gcmdln (ntap, otap, ns, ne, irs, ire, igath, verbos)
 
c-----
c     get logical unit numbers for input and output
c-----
      call getln(luin , ntap,'r', 0)
      call getln(luout, otap,'w', 1)
 
c-----
c     read line header of input
c     save certain parameters
c-----
      call rtape   ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         write(LERR,*)'adjsum: no header read from unit ',luin
         write(LERR,*)'FATAL'
         stop
      endif
 
c------
c     save certain parameters
 
      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif
 
c     For trace header values we take mnemonics and build a
c     set of pointers to an I*2 array equivalenced to the
c     RTAPE  Integer array (headers + data)
c     TRACEHEADER is a value in the include file <sisdef.h> that
c     refers to the trace header
 
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TRACEHEADER)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TRACEHEADER)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
 
      call savelu('SrPtXC',ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,TRACEHEADER)
      call savelu('SrPtYC',ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,TRACEHEADER)
      call savelu('RcPtXC',ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,TRACEHEADER)
      call savelu('RcPtYC',ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,TRACEHEADER)
      call savelu('SrRcMX',ifmt_SrRcMX,l_SrRcMX,ln_SrRcMX,TRACEHEADER)
      call savelu('SrRcMY',ifmt_SrRcMY,l_SrRcMY,ln_SrRcMY,TRACEHEADER)
      call savelu('CDPBCX',ifmt_CDPBCX,l_CDPBCX,ln_CDPBCX,TRACEHEADER)
      call savelu('CDPBCY',ifmt_CDPBCY,l_CDPBCY,ln_CDPBCY,TRACEHEADER)

      if (mod(ntrc,igath) .ne. 0) then
         write(LERR,*)' '
         write(LERR,*)'FATAL ERROR in adjsum:'
         write(LERR,*)'Number of adjacent traces must divide into the'
         write(LERR,*)'input number of traces/record, e.g. 240 / 2'
         write(LER ,*)' '
         write(LER ,*)'FATAL ERROR in adjsum:'
         write(LER ,*)'Number of adjacent traces must divide into the'
         write(LER ,*)'input number of traces/record, e.g. 240 / 2'
         call ccexit (666)
      else
         jtr = ntrc / igath
      endif
 
c-----
c     modify line header to reflect actual number of traces output
c-----
      call hlhprt (itr, lbytes, name, 6, LERR)
      call savew(itr, 'NumTrc', jtr  , LINHED)
 
      call savhlh(itr, lbytes, lbyout)
      call wrtape ( luout, itr, lbyout                 )

      item = nsamp

      call galloc (wkdata, item * SZSMPD, ierr1, iabort)
      call galloc (wksum , item * SZSMPD, ierr2, iabort)

      if ( ierr1 .ne. 0 .or.
     :     ierr2 .ne. 0 ) then

         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*) 2*item,'  bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'Unable to allocate workspace:'
         write(LER,*) 2*item,'  bytes'
         write(LER,*)' '
         go to 999
 
      else

         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*)  2*item,'  bytes'
         write(LERR,*)' '
 
      endif

 
c-----
c     verbose output of all pertinent information before
c     processing begins
c-----
c     if( verbos ) then
            call verbal(nsamp, nsi, ntrc, nrec, iform, igath, jtr,
     1                  ntap, otap)
c     endif
c-----
c     BEGIN PROCESSING
c     read trace, do adjacnet trc sum, write to output file
c-----
c-----
c     skip unwanted records
c-----
c     call recskp(1,irs-1,luin,ntrc,itr)
c-----
c     process desired trace records
c-----
      DO  1000  JJ = 1, nrec
 
            do  KK = 1, ntrc, igath
 
                isrcx_sum = 0
                isrcy_sum = 0
                ircvx_sum = 0
                ircvy_sum = 0
                isrmx_sum = 0
                isrmy_sum = 0
                icdpx_sum = 0
                icdpy_sum = 0
                idist_sum = 0
                istat_sum = 0
                live_sum  = 0

                call vclr (data, 1, nsamp)
                call vclr (sum , 1, nsamp)

                do  LL = 1, igath

                    nbytes = 0
                    call rtape ( luin, itr, nbytes)
                    if(nbytes .eq. 0) then
                       write(LERR,*)'End of file on input:'
                       write(LERR,*)'  rec= ',jj,'  trace= ',kk
                       go to 999
                    endif
                    call vmov (lhed(ITHWP1), 1, tri, 1, nsamp)
 
                    call saver2(lhed,ifmt_RecNum,l_RecNum, ln_RecNum,
     1                          recnum , TRACEHEADER)
                    call saver2(lhed,ifmt_TrcNum,l_TrcNum, ln_TrcNum,
     1                          trcnum , TRACEHEADER)
                    call saver2(lhed,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                          idist  , TRACEHEADER)
                    call saver2(lhed,ifmt_SrPtXC,l_SrPtXC, ln_SrPtXC,
     1                          isrcx  , TRACEHEADER)
                    call saver2(lhed,ifmt_SrPtYC,l_SrPtYC, ln_SrPtYC,
     1                          isrcy  , TRACEHEADER)
                    call saver2(lhed,ifmt_RcPtXC,l_RcPtXC, ln_RcPtXC,
     1                          ircvx  , TRACEHEADER)
                    call saver2(lhed,ifmt_RcPtYC,l_RcPtYC, ln_RcPtYC,
     1                          ircvy  , TRACEHEADER)
                    call saver2(lhed,ifmt_SrRcMX,l_SrRcMX, ln_SrRcMX,
     1                          isrmx  , TRACEHEADER)
                    call saver2(lhed,ifmt_SrRcMY,l_SrRcMY, ln_SrRcMY,
     1                          isrmy  , TRACEHEADER)
                    call saver2(lhed,ifmt_CDPBCX,l_CDPBCX, ln_CDPBCX,
     1                          icdpx  , TRACEHEADER)
                    call saver2(lhed,ifmt_CDPBCY,l_CDPBCY, ln_CDPBCY,
     1                          icdpy  , TRACEHEADER)
                    call saver2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                          static , TRACEHEADER)

 
                    IF (static .ne. 30000) then

                       live_sum  = live_sum + 1
                       isrcx_sum = isrcx_sum + isrcx
                       isrcy_sum = isrcy_sum + isrcy
                       ircvx_sum = ircvx_sum + ircvx
                       ircvy_sum = ircvy_sum + ircvy
                       isrmx_sum = isrmx_sum + isrmx
                       isrmy_sum = isrmy_sum + isrmy
                       icdpx_sum = icdpx_sum + icdpx
                       icdpy_sum = icdpy_sum + icdpy
                       idist_sum = idist_sum + idist
                       istat_sum = istat_sum + static

                       do  i = 1, nsamp
                           amp = tri (i)
                           if (amp .ne. 0.) then
                               data (i) = data (i) + amp
                               sum  (i) = sum  (i) + 1.0
                           endif
                       enddo

 
                    ENDIF

                enddo

                IF (live_sum .gt. 0) THEN

                    isrcx = isrcx_sum / live_sum
                    isrcy = isrcy_sum / live_sum
                    ircvx = ircvx_sum / live_sum
                    ircvy = ircvy_sum / live_sum
                    isrmx = isrmx_sum / live_sum
                    isrmy = isrmy_sum / live_sum
                    icdpx = icdpx_sum / live_sum
                    icdpy = icdpy_sum / live_sum
                    idist = idist_sum / live_sum
                    istat = istat_sum / live_sum

                    do  i = 1, nsamp
                        amp = sum (i)
                        if (amp .ne. 0.0) then
                            tri (i) = data (i) / amp
                        endif
                    enddo
                    call savew2(lhed,ifmt_DstSgn,l_DstSgn, ln_DstSgn,
     1                          idist  , TRACEHEADER)
                    call savew2(lhed,ifmt_SrPtXC,l_SrPtXC, ln_SrPtXC,
     1                          isrcx  , TRACEHEADER)
                    call savew2(lhed,ifmt_SrPtYC,l_SrPtYC, ln_SrPtYC,
     1                          isrcy  , TRACEHEADER)
                    call savew2(lhed,ifmt_RcPtXC,l_RcPtXC, ln_RcPtXC,
     1                          ircvx  , TRACEHEADER)
                    call savew2(lhed,ifmt_RcPtYC,l_RcPtYC, ln_RcPtYC,
     1                          ircvy  , TRACEHEADER)
                    call savew2(lhed,ifmt_SrRcMX,l_SrRcMX, ln_SrRcMX,
     1                          isrmx  , TRACEHEADER)
                    call savew2(lhed,ifmt_SrRcMY,l_SrRcMY, ln_SrRcMY,
     1                          isrmy  , TRACEHEADER)
                    call savew2(lhed,ifmt_CDPBCX,l_CDPBCX, ln_CDPBCX,
     1                          icdpx  , TRACEHEADER)
                    call savew2(lhed,ifmt_CDPBCY,l_CDPBCY, ln_CDPBCY,
     1                          icdpy  , TRACEHEADER)
                    call savew2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                          istat  , TRACEHEADER)


                ELSE

                    call savew2(lhed,ifmt_StaCor,l_StaCor, ln_StaCor,
     1                          30000 , TRACEHEADER)
                    call vclr (tri, 1, nsamp)

                ENDIF
 
                call vmov ( tri, 1, lhed(ITHWP1), 1, nsamp)
                call wrtape( luout, itr, nbytes)

            enddo
 
            if(verbos) write(LERR,*)'adjsum:  ri ',recnum
 
 1000       CONTINUE
c-----
c     close data files
c-----
  999 continue
      call lbclos ( luin )
      call lbclos ( luout )
      write(LERR,*)'end of adjsum, processed',nrec,' record(s)',
     :               ' with ',ntrc, ' traces'
      end
 
      subroutine help
#include <f77/iounit.h>
         write(LER,*)
     :'***************************************************************'
      write(LER,*)
     :'execute adjsum by typing adjsum and a list of program parameters'
      write(LER,*)
     :'note that each parameter is proceeded by -a where "a" is '
      write(LER,*)
     :'a character(s) corresponding to some parameter.'
        write(LER,*)
     :'users enter the following parameters, or use the default values'
      write(LER,*)' '
        write(LER,*)
     :' -N [ntap]    (no default)   : input data file name'
        write(LER,*)
     :' -O [otap]    (no default)   : output data file name'
      write(LER,*)' '
        write(LER,*)
     :' -gs[gs]      (default = 2)  : # trcs in adjacent sum'
        write(LER,*)
     :' -V                              : verbose printout'
      write(LER,*)' '
         write(LER,*)
     :'usage:   adjsum -N[ntap] -O[otap] -gs[gs] [ -V ]'
         write(LER,*)
     :'***************************************************************'
      return
      end
 
      subroutine gcmdln(ntap, otap, ns, ne, irs, ire, igath, verbos)
c-----
c     get command arguments
c
c     ntap  - c*255     input file name
c     otap  - c*255     output file name
c     verbos      - L   verbose output or not
c-----
#include <f77/iounit.h>
      character   ntap*(*), otap*(*)
      integer     ns, ne, irs, ire, igath
      logical     verbos
      integer     argis
 
            call argstr( '-N', ntap, ' ', ' ' )
            call argstr( '-O', otap, ' ', ' ' )
            call argi4 ( '-gs', igath ,   2  ,  2    )
            call argi4 ( '-ns', ns ,   0  ,  0    )
            call argi4 ( '-ne', ne ,   0  ,  0    )
            call argi4 ( '-rs', irs ,   0  ,  0    )
            call argi4 ( '-re', ire ,   0  ,  0    )
            verbos = ( argis( '-V' ) .gt. 0 )
 
      return
      end
 
      subroutine verbal(nsamp, nsi, ntrc, nrec, iform, igath, jtr,
     1                  ntap, otap)
c-----
c     verbose output of processing parameters
c
c     nsamp - I*4 number of samples in trace
c     nsi   - I*4 sample interval in ms
c     ntrc  - I*4 traces per record
c     nrec  - I*4 number of records per line
c     iform - I*4 format of data
c     ntap  - C*255     input file name
c     otap  - C*255     output file name
c-----
#include <f77/iounit.h>
      integer     nsamp, nsi, ntrc, nrec, iform, igath, jtr
      integer     length,lenth
      character   ntap*(*), otap*(*)
 
            write(LERR,*)' '
            write(LERR,*)' line header values after default check '
	    length = lenth(ntap)
	    if (length .gt. 0) then
	      write(LERR,*)' Input data set name =  ',
     :		ntap(1:length)
	    else
	      write(LERR,*)' Input data set name =  stdin'
	    endif
	    length = lenth(otap)
	    if (length .gt. 0) then
              write(LERR,*)' Output data set name=  ',
     :		otap(1:length)
	    else
              write(LERR,*)' Output data set name=  stdout'
	    endif
            write(LERR,*) ' # of samples/trace =  ', nsamp
            write(LERR,*) ' sample interval    =  ', nsi
            write(LERR,*) ' traces per record  =  ', ntrc
            write(LERR,*) ' records per line   =  ', nrec
            write(LERR,*) ' format of data     =  ', iform
            write(LERR,*) ' # trcs in adjacent sum =  ',igath
            write(LERR,*) ' # trcs per output rec  =  ',jtr
 
      return
      end
 
