C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       ???                                                  *
C  ROUTINE TYPE:  MAIN                                                 *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:  MAINLINE ENTRY                                       *
C  ARGUMENTS:     NONE                                                 *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 90/08/09  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 90/10/12  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      ARGIS   INTEGER -                                               *
C      HELP            -                                               *
C      OPENPR          -                                               *
C      GCMDLN          -                                               *
C      GAMOCO          -                                               *
C      GETLN           -                                               *
C      RTAPE           -                                               *
C      HLHPRT          -                                               *
C      SAVER           -                                               *
C      SAVEW           -                                               *
C      WRTAPE          -                                               *
C      WRCARD          -                                               *
C      DEADTR          -                                               *
C      VADD            -                                               *
C      VSUB            -                                               *
C      VMUL            -                                               *
C      VDIVZ           -                                               *
C      MOVE            -                                               *
C      RIPRNT          -                                               *
C      RICLR           -                                               *
C      LBCLOS          -                                               *
C      CCEXIT          -                                               *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      IPRINT  ( OUTPUT SEQUENTIAL ) -                                 *
C      IREADR  ( INPUT  SEQUENTIAL ) -                                 *
C      LERR    ( OUTPUT SEQUENTIAL ) -                                 *
C  COMMON:           NONE                                              *
C  STOP CODES:                                                         *
C      =BLANK=  ( 3) -                                                 *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:      1 DETECTED                               *
C      INTEGER*                                                        *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
C*****************  ITEMS DELETED FROM DOCPACK  ************************
C  =============================== DATE: 90/08/09 ==================   *
C      ITOFP           -                                               *
C  =============================== DATE: 90/08/10 ==================   *
C      ARITFP          -                                               *
C  =============================== DATE: 90/08/10 ==================   *
C      ZEROCK          -                                               *
C  =============================== DATE: 90/10/12 ==================   *
C      FLUSH           -                                               *
C********************  END OF DELETED ITEMS  ***************************
C***********************************************************************
C
C     LANGUAGE - FORTRAN
C     SYSTEM(S) - IBM/PE
C     AUTHOR - S. G. ROSE
C     DATE WRITTEN - 9/12/83 (REWRITE)
C
C     AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE
C
C     ABSTRACT -    ARITHMETIC GENERALIZED CURVE APPLICATION PROGRAM.
C                     THIS PROGRAM ARITHMETICALLY APPLIES A TRACE
C                     FROM THE OPERATOR TAPE(LUIN2) TO A TRACE FROM
C                     THE OPERAND TAPE(LUIN1) FOR THE LENGTH OF THE
C                     OPERAND TAPE AND PRODUCES A RESULTANT OUTPUT
C                     TAPE(LUOUT).  FORMAT 1 DATA IS CONVERTED TO FORMAT
C                     3 SO THAT THE SUBROUTINE ARITFP CAN BE USED
C                     TO PERFORM VECTOR ELEMENT ARITHMETIC(ADD,SUBTRACT,
C                     MULTIPLY OR DIVIDE DEPENDING ON THE MODE).
C                     THE USER HAS THREE BASIC METHODS OF APPLYING THE
C                     OPERATOR:
C                               TYPE                DESCRIPTION
C                                0                 TRACE TO TRACE
C                                1                 CONSTANT PANEL
C                                2                 VARIABLE PANEL
C
C    USAGE -
C
C    INPUT VARIABLES AND BUFFERS.
C               AN EXPLANATION OF EACH
C               AND VALID VALUES IF APPLICABLE.
C          JOB    - JOB NUMBER (1AGCA CARD).
C                    MUST BE EQUAL TO JOB NUMBER ON LINE HEADER.
C          LRI    - LAST RECORD NUMBER ON OPERAND TAPE THAT CURRENT
C                   OPERATOR IS TO BE APPLIED TOO (1AGCA CARD).
C                    0 - 9999.
C          NUM    - NUMBER OF OPERAND TRACES PER EACH OPERATOR TRACE
C                   (1AGCA CARD).
C                    0 - 9999.
C          IRIS   - RECORD INDEX NUMBER FOR THE OPERATOR TO BE SELECTED
C                   (1AGCA CARD).
C                    0 - 9999.
C          ITRS   - TRACE NUMBER FOR THE OPERATOR TO BE SELECTED
C                   (1AGCA CARD).
C                    0 - 999.
C          KARD   - INPUT CARD BUFFER.
C                   (1AGCA CARD).
C          MODE   - NUMERIC CODE INDICATES THE TYPE OF ARITHMETIC
C                   OPERATION TO BE PERFORMED.
C                   (1AGCA CARD).
C                    0,1,2,3.
C          NAME   - CARD TYPE IDENTIFIER.
C                   (1AGCA CARD).
C                    1AGCA.
C          ITYPE  - TYPE OF APPLICATION.
C                   (1AGCA CARD).
C                    0,1,2.
C          LHDR1  - INPUT BUFFER FOR OPERAND LINE HEADER.
C          LHCNT1 - BYTE COUNT FOR OPERAND LINE HEADER.
C          LHDR2  - INPUT BUFFER FOR OPERATOR LINE HEADER.
C          LHCNT2 - BYTE COUNT FOR OPERATOR LINE HEADER.
C          INBUF1 - INPUT BUFFER FOR OPERAND TRACES.
C          INCNT1 - BYTE COUNT FOR OPERAND TRACES.
C          INBUF2 - INPUT BUFFER FOR OPERATOR TRACES.
C          IN2CNT - BYTE COUNT FOR OPERATOR TRACES.
C    OUTPUT VARIABLES AND BUFFERS.
C               AN EXPLANATION OF EACH.
C          CC     - CONDITION CODE FOR CCEXIT.
C          HLHADD - BUFFER USED TO UPDATE LINE HEADER FOR ADD MODE.
C          HLHDIV - BUFFER USED TO UPDATE LINE HEADER FOR DIVISION MODE.
C          HLHMUL - BUFFER USED TO UPDATE LINE HEADER FOR MULTIPLY MODE.
C          HLHSUB - BUFFER USED TO UPDATE LINE HEADER FOR SUBTRACT MODE.
C          ITITLE - TILTE BUFFER FOR GAMOCO.
C          OUTBUF - OUTPUT BUFFER FOR RESULTANT TRACES.
C    IMPORTANT INTERMEDIATE VARIABLES AND BUFFERS.
C               AN EXPLANATION OF EACH.
C          IACT   - FLAG FOR NACCT2 PROCESSING. 0=NO,1=YES
C          ILIVE  - FLAG FOR DEADTR SUBROUTINE TO INDICATE IF OUTPUT
C                   TRACE IS LIVE OR DEAD. 0=DEAD 1=LIVE.
C          IOPTN  - OPTION PARM. FOR SUBROUTINE ARITFP.
C          IFRMT1 - FORMAT OF OPERAND TAPE.
C          IFRMT1 - FORMAT OF OPERATOR TAPE.
C          ICOUNT - COUNTER TO TEST FOR 'NUM' LIMIT. (ITYPE = 1)
C          IN1RIS - RECORD INDEX NUMBER OF CURRENT OPERAND TRACE.
C          LH1JOB - JOB NUMBER FROM OPERAND LINE HEADER.
C          NEWOPR - FLAG TO EXECUTE ITOFP WHEN A NEW OPERATOR TRACE
C                   IS RETRIEVED. (ITYPE = 2, OPERATOR FORMAT = 1)
C          NOREC1 - NUMBER OF RECORDS FROM OPERAND LINE HEADER.
C          NOSMP1 - NUMBER OF SAMPLES FROM OPERAND LINE HEADER.
C          NOTRC1 - NUMBER OF TRACES/RECORD FROM OPERAND LINE HEADER.
C          NOREC2 - NUMBER OF RECORDS FROM OPERATOR LINE HEADER.
C          NOSMP2 - NUMBER OF SAMPLES FROM OPERATOR LINE HEADER.
C          NOTRC2 - NUMBER OF TRACES/RECORD FROM OPERATOR LINE HEADER.
C          PREVRI - RECORD INDEX NUMBER OF LAST OPERAND.
C                   (CONTROLS RIPRNT CALL)
C          RECCNT - COUNT OF RECORDS (RI'S) PROCESSED.
C
C
C    SUBROUTINES CALLED -
C          HLH     MOVE    ITOFP   NACCT   RICLR   RTAPE
C          ARITFP  CCEXIT  GAMOCO  LBCLOS  LBOPEN  NACCT2
C          RIPRNT  WRCARD  WRTAPE
C
C    FILES REQUIRED/GENERATED -
C          LUIN1 (FT07001) - IN - OPERAND WORKTAPE.
C          LUIN2 (FT09001) - IN - OPERATOR WORKTAPE.
C          LUOUT (FT08001) - OUT- RESULTANT WORKTAPE.
C          IPRINT(FT06001) - OUT- SYSOUT.
C          IREADR(FT05001) - IN - SYSIN.
C
C    ERROR FILE AND MNEUMONIC - NONE
C
C    ERROR/RETURN CODES -
C          0  -  NORMAL COMPLETION
C        100  -  ABNORMAL COMPLETION
C
C
C***********************************************************************
C
C     MODIFICATION HISTORY - DATE, EXPLANATION OF CHANGE
C                            AND PROGRAMMER NAME.
C
C***********************************************************************
C
C
C***********************************************************************
C
C     SYSTEM DEPENDANT NOTES:  $$ ARE USED TO INDICATE CODE THAT CHANGES
C                            BETWEEN P/E AND IBM.  THE REPLACEMENT CODE
C                            HAS BEEN LEFT IN BUT COMMENTED OUT TO HELP
C                            IN MAKING CONVERSIONS.
C
C***********************************************************************
C
C
C
cmam............080790................
#include <localsys.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/pid.h>
	character ntap1*256, ntap2*256, otap*256, cardin*256
	logical verbos, query, xmode, xtype, xnum, cflag
	integer argis, pipe
 
#ifndef CRAYSYSTEM
      INTEGER INBUF1(6064), INBUF2(6064)
      REAL OUTBUF(6064)
#else
      INTEGER INBUF1(6128), INBUF2(6128)
      REAL OUTBUF(6128)
#endif
      INTEGER IFRMT1, IFRMT2
	character KARD*80
cmam..................................
cmam..........080790...........replace these w/ char types..............
cmam  REAL*8    NAME,          AGCA1,        LH1JOB,        JOB,
cmam *          HLHMUL(3),     HLHDIV(4),    HLHADD(2),     HLHSUB(3)
	character NAME*5, AGCA1*5, JOB*7, HLHMUL*22,
     *		  HLHDIV*32, HLHADD*16, HLHSUB*24
	character ITITLE*68
cmam....................................................................
cmam  REAL*4    CHARGE,        HLHNT2,
cmam *          OUTBUF(6064),
cmam *          R4WRK1(6000),  R4WRK2(6000), R4WRK3(6000)
      real      R4WRK1(6000),  R4WRK2(6000)
CMAM  real      R4WRK1(6000),  R4WRK2(6000), R4WRK3(6000)
      INTEGER*4 IPRINT,        LUOUT,        LUIN1,         LUIN2,
     *          NOREC1,        NOTRC1,       NOSMP1,        NOREC2,
     *          NOTRC2,        NOSMP2,       LHCNT2,        RECCNT,
     *          IN1CNT,        IN2CNT,       IOPTN,         MODE,
     *          ITYPE,         IRIS,         ITRS,          NUM,
     *          IN1RIS,        IREADR,       CC,            NEWOPR,
     *          LRI,           ICHECK,       ICOUNT,        KBYTES,
     *          LHCNT1,        PREVRI,       IACT,
     *          ILIVE,
     *           I4WRK1(1500), I4WRK2(1500)
cmam *          ITITLE(17),    I4WRK1(1500), I4WRK2(1500)
	integer LHDR1(1500), LHDR2(1500)
cmam  INTEGER*2 IFRMT1,        IFRMT2,
cmam *          INBUF1(12128), LHDR1(3000),  INBUF2(12128),
cmam *          LHDR2(3000),   KARD(40)
cmam  LOGICAL*1 L1WRK1(256)
C
      EQUIVALENCE (I4WRK1(1),LHDR1(1)),    (I4WRK2(1),LHDR2(1)),
cmam *            (L1WRK1(1),LHDR1(1)),
     *            (R4WRK1(1),INBUF1(ITHWP1)), (R4WRK2(1),INBUF2(ITHWP1))
cmam *            (R4WRK1(1),INBUF1(129)), (R4WRK2(1),INBUF2(129))
C
cmam  DATA      ITITLE/3*' ','  AP','PLY ','PREV','IOUS','LY C',
cmam *                           'ALCU','LATE','D AG','C CU','RVE ',
cmam *                     4*' '/
cmam  DATA      HLHMUL/'AGCA(APP','LY MULTI','PLIER)  '/
cmam  DATA      HLHDIV/'AGCA(APP','LY INVER','SE OF MU','LTIPLIER'/
cmam  DATA      HLHADD/'AGCA(ADD',' OPTION)'/
cmam  DATA      HLHSUB/'AGCA(SUB','TRACTION',' OPTION)'/
cmam  DATA      HLHNT2/'NTP2'/
cmam  DATA      NAME/'        '/,   AGCA1/'1AGCA   '/,
cmam *          LH1JOB/'        '/,   JOB/'        '/,
	data
     *           LHCNT1/0/,   RECCNT/0/,
cmam *          IPRINT/6/,   IREADR/5/,   LHCNT1/0/,   RECCNT/0/,
     *          IN1CNT/0/,   IN2CNT/0/,   NEWOPR/1/,   CHARGE/1.0/,
     *          CC/0/,       LHCNT2/0/,   PREVRI/-100000/, ICOUNT/0/,
     *          IACT/0/,     ILIVE/1/
cmam  DATA      INBUF1/12128*0/,   LHDR1/3000*0/,   INBUF2/12128*0/,
cmam *          LHDR2/3000*0/,     OUTBUF/6064*0.0/,R4WRK3/6000*0.0/
C
C$$$$        LOGICAL UNIT INITIALIZATION   (MUST BE CHANGED BETWEEN
C$$$$          FOR INPUT AND OUTPUT TAPES  ( P/E AND IBM)
C
      DATA      LUIN1/7/,    LUIN2/9/,    LUOUT/8/
      DATA	pipe/3/
C$$$  DATA      LUIN1/14/,   LUIN2/34/,   LUOUT/24/
C***
C***
C***
C***
C***
cc       check for help flag
      query = ( argis ( '-?' ) .gt. 0 )
      if ( query ) then
         call help()
         stop
      endif
cmam......080790.......initial character variables here
	mx = 0
	name='AGCA '
	agca1='1AGCA'
	job='       '
        hlhmul='AGCA(APPLY MULTIPLIER)'
	hlhdiv='AGCA(APPLY INVERSE OF MULTIPLIER)'
	HLHADD='AGCA(ADD OPTION)'
	hlhsub='AGCA(SUBTRATION OPTION)'
	ititle=' '
	ititle(13:52)='  APPLY PREVIOUSLY CALCULATED AGC CURVE '
	IPRINT = LERR
	IREADR = LUCARD
cmam...
#include <f77/open.h>
 
      call gcmdln (ntap1, ntap2, otap, cardin, kmode, ktype, knum,
     *             xmode, xtype, xnum, cflag, verbos, IREADR)
	if(verbos) then
      		CALL GAMOCO   (ITITLE,1,IPRINT)
	endif
cmam..........80290.................
      call getln (LUIN1, ntap1, 'r', 0)

cprg.... pipe-in facility for IKP ..............112190......
      if (ntap2(1:1) .ne. ' ') then
          call getln (LUIN2, ntap2, 'r', -1)
      else
          write(LERR,*)'agca assumed to be running inside IKP'
          call sisfdfit (luin2, pipe)
      endif
      if (luin2 .lt. 0) then
         write(LERR,*)'agca:  error opening gain curve data set'
         write(LERR,*)'Check existence of this data file'
         stop
      endif
cmam............open output dataset.............081390......
	call getln(LUOUT, otap, 'w', 1)
cmam........................................................
cccc  CALL LBOPEN   (LUIN1,LUIN2,LUOUT)
cmam................................
C
C****     READ LINE HEADER FROM OPERAND TAPE(#1), CHECK EOF
C
      CALL RTAPE    (LUIN1,LHDR1,LHCNT1)
C
      IF (LHCNT1 .GT. 0)    GO TO 110
C
      CC = 100
	mx = 100
      WRITE  (IPRINT,100)
  100 FORMAT ('0',
     *         T15,'** M0100 **  ERROR DETECTED BY PROGRAM AGCA',/,
     *         T27,'NO LINE HEADER FOUND ON OPERAND TAPE(#1),',/,
     *         T27,'INPUT DATA SET IS EMPTY.')
C
C****     READ LINE HEADER FROM OPERATOR TAPE(#2), CHECK EOF
C
  110 CALL RTAPE    (LUIN2,LHDR2,LHCNT2)
C
      IF (LHCNT2 .GT. 0)    GO TO 130
C
      CC = 100
	mx = 120
      WRITE  (IPRINT,120)
  120 FORMAT ('0',
     *         T15,'** M0120 **  ERROR DETECTED BY PROGRAM AGCA',/,
     *         T27,'NO LINE HEADER FOUND ON OPERATOR TAPE(#2),',/,
     *         T27,'INPUT DATA SET IS EMPTY.')
C
C****     READ FIRST CARD FROM READER
C
cmam......determine if we need to read card images........
c
  130 continue
     	if(xmode) then
		if(xtype) then
			if(ktype.eq.0) go to 145
			if(ktype.eq.1 .and. xnum) go to 145
cmam??????			go to 130
		endif
	endif
cmam......................................................
cmam......make certain a file is available..........
     	if(cflag) then
CMAM  130	if(cflag) then
      READ   (IREADR,140,END=8888)
cmam  130 READ   (IREADR,140,END=8888)
     *        KARD,NAME,MODE,ITYPE,IRIS,ITRS,NUM,JOB,LRI
  140 FORMAT (A80,T1,A5,I1,3X,I1,I4,I3,I4,47X,A7,1X,I4)
cmam  140 FORMAT (40A2,T1,A5,I1,3X,I1,I4,I3,I4,47X,A7,1X,I4)
	else
		go to 8888
	endif
cmam.....get proper parameters....................
  145	continue
	if(xmode) mode = kmode
	if(xtype) itype = ktype
	if(xnum) num = knum
cmam..............................................
C
C****      UPDATE LINE HEADER BUFFER AND WRITE TO SYSOUT(HLH),
C****        START ACCOUNTING
C
      IF (LHCNT1 .EQ. 0)  GO TO 160
      WRITE  (IPRINT,150)
  150 FORMAT ('0',
     *         T32,'** M0220 **   NTP1 LINE HEADER'//)
cmam............080690..........new call specifies unit............
cmam  IF (MODE .EQ. 0)   CALL HLH      (LHDR1,LHCNT1,HLHMUL,22)
cmam  IF (MODE .EQ. 1)   CALL HLH      (LHDR1,LHCNT1,HLHDIV,33)
cmam  IF (MODE .EQ. 2)   CALL HLH      (LHDR1,LHCNT1,HLHADD,15)
cmam  IF (MODE .EQ. 3)   CALL HLH      (LHDR1,LHCNT1,HLHSUB,23)
      IF (MODE .EQ. 0)   CALL HLHPRT   (LHDR1,LHCNT1,HLHMUL,22,IPRINT)
      IF (MODE .EQ. 1)   CALL HLHPRT   (LHDR1,LHCNT1,HLHDIV,33,IPRINT)
      IF (MODE .EQ. 2)   CALL HLHPRT   (LHDR1,LHCNT1,HLHADD,15,IPRINT)
      IF (MODE .EQ. 3)   CALL HLHPRT   (LHDR1,LHCNT1,HLHSUB,23,IPRINT)
      IACT = 1
cmam  CALL NACCT    ('AGCA',LHDR1,CHARGE)
  160 IF (LHCNT2 .EQ. 0) GO TO 9999
      WRITE  (IPRINT,170)
  170 FORMAT ('0',
     *         T32,'** M0230 **   NTP2 LINE HEADER'//)
cmam..can't see what this is for...  CALL HLH      (LHDR2,LHCNT2,HLHNT2,4)
      IF(CC .GT. 0) GO TO 9999
C
cmam 080290...........................................................
      call saver (LHDR1, 'NumSmp', NOSMP1 , LINHED )
      call saver (LHDR1, 'SmpInt', nsi1   , LINHED )
      call saver (LHDR1, 'NumTrc', NOTRC1 , LINHED )
      call saver (LHDR1, 'NumRec', NOREC1 , LINHED )
      call saver (LHDR1, 'Format', IFRMT1 , LINHED )
      call saver (LHDR1, 'UnitSc', unitsc , LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(LHDR1, 'UnitSc', unitsc, LINHED)
      endif
      call saver (LHDR2, 'NumSmp', NOSMP2 , LINHED )
      call saver (LHDR2, 'SmpInt', nsi2   , LINHED )
      call saver (LHDR2, 'NumTrc', NOTRC2 , LINHED )
      call saver (LHDR2, 'NumRec', NOREC2 , LINHED )
      call saver (LHDR2, 'Format', IFRMT2 , LINHED )
cmam 080290...........................................................
 
cccc  NOREC1 = I4WRK1(14)
cccc  NOTRC1 = I4WRK1(13)
cccc  NOSMP1 = I4WRK1(16)
cccc  IFRMT1 = LHDR1(33)
cccc  NOREC2 = I4WRK2(14)
cccc  NOTRC2 = I4WRK2(13)
cccc  NOSMP2 = I4WRK2(16)
cccc  IFRMT2 = LHDR2(33)
C
      call savew (LHDR1, 'Format', 3 , LINHED )
cccc  LHDR1(33) = 3
cmam 080290...........................................................
C
C****      WRITE OUT NEW LINE HEADER
C
      CALL WRTAPE   (LUOUT,LHDR1,LHCNT1)
C
C****     WRITE OUT CARD READ
C
      CALL WRCARD   (KARD,1,IPRINT)
C
C****     GET JOB NUMBER FROM LINE HEADER
C
cmam........080690.......don't need to check job number........
cmam  CALL MOVE     (1,LH1JOB,L1WRK1(41),8)
cmam...........................................................
C
C****     CHECK INPUT FORMAT. MUST BE 1 OR 3
C
cmam.....080990....only allow format 3
	if(ifrmt1 .eq. 3) go to 190
cmam  IF (IFRMT1 .EQ. 1 .OR. IFRMT1 .EQ. 3)    GO TO 190
C
      CC = 100
	mx = 180
      WRITE  (IPRINT,180) IFRMT1
  180 FORMAT ('0',
     *         T15,'** M0110 **  ERROR DETECTED BY PROGRAM AGCA',/,
     *         T27,'INPUT FORMAT CODE FROM THE OPERAND TAPE(#1) ',
     *             'LINE HEADER IS ',I2,/,
     *         T27,'VALID FORMAT IS 3.')
cmam *         T27,'VALID FORMATS ARE 1 AND 3.')
cmam.....080990....only allow format 3
  190	if(ifrmt2 .eq. 3) go to 230
cmam  190 IF (IFRMT2 .EQ. 1 .OR. IFRMT2 .EQ. 3)    GO TO 210
C
      CC = 100
	mx = 200
      WRITE  (IPRINT,200) IFRMT2
  200 FORMAT ('0',
     *         T15,'** M0130 **  ERROR DETECTED BY PROGRAM AGCA',/,
     *         T27,'INPUT FORMAT CODE FROM THE OPERATOR TAPE(#1) ',
     *             'LINE HEADER IS ',I2,/,
     *         T27,'VALID FORMAT IS 3.')
cmam *         T27,'VALID FORMATS ARE 1 AND 3.')
cmam.....080990...we don't need to check the card type!!!!!.....
cmam..........delete the stuff here.............................
C
C****       CHECK FOR VALID TYPE APPLICATION
C
  230 IF (ITYPE .GE. 0 .AND. ITYPE .LE. 2)    GO TO 250
C
      CC = 100
	mx = 240
      WRITE  (IPRINT,240) ITYPE
  240 FORMAT ('0',
     *         T15,'** M0150 **  ERROR DETECTED BY PROGRAM AGCA',/,
     *         T27,'THE APPLICATION TYPE SPECIFIED ',
     *             'ON THE INPUT CARD IS ',I4,/,
     *         T27,'THE VALID APPLICATION TYPES ARE: (0, 1, 2)')
C
      IF (LRI .EQ. 0 .OR. ITYPE .NE. 2)     LRI = 99999
C
C****       CHECK FOR NUMBER OF OPERAND TRACES PER OPERATOR TRACE
C****             (TYPE 1 ONLY)
C
  250 IF (ITYPE .NE. 1)    GO TO 290
      IF (NUM .GT. 0)    GO TO 260
      GO TO 270
  260 ICHECK = NOTRC1 * NOREC1 / NUM
      IF (ICHECK .LE. NOREC2)    GO TO 290
  270 WRITE  (IPRINT,280) NUM
  280 FORMAT ('0',
     *         T15,'** M0160 **  ERROR DETECTED BY PROGRAM AGCA',/,
     *         T27,'THE NUMBER OF OPERAND TRACES PER OPERATOR TRACE ',/,
     *         T27,'SPECIFIED ON THE INPUT CARD ',I4,/,
     *         T27,'IS INVALID')
      CC = 100
	mx = 280
C
C****       CHECK FOR VALID MODE
C
  290 IF (MODE .GE. 0 .AND. MODE .LE. 3)    GO TO 310
C
      CC = 100
	mx = 300
      WRITE  (IPRINT,300) MODE
  300 FORMAT ('0',
     *         T15,'** M0170 **  ERROR DETECTED BY PROGRAM AGCA',/,
     *         T27,'THE MODE SPECIFIED ON THE INPUT CARD IS ',I4,/,
     *         T27,'THE VALID MODES ARE: (0, 1, 2, 3)')
C
C****       CHECK FOR VALID JOB NUMBER
C
  310 ICC = 0
cmam.............080690.....don't need to check job number........
cmam  CALL JOBCHK (JOB,LH1JOB,IPRINT,ICC)
cmam  IF (ICC .EQ. 0)    GO TO 320
cmam  CC = 100
cmam..............................................................
C
C****       CHECK FOR VALID RECORD, TRACE AND LAST RECORD NUMBERS
C****          (TYPE 2 ONLY)
C
  320 IF (ITYPE .NE. 2)   GO TO 380
      IF (IRIS .GE. 0)     GO TO 340
      CC = 100
	mx = 330
      WRITE  (IPRINT,330) IRIS
  330 FORMAT ('0',
     *         T15,'** M0190 **  ERROR DETECTED BY PROGRAM AGCA',/,
     *         T27,'THE RECORD NUMBER FROM THE INPUT CARD IS ',I5,/,
     *         T27,'THE RECORD NUMBER CANNOT BE NEGATIVE')
  340 IF (ITRS .GE. 0)    GO TO 360
      CC = 100
	mx = 350
      WRITE  (IPRINT,350) ITRS
  350 FORMAT ('0',
     *         T15,'** M0200 **  ERROR DETECTED BY PROGRAM AGCA',/,
     *         T27,'THE TRACE NUMBER FROM THE INPUT CARD IS ',I5,/,
     *         T27,'THE TRACE NUMBER CANNOT BE NEGATIVE')
  360 IF (LRI .GE. 0)     GO TO 380
      CC = 100
	mx = 370
      WRITE  (IPRINT,370) LRI
  370 FORMAT ('0',
     *         T15,'** M0210 **  ERROR DETECTED BY PROGRAM AGCA',/,
     *         T27,'THE LAST RECORD NUMBER FROM THE INPUT CARD IS',I6,/,
     *         T27,'THE LAST RECORD NUMBER CANNOT BE NEGATIVE')
C
C****     READ FIRST TRACE FROM OPERAND TAPE(#1), AND CHECK FOR EOF
C
  380 CALL RTAPE    (LUIN1,INBUF1,IN1CNT)
      IF (IN1CNT .GT. 0)    GO TO 400
C
      CC = 100
	mx = 390
      WRITE  (IPRINT,390)
  390 FORMAT ('0',
     *         T15,'** M0240 **  ERROR DETECTED BY PROGRAM AGCA',/,
     *         T27,'NO TRACES FOUND ON OPERAND TAPE(#1),',/,
     *         T27,'INPUT DATA SET IS EMPTY PAST THE LINE HEADER.')
      GO TO 410
C
C****     GET RECORD NUMBER AND TRACE NUMBER FROM TRACE HEADER
C
  400 call saver(INBUF1,'RecNum', IN1RIS, TRCHED)
cmam  400 IN1RIS = INBUF1(106)
C
C****     READ FIRST TRACE FROM OPERATOR TAPE(#2), AND CHECK FOR EOF
C
  410 CALL RTAPE    (LUIN2,INBUF2,IN2CNT)
      IF (IN2CNT .GT. 0)    GO TO 430
C
      CC = 100
	mx = 420
      WRITE  (IPRINT,420)
  420 FORMAT ('0',
     *         T15,'** M0250 **  ERROR DETECTED BY PROGRAM AGCA',/,
     *         T27,'NO TRACES FOUND ON OPERATOR TAPE(#2),',/,
     *         T27,'INPUT DATA SET IS EMPTY PAST THE LINE HEADER.')
C
C
  430 IF (CC .GT. 0)    GO TO 9999
C
C****        MODE = 0, MULTIPLY OPTION = 3
C
      IF (MODE .EQ. 0)    IOPTN = 3
C
C****        MODE = 1, DIVIDE OPTION = 4
C
      IF (MODE .EQ. 1)    IOPTN = 4
C
C****        MODE = 2, ADD OPTION = 1
C
      IF (MODE .EQ. 2)    IOPTN = 1
C
C****        MODE = 3, SUBTRACT OPTION = 2
C
      IF (MODE .EQ. 3)    IOPTN = 2
C
C****        DETERMINE MAIN PROCESSING LOOP DEPENDING ON INPUT FORMATS
C****        AND TYPE APPLICATION REQUESTED.(FORMAT 1 DATA  WILL BE -
C****                                    - CONVERTED TO FORMAT 3 DATA)
C
cmam....080990....only format 3 data is allowed .. remove references to
cmam................format 1 data...................................
	if(itype.eq.1) go to 4000
cmam  IF (ITYPE .EQ. 1 .AND.
cmam *    IFRMT1 .EQ. 3 .AND.
cmam *    IFRMT2 .EQ. 3)   GO TO 4000
	if(itype.eq.0) go to 4500
cmam  IF (ITYPE .EQ. 0 .AND.
cmam *    IFRMT1 .EQ. 3 .AND.
cmam *    IFRMT2 .EQ. 3)   GO TO 4500
	if(itype.eq.2) go to 5000
cmam  IF (ITYPE .EQ. 2 .AND.
cmam *    IFRMT1 .EQ. 3 .AND.
cmam *    IFRMT2 .EQ. 3)   GO TO 5000
C
C       THIS TEST SHOULD NEVER BE EXECUTED BECAUSE OF PREVIOUS CHECKS
C         ON TYPE AND FORMATS.  IF MESSAGE IS WRITTEN OUT THEN PREVIOUS
C         LOGIC MUST HAVE A PROBLEM.
C
      WRITE (IPRINT,450) ITYPE,IFRMT1,IFRMT2
  450 FORMAT ('0',
     *         T15,'** M0260 **  ERROR DETECTED BY PROGRAM AGCA',/,
     *         T27,'ONE OF THE FOLLOWING IS INVALID.',/,
     *         T27,'TYPE APPLICATION',I5,/,
     *         T27,'OPERAND FORMAT',I5,/,
     *         T27,'OPERATOR FORMAT',I5,/,
     *         T27,'NOTIFY RESPONSIBLE USER REPRESENTATIVE')
      CC = 100
	mx = 450
      GO TO 9999
cmam.....080990.....remove all the code that deals with format 1
C
C    ***********
C    /////////  LOOP FOR TYPE 1, OPERAND  AND OPERATOR FORMAT 3
C    ***********
C
C****        MAJOR OUTLINE OF PROCESSING LOGIC IN THIS LOOP:
C****          1.  CHECK FOR DEAD OPERAND TRACE
C****          2.  PERFORM DESIRED OPERATION (ARITFP, PARM. IOPTN IS
C****                              SET DEPENDING ON INPUT CARD PARM.)
C****          3.  WRITE OUTPUT TRACE
C****          4.  READ NEXT OPERAND TRACE / CHECK FOR EOF
C****          5.  READ NEXT OPERATOR TRACE / CHECK FOR EOF
C
 4000 KBYTES = IN1CNT
      ICOUNT = ICOUNT + 1
	call saver(INBUF1, 'StaCor', isc1, TRCHED)
	call saver(INBUF2, 'StaCor', isc2, TRCHED)
	if(isc1 .eq. 30000 .or. isc2 .eq. 30000)
cmam  IF (INBUF1(125) .EQ. 30000 .OR. INBUF2(125) .EQ. 30000)
     *    CALL DEADTR (LUOUT,IOPTN,KBYTES,INBUF1,INBUF2,ILIVE)
      IF (ILIVE .EQ. 0)    GO TO 4040
C
C****        IF MODE IS DIVIDE THEN CHECK FOR ZERO DIVIDE.
C
cmam....081090...replace aritfp with mathadvantage calls........
c...............................................................
 4030	if(IOPTN.eq.1) then
	   call vadd(R4WRK1,1,R4WRK2,1,OUTBUF(ITHWP1),1,NOSMP1)
	elseif(IOPTN.eq.2) then
	   call vsub(R4WRK1,1,R4WRK2,1,OUTBUF(ITHWP1),1,NOSMP1)
	elseif(IOPTN.eq.3) then
	   call vmul(R4WRK1,1,R4WRK2,1,OUTBUF(ITHWP1),1,NOSMP1)
	else
  	   call vdivz(R4WRK1,1,R4WRK2,1,0.,OUTBUF(ITHWP1),1,NOSMP1)
	endif
cmam  IF (IOPTN .EQ. 4)    CALL ZEROCK(R4WRK1,R4WRK2,NOSMP1)
C
cmam 4030 CALL ARITFP    (R4WRK1,R4WRK2,OUTBUF(65),NOSMP1,IOPTN)
c...............................................................
      CALL MOVE     (1,OUTBUF,INBUF1,128*SZHFWD)
cmam  CALL MOVE     (1,OUTBUF,INBUF1,256)
      CALL WRTAPE   (LUOUT,OUTBUF,KBYTES)
 4040 ILIVE = 1
      IF (IN1RIS .EQ. PREVRI)     GO TO 4050
      CALL RIPRNT(IN1RIS,IPRINT)
      PREVRI = IN1RIS
      RECCNT = RECCNT + 1
 4050 IN1CNT = 0
      CALL RTAPE    (LUIN1,INBUF1,IN1CNT)
	call saver(INBUF1, 'RecNum', IN1RIS, TRCHED)
cmam  IN1RIS = INBUF1(106)
      IF (IN1CNT .EQ. 0)    GO TO 8910
      IF (ICOUNT .LT. NUM)    GO TO 4000
      ICOUNT = 0
      IN2CNT = 0
      CALL RTAPE    (LUIN2,INBUF2,IN2CNT)
      IF (IN2CNT .EQ. 0)    GO TO 8950
C
      GO TO 4000
C
C
C
C
C    ***********
C    /////////  LOOP FOR TYPE 0, OPERAND  AND OPERATOR FORMAT 3
C    ***********
C
C****        MAJOR OUTLINE OF PROCESSING LOGIC IN THIS LOOP:
C****          1.  CHECK FOR DEAD OPERAND TRACE
C****          2.  PERFORM DESIRED OPERATION (ARITFP, PARM. IOPTN IS
C****                              SET DEPENDING ON INPUT CARD PARM.)
C****          3.  WRITE OUTPUT TRACE
C****          4.  READ NEXT OPERAND TRACE / CHECK FOR EOF
C****          5.  READ NEXT OPERATOR TRACE / CHECK FOR EOF
C
 4500 KBYTES = IN1CNT
	call saver(INBUF1, 'StaCor', isc1, TRCHED)
	call saver(INBUF2, 'StaCor', isc2, TRCHED)
	if(isc1 .eq. 30000 .or. isc2 .eq. 30000)
cmam  IF (INBUF1(125) .EQ. 30000 .OR. INBUF2(125) .EQ. 30000)
     *    CALL DEADTR (LUOUT,IOPTN,KBYTES,INBUF1,INBUF2,ILIVE)
      IF (ILIVE .EQ. 0)    GO TO 4540
C
C****        IF MODE IS DIVIDE THEN CHECK FOR ZERO DIVIDE.
C
cmam....081090...replace aritfp with mathadvantage calls........
c...............................................................
 4530	if(IOPTN.eq.1) then
	   call vadd(R4WRK1,1,R4WRK2,1,OUTBUF(ITHWP1),1,NOSMP1)
	elseif(IOPTN.eq.2) then
	   call vsub(R4WRK1,1,R4WRK2,1,OUTBUF(ITHWP1),1,NOSMP1)
	elseif(IOPTN.eq.3) then
	   call vmul(R4WRK1,1,R4WRK2,1,OUTBUF(ITHWP1),1,NOSMP1)
	else
  	   call vdivz(R4WRK1,1,R4WRK2,1,0.,OUTBUF(ITHWP1),1,NOSMP1)
	endif
cmam  IF (IOPTN .EQ. 4)    CALL ZEROCK(R4WRK1,R4WRK2,NOSMP1)
C
cmam 4530 CALL ARITFP    (R4WRK1,R4WRK2,OUTBUF(65),NOSMP1,IOPTN)
c...............................................................
      CALL MOVE     (1,OUTBUF,INBUF1,128*SZHFWD)
cmam  CALL MOVE     (1,OUTBUF,INBUF1,256)
      CALL WRTAPE   (LUOUT,OUTBUF,KBYTES)
 4540 ILIVE = 1
      IF (IN1RIS .EQ. PREVRI)     GO TO 4550
      CALL RIPRNT(IN1RIS,IPRINT)
      PREVRI = IN1RIS
      RECCNT = RECCNT + 1
 4550 IN1CNT = 0
      CALL RTAPE    (LUIN1,INBUF1,IN1CNT)
	call saver(INBUF1, 'RecNum', IN1RIS, TRCHED)
cmam  IN1RIS = INBUF1(106)
      IF (IN1CNT .EQ. 0)    GO TO 8910
      IN2CNT = 0
      CALL RTAPE    (LUIN2,INBUF2,IN2CNT)
      IF (IN2CNT .EQ. 0)    GO TO 8950
C
      GO TO 4500
C
C
C
C
C    ***********
C    /////////  LOOP FOR TYPE 2, OPERAND & OPERATOR FORMAT 3
C    ***********
C
C****        MAJOR OUTLINE OF PROCESSING LOGIC IN THIS LOOP:
C****          1.  SELECT CORRECT RECORD AND TRACE NUMBER FROM OPERATOR
C****                 TAPE
C****          2.  CHECK FOR DEAD OPERAND TRACE
C****          3.  PERFORM DESIRED OPERATION (ARITFP, PARM. IOPTN IS
C****                              SET DEPENDING ON INPUT CARD PARM.)
C****          4.  WRITE OUTPUT TRACE
C****          5.  READ NEXT OPERAND TRACE / CHECK FOR EOF
C****          6.  READ NEXT INPUT CARD
C****                 AND RESET PARAMETERS (IRIS,ITRS,LRI)
C****          7.  READ NEXT OPERATOR TRACE / CHECK FOR EOF
C
 5000 KBYTES = IN1CNT
	call saver(INBUF2, 'RecNum', ir2, TRCHED)
	call saver(INBUF2, 'TrcNum', it2, TRCHED)
	if(ir2 .eq. IRIS .and. it2 .eq. ITRS) go to 5020
cmam  IF (INBUF2(106) .EQ. IRIS .AND. INBUF2(107) .EQ. ITRS) GO TO 5020
      IN2CNT = 0
      CALL RTAPE    (LUIN2,INBUF2,IN2CNT)
      IF (IN2CNT .NE. 0)     GO TO 5000
C
      CC = 100
	mx = 5010
      WRITE  (IPRINT,5010) IRIS,ITRS
 5010 FORMAT ('0',
     *         T15,'** M0300 **  ERROR DETECTED BY PROGRAM AGCA',/,
     *         T27,'OPERATOR TAPE(#2) REACHED END OF FILE WHILE',/,
     *         T27,'LOOKING FOR RI ',I5,' AND TRACE ',I5)
      GO TO 9999
 5020	call saver(INBUF1, 'StaCor', isc1, TRCHED)
	call saver(INBUF2, 'StaCor', isc2, TRCHED)
	if(isc1 .eq. 30000 .or. isc2 .eq. 30000)
cmam 5020 IF (INBUF1(125) .EQ. 30000 .OR. INBUF2(125) .EQ. 30000)
     *    CALL DEADTR (LUOUT,IOPTN,KBYTES,INBUF1,INBUF2,ILIVE)
      IF (ILIVE .EQ. 0)    GO TO 5040
C
C****        IF MODE IS DIVIDE THEN CHECK FOR ZERO DIVIDE.
C
cmam....081090...replace aritfp with mathadvantage calls........
c...............................................................
 5030	if(IOPTN.eq.1) then
	   call vadd(R4WRK1,1,R4WRK2,1,OUTBUF(ITHWP1),1,NOSMP1)
	elseif(IOPTN.eq.2) then
	   call vsub(R4WRK1,1,R4WRK2,1,OUTBUF(ITHWP1),1,NOSMP1)
	elseif(IOPTN.eq.3) then
	   call vmul(R4WRK1,1,R4WRK2,1,OUTBUF(ITHWP1),1,NOSMP1)
	else
  	   call vdivz(R4WRK1,1,R4WRK2,1,0.,OUTBUF(ITHWP1),1,NOSMP1)
	endif
cmam  IF (IOPTN .EQ. 4)    CALL ZEROCK(R4WRK1,R4WRK2,NOSMP1)
C
cmam 5030 CALL ARITFP   (R4WRK1,R4WRK2,OUTBUF(65),NOSMP1,IOPTN)
c...............................................................
      CALL MOVE     (1,OUTBUF,INBUF1,128*SZHFWD)
cmam  CALL MOVE     (1,OUTBUF,INBUF1,256)
      CALL WRTAPE   (LUOUT,OUTBUF,KBYTES)
 5040 ILIVE = 1
      IF (IN1RIS .EQ. PREVRI)    GO TO 5050
      CALL RIPRNT(IN1RIS,IPRINT)
      PREVRI = IN1RIS
      RECCNT = RECCNT + 1
 5050 IN1CNT = 0
      CALL RTAPE    (LUIN1,INBUF1,IN1CNT)
	call saver(INBUF1, 'RecNum', IN1RIS, TRCHED)
cmam  IN1RIS = INBUF1(106)
      IF (IN1CNT .EQ. 0)    GO TO 8910
	if(IN1RIS .le. LRI) go to 5000
cmam  IF (INBUF1(106) .LE. LRI)    GO TO 5000
      CALL RICLR(IPRINT)
      READ   (IREADR,5080,END=5090) KARD,IRIS,ITRS,LRI
 5080 FORMAT (A80,T1,10X,I4,I3,59X,I4)
cmam 5080 FORMAT (40A2,T1,10X,I4,I3,59X,I4)
      CALL WRCARD   (KARD,1,IPRINT)
      IF (LRI .EQ. 0)    LRI = 99999
      GO TO 5100
 5090 LRI = 99999
      GO TO 5000
 5100 IN2CNT = 0
      CALL RTAPE    (LUIN2,INBUF2,IN2CNT)
      IF (IN2CNT .EQ. 0)    GO TO 8950
C
      GO TO 5000
C
C
C
 8888 WRITE  (IPRINT,8900)
 8900 FORMAT ('0',
     *         T15,'** M0310 **  ERROR DETECTED BY PROGRAM AGCA',/,
     *         T27,'NO INPUT CARD FOUND.  A 1AGCA CARD IS REQUIRED.')
      GO TO 9999
C
 8910 WRITE  (IPRINT,8920)
 8920 FORMAT ('0',
     *         T15,'** M0320 **  MESSAGE FROM PROGRAM AGCA',/,
     *         T27,'END OF FILE ON OPERAND TAPE(#1)')
      GO TO 9999
C
 8950 WRITE  (IPRINT,8960)
 8960 FORMAT ('0',
     *         T15,'** M0330 **  ERROR DETECTED BY PROGRAM AGCA',/,
     *         T27,'END OF FILE ON OPERATOR TAPE(#2) BEFORE',/,
     *         T27,'END OF FILE ON OPERAND TAPE(#1)',/,
     *         T27,'POSSIBLE LINE HEADER ERROR AND SHORT RECORD MAY',/,
     *         T27,'BE WRITTEN ON OUTPUT TAPE')
C
C
 9999 IF (RECCNT .NE. 0)    CALL RICLR(IPRINT)
	call lbclos (luout)
	call lbclos (luin1)
	call lbclos (luin2)
cmam  CALL LBCLOS   (LUOUT,LUIN1,LUIN2)
cmam  IF (IACT .EQ. 1)   CALL NACCT2   (RECCNT)
      CALL CCEXIT   (CC)
      STOP
      END
C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       DEADTR                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      DEADTR  (LUOUT,IOPTN,KBYTES,INBUF1,INBUF2,ILIVE)                *
C  ARGUMENTS:                                                          *
C      LUOUT   INTEGER  ??IOU*      -                                  *
C      IOPTN   INTEGER  ??IOU*      -                                  *
C      KBYTES  INTEGER  ??IOU*      -                                  *
C      INBUF1  INTEGER  ??IOU*  (*) -                                  *
C      INBUF2  INTEGER  ??IOU*  (*) -                                  *
C      ILIVE   INTEGER  ??IOU*      -                                  *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 90/08/09  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 90/10/12  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      SAVER  -                                                        *
C      MOVE   -                                                        *
C      SAVEW  -                                                        *
C      WRTAPE -                                                        *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:            NONE                                              *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      SUBROUTINE DEADTR (LUOUT,IOPTN,KBYTES,INBUF1,INBUF2,ILIVE)
C***********************************************************************
C
C     SUBROUTINE - DEADTR                ENTRY POINT(S) - DEADTR
C
C     LANGUAGE - FORTRAN
C
C     SYSTEM(S) - IBM/PE
C
C     AUTHOR - S. G. ROSE
C
C     DATE WRITTEN - 3/05/84
C
C     AMOCO PRODUCTION CO. PROPRIETARY - TO BE MAINTAINED IN CONFIDENCE
C
C     ABSTRACT -    THIS SUBROUTINE CHECKS THE DEAD FLAGS OF BOTH INPUT
C                     TRACES AND DETERMINES THE OUTPUT BASED ON THE MODE
C                     AND THE DEAD TRACE FLAG VALUES.  IF THE OUTPUT
C                     IS DEAD THE TRACE IS WRITTEN OTHERWISE THE
C                     ILIVE FLAG IS TURNED ON AND CONTROL PASSES BACK
C                     TO THE CALLING ROUTINE.
C
C
C     USAGE
C
C         CALL DEADTR (LUOUT,IOPTN,KBYTES,INBUF1,INBUF2,ILIVE)
C
C          LUOUT (FT08001) - OUT- RESULTANT WORKTAPE.
C          KBYTES - BYTE COUNT FOR OUTPUT TRACES.
C          INBUF1 - INPUT BUFFER FOR OPERAND TRACES.
C          INBUF2 - INPUT BUFFER FOR OPERATOR TRACES.
C          ILIVE  - FLAG FOR DEADTR SUBROUTINE TO INDICATE IF OUTPUT
C                   TRACE IS LIVE OR DEAD. 0=DEAD 1=LIVE.
C          IOPTN  - OPTION PARM. FOR SUBROUTINE ARITFP.
C
C    SUBROUTINES CALLED - ENTER THE NAMES OF THE ROUTINES
C               THAT MUST BE INCLUDED IN THE LINK.
C          WRTAPE
C
C***********************************************************************
C
C     MODIFICATION HISTORY - DATE, EXPLANATION OF CHANGE
C                            AND PROGRAMMER NAME.
C
C***********************************************************************
C
C
C
C
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
 
      INTEGER INBUF1(*), INBUF2(*)
cmam  INTEGER*2 INBUF1(12128),    INBUF2(12128)
C
C
	IBYTES = KBYTES - szhfwd*128
cmam  IBYTES = KBYTES - 256
      ILIVE = 0
C
C***********************************************************************
C                IF BOTH TRACES ARE DEAD THEN OUTPUT IS DEAD.
C                IF MODE IS MULTIPLY OR DIVIDE OUTPUT IS DEAD.
C***********************************************************************
C
	call saver(INBUF1,'StaCor',isc1,TRCHED)
	call saver(INBUF2,'StaCor',isc2,TRCHED)
	if(isc1 .eq. 30000 .and. isc2 .eq. 30000) go to 200
cmam  IF (INBUF1(125) .EQ. 30000 .AND. INBUF2(125) .EQ. 30000) GO TO 200
      IF (IOPTN .EQ. 4)    GO TO 200
      IF (IOPTN .EQ. 3)    GO TO 200
C
C***********************************************************************
C                ADD AND SUBTRACT FOLLOW
C***********************************************************************
C***********************************************************************
C                IF FIRST TRACE IS LIVE THEN  OUTPUT IT WITHOUT SCALE.
C***********************************************************************
C
	if(isc1 .eq. 30000) go to 100
cmam  IF (INBUF1(125) .EQ. 30000)   GO TO 100
      GO TO 900
C
C***********************************************************************
C                IF FIRST TRACE IS DEAD THEN ZERO FIRST TRACE DATA
C                   TURN ON LIVE OUTPUT FLAG AND RETURN.
C***********************************************************************
C
  100 CALL MOVE (1,INBUF1(ITHWP1),INBUF2(ITHWP1),IBYTES)
	call savew(INBUF1,'StaCor',0,TRCHED)
cmam  INBUF1(125) = 0
      GO TO 900
C
C***********************************************************************
C                DEAD OUTPUT TRACE SECTION.
C***********************************************************************
C
  200	call savew(INBUF1,'StaCor',30000,TRCHED)
cmam  200 INBUF1(125) = 30000
      CALL MOVE (0,INBUF1(ITHWP1),0,IBYTES)
cmam  CALL MOVE (0,INBUF1(129),0,IBYTES)
  900 CALL WRTAPE (LUOUT,INBUF1,KBYTES)
C
      RETURN
      END
