C***********************************************************************
C                                                                      *
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
C***********************************************************************
C  ROUTINE:       GCMDLN                                               *
C  ROUTINE TYPE:  SUBROUTINE                                           *
C  PURPOSE:  ???                                                       *
C  ENTRY POINTS:                                                       *
C      GCMDLN  (NTAP1,NTAP2,OTAP,CARDIN,MODE,ITYPE,INUM,XMODE,XTYPE,   *
C               XNUM,CFLAG,VERBOS,IREADR)                              *
C  ARGUMENTS:                                                          *
C      NTAP1   CHAR*100  ??IOU* -                                      *
C      NTAP2   CHAR*100  ??IOU* -                                      *
C      OTAP    CHAR*100  ??IOU* -                                      *
C      CARDIN  CHAR*100  ??IOU* -                                      *
C      MODE    INTEGER   ??IOU* -                                      *
C      ITYPE   INTEGER   ??IOU* -                                      *
C      INUM    INTEGER   ??IOU* -                                      *
C      XMODE   LOGICAL   ??IOU* -                                      *
C      XTYPE   LOGICAL   ??IOU* -                                      *
C      XNUM    LOGICAL   ??IOU* -                                      *
C      CFLAG   LOGICAL   ??IOU* -                                      *
C      VERBOS  LOGICAL   ??IOU* -                                      *
C      IREADR  INTEGER   ??IOU* -                                      *
C       +------------------------------------------------------+       *
C       |               DEVELOPMENT INFORMATION                |       *
C       +------------------------------------------------------+       *
C  AUTHOR:   ???                                ORIGIN DATE: 90/08/09  *
C  LANGUAGE: FORTRAN 77                  DATE LAST COMPILED: 90/08/15  *
C       +------------------------------------------------------+       *
C       |                 EXTERNAL ENVIRONMENT                 |       *
C       +------------------------------------------------------+       *
C  ROUTINES CALLED:                                                    *
C      ARGIS   INTEGER -                                               *
C      ARGSTR          -                                               *
C      ARGI4           -                                               *
C      NOBLNK          -                                               *
C      COPEN   INTEGER -                                               *
C  INTRINSIC FUNCTIONS CALLED:  NONE                                   *
C  FILES:                                                              *
C      LER  ( OUTPUT SEQUENTIAL ) -                                    *
C  COMMON:           NONE                                              *
C  STOP CODES:       NONE                                              *
C       +------------------------------------------------------+       *
C       |             OTHER DOCUMENTATION DETAILS              |       *
C       +------------------------------------------------------+       *
C  ERROR HANDLING:  ???                                                *
C  GENERAL DESCRIPTION:  ???                                           *
C  REVISED BY:  ???                           REVISION DATE: ?Y/?M/?D  *
C       +------------------------------------------------------+       *
C       |                 ANALYSIS INFORMATION                 |       *
C       +------------------------------------------------------+       *
C  NONSTANDARD FEATURES:   NONE DETECTED                               *
C*******************   END OF DOCUMENTATION PACKAGE   ******************
C***********************************************************************
      subroutine gcmdln ( ntap1, ntap2, otap, cardin, mode, itype,
     *            inum, xmode, xtype, xnum, cflag, verbos, IREADR )
c     FORTRAN by M. A. Miller  08/02/90
c
c     this routine processes the command line arguments for use in
c     program AGCA on SUN/Cray2
c
#include <f77/iounit.h>
      character ntap1*(*), ntap2*(*), otap*(*), cardin*(*)
      logical     verbos, cflag
      logical	  xmode, xtype, xnum
      integer copen, argis, iflag
 
      mode = -1
      itype = -1
      inum = -1
	xmode = .false.
	xtype = .false.
	xnum = .false.
 
      verbos = .false.
 
      verbos = (argis('-V') .gt. 0)
      if(verbos) then
        write(LERR,*)' verbos is true'
      else
        write(LERR,*)' verbos is false'
      endif
 
      call argstr ('-N1',ntap1,' ',' ')
      call argstr ('-N2',ntap2,' ',' ')
      call argstr ('-O',otap,' ',' ')
	call argi4('-mode', mode, 0, -1)
	call argi4('-type', itype, 0, -1)
      if(verbos) then
      	write(LERR,*)' ntap1 as read=',ntap1
      	write(LERR,*)' ntap2 as read=',ntap2
      	write(LERR,*)' otap as read=',otap
  	 write(LERR,*)' mode as read=',mode
  	 write(LERR,*)' type as read=',itype
      endif
 
cmam................080290...............
c          get INUM
c.....................
	 call argi4 ('-num', inum, 0, -1)
   	 write(LERR,*)' num as read=',inum
cmam.....................................
 
	if(mode.ge.0) xmode = .true.
	if(itype.ge.0) xtype = .true.
c	if(num.ge.0) xnum = .true. - assuming num means inum - j.m.wade 8/20/92
	if(inum.ge.0) xnum = .true.
 
      cflag = .false.
cmam............080990.....................................
c		see if we need to open a card-input file
c
	write(LERR,*)' mode, itype, inum=', mode, itype, inum
	if(xmode .and. xtype) then
		if(itype.eq.0) then
			return
		elseif((itype.eq.1) .and. xnum) then
			return
		endif
	endif
cmam.......................................................
 
 
          call argstr ('-C',cardin,' ',' ')
          if(verbos) write(LERR,*)' cardin as read=',cardin
          call noblnk(cardin,lc)
 
        if(cardin(1:1) .ne. ' ') then
cmam..........a file name was given................
          if(verbos) write(LERR,*)' open(unit=IREADR, file=cardin) '
          open(unit=IREADR, file=cardin, status='old',
     *         form='formatted',access='sequential')
          rewind (IREADR)
        else
cmam.........no file name given, use -agca.crd inline......
          if(verbos) write(LERR,*)' iflag=copen( -agca.crd ,IREADR) '
          iflag = copen('-agca.crd',IREADR)
          if(verbos) write(LERR,*) ' iflag=',iflag
        endif
 
	cflag = .true.
 
      return
      end
 
