C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c --------------------- ahist ---------------------------
c     Program Changes:

c     Author: David L. Tett
c     Original written: November 8-13, 1995
c     as part of Codeslinger 100 class
c	
c	Modified by James M. Gridley
c	USP Team, Tulsa OK
c	Fall 1997

c     Program Description:
 
c     This program creates an amplitude histogram for a seismic data set.
c     The user specifies the bin min and max, and the number of bins.  The
c     output is a file suitable for input into xgraph.


c get machine dependent parameters 

#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <save_defs.h> 

c dimension standard USP variables 

      integer     itr ( SZLNHD )
     
      integer     nsamp, nsi, ntrc, nrec, iform
      integer     luin , luout, lbytes, nbytes
      integer     ist, iend, irs, ire, ns, ne, argis

      real        tri ( SZLNHD )

      character   ntap*255, otap*255, name*5
      logical     verbos
      character   hdrwd1 * 6, hdrwd2 * 6
c Program Specific _ static memory variables

      integer ifmt_StaCor,l_StaCor,ln_StaCor, StaCor

      integer nb, length, np(1001), totsmp, cumsmp
      integer lucum, reject

c     Explanation of variables
c       lb(i) = lower boundary of bin i
c       ub(i) = upper boundary of bin i
c       bs    = bin size
c       np(i) = number of points in bin i
c       totsmp = total number of samples in input data set
c       cumsmp = cumulative number of samples
c       cumfile = does user want file with cumulative pct.?
c       pct = cumulative percentage
c       absolute = Use absolute value of amplitude?-
c       retain = retain values outside of (min,max) in histogram?
c       reject = number of values that are thrown away if retain=false

      real minv, maxv, lb(1001), ub(1001), bs, pct

      logical cumfile, absolute, retain

      character HistTitle*19, CumTitle*22

      data abort/1/
      data name/"AHIST"/
      data luout/6/
      data lucum/90/
      data HistTitle/'"No. of Occurrences'/
      data CumTitle/'"Cumulative Percentage'/

c give command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c open printout file

#include <f77/open.h>

c get command line input parameters

      call cmdln ( ntap, otap, ns, ne, irs, ire, ist, iend, 
     :     name, nb, cumfile, absolute, retain, verbos,
     :     hdrwd1, hdrwd2, minv, maxv )

c open input and output files

      call getln(luin , ntap,'r', 0)
      length = lenth(otap)
      if ( otap(1:1) .ne. ' ' ) then
         open(luout,file=otap(1:length),status='unknown',err=990)
         if (cumfile) open (lucum, file=otap(1:length)//'.cum',
     :        status='unknown', err=991)
      else
         if (cumfile) open (lucum, file='ahist.cum', 
     :        status='unknown', err=991)

      endif

c  read input line header and save certain parameters

      call rtape(luin,itr,lbytes)
      if(lbytes.eq.0)then
         write(LER,*)'AHIST: no line header on input dataset ',ntap
         write(LER,*)'FATAL'
         stop
      endif

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'Format', iform, LINHED)

c define pointers to header words required by your routine

      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

      if (hdrwd1 .ne. '-99999') 
     :     call savelu(hdrwd1,ifmt_hdrwd1,l_hdrwd1,ln_hdrwd1,
     :     TRACEHEADER)

      if (hdrwd2 .ne. '-99999') 
     :     call savelu(hdrwd2,ifmt_hdrwd2,l_hdrwd2,ln_hdrwd2,
     :     TRACEHEADER)

c update historical line header and print to printout file 

c      call hlhprt (itr, lbytes, name, 5, LERR)

c check user-supplied boundary conditions and set defaults

      if ( irs .eq. 0 ) irs = 1
      if ( ire .eq. 0 .or. ire .gt. nrec ) ire = nrec
      if ( irs .gt. ire) then
         write(LERR,*)' '
         write(LERR,*)'-rs must be less than or equal to -re'
         write(LER,*)' '
         write(LER,*)'AHIST: -rs must be less than or equal to -re'
         write(LER,*)'FATAL'
         write(LER,*)' '
         go to 999
      endif
    
      if ( ns .eq. 0 ) ns = 1
      if ( ne .eq. 0 .or. ne .gt. ntrc ) ne = ntrc
      if ( ns .gt. ne) then
         write(LERR,*)' '
         write(LERR,*)'-ns must be less than or equal to -ne'
         write(LER,*)' '
         write(LER,*)'AHIST: -ns must be less than or equal to -ne'
         write(LER,*)'FATAL'
         write(LER,*)' '
         go to 999
      endif

      ist = nint ( float(ist) / float(nsi) )
      iend = nint ( float(iend) / float(nsi) )
      if ( ist .eq. 0 ) ist = 1
      if ( iend .eq. 0 .or. iend .gt. nsamp ) iend = nsamp
      if ( ist .gt. iend) then
         write(LERR,*)' '
         write(LERR,*)'-s must be less than or equal to -e'
         write(LER,*)' '
         write(LER,*)'AHIST: -s must be less than or equal to -e'
         write(LER,*)'FATAL'
         write(LER,*)' '
         go to 999
      endif



      if (nb .le. 0) then
         write(LERR,*)' '
         write(LERR,*)'-nb must be an integer greater than zero'
         write(LER,*)' '
         write(LER,*)'AHIST: -nb must be an integer greater than zero'
         write(LER,*)'FATAL'
         write(LER,*)' '
         go to 999
      endif

c verbose output of all pertinent information before processing begins

      call verbal( ntap, otap, nsamp, nsi, ntrc, nrec, iform, ist, 
     :     iend, irs, ire, ns, ne, minv, maxv, nb, cumfile,
     :     absolute, retain, verbos, hdrwd1, hdrwd2)

c BEGIN PROCESSING 

      totsmp = 0
      vmin_temp=minv
      vmax_temp=maxv

      if (vmin_temp .eq. -99999. .or.  vmax_temp .eq. -99999.) then
      if (maxv .eq. -99999. ) maxv = 0.
      if (minv .eq. -99999. ) minv = 1.E30
c=====================================================================
      
c     read through the data to get the min/max
c     skip unwanted input records
      
      call recskp ( 1, irs-1, luin, ntrc, itr )
      
      DO JJ = irs, ire
         
c     skip to start trace
         
         call trcskp ( JJ, 1, ns-1, luin, ntrc, itr )
         
         DO KK = ns, ne
            
            nbytes = 0
            call rtape( luin, itr, nbytes)
            
c     if end of data encountered (nbytes=0) then bail out
            
            if(nbytes .eq. 0) then
               write(LERR,*)'Premature EOF on input at:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif
c     get required trace header information
            
            call saver2( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 
     :           StaCor, TRACEHEADER )
            
            if (hdrwd1 .ne. '-99999')
     :           call saver2 (itr,ifmt_hdrwd1,l_hdrwd1, ln_hdrwd1,
     :           iword1 , TRACEHEADER)
            
            if (hdrwd2 .ne. '-99999')
     :           call saver2 (itr,ifmt_hdrwd2,l_hdrwd2, ln_hdrwd2,
     :           iword2 , TRACEHEADER) 
            
            if ( StaCor .ne. 30000) then
                  
               if (hdrwd1 .ne. '-99999')  ist = iword1/nsi
               if (hdrwd2 .ne. '-99999') iend = iword2/nsi
            
               call vmov ( itr(ITHWP1), 1, tri, 1, nsamp )
               
               do i = ist, iend
                  if (absolute) tri(i) = abs(tri(i))
                  if (vmax_temp .eq. -99999.) maxv = max(maxv,tri(i))
                  if (vmin_temp .eq. -99999.) minv = min(minv,tri(i))  
               enddo
               
            endif
          
         ENDDO
         
c     skip to end of record
         
         call trcskp ( JJ, ne+1, ntrc, luin, ntrc, itr )
         
      ENDDO
      
      write(LERR,*)' Maximum Value = ',maxv
      write(LERR,*)' Minimum Value = ',minv
      write(LERR,*)' Total Number of Samples = ',totsmp
     
c     rewind the input data file so that we can do the binning
      rewind (luin)
     
      endif
c=====================================================================
c     initialize bins to be empty, and define bin boundaries

      bs = (maxv - minv) / float(nb)
      reject = 0

      np(1) = 0
      lb(1) = minv - bs
      ub(1) = minv

      DO MM = 2, nb+1

         np(MM) = 0
         ub(MM) = minv + (bs * float(MM-1))
         lb(MM) = ub(MM-1)

      ENDDO

      np(nb+2) = 0
      lb(nb+2) = maxv
      ub(nb+2) = maxv + bs

c skip unwanted input records

      call recskp ( 1, irs-1, luin, ntrc, itr )

      DO JJ = irs, ire
 
c skip to start trace

         call trcskp ( JJ, 1, ns-1, luin, ntrc, itr )

         DO KK = ns, ne

            nbytes = 0
            call rtape( luin, itr, nbytes)

c if end of data encountered (nbytes=0) then bail out

            if(nbytes .eq. 0) then
               write(LERR,*)'Premature EOF on input at:'
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif

c get required trace header information

            call saver2( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 
     :           StaCor, TRACEHEADER )

            if (hdrwd1 .ne. '-99999')
     :           call saver2 (itr,ifmt_hdrwd1,l_hdrwd1, ln_hdrwd1,
     :           iword1 , TRACEHEADER)

            if (hdrwd2 .ne. '-99999')
     :           call saver2 (itr,ifmt_hdrwd2,l_hdrwd2, ln_hdrwd2,
     :           iword2 , TRACEHEADER)    

c process only live traces

            if ( StaCor .ne. 30000) then

c Put your subroutine here [remember to declare any arguments you need
c over and above those already declared]
c load trace portion of itr[] to real array tri[]
 
               call vmov ( itr(ITHWP1), 1, tri, 1, nsamp )

               if (hdrwd1 .ne. '-99999')  ist = iword1/nsi
               if (hdrwd2 .ne. '-99999') iend = iword2/nsi

               totsmp = totsmp + ( iend - ist + 1 )
             
               call toss ( tri, nsamp, ist, iend, minv, maxv, bs, nb,
     :              absolute, np)

            endif

         ENDDO
 
c skip to end of record

         call trcskp ( JJ, ne+1, ntrc, luin, ntrc, itr )

      ENDDO

      
      write(LERR,*)' Maximum Value = ',maxv
      write(LERR,*)' Minimum Value = ',minv
      write(LERR,*)' Total Number of Samples = ',totsmp

      if (.not. retain) then

         reject = np(1) + np(nb+2)

         DO MM = 1, nb
            lb(MM) = lb(MM+1)
            ub(MM) = ub(MM+1)
            np(MM) = np(MM+1)
         ENDDO

         nb = nb - 2

         write(LERR,'(a27,i20)')
     :        'Number of points rejected: ', reject
         write(LERR,'(a7,1x,i20,1x,a29)') 'Out of', totsmp,
     :        'live samples in input volume.'
         write(LERR,'(a31,f7.4)') 'Percentage of points rejected: ',
     :        100. * (float(reject) / float(totsmp))

         totsmp = totsmp - reject

      endif

c write histogram statistics to output file

      write(luout,'(a19)') HistTitle

      DO MM = 1, nb + 2
         write(luout,*) lb(MM), np(MM)
         write(luout,*) ub(MM), np(MM)
      ENDDO

 10   format (g20.18, 1x, i20)

c Write out cumulative percentage file

      if (cumfile) then
         cumsmp = 0
         write(lucum,'(a22)') CumTitle
         write(lucum,*) lb(1), 0.0

         DO MM = 1, nb + 2
            cumsmp = cumsmp + np(MM)
            pct = float(cumsmp)/float(totsmp)
            write(lucum,*) lb(MM), pct
            write(lucum,*) ub(MM), pct
         ENDDO
      endif

 20   format(g20.18,1x,f10.8)

c close data files 

      call lbclos ( luin )
      if (otap(1:length) .ne. ' ') close ( luout )
      if (cumfile) close (lucum)
      write(LERR,*) 'ahist: Normal Termination'
      write(LER,*) 'ahist: Normal Termination'
      stop

 990  continue

      write(LERR,*) ' '
      write(LERR,*) ' FATAL ...............'
      write(LERR,*) ' Error opening output file:  ',otap(1:length)
      write(LERR,*) ' '
      go to 999

 991  continue

      write(LERR,*) ' '
      write(LERR,*) ' FATAL ...............'
      write(LERR,*) ' Error opening cumulative output file'
      write(LERR,*) ' '

 999  continue

      call lbclos ( luin )
      if (otap(1:length) .ne. ' ') close ( luout )
      if (cumfile) close (lucum)
      write(LERR,*)'ahist: ABNORMAL Termination'
      write(LER,*)'ahist: ABNORMAL Termination'
      stop
      end

c -----------------  Subroutine -----------------------

      subroutine help()

c provide terse online help [detailed help goes in man page]

#include <f77/iounit.h>

      write(LER,*)' '
      write(LER,*)'===================================================='
      write(LER,*)' '
      write(LER,*)' Command Line Arguments for AHIST'
      write(LER,*)' '
      write(LER,*)' For a more detailed description of these parameters'
      write(LER,*)' see the online man page using uman, xman or xuspman'
      write(LER,*)' '
      write(LER,*)'Input...................................... (def)'
      write(LER,*)' '
      write(LER,*)'-N[]   -- input data set                  (stdin)'
      write(LER,*)'-s[]   -- process start time (ms)             (1)'
      write(LER,*)'-e[]   -- process end time (ms)     (last sample)'
      write(LER,*)'-ns[]  -- start trace number                  (1)'
      write(LER,*)'-ne[]  -- end trace number           (last trace)'
      write(LER,*)'-rs[]  -- start record                        (1)'
      write(LER,*)'-re[]  -- end record                (last record)'
      write(LER,*)'-nb[]  -- number of bins                     (32)'
      write(LER,*)'-min[] -- minimum value to use         (optional)'
      write(LER,*)'-max[] -- maximum value to use         (optional)'
      write(LER,*)'     if no min/max given program finds the values'
      write(LER,*)' '
      write(LER,*)'-hw1[] -- apply analysis starting with the value'
      write(LER,*)' in this headerword (Optional, else first sample)'
      write(LER,*)'-hw2[] -- apply analysis ending with the value'
      write(LER,*)' in this headerword (Optional, else last sample)'
      write(LER,*)'-C     -- produce cumulative pct. file'
      write(LER,*)'-A     -- use absolute amplitude values'
      write(LER,*)'-K     -- keep values outside of (min,max)'
      write(LER,*)'-V     -- verbose printout'
      write(LER,*)' '
      write(LER,*)'Usage:'
      write(LER,*)'       ahist -N[] -O[] -s[] -e[] -ns[] -ne[] -rs[]'
      write(LER,*)'             -re[] -nb[] -min[] -max[] -C -A -K '
      write(LER,*)'             -hw1[] -hw2[]  -V'
      write(LER,*)' '
      write(LER,*)'===================================================='
      
      return
      end

c -----------------  Subroutine -----------------------

c pick up command line arguments 

      subroutine cmdln ( ntap, otap, ns, ne, irs, ire, ist, iend, 
     :     name, nb, cumfile, absolute, retain, verbos,
     :     hdrwd1, hdrwd2, minv, maxv )

#include <f77/iounit.h>

      integer    ist, iend, ns, ne, irs, ire, argis, nb
      real maxv, minv

      character  ntap*(*), otap*(*), name*(*)
      character   hdrwd1 * 6, hdrwd2 * 6

      logical    cumfile, verbos, absolute, retain
      
      absolute = (argis('-A') .gt. 0)
      cumfile  = (argis('-C') .gt. 0)

      call argstr( '-HW1', hdrwd1, '-99999', '-99999' )
      call argstr( '-hw1', hdrwd1, hdrwd1, hdrwd1)
      call argstr( '-Hw1', hdrwd1, hdrwd1, hdrwd1)

      call argstr( '-HW2', hdrwd2, '-99999', '-99999' )
      call argstr( '-hw2', hdrwd2, hdrwd2, hdrwd2)
      call argstr( '-Hw2', hdrwd2, hdrwd2, hdrwd2)

      call argi4 ( '-e', iend, 0, 0 )
      retain   = (argis('-K') .gt. 0)          

      call argr4 ( '-max', maxv, -99999., -99999. )  
      call argr4 ( '-min', minv, -99999., -99999. )

      call argi4 ( '-nb', nb, 32, 32 ) 
      call argi4 ( '-ne', ne, 0, 0 )
       call argi4 ( '-ns', ns, 0, 0 ) 
      call argstr ( '-N', ntap, ' ', ' ' ) 
      call argstr ( '-O', otap, ' ', ' ' )       
      call argi4 ( '-re', ire, 0, 0 )
      call argi4 ( '-rs', irs, 0, 0 )      
      call argi4 ( '-s', ist, 1, 1 )      
      verbos = (argis('-V') .gt. 0)
      
c check for extraneous arguments and abort if found to
c catch all manner of user typo's

      call xtrarg ( name, ler, .FALSE., .FALSE. )
      call xtrarg ( name, lerr, .FALSE., .TRUE. )


      if (absolute .and. minv .lt. 0.) then
         write(LER,*)'Warning: Program ahist'
         write(LER,*)'Minimum Value Choosen is less than zero'
         write(LER,*)'while absolute value is being used'
         write(LER,*)'Please check command line 
     :        if this is inappropriate'
         write(LERR,*)'Warning: Program ahist'
         write(LERR,*)'Minimum Value Choosen is less than zero'
         write(LERR,*)'while absolute value is being used'
         write(LERR,*)'Please check command line 
     :        if this is inappropriate'
         endif
      return
      end

c -----------------  Subroutine -----------------------

c verbal printout of pertinent program particulars


      subroutine verbal ( ntap, otap, nsamp, nsi, ntrc, nrec, iform, 
     :     ist, iend, irs, ire, ns, ne, minv, maxv, nb, cumfile,
     :     absolute, retain, verbos,hdrwd1, hdrwd2)

#include <f77/iounit.h>

      integer    nsamp, ntrc, iform, ist, iend, irs, ire, ns, ne, nsi
      integer    nb
      integer    lenth

      real minv, maxv

      character  ntap*(*), otap*(*), hdrwd1*(*), hdrwd2*(*)

      logical    verbos, cumfile, absolute, retain

      ln = lenth(ntap)
      lno = lenth(otap)

      write(LERR,*)' '
      write(LERR,*)' Input Line Header Parameters'
      write(LERR,*)' '
      if (ln .gt. 0) then
        write(LERR,*) ' input data set name   =  ', ntap(1:ln)
      else
        write(LERR,*) ' input data set name   =  stdin'
      endif
      write(LERR,*) ' samples per trace     =  ', nsamp
      write(LERR,*) ' traces per record     =  ', ntrc
      write(LERR,*) ' number of records     =  ', nrec
      write(LERR,*) ' data format           =  ', iform
      write(LERR,*) ' sample interval       =  ', nsi
      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)' Command Line Parameters '
      write(LERR,*)' '
      if (lno .gt. 0) then
        write(LERR,*) ' output data set name  =  ', otap(1:lno)
      else
        write(LERR,*) ' output data set name  =  stdout'
      endif
      write(LERR,*) ' start record          =  ', irs 
      write(LERR,*) ' end record            =  ', irs 
      write(LERR,*) ' start trace           =  ', ns
      write(LERR,*) ' end trace             =  ', ne
      write(LERR,*) ' processing sample start = ', ist
      write(LERR,*) ' processing sample end   = ', iend
      write(LERR,*) ' '
      write(LERR,*) ' number of bins       =  ', nb
      write(LERR,*) ' '
      if (hdrwd1 .ne. '-99999') then
	write(LERR,*)' Horizion Control Enabled :',hdrwd1
	endif
      if (hdrwd2 .ne. '-99999') then
	write(LERR,*)' Horizion Control Enabled :',hdrwd2
	endif
      if (cumfile) write(LERR,*) 'Cumulative percent file requested'
      if (absolute) write (LERR,*) 'Use absolute values'
      if (verbos) write(LERR,*) 'verbose printout requested'
      if (retain) then
         write (LERR,*) 'Extreme values will be RETAINED.'
         write (LER,*) 'AHIST: Extreme values will be RETAINED.'
      else
         write (LERR,*) 'Extreme values will be REJECTED.'
         write (LER,*) 'AHIST: Extreme values will be REJECTED.'
      endif
      write(LERR,*)' '
      write(LERR,*)'========================================== '
      write(LERR,*)' '

      return
      end





