C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c ----- ----- ----- ampspec --> generate summed fft for dataset

#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c declare standard USP variables

      integer     itr ( 2*SZLNHD )
      integer     nsamp, nsi, ntrc, nrec, iform
      integer     luin , luout, lbytes, nbytes, obytes
      integer     argis, irec

      real unitsc

      character   name * 7,  ntap * 256, otap * 256

      logical     verbos

c declare local variables

      integer ordfft, lc

      real  radeg, thresh, smax
      real  tri ( 8*SZLNHD ), work (8*SZLNHD )
      real  sum (8*SZLNHD )

      complex ctr ( 4*SZLNHD )

      character   char1 * 256

      logical     norm, graph, db

c initialize variables

      data name /'AMPSPEC'/
      data radeg/57.29578/

c---------------------------------
c  get online help if necessary
c---------------------------------

      if ( argis('-?') .gt. 0 .or. 
     :     argis('-h') .gt. 0.or. 
     :     argis('-help') .gt. 0) then
         call help ()
         stop
      endif

c---------------------------------
c  open printout files
c---------------------------------
#include <f77/open.h>
      
c---------------------------------------------------------------
c     read program parameters from command line
c---------------------------------------------------------------
      call cmdln ( ntap, otap, ist, iend, nst, ned, nrst, nred, verbos, 
     :     norm, thresh, graph, db )
      
C**********************************************************************C
C     open logical units
C     READ AND UPDATE LINE HEADER,
C     WRITE LINE HEADER, SAVE KEY PARAMETERS.
C**********************************************************************C
      
      call getln( luin, ntap, 'r', 0)
      
      if (otap(1:1) .eq. ' ') then
         luout = LOT
      else
         call alloclun(luout)
         open (unit=luout, file=otap, status='unknown', iostat=ierr)
         if ( iostat .ne. 0 ) then
            write(LERR,*)' '
            write(LERR,*)' error opening output file '
            write(LERR,*)' check permissions and rerun'
            write(LERR,*)'FATAL '
            write(LER,*)' '
            write(LER,*)'AMPSPEC: '
            write(LER,*)' error opening output file '
            write(LER,*)' check permissions and rerun'
            write(LER,*)'FATAL'
            write(LER,*)' '
            stop
         endif
      endif
      
      lbytes=0
      call rtape ( luin, itr, lbytes )
      if(lbytes .eq. 0) then
         length = lenth(ntap)
         write(LERR,*)'AMPSPEC: '
	 if (length .gt. 0)  then
           write(LERR,*)' no header read on ',ntap(1:length)
	 else
           write(LERR,*)' no header read on stdin'
	 endif
         write(LERR,*)'FATAL'
         write(LER,*)' ' 
         write(LER,*)'AMPSPEC: '
	 if (length .gt. 0)  then
           write(LER,*)' no header read on ',ntap(1:length)
	 else
           write(LER,*)' no header read on stdin'
	 endif
         write(LER,*)'FATAL'
         write(LER,*)' ' 
         stop
      endif

#include <f77/saveh.h>

      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TRACEHEADER)
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TRACEHEADER)

      call hlhprt ( itr , lbytes, name, 7, lerr  )

c---------------------------------------
c  check key values for reasonableness
c---------------------------------------

      call cmdchk(nst,ned,nrst,nred,ntrc,nrec)

      if(nsamp .gt. 2*SZLNHD) nsamp=2*SZLNHD

      ntr = ned-nst+1
      nrecc = nred-nrst+1

C**********************************************************************C
C     CHECK CARD DEFAULTS, SET PARAMETERS, and print out values
C**********************************************************************C
      dt = float (nsi) * unitsc
      iend=iend/nsi + .5
      ist0 = ist
      ist=ist/nsi
      if(ist .le. 1) ist=1
      if(iend .eq. 0) iend=nsamp
      if(iend .gt. nsamp) iend=nsamp
      nsampo=iend-ist+1
c------------------------------
c  find power of 2, nsampo

      nu = ordfft (nsampo)
      n2 = 2 ** nu
      fnyq = .5 / dt

      df = fnyq / float(n2/2 - 1)
      ndf = 1000*df

      obytes = SZTRHD + SZSMPD * n22
c------------------------------

      write(LERR,*)
      write(LERR,*)' Line header values after default check '
      write(LERR,*)
      write(LERR,*) ' Input Samples/Trace =  ', nsamp
      write(LERR,*) ' # of Samples/Trace  =  ', nsampo
      write(LERR,*) ' power of 2 samples  =  ', n2,n22
      write(LERR,*) ' Sample Interval     =  ', nsi  
      write(LERR,*) ' Input traces/rec    =  ', ntrc
      write(LERR,*) ' Input Records/Line  =  ', nrec
      write(LERR,*) ' Format of Data      =  ', iform
      write(LERR,*) ' Pack Reals & Imag in each trace= ',pack
      write(LERR,*) ' Frequency interval (Hz)        = ',df
      write(LERR,*) ' Output number bytes =  ', obytes
      if (db) 
     :write(LERR,*) ' Output plotted in db down'
      if (verbos)
     :write(LERR,*) ' verbose output requested'

      call vclr  (sum, 1, n2)

c  skip to start record

      call recskp(1,nrst-1,luin,ntrc,itr)

      DO JJ = nrst, nred

c  skip to start trace

         call trcskp(jj,1,nst-1,luin,ntrc,itr)

         DO KK = nst, ned
 
            nbytes = 0
            call rtape  ( luin , itr, nbytes  )
            if(nbytes .eq. 0) then
               write(LERR,*)'Premature End of file on input:'
               write(LERR,*)'  rec= ',jj,'  trace= ',kk
               go to 999
            endif

            call saver2(itr, ifmt_StaCor, l_StaCor, ln_StaCor, StaCor, 
     :           TRACEHEADER )
            call saver2(itr, ifmt_RecNum, l_RecNum, ln_RecNum, irec, 
     :           TRACEHEADER )
            if ( StaCor .ne. 30000 ) then

               call vmov (itr(ITHWP1+ist-1), 1, work, 1, nsampo)
               call vclr  (ctr, 1, n2)
               call vclr  (tri, 1, nsamp)
               call rfftb (work,ctr,n2,1)
               call rfftsc (ctr,n2,1,1)
               call cvabs  (ctr, 2, tri,  1, n2)

c get the max value of each fft 

               call maxv(tri,1,smax,lc,nsamp)

c keep a running sum of the input

               do ik=1,n2/2

                  sum(ik)=sum(ik)+tri(ik)
               enddo

            endif

         ENDDO

c  skip to the end of current record: trace # ntrc

         call trcskp(jj,kk+1,ntrc,luin,ntrc,itr)

      ENDDO
      
      if(verbos) then
         write(LERR,*)'Output Record ',irec
      endif

      call maxv(sum,1,smax,lc,nsamp)

      if (norm .AND. smax .eq. 0.0) then
         write(LERR,*)'FATAL ERROR in ampspec normalization option:'
         write(LERR,*)'Normalization factor is zero indicating zero'
         write(LERR,*)'data. Check input data.'
         write(LER ,*)'FATAL ERROR in ampspec normalization option:'
         write(LER ,*)'Normalization factor is zero indicating zero'
         write(LER ,*)'data. Check input data.'
         go to 999
      endif

      vfreq=0.
      dfreq=((1./(2.*dt))/(n2/2.))

      do i=1,n2/2
         vfreq=vfreq+dfreq
         if(norm) then
            write(luout,*)vfreq,sum(i)/smax
         elseif (db) then
            write(luout,*)vfreq,10.0*log( sum(i)/smax)
         else
            write(luout,*)vfreq,sum(i)
         endif
      enddo

      if (graph) then
         char1 = 'usp xgraph '
         char1(12:98) = otap
         char1(99:100) = ' &'
         call systemfu(char1)
      endif

      call lbclos(luin)
      close(luout)

      write(LERR,*)' '
      write(LERR,*)' Normal Termination '
      write(LER,*)' '
      write(LER,*)' '
      write(LER,*)' ampspec: Normal Termination '
      write(LER,*)' '
      stop

 999  continue

      write(LERR,*)' Abnormal Termination '
      write(LER,*)' ampspec: Abnormal Termination '

      call lbclos(luin)
      close (luout)

      stop

      END

c--------------------------------
c  online help routine
c--------------------------------
      subroutine help
#include <f77/iounit.h>
        write(LER,*)' '
        write(LER,*)'Command Line Arguments for AMPSPEC: '
        write(LER,*)'convert seismic traces to frequency (fft)'
        write(LER,*)'output an ascii file for graphing'
        write(LER,*)' '
        write(LER,*)'Input...................................... (def)'
        write(LER,*)' '
        write(LER,*)'-N[ntap]   -- input data set name'
        write(LER,*)'-O[otap]   -- output data set name'
        write(LER,*)'-s[ist]    -- start time                   (0 ms)'
        write(LER,*)'-e[iend]   -- end time                (last samp)'
        write(LER,*)'-ns[nst]   -- start trace number       (first tr)'
        write(LER,*)'-ne[ned]   -- end trace number          (last tr)'
        write(LER,*)'-rs[nrst]  -- start record            (first rec)'
        write(LER,*)'-re[nred]  -- end record               (last rec)'
        write(LER,*)'-P         -- normalize summation '
        write(LER,*)'-db        -- spectra in db down         (linear)'
        write(LER,*)'-X         -- automatic xgraph          '
        write(LER,*)'-V         -- verbos printout'
        write(LER,*)' '
        write(LER,*)'Usage:'
        write(LER,*)'      ampspec -N[] -O[] -s[] -e[] -ns[] -ne[] -rs[] 
     &  -re[] [-P] [-db] [-X]'
        write(LER,*)' '
      return
      end

      subroutine cmdln(ntap,otap,ist,iend,nst,ned,nrst,nred,
     1                  verbos,norm,thresh,graph, db )
c-----
c     get command arguments
#include <f77/iounit.h>
      character ntap*(*), otap*(*)
      real      thresh
      integer   argis,ist,iend,nst,ned,nrst,nred
      logical   verbos, norm,graph, db

           db = ( argis('-db') .gt. 0 )
           call argi4('-e',iend,0,0) 

           call argi4('-ne',ned,0,0)
           call argi4('-ns',nst,0,0)
           call argstr('-N',ntap,' ',' ')

           call argstr('-O',otap,' ',' ')

           norm   = ( argis( '-P' ) .gt. 0 )

           call argi4('-rs',nrst,1,1)
           call argi4('-re',nred,0,0)

           call argi4('-s',ist,1,1)
 
           call argr4 ('-t',thresh, .0, .0)

           verbos = ( argis( '-V' ) .gt. 0 )

           graph   = ( argis( '-X' ) .gt. 0 )



c-----
      return
      end

      subroutine drum (lphz, phz)
      real      phz(*)
      integer   lphz
      pi = 180.

      pj = 0.
      do  40 i = 2, lphz

          if (abs(phz(i)+pj-phz(i-1))-pi) 40,40,10

10        if (phz(i)+pj-phz(i-1)) 20,40,30

20        pj = pj +  2*pi
          go to 40

30        pj = pj -  2*pi

40        phz(i) = phz(i) + pj

      return
      end

