C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C******************************************************************
C                                                                 
C     SUBROUTINE - DOSTAK            ENTRY POINT - DOSTAK        
C                                                               
C     LANGUAGE - FORTRAN 77                                    
C     SYSTEM(S) - SUN, CRAY2                                         
C     AUTHOR - Richard Crider                                
C     DATE WRITTEN - January 28, 1991
C                                                          
C                AMOCO PRODUCTION CO. PROPRIETARY
C                 TO BE MAINTAINED IN CONFIDENCE
C                                                        
C     ABSTRACT - Do angle stacking as a function of velocity and
C                offset.
C                                                            
C     USAGE                                                 
C                                                          
C          CALL DOSTAK(NS,VCOEF, DATA, ANGLES, STAK, DX,
C                       ANGMN, ANGMX, NANG, ntr, dt, LIVEBF,
C                       TIMVEC, VRMS, mode emerg,app_mute,vtmax,
C                       ierr, errparms,vsrms,vism,vit,domain,depthint)
C                                                       
C               NS    =  NUMBER OF SAMPLES PER TRACE.              
C            VCOEF    =  RMS VELOCITY COEFFICIENTS
C              DATA   =  TRACE DATA
C             ANGLES  =  Returned ANGLES MATRIX
C              STAK   =  Returned angle staks
C              DX     =  TRACE DISTANCES
C            ANGMN    =  MINIMUM ANGLE VECTOR
C            ANGMX    =  MAXIMUM ANGLE VECTOR
C             NANG    =  NUMBER OF ANGLE STACKS
C              NTR    =  NUMBER OF TRACES PER RECORD
C             dt      =  sample interval, in seconds.
C          LIVEBF     =  counter buffer for live samples in each stak.
C           TIMVEC    =  Vector containing time (in sec) for each
C                        sample.
C            VRMS     =  RMS Velocity vector, 1 value for each
C                        sample.
C            MODE     =  Solution type
C                        0 = Straight Ray
C                        1 = Curved Ray
C                        2 = Perturbed Curved Ray
C           EMERG     =  Angle type   
C                        0 = Incident     
C                        1 = Emergence 
C           app_mute  =  Output type
C                        .false. = angle-dependent stacks
C                        .true.  = angle-dependent mute 
C            VTMAX    =  Valid last time for velocity vector  
C             IERR    =  Error flag to be returned by crvray(creray)
C          ERRPARMS   =  V2,V1,T2,T1, error time for error r  
C                        returned by crvray(creray)     
C            vsrms    =  Smoothed rms function
C            vism     =  Smooth interval velocities
C             vit     =  Inteval velocities from vrms
C            domain   =  1 = depth  0 = time
C            depthint =  depth sample interval
C            inorm    =  0 = normalize by number samples
C                        1 = normalize by delta theta
C                                                      
C     ERROR/RETURN CODES - ierr                 
C                          1 = error in crvray 
C                                              
C***************************************************************
      subroutine dostak(ns,vcoef, data, angles, stak, dx,
     *  angmn, angmx, nang, ntr, dt, livebf, timvec,
     *  vrms, mode,emerg,app_mute,vtmax,ierr,errparms,vsrms,vism,vit,
     :  expw,firstang,lastang,Angles_in,onevel,irdm,ivrec,
     :  domain,depthint,inorm)
C                                                            
C       DATA DECLARATIONS                                   
      real data(*), stak(*), angles(*), vcoef(*)
      real timvec(*), vrms(*),vsrms(*),vism(*),vit(*)
      real lastang(*),firstang(*)
      real  dx(*),livebf(*),errparms(*)
      integer emerg,ierr,domain
      logical Angles_in,app_mute,onevel
C
      real ANGMN(*), ANGMX(*)
C
      call sizefloat(jsz)
      ier = 0
      do i=1,ntr
       if(dx(i).eq.0.0)dx(i)=0.0005
      end do
      const = 57.295
      delt = dt
      if(domain.eq.1)delt=depthint
      iws=1
      iwe=ns
      ierr = 0
c +=================================================+
c |  crvray and creray build the "angles" matrix    |
c +=================================================+
      if(.not.Angles_in .AND. .not.onevel)then

       if(emerg.eq.0)then
        call crvray(ntr,angles,timvec,dx,vrms,vcoef,
     :  delt,ns,mode,vtmax,ierr,errparms,vsrms,vism,vit,const,domain)
        if(ierr.ne.0)return
       else
        call creray(ntr,angles,timvec,dx,vrms,vcoef,
     :  delt,ns,mode,vtmax,ierr,errparms,vsrms,vism,vit,const,domain)
        if(ierr.ne.0)return
       endif

      elseif (onevel .AND. irdm.eq.0) then

       if(emerg.eq.0)then
        call crvray(ntr,angles,timvec,dx,vrms,vcoef,
     :  delt,ns,mode,vtmax,ierr,errparms,vsrms,vism,vit,const,
     :  domain)
        if(ierr.ne.0)return
       else
        call creray(ntr,angles,timvec,dx,vrms,vcoef,
     :  delt,ns,mode,vtmax,ierr,errparms,vsrms,vism,vit,const,
     :  domain)
        if(ierr.ne.0)return
       endif
      endif

c +====================================================+
c |  Following loops perform the "binning" operation   |
c |  If app_mute is false, the number of output traces |
c |  is nang, else ntr. Number of input traces = ntr   |
c |  (ntr generally > nang). Loops take a value of     |
c |  ang and compare it to min and max values for      |
c |  each of the nang possible values and sums a       |
c |  data value corresponding the the angle value      |
c |  into a summation buffer.                          |
c +====================================================+
      if(.not.app_mute)then

        
       do 200 i=1,ntr
        indx1 = (i-1)*ns
        do 200 k = 1,nang
         indx2 = (k-1)*ns
         do 200 j=iws,iwe
          iaddr = indx1 + j
          iaddr2 = indx2 + j
          if(i.eq.1)stak(iaddr2)=0.0           
          if(data(iaddr).ne.0.0)then
           if((angles(iaddr).ge.angmn(k)).and.
     &           (angles(iaddr).lt.angmx(k)))then
            stak(iaddr2) = stak(iaddr2) +  data(iaddr)
            livebf(iaddr2) = livebf(iaddr2)+1.
            if(livebf(iaddr2).eq.1)firstang(iaddr2)=angles(iaddr)
            lastang(iaddr2) = angles(iaddr)
           endif
          endif
200    continue           
        fxpw = expw
        if(fxpw .lt. 0) fxpw= 0.
       do k=0,nang-1
        indx2=k*ns
        do j=iws,iwe
         iaddr2 = indx2+j
         x = livebf(iaddr2)
         ax = abs(lastang(iaddr2)-firstang(iaddr2))
         if(x.ne.0.0)then
          if(inorm.eq.0)then
           stak(iaddr2)=stak(iaddr2)/(x**fxpw)
          else
           if(ax.ne.0.)then
            stak(iaddr2)=stak(iaddr2)/ax
           else
            stak(iaddr2)=0.
           endif
          endif
         else
          stak(iaddr2)=0.0
         endif
        end do
       end do
      else
       do i=1,ntr
        indx1 = (i-1)*ns
        do k = 1,nang
         do j=iws,iwe
           iaddr = indx1 + j
           if((angles(iaddr).ge.angmn(k)).and.
     :               (angles(iaddr).lt.angmx(k)))then
            data(iaddr) = 0.
           endif
         end do
        end do
       end do
      endif
      return
      end
