C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
C******************************************************************
C                                                                 
C     PROGRAM - ANGST               ENTRY POINT - MAIN            
C                                                               
C     LANGUAGE - FORTRAN                                       
C     SYSTEM(S) - SUN, CRAY                                         
C     AUTHOR - Richard Crider
C     DATE WRITTEN - January 28, 1991
C                                                          
C                 AMOCO PRODUCTION CO. PROPRIETARY 
C                  TO BE MAINTAINED IN CONFIDENCE
C                                                                     
C     ABSTRACT - Perform Anlge Stack on CDPs.
C                                                                  
C     USAGE                                                       
C                                                                
C      ANGBEG   -   Begin angle.
C      ANGEND   -   End angle.
C      ANGINC   -   Angle increment
C      RECST    -   Start record
C      RECEND   -   End record
C      VCARD    -   TDFN card file
C      vtap     -   velocity file
C      NTAP     -   Input data set
C      OTAP     -   Stack output data set
C      ATAP     -   Optional angle data set.
C      ANGCRD   -   Optional angle data card file.
C                                                                
C                                                                 
C     FILES REQUIRED/GENERATED -                                 
C      5  ( INPUT  SEQUENTIAL ) -                               
C      6  ( OUTPUT SEQUENTIAL ) -                              
C                                                            
C     ERROR FILE AND MNEUMONIC - NONE
C                                   
C                                  
C
C     DATA DECLARATIONS               
C                                    
C******************************************************************
c  29/05/01 - rlc
c  Added code around call to fitvel to bypass if mode 3.  This is
c  done to make raytracing for this mode equivalent to vendor and 
c  to remove "wobble" from angle calculations.
c  Also modified argument list for rmsint to make same as in attin
c  and attsel.
c 
#include <localsys.h>
#include <save_defs.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
#include <f77/pid.h>
#include <f77/iounit.h>

      integer npol
      PARAMETER (npol = 6)
      external fpoly
      real vel_array(1), t_array(1),dx(1),amn(1), amx(1)
      real data(1), angles(1), stack(1),livebf(1),lastangle(1)
      real firstangle(1)
      real sig(1),vtrms(1),vsrms(1),vism(1),vit(1)
      real angmn(1),angmx(1),c(1),tt(1)
      integer nca(1),jra(1),trhd(1),nc(1),jr(1),TH,LH
      POINTER (advel,vel_array),(adta,t_array)
      POINTER (addx,dx),(adamn,amn),(adamx,amx)
      POINTER (adnca,nca),(adjra,jra)
      POINTER (pdata, data), (adang, angles)
      POINTER (adstk, stack), (adtrhd, trhd)
      POINTER (adlive, livebf),(adangmn,angmn),(adangmx,angmx)
      POINTER (adlast,lastangle),(adfirst,firstangle)
      POINTER (adsig,sig),(advtrms,vtrms),(advsrms,vsrms)
      POINTER (advism,vism),(advit,vit)
      POINTER (adc, c), (adtt,tt), (adnc,nc), (adjr,jr)
      real coefs(NPOL),errparms(5)
      real timvec(SZLNHD), tmps(SZLNHD)
      real ramp(192)
C                                                      
      CHARACTER NAME*5,TITLE(17)*4
      character ntap*256,otap*256,atap*256
      character vtap*256, angcrd*256
      character irecC*1
C
      logical query, aflag,atapfl,fit,cdp,srcpnt,short,depth
      logical dead,tdfn,disco,veltape
      logical Angles_in,app_mute,ikp,BC,onevel
c
      integer pol,domain
      integer argis,luv, lua, pipe
      integer angbeg, angend, anginc, irs, ire
      integer emerg
      integer linehead(SZLNHD)
      integer itr(SZLNHD),vitr(SZLNHD)
      integer getnang,getnc,getnhv
C
C
      DATA NAME/'ANGST'/
      DATA IER/0/
      DATA short/.false./
      DATA TITLE/7*'    ','ANGL','E ST','ACKI','NG  ',
     *             6*'    '/                   
      data lua/25/,luv/26/, pipe/3/

      TH = TRACEHEADER
      LH = LINEHEADER
      ival = 0
      aflag = .false.
c +---------------------------+
c |     check for help flag.  |
c +---------------------------+
      query= ((argis ('-?').gt.0).or.
     :     (argis('-H').gt.0) .or.
     :     (argis('-h').gt.0) .or.
     :     (argis('-help').gt.0))
      if (query) then
        call help(LER)
        stop
      endif

c---
c  check for ikp run
c---
      ikp = .false.
      if (in_ikp() .eq. 1) ikp = .true.

#include <f77/open.h>
C               +------------------------------+
C               |       Begin Edit Phase       |
C               +------------------------------+
      Angles_in = .false.
      call gcmdln(ntap,otap,vtap,angcrd, aflag,luv,
     :lua, angbeg, angend, anginc, irs, ire,
     :atap, atapfl, mode,emerg,app_mute,pol,dead,saf,disco,tdfn,iord,
     :cdp,srcpnt,expw,Angles_in,BC,onevel,depth,inorm)
      if(Angles_in)atapfl=.false.
      if(expw.eq.0)expw=1.
      veltape=.false.
      if(.not.disco.and..not.tdfn)veltape=.true.
      if(irs.eq.0)irs=1
      if(ire.eq.0)ire = 999999
      if(tdfn.and.disco)then
       write(LER,*)'Velocity input must be tdfn OR DISCO, not both'
       write(LER,*)'Fatal parameterization error'
       stop
      endif
C
*     if(mode.ne.0.and.mode.ne.1.and.mode.ne.2.and.mode.ne.3)then
*      write(LER,*)' Solution mode must be specified. There is',
*    :' no default for it.'
*      stop
*     endif
      if(mode.ne.0.and.mode.ne.1.and.mode.ne.2.and.mode.ne.3)then
       write(LER,*)' Solution mode (',mode,') not recognized. ',
     :' Defaulting to mode 1.'
       mode = 1
      endif
      domain=0
      if(depth)domain=1
      if(domain.eq.1)mode=0
c +=========================+
c |   print torch and oval  |
c +=========================+
      call gamoco(title,1,lerr) 
c +====================================+
c |   read line header from input data |
c +====================================+
      call getln(luin,ntap,'r',0)
      if(luin.lt.0)then
       write(LERR,*)'Unable to open ', ntap
       stop
      endif

c------------------------------------------------------------------
c   if a velocity tape...
c----
      IF (veltape) THEN
c---
c  get RMS p velocity data:
c      if in ikp attach a USP data structure to the socket,
c      else attach a disk file to the structure
c---
      if (ikp .AND. vtap(1:1).eq.' ') then
         call sisfdfit (luv, pipe)
      elseif (vtap(1:1).ne.' ') then
         call getln(luv,vtap,'r',-1)
      else
         luv = -1
      endif
      if(luv.lt.0)then
       write(LERR,*)'Unable to open velocity tape ', vtap
       write(LER ,*)'Unable to open velocity tape ', vtap
       call lbclos(luin)
       close(lerr)
       stop
      endif

      ENDIF
c------------------------------------------------------------------

      nby = 0 
      call rtape(luin,linehead,NBY)     
      if (nby.EQ.0) then         
        write(LERR,9041)
 9041 format(8x,'EOF encountered trying to read line header from',
     *'input data set. FATAL.')
        call lbclos(luin)
        close(lerr)
        if(veltape)call lbclos(luv)
        stop
      endif
C   get processing constants from line header
      call saver(linehead, 'NumSmp', nsamp, LINHED)
      call saver(linehead, 'SmpInt', nsi  , LINHED)
      call saver(linehead, 'NumTrc', ntrc , LINHED)
      call saver(linehead, 'NumRec', nrec , LINHED)
      call saver(linehead, 'Format', iform, LINHED)
      call saver(linehead, 'UnitSc',unitsc, LINHED)
      call saver(linehead, 'TmSlIn', idpthi,LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(linehead, 'UnitSc', unitsc, LINHED)
      endif
      call savelu('TrcNum',ifmt_TrcNum,l_TrcNum,ln_TrcNum,TH)
      call savelu('RecNum',ifmt_RecNum,l_RecNum,ln_RecNum,TH)
      call savelu('DstSgn',ifmt_DstSgn,l_DstSgn,ln_DstSgn,TH)
      call savelu('DstUsg',ifmt_DstUsg,l_DstUsg,ln_DstUsg,TH)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TH)
      call savelu('DphInd',ifmt_DphInd,l_DphInd,ln_DphInd,TH)
      call savelu('SrcPnt',ifmt_SrcPnt,l_SrcPnt,ln_SrcPnt,TH)
      call savelu('SoPtBi',ifmt_SoPtBi,l_SoPtBi,ln_SoPtBi,TH)
      call savelu('CDPBCX',ifmt_CDPBCX,l_CDPBCX,ln_CDPBCX,TH)
      call savelu('CDPBCY',ifmt_CDPBCY,l_CDPBCY,ln_CDPBCY,TH)
      call savelu('SrPtXC',ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,TH)
      call savelu('SrPtYC',ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,TH)
      call savelu('RcPtXC',ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,TH)
      call savelu('RcPtYC',ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,TH)

C
      delt = float(nsi) * unitsc
      fsr = nsi

      depthint=float(idpthi)/1000.
      nsr = fsr
      lramp = 48./fsr
      maxt = nsamp*nsr
      ramp(1)=0.
      do i=2,lramp
       x = i-1
       ramp(i)= x/float(lramp)
      end do
      do i = 1,  nsamp
       timvec(i) = float(i) * delt
      end do
      vtmax = (nsamp-1)*delt
      n4 = 5
      call hlhprt (linehead,NBY,NAME,n4, LERR)
      ntbyt = nsamp*iszbyt + sztrhd
      nasets = 1
      nvsets = 0

      if(aflag)then

       nangf = getnang(lua,nstak,nasets)
       rewind (lua)
       iget=nangf*63*ISZBYT
       call galloc(adamn,iget,ierr,0)
       call galloc(adamx,iget,ierr,0)
       iget=nangf*ISZBYT
       call galloc(adnca,iget,ierr,0)
       call galloc(adjra,iget,ierr,0)
       if(ierr.ne.0)then
        write(lerr,*)' memory allocation error for angles. FATAL'
        call lbclos(luin)
        if(veltape)call lbclos(luv)
        close(lerr)
        stop
       endif
       do  i = 1, nangf
            nca (i) = 0
       enddo
       call rdangs(amn, amx, nca, jra, lua,nstak,nasets,nangf)
       nang = nstak
       jra(nasets) = 99999

      else

       if(anginc.ne.0)then
         nstak = (angend - angbeg+ anginc-1)/anginc
       else
         nstak = 1
       endif

      endif

      if(anginc.ne.0)then
       lastang = nstak*anginc + angbeg
      else
       lastang = angend
      endif
      if(lastang.lt.angend)then
          nstak = nstak + 1
      endif
      nang = nstak
      if(app_mute)nstak=1
                           
      call getln(luout,otap,'w',1)
      if(luout.lt.0)then
       write(LERR,*)'  Unable to open ',otap
       call lbclos(luin)
       if(veltape)call lbclos(luv)
       close(lerr)
       stop
      endif
      if(atapfl)then
        call getln(luat, atap,'w',-1)
      endif
      if(ire.lt.32767.and.irs.gt.0)then
        jnrec=ire-irs+1
        call savew(linehead, 'NumRec', jnrec , LINHED)
      endif
      if(app_mute)then
         kstak = nstak*ntrc
      else
         kstak = nang
      endif
      call savew(linehead,'NumTrc',  kstak, LINHED)
      call savhlh(linehead,nby,jtbyt)
      call wrtape(luout,linehead,jtbyt)
      if(atapfl)then
       call savew(linehead,'NumTrc',  ntrc, LINHED)
       call wrtape(luat, linehead,jtbyt)
      endif
c +==================================================+
c | get line header parameters for velocity data set |
c +==================================================+
      IF (veltape) THEN

       nby = 0
       call rtape(luv,linehead,nby)
       if(nby.eq.0)then
        write(lerr,*)'EOF on velocity data set reading header. FATAL'
        write(ler ,*)'EOF on velocity data set reading header. FATAL'
        call lbclos(luin)
        if(veltape)call lbclos(luv)
        if(atapfl)call lbclos(luat)
        close(lerr)
        stop
       endif
       call saver(linehead, 'NumSmp', nvsamp, LINHED)
       call saver(linehead, 'SmpInt', nsiv,   LINHED)
       call saver(linehead, 'NumTrc', ntrcv,  LINHED)
       call saver(linehead, 'NumRec', nrecv,  LINHED)
       call saver(linehead, 'TmSlIn', idpthv,LINHED)

       if (onevel) then
       write(lerr,*)' '
       write(lerr,*)'Single velocity option flagged. The option assumes'
       write(lerr,*)'that trace distances for all gathers will be same'
       write(lerr,*)'so that only one set of angles need be computed'
       write(lerr,*)' '
       ntrcv = 1
       nrecv = 1
       endif

       if (nrecv .eq. 1 .AND. ntrcv .gt. 1) then
        write(lerr,*)
     :  'Velocity data set has 1 rec and ',ntrcv,' traces'
        write(lerr,*)
     :  'Will read one velocity trace for every input gather'
         nrecv = ntrcv
         ntrcv = 1
       elseif (nrecv .gt. 1 .AND. ntrcv .gt. 1) then
        write(lerr,*)
     :  'Velocity data set has ',nrecv,'  recs and ',ntrcv,' traces'
        write(lerr,*)
     :  'Will read one velocity trace for every input gather'
         nrecv = ntrcv * nrecv
         ntrcv = 1
       elseif (nrecv .eq. 1 .AND. ntrcv .eq. 1) then
        write(lerr,*)' '
        write(lerr,*)'Single velocity (usp) function will be used'
        write(lerr,*)' '
       endif
         
       if(.not.depth) then
        if(nsiv  .ne. nsi) then
         write(lerr,*)
     :   'Velocity and input not compatible. Must have '
         write(LERR,*)
     :   'same sample interval. FATAL!'
         write(ler,*)
     :   'Velocity and input not compatible. Must have '
         write(LER,*)
     :   'same sample interval. FATAL!'
         call lbclos(luin)
         if(veltape)call lbclos(luv)
         call lbclos(luout)
         if(atapfl)call lbclos(luat)
         close(lerr)
         stop
        endif
       else
        if(idpthv  .ne. idpthi) then
         write(lerr,*)
     :   'Velocity and input not compatible. Input is  '
         write(LERR,*)
     :   'in depth and depth sample intervals are not the'
         write(lerr,*)
     :   'same. FATAL!'
         write(ler ,*)
     :   'Velocity and input not compatible. Input is  '
         write(LER ,*)
     :   'in depth and depth sample intervals are not the'
         write(ler ,*)
     :   'same. FATAL!'
         call lbclos(luin)
         if(veltape)call lbclos(luv)
         call lbclos(luout)
         if(atapfl)call lbclos(luat)
         close(lerr)
         stop
        endif
       endif
       if(nvsamp.gt.nsamp) then
        write(lerr,*)
     : 'WARNING from angst: velocity and input not compatible.'
        write(lerr,*)
     : 'velocity traces too long - will truncate from ',nvsamp,' to ',
     : nsamp
        write(ler ,*)
     : 'WARNING from angst: velocity and input not compatible.'
        write(ler ,*)
     : 'velocity traces too long - will truncate from ',nvsamp,' to ',
     : nsamp
       endif
       if(nvsamp.lt.nsamp) then
        write(lerr,*)
     : 'WARNING from angst: velocity and input not compatible.'
        write(lerr,*)
     : 'velocity traces too short - will extend using last sample'
        write(lerr,*)
     : ' from ',nvsamp,'  to ',nsamp
        write(ler ,*)
     : 'WARNING from angst: velocity and input not compatible.'
        write(ler ,*)
     : 'velocity traces too short - will extend using last sample'
        write(ler ,*)
     : ' from ',nvsamp,'  to ',nsamp
        short = .true.
       endif

      ENDIF
C +==================================+
C |   allocate the required memory   |
C +==================================+
      ierror = 0
      iabort = 0
      ner = 0
      iget =nsamp * ntrc * ISZBYT
      call galloc(pdata,iget,ierror,iabort)
      if(ierror.ne.0)ner=ner+1
      call galloc(adang, iget,ierror,iabort)
      if(ierror.ne.0)ner=ner+1
      if(.not.app_mute)then
        iget = nsamp * nang * ISZBYT
      else
        iget = nsamp * ntrc * ISZBYT
      endif
      call galloc(adstk  ,iget,ierror,iabort)
      if(ierror.ne.0)ner=ner+1
      call galloc(adlive,iget,ierror,iabort)
      if(ierror.ne.0)ner=ner+1
      call galloc(adlast,iget,ierror,iabort)
      if(ierror.ne.0)ner=ner+1
      call galloc(adfirst,iget,ierror,iabort)
      if(ierror.ne.0)ner=ner+1
      iget = ITRWRD * ntrc * ISZBYT
      call galloc(adtrhd,iget,ierror,iabort)
      if(ierror.ne.0)ner=ner+1
      iget = nang*ISZBYT
      call galloc(adangmn,iget,ierror,iabort)
      if(ierror.ne.0)ner=ner+1
      call galloc(adangmx,iget,ierror,iabort)
      if(ierror.ne.0)ner=ner+1
      iget = nsamp*ISZBYT
      if(.not.Angles_in)then
       call galloc(adsig  ,iget,ierror,iabort)
       call galloc(advtrms,iget,ierror,iabort)
       call galloc(advsrms,iget,ierror,iabort)
       call galloc(advism ,iget,ierror,iabort)
       call galloc(advit  ,iget,ierror,iabort)
      endif
      if(ierror.ne.0)ner=ner+1

      if(ner.ne.0)then
       write(LERR,*)' Memory allocation failed.  FATAL'
       call lbclos(luin)
       call lbclos(luout)
       if(atapfl)call lbclos(luat)
       close(lerr)
       stop
      endif
  
      lmove = nsamp
      write(LERR,*)' ANGST Processing Parameters :'
      write(LERR,'(a,i5)')'Start Record ...............',irs
      write(LERR,'(a,i5)')'End Record .................',ire
      write(LERR,'(a,i5)')'Mode........................',mode
      write(LERR,'(a   )')'     0 = Straight Ray'
      write(LERR,'(a   )')'     1 = Curved Ray'
      write(LERR,'(a   )')'     2 = Perturbed Curved Ray'
      write(LERR,'(a,i5)')'Angles......................',emerg
      write(LERR,'(a   )')'     0 = Use incident angles'
      write(LERR,'(a   )')'     1 = Use emergent angles'
      if(saf.ne.0)then
       write(LERR,'(a,e10.3)')'Vel Fn resample thresh... ',saf
      endif
      if(iord.ne.0)then
       write(LERR,'(a,i5)')'Vel Fn smoothing order... ',iord
      endif
      if(.not.app_mute)then
       write(LERR,'(a,i5)')'Number Stacked Traces.......',nstak
      else
       write(LERR,'(a)'   )'Output is muted data........'
      endif
      if(.not.aflag)then
        write(LERR,'(a,i5)')'Start Angle.................',angbeg
        write(LERR,'(a,i5)')'Angle Increment.............',anginc
        write(LERR,'(a,i5)')'End Angle...................',angend
      else
        write(LERR,'(a   )')' Minimum Angles:'
        call writer(amn,nang,1,LERR)
        write(LERR,'(a   )')' Maximum Angles:'
        call writer(amx,nang,1,LERR)
      endif
C               +---------------------------------+
C               |       Begin Process Phase       |
C               +---------------------------------+
      ier = 0
      iget = nsamp*ISZBYT
      call galloc(advel ,iget,ier,0)
      call galloc(adta,iget,ier,0)
      iget = ntrc*ISZBYT
      call galloc(addx,iget,ier,0)
      if(ier.ne.0)then
       write(ler,*)'Memory allocation error for velocities. FATAL!'
       call lbclos(luin)
       call lbclos(luout)
       close(lerr)
       if(veltape)call lbclos(luv)
       if(atapfl)call lbclos(luat)
       stop
      endif
c +==============================+
c | If card image velocity file, |
c | gotta read it                |
c +==============================+
       if(tdfn)then
        nvelf = getnc(luv,LERR,ier)
        nvsets = nvelf
        rewind (LUV)
        iget = 63*nvelf*ISZBYT
        call galloc(adc ,iget,ier,0)
        call galloc(adtt,iget,ier,0)
        iget = nvelf*ISZBYT
        call galloc(adnc,iget,ier,0)
        call galloc(adjr,iget,ier,0)
        if(ier.ne.0)then
         write(ler,*)'Memory allocation error for velocities. FATAL!'
         call lbclos(luin)
         call lbclos(luout)
         close(lerr)
         if(veltape)call lbclos(luv)
         if(atapfl)call lbclos(luat)
         stop
        endif
        call rdtdfn(c,tt,nc,jr,luv,maxt,LERR,ier)
       endif
       if(disco)then
        nvelf = getnhv(luv,LERR,ier)
        rewind(luv)
        iget = nvelf*ISZBYT
        call galloc(adnc,iget,ier,0)
        call galloc(adjr,iget,ier,0)
        iget = 63*nvelf*ISZBYT
        call galloc(adc ,iget,ier,0)
        call galloc(adtt,iget,ier,0)
        if(ier.ne.0)then
         write(ler,*)'Memory allocation error for velocities. FATAL!'
         call lbclos(luin)
         call lbclos(luout)
         close(lerr)
         if(veltape)call lbclos(luv)
         if(atapfl)call lbclos(luat)
         stop
        endif
        call rdhvel(c,tt,nc,jr,luv,LERR,ier)
       endif
c +=================+
c | go get the data |      
c +=================+
      irdm = 0
      if(irs.gt.1)then
       do i=1,irs-1
        if (.not.onevel) then
        do j=1,ntrc
         nit=0
         call rtape(luin,itr,nit)
         if(nit.eq.0)then
          write(LER,*)'Fatal error! EOF found before data!'
          write(LERR,*)'Fatal error! EOF found before data!'
          call lbclos(luin)
          call lbclos(luout)
          if(veltape)call lbclos(luv)
          if(atapfl)call lbclos(luat)
          close(lerr)
          stop
         endif
        end do
        endif
        if(.not.onevel .and. veltape.and.nrecv.gt.1)then
         n = 1
         if(Angles_in)n=ntrc
         do j=1,n
          nit = 0
          call rtape(luv,itr,nit)
          if(nit.eq.0)then
           write(LER,*)'Fatal error! EOF on velocity input!'
           write(LERR,*)'Fatal error! EOF on velocity input!'
           call lbclos(luin)
           call lbclos(luout)
           if(veltape)call lbclos(luv)
           if(atapfl)call lbclos(luat)
           close(lerr)
           stop
          endif
         end do
        endif
       end do
      endif
c +=================+
c |  PROCESS DATA   |
c +=================+
      do while(irs.le.ire)
       irec=0
       cdpxsum = 0.
       cdpysum = 0.
       noffset = 0
       iilive  = 0
       do j=1,ntrc
        nby = 0   
        call rtape (luin,itr,nby)
        if (nby.eq.0) then
         call lbclos(luin)
         call lbclos(luout)
         if(veltape)call lbclos(luv) 
         if(atapfl)call lbclos(luat)
         close(lerr)
         stop
        endif
        call saver2(itr,ifmt_StaCor,l_StaCor,ln_StaCor,istat,TH)
        call vmov(itr(ITHWP1),1,tmps,1,nsamp)
        ams = 0.
        do  ii = 1, nsamp
            ams = ams + abs(tmps(ii))
        enddo
        iaddr = (j-1)*nsamp
        if(istat.ne.30000 .AND. ams.ne.0.0)then
          call vmov(itr(ITHWP1),1,data(iaddr+1),1,nsamp)
          if (iilive .eq. 0) iilive = j
          if (BC) then
             noffset = noffset + 1
             call saver2(itr,ifmt_SrPtXC,l_SrPtXC,ln_SrPtXC,i_SrPtXC,TH)
             call saver2(itr,ifmt_SrPtYC,l_SrPtYC,ln_SrPtYC,i_SrPtYC,TH)
             call saver2(itr,ifmt_RcPtXC,l_RcPtXC,ln_RcPtXC,i_RcPtXC,TH)
             call saver2(itr,ifmt_RcPtYC,l_RcPtYC,ln_RcPtYC,i_RcPtYC,TH)
             cdpx = 0.5 * float (i_SrPtXC + i_RcPtXC) + 0.5
             cdpy = 0.5 * float (i_SrPtYC + i_RcPtYC) + 0.5
             cdpxsum = cdpxsum + cdpx
             cdpysum = cdpysum + cdpy
          endif
         if(irec.eq.0)then
          call saver2(itr,ifmt_RecNum,l_RecNum,ln_RecNum,irec,TH)
          if(cdp)call saver2(itr,ifmt_DphInd,l_DphInd,ln_DphInd,irec,TH)
          if(srcpnt)then
           call saver2(itr,ifmt_SrcPnt,l_SrcPnt,ln_SrcPnt,irec,TH)
           call saver2(itr,ifmt_SoPtBi,l_SoPtBi,ln_SoPtBi,irecC,TH)
           call asc2int(irecC,jrec)
           irec=irec+jrec*10000
          endif
         endif
        else
         call savew2(itr,ifmt_StaCor,l_StaCor,ln_StaCor,30000,TH)
         do k=1,nsamp
          data(iaddr+k)=0.0
         end do
        endif
        call saver2(itr,ifmt_DstSgn,l_DstSgn,ln_DstSgn,idist,TH)
        idist = iabs(idist)
        dx(j) = idist
        iaddr = (j-1)*ITRWRD+1
        call vmov(itr,1,trhd(iaddr),1,ITRWRD)
       end do

         if (BC) then
             cdpxsum = cdpxsum / noffset
             cdpysum = cdpysum / noffset
             i_CDPBCX = cdpxsum
             i_CDPBCY = cdpysum
         endif

c +=================================+
c | Get the local velocity function |
c +=================================+
       if(.not.Angles_in)then
        do i=1,nsamp
         sig(i)=1.0
        end do
       endif
       chisq = 0.
       if(tdfn.or.disco)then
        fit = .true.
        call getvel(irec, jr, tt, c, nc, nsamp, delt, coefs,
     &   sig,chisq,vtrms,nvsets,vtmax,fit,pol,vsrms,vism,vit,ier,iord)
        if(ier.ne.0)then
         write(LER,*)'Memory allocation error in getvel. FATAL'
         call lbclos(luin)
         call lbclos(luout)
         if(atapfl)call lbclos(luat)
         close(lerr)
         stop
        endif
       else
        if(irdm.eq.0)then
         if(Angles_in)then
          do i=1,ntrc
           nit = 0
           call rtape(luv,vitr,nit)
           if(nit.eq.0)then
            write(LERR,*)' EOF on angles file. FATAL.'
            call lbclos(luin)
            call lbclos(luout)
            if(veltape)call lbclos(luv)
            if(atapfl)call lbclos(luat)
            close(lerr)
            stop
           endif
           ndx = (i-1)*nsamp+1
           call vmov(vitr(ITHWP1),1,angles(ndx),1,nsamp)
          end do
         else
          nby=0
          call rtape(luv,vitr,nby)
          call saver2(vitr,ifmt_RecNum,l_RecNum,ln_RecNum,ivrec,TH)
          if(nby.eq.0)then
           write(LERR,*)' EOF on velocity file. FATAL.'
           call lbclos(luin)
           call lbclos(luout)
           if(veltape)call lbclos(luv)
           if(atapfl)call lbclos(luat)
           close(lerr)
           stop
          endif
          nv=nsamp
          call vmov(vitr(ITHWP1),1,vel_array,1,nvsamp)
          if (short) then
             do i = nvsamp+1, nsamp
                vel_array (i) = vel_array (nvsamp)
             enddo
          endif
          do i=1,nv
           xi = i
           t_array(i)=xi*delt
          end do
          if(saf.ne.0.0.and..not.depth)then
           call sloper(t_array, vel_array, nv,saf)
           fit = .true.
          else
           nv=nsamp
           fit = .false.
          endif
          if(.not.depth)then
           if(mode.ne.3)then
            call fitvel(t_array, vel_array, nv,nsamp, delt, coefs,
     :      sig,ch,vtrms,vsrms,vism, vit,iord,fit,jerr)
            if(jerr.ne.0)then
             write(lerr,*)' Error allocating memory in fitvel. FATAL.'
             call lbclos(luin)
             call lbclos(luout)
             if(veltape)call lbclos(luv)
             if(atapfl)call lbclos(luat)
             close(lerr)
             stop
            endif
           else
            call vmov(vel_array,1,vtrms, 1,nsamp)
            call vmov(vel_array,1,vsrms,1,nsamp)
            call rmsint(vel_array,t_array,nsamp,vism)
            call rmsint(vel_array,t_array,nsamp,vit)
           endif
          else
           call vmov(vel_array,1,vsrms,1,nsamp)
           call vmov(vel_array,1,vism,1,nsamp)
           call vmov(vel_array,1,vit, 1,nsamp)
           call vmov(vel_array,1,vtrms, 1,nsamp)
          endif
         endif
        endif
       endif
c     get the local min/max angle function
       if(aflag)then
        call getang(amn, amx, nca, jra, irec, angmn, angmx, nang,
     :    nasets)
       else
        bang = angbeg
        cang = anginc
        do J = 1, nang
         angmn(j)= float((j-1))*cang + bang
         angmx(j) = angmn(j) + cang
         if(angmx(j).gt.angend)angmx(j)= angend
        end do
       endif
c +=======================================+ 
c | Go compute the angles and do stacking |
c +=======================================+ 
       if(.not.app_mute)then
        lclr = nsamp * nang
       else
        lclr = nsamp*ntrc
       endif
       do i=1,lclr
        stack(i)=0.
        livebf(i)=0.
        lastangle(i)=-1.
        firstangle(i)=-1.
       end do
       if(irdm.eq.0 .AND. .not.Angles_in)then
        lclr = nsamp * ntrc
        do i=1,lclr
        angles(i)=0.
        end do
       endif
       vtmax = (nsamp-1)*delt
       call dostak(nsamp, coefs, data, angles,stack, dx,
     * angmn, angmx, nang, ntrc, delt, livebf, timvec, vtrms,
     * mode,emerg,app_mute,vtmax,ierr,errparms,vsrms,vism,vit,expw,
     : firstangle,lastangle,Angles_in,onevel,irdm,ivrec,domain,depthint,
     : inorm)

       if(onevel .or. nrecv.le.1)irdm=1
       if(ierr.ne.0)then
        call lbclos(luin)
        call lbclos(luout)
        if(veltape)call lbclos(luv)
        if(atapfl)call lbclos(luat)
        write(LERR,'(a,i5)')
     :' Fatal Error in Velocity Function for Record',irec
        write(LERR,'(a,f8.3,a)')
     :' Found imaginary interval velocity at ',errparms(5),' seconds.'
        write(LERR,'(a,f10.0,a,f8.3)')
     :' V2 = ',errparms(1),' T2 = ',errparms(3)
        write(LERR,'(a,f10.0,a,f8.3)')
     :' V1 = ',errparms(2),' T1 = ',errparms(4)
        write(LERR,*)' coefs'
        call writer(coefs,npol,1,LERR)
        write(LERR,*)'vsrms '
        call writer(vsrms,nsamp,1,LERR)
        write(LERR,*)'vism '
        call writer(vism,nsamp,1,LERR)
        write(LERR,*)'vit '
        call writer(vit,nsamp,1,LERR)
        close(lerr)
        stop
       endif
       if(atapfl)then
        do i=1,ntrc
         ist = (i-1)*nsamp
         call vmov(angles(ist+1),1,itr(ITHWP1),1,nsamp)
         ist = (i-1)*ITRWRD
         call vmov(trhd(ist+1),1,itr(1),1,ITRWRD)
         if (BC) then
          call savew2(itr,ifmt_CDPBCX,l_CDPBCX,ln_CDPBCX,i_CDPBCX,TH)
          call savew2(itr,ifmt_CDPBCY,l_CDPBCY,ln_CDPBCY,i_CDPBCY,TH)
         endif
         call savew2(itr,ifmt_StaCor,l_StaCor,ln_StaCor,0,TH)
         call wrtape(luat,itr,ntbyt)
        end do
       endif
       kstak = nstak
       if(app_mute)kstak = ntrc

       ioknt = 0
       do i = 1,kstak
        ioknt = ioknt + 1
        if(ioknt.gt.ntrc)ioknt = 1
        ist = (i-1)*nsamp

        if(.not.app_mute)then
         call vmov(stack(ist+1),1,itr(ITHWP1),1,nsamp)
        else
         call vmov(data(ist+1),1,itr(ITHWP1),1,nsamp)
         k=1
         do while(data(ist+k).eq.0.and.k.le.nsamp)
          k=k+1
         end do
         if(k.lt.nsamp-lramp)then
          call vmul(itr(ITHWP1+k-1),1,ramp,1,itr(ITHWP1+k-1),1,lramp)
         endif
        endif

        if(.not.app_mute)then
         ist = (iilive-1)*ITRWRD
         call vmov(trhd(ist+1),1,itr,1,ITRWRD)
         iang = angmn(i)
         call savew2(itr,ifmt_DstSgn,l_DstSgn,ln_DstSgn,iang, TH)
         iang = angmx(i)
         call savew2(itr,ifmt_DstUsg,l_DstUsg,ln_DstUsg,iang, TH)
         call savew2(itr,ifmt_TrcNum,l_TrcNum,ln_TrcNum,i, TH)
         call savew2(itr,ifmt_StaCor,l_StaCor,ln_StaCor,0, TH)
        else
         jst = (ioknt-1)*ITRWRD
         call vmov(trhd(jst+1),1,itr,1,ITRWRD)
        endif

        if(.not.app_mute)then
         if(.not.dead)then
          sum = 0.
          do k=1,nsamp
           sum = sum+abs(stack(ist+k))
          end do
          if(sum.ne.0.0)then
           call savew2(itr,ifmt_StaCor,l_StaCor,ln_StaCor,0, TH)
          else
           call savew2(itr,ifmt_StaCor,l_StaCor,ln_StaCor,30000, TH)
          endif
         else
           call savew2(itr,ifmt_StaCor,l_StaCor,ln_StaCor,0, TH)
         endif
        endif
         if (BC) then
          call savew2(itr,ifmt_CDPBCX,l_CDPBCX,ln_CDPBCX,i_CDPBCX,TH)
          call savew2(itr,ifmt_CDPBCY,l_CDPBCY,ln_CDPBCY,i_CDPBCY,TH)
         endif
        call wrtape(luout,itr,ntbyt)
       end do   
      irs = irs+1
      end do
      call lbclos(luin)                   
      call lbclos(luout)                   
      if(veltape)call lbclos(luv)
      if(atapfl)call lbclos(luat)
      close(lerr)
      stop
      END                                                    

      subroutine gcmdln ( ntap, otap, vtap, angcrd, aflag,luv,
     *lua, angbeg, angend, anginc, irs, ire,
     *atap, atapfl,mode,emerg,app_mute,npol,dead,saf,disco,tdfn,iord,
     :cdp,srcpnt,expw,Angles_in,BC,onevel,depth,inorm)
#include <f77/iounit.h>
      character ntap*(*), otap*(*), vtap*(*), angcrd*(*)
      character atap*(*), mdc*2
      logical     aflag, atapfl,dead,Angles_in
      integer argis
      integer angbeg, angend, anginc, irs, ire
      integer emerg
      logical tdfn, disco,cdp,srcpnt,app_mute,BC,onevel,depth
C                                                         
      call argstr ('-N',ntap,' ',' ')          
      atapfl = .false.
      atap = ' '
      call argstr('-A', atap, ' ', ' ')
      call argstr ('-O',otap,' ',' ')            
      if(atap.ne.' ')    atapfl = .true.
      vtap = ' '
      call argstr ('-v',vtap,' ',' ')
      Angles_in = (argis('-angles').gt.0)
      angcrd = ' '
      aflag = .false.
      call argstr ('-DA',angcrd,' ',' ')
      if(angcrd.ne.' ') then
       call chkfle(angcrd)
       open(unit=LUA, file=angcrd, status='old',
     *       form='formatted',access='sequential')
       rewind (LUA)                           
       aflag = .true.
      else                                      
       call argi4('-as', angbeg, 0,0)
       if(angbeg.lt.0)angbeg = 0
       call argi4('-ae', angend, 0,0)
       if(angend.le.0)angend = 45
       call argi4('-ai', anginc, 0,0)
       if(anginc.eq.0)anginc = 5
       if(anginc.lt.0)anginc = 0
      endif
      call argi4('-rs', irs, 0,0)
      call argi4('-re', ire, 0,0)
      call argstr('-md',mdc,' ',' ')
      if(mdc.eq.'0'.or.mdc.eq.'1'.or.mdc.eq.'2'.or.mdc.eq.'3')then
        read(mdc,'(I1)')mode
      else
        mode = -1
      endif
      call argr4('-exp',expw,0.0,0.0)
      srcpnt = (argis('-srcpnt').gt.0)
      call argi4('-em',emerg,0,0)
      call argi4('-sm',jstak,0,0)
      if(jstak.eq.1)then
       app_mute=.true.
      else
       app_mute=.false.
      endif
      if(app_mute)anginc=90
      call argr4('-saf',saf,0.0,0.0)
      if(mode.gt.3)mode = 0
      if(emerg.ne.1)emerg=0
      call argi4('-or',npol,0,0)
      if(npol.eq.0)npol=5
       npol = npol + 1
       if(npol.gt.6)npol=6
      dead = (argis('-dead').gt.0)
      tdfn = (argis('-tdfn').gt.0)
      disco = (argis('-disco').gt.0)
      call argi4('-iord',iord,0,0)
      cdp = (argis('-cdp').gt.0)
      BC  = (argis('-BC').gt.0)
      onevel = (argis('-S').gt.0)
      depth = (argis('-D').gt.0)
      call argi4('-norm',inorm,0,0)

      if(tdfn.or.disco)then
       call chkfle(vtap)
       open(unit=LUV, file=vtap, status='old',
     *     form='formatted',access='sequential')
       rewind (LUV)        
      endif

      return                                                  
      end

      subroutine help(LER)
          write(LER,*)  
     :'***************************************************************'
         write(LER,*)
     :'Program ANGST............................ ANGle-dependent STack' 
      write(LER,*)' '                                             
      write(LER,*)                                               
     :'-N [ntap]   (default = stdin)  : Input data file name'   
      write(LER,*)                                             
     :'-O [otap]   (default = stdout) : Output data file name'
      write(LER,*)                                             
     :'-A [otp2]       (optional)     : Angle data set'
      write(LER,*)                                           
     :'-v[vtap]    (required)         : RMS (stacking) velocity file'
      write(LER,*) 
     :'                                 or angle data file for time '
      write(LER,*)
     :'                                 input, interval velocity for'
      write(LER,*)
     :'                                 depth input.                ' 
      write(LER,*)
     :'-as[angbeg]  (default = 0)      : Start Angle'
      write(LER,*)
     :'-ae[angend]  (default = 45)     : End Angle'
      write(LER,*)
     :'-ai[anginc]  (default = 5)      : Angle Increment'
      write(LER,*)
     :'-rs[irs]  (default = first)     : Starting sequential record'
      write(LER,*)
     :'-re[ire]  (default = last)      : Ending sequential record'
      write(LER,*)
     :'-ws[ws]   (default = 0 )        : Start time for stacking'
      write(LER,*)
     :'-we[we] (default=end of trace)  : End time for stacking'
      write(LER,*)
     :'-md[mode]   (default = 1        : Solution Flag'
      write(LER,*)
     :'              value require)      0 = Straight Ray'
      write(LER,*)
     :'                                  1 = Curved Ray'
      write(LER,*)
     :'                                  2 = Perturbed Curved Ray'
      write(LER,*)
     :'                                  3 = Fast curved ray'
      write(LER,*)
     :'-em[angl]      (default = 0)    : Angles Flag'
      write(LER,*)
     :'                                  0 = incident angle'
      write(LER,*)
     :'                                  1 = emergent angle'
      write(LER,*)
     :'-saf       (default =           : Slope adjustment factor '
      write(LER,*)
     :'           no sampling - use      amount by which slope of vel'
      write(LER,*)
     :'           function as input)     must change for pick ' 
      write(LER,*)
     :'-S            (default = No)     : global velocity function (in'
      write(LER,*)
     :'                        usp format), & all trace distance same'
      write(LER,*)
     :'-tdfn          (default = No)   : If present, velocity file is'
      write(LER,*)
     :'                                  in TDFN card image format'
      write(LER,*)
     :'-disco         (default =  No)  : If present, velocity file is'
      write(LER,*)
     :'                                  in DISCO HANDVEL card images'
      write(LER,*)
     :'-cdp           (default =  No)  : If present, velocity and'
      write(LER,*)
     :'                                  angle fields are keyed to CDP'
      write(LER,*)
     :'                                      (DphInd, word 122) ' 
      write(LER,*)
     :'                                  number instead of RI number' 
      write(LER,*)
     :'-BC            (default =  No)  : compute CDP XYs from S/R XYs'
      write(LER,*)
     :'-srcpnt        (default =  No)  : If present, velocity and'
      write(LER,*)
     :'                                  angle fields are keyed to '
      write(LER,*)
     :'                                  SOURCE POINT number (SrcPnt,'
      write(LER,*)
     :'                                  word 108) instead of RI #'
      write(LER,*)
     :'-sm[sm]        (default = 0)    : Output Mode' 
      write(LER,*)
     :'                                  0 = Normal' 
      write(LER,*)
     :'                                  1 = Output muted cdps'
      write(LER,*)
     :'-norm[inorm]    (default = 0)    : Stack normalization mode'
      write(LER,*)
     :'                                  0 = number live samples '
      write(LER,*)
     :'                                  1 = delta theta'
      write(LER,*)
     :'-dead          (default = No)    : If present, zero-valued'
      write(LER,*)
     :'                                  stack traces not flagged'
      write(LER,*)
     :'                                  "dead"'
      write(LER,*)
     :'-iord          (default = None)  : Enter smoothing factor for' 
      write(LER,*)
     :'                                   RMS velocities'        
      write(LER,*)
     :'-angles       (default = No)     : If present, the "-v" data '
      write(LER,*)
     :'                                   file is an angle data set,'
      write(LER,*)
     :'-exp[expw]    (default = 1.0)    : Exponent for stack '
      write(LER,*)
     :'                                   normalization vector'
      write(LER,*)
     :'                                   USE ONLY THE DEFAULT FOR AVO'
      write(LER,*)
     :'                                   APPLICATIONS.'
      write(LER,*)
     :'                                   If < 0, do no normalization'
      write(LER,*)
     :'-D             (default = No)    : If present, the input data'
      write(LER,*)
     :'                                   and velocities are in depth'
      write(LER,*)
     :'                                   Samp interval must be correct'
      write(LER,*)
     :'                                   Velocities must be interval  '
       write(LER,*)' '
       write(LER,*)                                        
     :'Usage:  '
      write(LER,*)
     :' angst -N[] -O[] -v[] -A[] -as[] -ae[] -ai[] -rs[] -re[]' 
*    :' angst -N[] -O[] -v[] -O2[] -O3[] -as[] -ae[] -ai[] -rs[] -re[]' 
       write(LER,*)
     :' -ws[ws] -we[we] -md[md] -em[em] -sm[] -saf[] -iord[] -exp[]'
      write(LER,*)
     :' -dead -tdfn -disco -cdp -BC -shot -angles -D -norm[]'
       write(LER,*)                                     
     :'***************************************************************'
       write(LER,*)                                     
     :' OR the angle parameters can be omitted and angles entered via'
       write(LER,*)
     :' nANGL cards.  In this case the Usage is'
       write(LER,*)
     :' '
       write(LER,*)
     :' angst -N[] -O[] -v[] -A[] -DA[nANGL cards] -rs[] -re[]'
*    :' angst -N[] -O[] -v[] -O2[] -O3[] -DA[nANGL cards] -rs[] -re[]'
       write(LER,*)
     :' -ws[ws] -we[we] -md[md] -em[em] -sm[] -saf[saf] -iord[]'
       write(LER,*)
     :' -S -dead -tdfn -disco -cdp -shot -angles -D'
*    :' -S -dead -tdfn -disco -cdp -shot -A'
      return                                                          
      end                                                            
      subroutine chkfle(name,lu)
#include <f77/iounit.h>
      character*100 name
      integer lu
      logical there
C
      inquire(FILE=name, EXIST=there)
      if(.not.there)THEN
        write(LER, *)name, ' does not exist.'
        write(LER, *)' Program abended'
        call ccexit(100)
      endif
      return
      end
