C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine XgraphOut( luout, Cumulative, Smoothed, Static, Xaxis, 
     :     nelem )

c Routine to build and output xgraph format file plottable using 
c xgraph to show the cumulative static curve, the current fit to it
c and the resulting static application profile

      integer luout, nelem, Xaxis(nelem)

      real Cumulative(nelem), Smoothed(nelem), Static(nelem)

      character CumStat*18, StatFromHead*24, StatFromGraph*19

      CumStat = '"Cumulative Static'
      StatFromHead = '"Static From Data Header'
      StatFromGraph = '"Static From Xgraph'

c output curve 1 : cumulative  static

      write(luout,'(a18)') CumStat
      write(luout,100)(float(Xaxis(i)),Cumulative(i),i=1,nelem)
 100  format(f15.3,2x,f15.3)

      write(luout,110)
 110  format(/)

c output curve 2: Static from input header

      write(luout,'(a24)') StatFromHead
      write(luout,100)(float(Xaxis(i)),Smoothed(i),i=1,nelem)
      write(luout,110)

c output curve 3: calculated shot static

      write(luout,'(a19)') StatFromGraph
      write(luout,100)(float(Xaxis(i)),Static(i),i=1,nelem)
      write(luout,110)

      return
      end

