C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c                      arcsapply
c  
c Adjacent Record Cumulative Statics: application of calculated static routine
c
c declare standard USP variables
 
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
 
      integer     itr ( SZLNHD )
      integer     nsamp, nsi, ntrc, ntrco, nrec, nreco, iform
      integer     luin, luout, lbytes, nbytes, lbyout
      integer     irs, ire, ns, ne, argis

      real        tri( 2*SZLNHD )

      character   ntap*255, otap*255, name*9
      
      logical     verbos

c declare program specific static memory variables

      integer   SrcLoc, ifmt_SrcLoc, l_SrcLoc, ln_SrcLoc
      integer   RecInd, ifmt_RecInd, l_RecInd, ln_RecInd
      integer   StaCor, ifmt_StaCor, l_StaCor, ln_StaCor
      integer   TVPT21, ifmt_TVPT21, l_TVPT21, ln_TVPT21
      integer   TVPT20, ifmt_TVPT20, l_TVPT20, ln_TVPT20
      integer   TVPV20, ifmt_TVPV20, l_TVPV20, ln_TVPV20
      integer   StaWrd, l_StaticWord, ifmt_StaticWord, ln_StaticWord
      integer   lugraph, lugraphout, istatic, OldStatic
      integer   ordfft, length, k2, ntnew, nsampX, JJ, KK
      integer   XgraphIndex(2 * SZLNHD), InputHeaderStatic(2 * SZLNHD)

      real        work(2 * SZLNHD), omega(2 * SZLNHD)
      real        Static, pi, domega, XgraphStatic(2 * SZLNHD)
      real        CumStatic(2 * SZLNHD)

      complex     expphi(2 * SZLNHD)

      character   xtap*255, xouttap*255, StaticWord*6
      character   xgraph_SortFlag*1, ApplicationFlag*6

c initialize variables

      data lbytes / 0 /
      data nbytes / 0 /
      data luin / 0 /
      data luout / 1 /
      data name/'ARCSAPPLY'/
      data xgraph_SortFlag/' '/
      data ApplicationFlag/'apply'/

c get command line help if requested

      if ( argis ( '-?' ) .gt. 0 .or. 
     :     argis ( '-h' ) .gt. 0 .or. 
     :     argis ( '-help' ) .gt. 0 ) then
         call help()
         stop
      endif

c Open Printout File

#include <f77/open.h>

c get Command Line Parameters

      call gcmdln ( ntap, otap, ns, ne, irs, ire, xtap, xouttap,
     :     xgraph_SortFlag, ApplicationFlag, StaticWord, verbos )

c ntap : input dataset name
c otap : output dataset name
c xtap: xgraph input file [as output by arcsapplycum]
c xouttap: xgraph output file 
c ns,ne : start and end traces
c irs,ire : start and end records
c verbos : verbosity flag
c xgraph_SortFlag : G = group indexed, S = shot indexed]
c ApplicationFlag : header = put statics in trace header only
c                   apply = put statics in trace header and apply to data
c                   [default] = apply
c StaticWord : Header word to use for storage/application of calculated static
 
c get logical unit numbers for input and output of seismic data

      call getln ( luin , ntap, 'r', 0 )
      call getln ( luout, otap, 'w', 1 )

c open input xgraph file

      call alloclun(lugraph)
      length = lenth(xtap)
      if (length .eq. 0) go to 992
      open( unit = lugraph, file = xtap(1:length), status = 'old', 
     :     err = 992 ) 

c open output xgraph file

      if ( xouttap .ne. ' ' ) then
         lugraphout = 27
         length = lenth(xouttap)
         if (length .eq. 0) go to 993
         open( unit = lugraphout, file = xouttap(1:length), 
     :        status = 'unknown', err = 993 ) 
      endif

c read input line header 

      call rtape  ( luin, itr, lbytes)
      if(lbytes .eq. 0) then
         length = lenth(ntap)
	 if (length .gt. 0) then
           write(LER,*)'ARCSAPPLY: no header on input ',
     :		ntap(1:length)
	 else
           write(LER,*)'ARCSAPPLY: no header on stdin '
	 endif
         write(LER,*)'FATAL'
         stop
      endif
 
c save certain parameters

      call savelu('SrcLoc',ifmt_SrcLoc,l_SrcLoc,ln_SrcLoc,TRACEHEADER)
      call savelu('RecInd',ifmt_RecInd,l_RecInd,ln_RecInd,TRACEHEADER)
      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)
      call savelu('TVPT21',ifmt_TVPT21,l_TVPT21,ln_TVPT21,TRACEHEADER)
      call savelu('TVPT20',ifmt_TVPT20,l_TVPT20,ln_TVPT20,TRACEHEADER)
      call savelu('TVPV20',ifmt_TVPV20,l_TVPV20,ln_TVPV20,TRACEHEADER)
      call savelu ( StaticWord, ifmt_StaticWord, l_StaticWord, 
     :     ln_StaticWord, TRACEHEADER )

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

c check compatability of command line parameters with data
      
         call cmdchk( ns, ne, irs, ire, ntrc, nrec )
 
c print the historical line header to the printout file and load to
c modified historical line header in memory 

      call hlhprt (itr, lbytes, name, 9, LERR)
 
c modify line header to reflect actual number of traces output

      if ( ns .eq. 0 ) ns = 1
      if ( ne .eq. 0 ) ne = ntrc
      if ( irs .eq. 0 ) irs = 1
      if ( ire .eq. 0 ) ire = nrec

      nreco = ire - irs + 1
      ntrco   = ne - ns + 1

      call savew(itr, 'NumRec', nreco, LINHED)
      call savew(itr, 'NumTrc', ntrco  , LINHED)
 
c move hlh into output line header 
 
      call savhlh ( itr, lbytes, lbyout )
 
c write output line header as required

      call wrtape ( luout, itr, lbyout )

c output of all pertinent information before processing begins

      call verbal ( ntap, otap, xtap, xouttap, ns, ne, irs, ire,
     :     xgraph_SortFlag, ApplicationFlag, StaticWord, nsamp, nsi, 
     :     ntrc, nrec, iform, nreco, ntrco, verbos )

c Initialize arrays and variables 

      call vclr( CumStatic, 1, 2*SZLNHD )
      call vclr( XgraphStatic, 1, 2*SZLNHD )
      call vclr( work, 1, 2*SZLNHD )
      call vclr( omega, 1, 2*SZLNHD )

      do i = 1, 2*SZLNHD 
         XgraphIndex(i) = 0
         InputHeaderStatic(i) = 0
      enddo

c determine fft stuff for ApplyStatics subroutine 
c do this here so it happens only once to speed things up
c This stuff is required for the rshift() subroutine which
c does a phase shift in fft to allow floating point static application

      pi = 3.1415926
      k2 = ordfft ( nsamp )
      ntnew = 2**k2
      domega = 2. * pi/ntnew

      do iomega = 1, ntnew/2
         omega(iomega) = ( iomega - 1 ) * domega
      enddo  

c READ the xgraph input

      call ReadXgraph ( lugraph, XgraphIndex, XgraphStatic, nsampX )
      
c BEGIN PROCESSING

c skip to start record

      call recskp ( 1, irs-1, luin, ntrc, itr )

      DO JJ = irs, ire 

c skip to start trace

         call trcskp ( JJ, 1, ns - 1, luin, ntrc, itr )

         DO KK = ns, ne

c read input data
            
            call rtape ( luin, itr, lbytes )
            if ( lbytes .eq. 0 ) then
               write(LERR,*)'End of file on input:'   
               write(LERR,*)'  rec= ',JJ,'  trace= ',KK
               go to 999
            endif

            call vmov ( itr(ITHWP1), 1, tri, 1, nsamp )

            call saver2 ( itr, ifmt_SrcLoc, l_SrcLoc, ln_SrcLoc, SrcLoc, 
     :           TRACEHEADER )
            call saver2 ( itr, ifmt_RecInd, l_RecInd, ln_RecInd, RecInd, 
     :           TRACEHEADER )
            call saver2 ( itr, ifmt_StaCor, l_StaCor, ln_StaCor, StaCor, 
     :           TRACEHEADER )
            call saver2 ( itr, ifmt_StaticWord, l_StaticWord, 
     :           ln_StaticWord, StaWrd, TRACEHEADER )

c Handle dead traces

            IF ( StaCor .ne. 30000 ) then

c find static to apply and update output xgraph curves

               if ( xgraph_SortFlag .eq. 'G' ) then

                  call FindStaticToApply ( XgraphStatic, XgraphIndex, 
     :                 RecInd, nsampX, Static )

                  call LoadOutputXgraph ( XgraphIndex, CumStatic, 
     :                 InputHeaderStatic, Static, StaWrd, RecInd, 
     :                 nsampX )

               else

                  call FindStaticToApply ( XgraphStatic, XgraphIndex, 
     :                 SrcLoc, nsampX, Static )

                  call LoadOutputXgraph ( XgraphIndex, CumStatic, 
     :                 InputHeaderStatic, Static, StaWrd, SrcLoc, 
     :                 nsampX )

               endif

c apply static if requested

               if ( ApplicationFlag .eq. 'apply' 
     :              .and. abs(Static) .gt. 1.e-32 )then
                  call vmov ( tri, 1, work, 1, nsamp )

c store static in the header in 10ths of milliseconds as per request
c from Steve Harris

                  istatic = nint( Static * 10.)

c convert Static to samples for application 

                 Static = Static / float(nsi)

c apply static

                 call rshift ( work, nsamp, ntnew, Static, omega,
     :                expphi )
                 call vmov ( work, 1, tri, 1, nsamp )

               endif

c Accumulate the applied static in the desired trace header entry

               call saver2( itr, ifmt_StaticWord, l_StaticWord,  
     :              ln_StaticWord, OldStatic, TRACEHEADER )

               istatic = istatic + OldStatic

               call savew2( itr, ifmt_StaticWord, l_StaticWord,  
     :              ln_StaticWord, istatic, TRACEHEADER )

c Now form the cummulative static for both shot and group application and store
c it in TVPT21  for use  with arcsdatum and pstack.  This will allow the automatic
c restoration of the datum post stack and was desired by Steve Harris.  I am going
c to put a loop into pstack that will  load the near offset TVPT21 to the output
c stacked trace.  This will allow a -stack option  to be put into arcsdatum to 
c restore the datum post-stack.

               call saver2( itr, ifmt_TVPT20, l_TVPT20,  
     :              ln_TVPT20, TVPT20, TRACEHEADER )
               call saver2( itr, ifmt_TVPV20, l_TVPV20,  
     :              ln_TVPV20, TVPV20, TRACEHEADER )

               TVPT21 = TVPT20 + TVPV20
               call savew2( itr, ifmt_TVPT21, l_TVPT21,  
     :              ln_TVPT21, TVPT21, TRACEHEADER )

            ENDIF

            call vmov ( tri, 1, itr(ITHWP1), 1, nsamp )
            call wrtape ( luout, itr, lbytes )

         ENDDO

c  skip to end of record

         call trcskp ( JJ, ne + 1, ntrc, luin, ntrc, itr )

      ENDDO

c write the xgraph output file if requested

      if ( xouttap .ne. ' ' ) then
         call XgraphOut ( lugraphout, CumStatic, InputHeaderStatic,
     :        XgraphStatic, XgraphIndex, nsampX )
      endif
c GO TO NORMAL TERMINATION

      goto 999

c ERROR MESSAGES

 992  continue

      write(LER,*)' ARCSAPPLY: Cannot open input Xgraph file'
      write(LER,*)'       Check existance/permissions'
      write(LER,*)'       and try again.'
      write(LER,*)'  '
      write(LER,*)' FATAL'
      write(LERR,*)' ARCSAPPLY: Cannot open input Xgraph file'
      write(LERR,*)'       Check existance/permissions'
      write(LERR,*)'       and try again.'
      write(LERR,*)'  '
      write(LERR,*)' FATAL'
      stop

 993  continue

      write(LER,*)' ARCSAPPLY: Cannot open output Xgraph file'
      write(LER,*)'       Check permissions'
      write(LER,*)'       and try again.'
      write(LER,*)'  '
      write(LER,*)' FATAL'
      write(LERR,*)' ARCSAPPLY: Cannot open input Xgraph file'
      write(LERR,*)'       Check permissions'
      write(LERR,*)'       and try again.'
      write(LERR,*)'  '
      write(LERR,*)' FATAL'
      stop

c Normal Termination

 999  continue
 

      call lbclos(luin)
      call lbclos(luout)
      close(lugraph)
      if ( xouttap .ne. ' ' ) close(lugraphout)

      write(LERR,*)' '
      write(LERR,*)' '
      write(LERR,*)'processed',nreco,' record(s)',' with ',ntrco, 
     :     ' traces'
      write(LERR,*)'       Normal Termination'

      write(LER,*)'ARCSAPPLY: Normal Termination'

      stop
      end
