C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      integer function ordfft (npts)
c
c     Written by:  Bill Done
c
c     Given the integer npts, not necessarily a power of 2, this function
c     computes that power of 2 (nu) such that 2**nu >= npts.
c
      if (npts .ge. 2) then
         nu = alog10(float(npts))/alog10(2.)
         if (npts .gt. 2**nu) then
            nu = nu + 1
         endif
       else
         nu = 1
      endif
      ordfft = nu
      return
      end
