C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c                         arcscross
c  
c Adjacent Record Cumulative Statics: cross correlation routine
c
c Reads in Pilot and Object stack information as output by arcsstack, 
c performs a cross-correlation [user window input if desired] and outputs
c to stdout the resulting correlation for input to arcscum which will
c construct the cummulative static profile.  The optional pickfile input
c will serve to limit the amount of data used in the cross-correlation and
c will take the form of a standard xsd pickfile where both a window start
c and window end will be expected.  It is expected that regardless of how
c many segments it has taken the user to build this file that each trace
c will have defined a start and end time.

c declare standard USP variables
 
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>
 
      integer     itr ( SZLNHD )
      integer     nsamp, nsi, ntrc, ntrco, nrec, nreco, iform, obytes
      integer     luout, lbytes, nbytes, lbyout
      integer     irs, ire, argis

      real        tri( 2* SZLNHD )

      character   otap*100, name*9

      logical     verbos, query

c declare program specific static memory variables

      integer   ifmt_StaCor, l_StaCor, ln_StaCor
      integer   WindowStart, WindowEnd, Lags

      integer   lupilot, luobject

      real      work( 2* SZLNHD ), Pilot( 2* SZLNHD), Object( 2* SZLNHD)

      character   pilottap*100, objecttap*100

c initialize variables

      data lbytes / 0 /
      data nbytes / 0 /
      data name/'ARCSCROSS'/

c get command line help if requested

      query = ( argis ( '-?' ) .gt. 0 .or. argis ( '-h' ) .gt. 0 )
      if ( query )then
         call help()
         stop
      endif

c Open Printout File

#include <f77/open.h>
 

c get Command Line Parameters

      call gcmdln ( pilottap, objecttap, otap, irs, ire,
     :     WindowStart, WindowEnd, Lags, verbos )

c pilottap : pilot stack dataset name 
c objecttap : object stack dataset name
c otap : output dataset name
c irs,ire : start and end records
c verbos : verbosity flag
c WindowStart/End : user defined correlation window start and end time (ms)
c Lags : number of lags to use in cross-correlation [default 100]

c get logical unit numbers for input and output of seismic data

      call alloclun(lupilot)
      call getln(lupilot,pilottap,'r',1)
      call alloclun(luobject)
      call getln(luobject,objecttap,'r',1)

c output files
         
      call getln(luout, otap,'w', 1)

c read input Pilot Stack line header 

      call rtape  ( lupilot, itr, lbytes)

      if(lbytes .eq. 0) then
         write(LER,*)'ARCSCROSS: no data in ',pilottap
         write(LER,*)'           Check existance/permissions and try'
         write(LER,*)'           again'
         write(LER,*)'FATAL'
         stop
      endif
 
c save certain parameters

      call savelu('StaCor',ifmt_StaCor,l_StaCor,ln_StaCor,TRACEHEADER)

      call saver(itr, 'NumSmp', nsamp, LINHED)
      call saver(itr, 'SmpInt', nsi  , LINHED)
      call saver(itr, 'Format', iform, LINHED)
      call saver(itr, 'NumTrc', ntrc , LINHED)
      call saver(itr, 'NumRec', nrec , LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

c modified historical line header in memory 

      call hlhprt (itr, lbytes, name, 9, LERR)
 
c convert window limits and lags to samples for processing

      WindowStart = nint( float(WindowStart) / float(nsi) )
      if ( WindowStart .eq. 0 ) WindowStart = 1
      WindowEnd = nint( float(WindowEnd) / float(nsi) )
      if ( WindowEnd .eq. 0 ) WindowEnd = nsamp
      nsampwind = WindowEnd - WindowStart + 1
      Lags = nint( float(Lags) / float(nsi) )

      if ( Lags .gt. nsampwind ) then
         Lags = nsampwind - 1
         write(LERR,*) ' ' 
         write(LERR,*) ' WARNING: reduced Lags to ', Lags * nsi, ' ms'
         write(LERR,*) ' ' 
      endif

c modify line header to reflect actual number of records, traces, samples output

      if ( irs .eq. 0 ) irs = 1
      if ( ire .eq. 0 ) ire = nrec
      nreco = ire - irs + 1

      ntrco   = 1

      nsampo = 2 * Lags + 1

      call savew(itr, 'NumRec', nreco, LINHED)
      call savew(itr, 'NumTrc', ntrco  , LINHED)
      call savew(itr, 'NumSmp', nsampo  , LINHED)
 
c number output bytes

      obytes = SZTRHD + nsampo * SZSMPD
 
c move hlh into output line header 
 
      call savhlh ( itr, lbytes, lbyout )
      call wrtape ( luout, itr, lbyout )

c output of all pertinent information before processing begins

      call verbal ( pilottap, objecttap, otap, irs, ire, 
     :     WindowStart, WindowEnd, Lags, nsamp, nsi, nrec, nreco, 
     :     nsampo, verbos )

c read past line header of Object stack

      call rtape(luobject,itr,lbytes)
      if(lbytes .eq. 0) then
         write(LER,*)'ARCSCROSS: no data in ',objecttap
         write(LER,*)'      Check existance/spelling and try again.'
         write(LER,*)'FATAL'
         stop
      endif

c read pair of traces from Pilot and Object and Cross-correlate
c within limits supplied by user.

c skip down to start record

      call recskp ( 1, irs-1, luin, ntrc, itr )

      DO JJ = irs, ire

         call rtape ( lupilot, itr, lbytes )
         if ( lbytes .eq. 0 ) goto 993 
         call vmov( itr( ITHWP1 + WindowStart - 1 ), 1, Pilot(1), 1, 
     :        nsampwind )

         call rtape ( luobject, itr, lbytes )
         if ( lbytes. eq. 0 ) goto 994 
         call vmov ( itr( ITHWP1 + WindowStart - 1 ), 1, Object(1), 1,
     :        nsampwind )

c clear workspace

         call vclr ( tri, 1, nsamp )
         call vclr ( work, 1, nsamp )

c do negative lags first using work space
c then move into tri() in reverse order

         call ccort ( Object, Pilot, work, Lags, nsampwind )
         call vmov ( work, 1, tri( Lags + 1), -1, Lags )

c do positive lags directly into tri()

         call ccort ( Pilot, Object, tri( Lags + 1 ), Lags, nsampwind )

c output cross correlation trace with header from Object
c [as it was the last trace read, itr(1-128) will be from it]

         call vmov ( tri, 1, itr(ITHWP1), 1, nsampo )
         call savew2 ( itr, ifmt_StaCor, l_StaCor, ln_StaCor, 0, 
     :        TRACEHEADER )
         call wrtape ( luout, itr, obytes )

      ENDDO

c GO TO NORMAL TERMINATION

      goto 999

c ERROR MESSAGES

 993  continue

      if ( verbos ) then
         write(LER,*)' ARCSCROSS: Premature EOF on Pilot Stack dataset'
         write(LER,*)'       while calculating cross-correlations. '
         write(LER,*)'  '
         write(LER,*)' FATAL'
      endif

      write(LERR,*)' ARCSCROSS: Premature EOF on Pilot Stack dataset'
      write(LERR,*)'       while calculating cross-correlations. '
      write(LERR,*)'  '
      write(LERR,*)' FATAL'
      stop

 994  continue

      if ( verbos ) then
         write(LER,*)' ARCSCROSS: Premature EOF on Object Stack dataset'
         write(LER,*)'       while calculating cross-correlations. '
         write(LER,*)'  '
         write(LER,*)' FATAL'
      endif

      write(LERR,*)' ARCSCROSS: Premature EOF on Object Stack dataset'
      write(LERR,*)'       while calculating cross-correlations. '
      write(LERR,*)'  '
      write(LERR,*)' FATAL'
      stop

c Normal Termination

 999  continue
 
c close data files flush data left in output buffer
c NOTE: if the output buffer is not closed you can sometimes end up
c with missing data

      call lbclos(lupilot)
      call lbclos(luobject)
      call lbclos(luout)

c Termination Messages

      write(LERR,*) ' '
      write(LERR,*) ' '
      write(LERR,*) ' '
      write(LERR,*)'processed',nreco,' record(s)',' with ',ntrco, 
     :     ' traces'
      write(LERR,*)'       Normal Termination'

      write(LER,*)'ARCSCROSS: Normal Termination'

      stop
      end
