C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine verbal ( pilottap, objecttap, otap, irs, ire, 
     :     WindowStart, WindowEnd, Lags, nsamp, nsi, nrec, nreco, 
     :     nsampo, verbos )

#include <f77/iounit.h>
 
      integer     nsamp, nsi, nrec, nreco, nsampo
      integer     WindowStart, WindowEnd, Lags, length

      character   otap*(*), pilottap*(*), objecttap*(*)

      logical     verbos
 
      write(LERR,*)' '
      write(LERR,*)' input line header values '
      write(LERR,*) ' # of samples/trace =  ', nsamp
      write(LERR,*) ' sample interval    =  ', nsi
      write(LERR,*) ' traces per record  =  1'
      write(LERR,*) ' records per line   =  ', nrec
      write(LERR,*) ' format of data     =  ', iform
      length = lenth(pilottap)
      if (length .gt. 0) then
        write(LERR,*)' Pilot Stack dataset name = ',
     :		pilottap(1:length)
      else
        write(LERR,*)' Pilot Stack dataset name = N/A'
      endif
      length = lenth(objecttap)
      if (length .gt. 0) then
        write(LERR,*)' Object Stack dataset name = ',
     :		objecttap(1:length)
      else
        write(LERR,*)' Object Stack dataset name = N/A'
      endif
      
      write(LERR,*)' '
      write(LERR,*)' output line header values '
      write(LERR,*) ' # of samples/trace =  ', nsampo
      write(LERR,*) ' sample interval    =  ', nsi
      write(LERR,*) ' traces per record  =  1'
      write(LERR,*) ' records per line   =  ', nreco
      write(LERR,*) ' format of data     =  ', iform

      write(LERR,*)' '
      write(LERR,*)' command line entries used '
      write(LERR,*)' '
      write(LERR,*)' start record = ',irs
      write(LERR,*)' end record = ',ire
      write(LERR,*)' window start (ms) = ',WindowStart
      write(LERR,*)' window end (ms) = ',WindowEnd
      write(LERR,*)' Maximum Lag of cross correlation (ms) = ',Lags

      if (verbos) write(LERR,*)' Verbos printout requested'
      return
      end
