C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine ReadPicks(lupicks,StructurePicks,CDPlocation,PickIndex,
     :     nseg)

c routine to read structural xsd header value at pick file
c to retrieve cdp vs horizon time information 

      integer lupicks,PickIndex(*),nseg,npick,count
      integer CDPlocation(*)

      real StructurePicks(*),value

      character key*10

      nseg = 0
      npick = 0
      count = 0

      rewind(lupicks)

      DO while(1.eq.1)
            
         read(lupicks,'(a10,1x,f17.6)',end=200)key,value

c assign npick to last segment
c advance segment counter
c reset pick in a segment counter

           if (key.EQ.'Segment') then

              if(nseg.gt.0)PickIndex(nseg) = npick
              nseg=nseg+1
              npick = 0
              read(lupicks,'(a10,1x,a20)',end=200)key,value

           endif

c Increment pick counter

           if (key.EQ.'Pick') then
              count=count+1
              npick = npick + 1
           endif

c get sample value of pick

           if (key.EQ.'Sample') then
              StructurePicks(count)=value
           endif

c get DphInd location of pick

           if (key.EQ.'DphInd') then
              CDPlocation(count)=ifix(value)
           endif

      ENDDO

 200  continue

c assign segment number and number of picks to index() for
c last segment picked

      if(nseg.gt.0)PickIndex(nseg) = npick
      
      return
      end




