C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      SUBROUTINE CEEZ (DEL1,DEL2,SIGMA,C1,C2,C3,N)
C
      REAL DEL1,DEL2,SIGMA,C1,C2,C3
C
C                      FROM THE SPLINE UNDER TENSION PACKAGE
C                       CODED BY A. K. CLINE AND R. J. RENKA
C                            DEPARTMENT OF COMPUTER SCIENCES
C                              UNIVERSITY OF TEXAS AT AUSTIN
C
C THIS SUBROUTINE DETERMINES THE COEFFICIENTS C1, C2, AND C3
C USED TO DETERMINE ENDPOINT SLOPES. SPECIFICALLY, IF
C FUNCTION VALUES Y1, Y2, AND Y3 ARE GIVEN AT POINTS X1, X2,
C AND X3, RESPECTIVELY, THE QUANTITY C1*Y1 + C2*Y2 + C3*Y3
C IS THE VALUE OF THE DERIVATIVE AT X1 OF A SPLINE UNDER
C TENSION (WITH TENSION FACTOR SIGMA) PASSING THROUGH THE
C THREE POINTS AND HAVING THIRD DERIVATIVE EQUAL TO ZERO AT
C X1. OPTIONALLY, ONLY TWO VALUES, C1 AND C2 ARE DETERMINED.
C
C ON INPUT--
C
C   DEL1 IS X2-X1 (.GT. 0.).
C
C   DEL2 IS X3-X1 (.GT. 0.). IF N .EQ. 2, THIS PARAMETER IS
C   IGNORED.
C
C   SIGMA IS THE TENSION FACTOR.
C
C AND
C
C   N IS A SWITCH INDICATING THE NUMBER OF COEFFICIENTS TO
C   BE RETURNED. IF N .EQ. 2 ONLY TWO COEFFICIENTS ARE
C   RETURNED. OTHERWISE ALL THREE ARE RETURNED.
C
C ON OUTPUT--
C
C   C1, C2, AND C3 CONTAIN THE COEFFICIENTS.
C
C NONE OF THE INPUT PARAMETERS ARE ALTERED.
C
C THIS SUBROUTINE REFERENCES PACKAGE MODULE SNHCSH.
C
C-----------------------------------------------------------
C
      IF (N .EQ. 2) GO TO 2
      IF (SIGMA .NE. 0.) GO TO 1
      DEL = DEL2-DEL1
C
C TENSION .EQ. 0.
C
      C1 = -(DEL1+DEL2)/(DEL1*DEL2)
      C2 = DEL2/(DEL1*DEL)
      C3 = -DEL1/(DEL2*DEL)
      RETURN
C
C TENSION .NE. 0.
C
    1 CALL SNHCSH (DUMMY,COSHM1,SIGMA*DEL1,1)
      CALL SNHCSH (DUMMY,COSHM2,SIGMA*DEL2,1)
      DELP = SIGMA*(DEL2+DEL1)/2.
      DELM = SIGMA*(DEL2-DEL1)/2.
      CALL SNHCSH (SINHMP,DUMMY,DELP,-1)
      CALL SNHCSH (SINHMM,DUMMY,DELM,-1)
      DENOM = COSHM1*(DEL2-DEL1)-2.*DEL1*(SINHMP+DELP)*
     *        (SINHMM+DELM)
      C1 = 2.*(SINHMP+DELP)*(SINHMM+DELM)/DENOM
      C2 = -COSHM2/DENOM
      C3 = COSHM1/DENOM
      RETURN
C
C TWO COEFFICIENTS
C
    2 C1 = -1./DEL1
      C2 = -C1
      RETURN
      END
      SUBROUTINE TERMS (DIAG,SDIAG,SIGMA,DEL)
C
      REAL DIAG,SDIAG,SIGMA,DEL
C
C                      FROM THE SPLINE UNDER TENSION PACKAGE
C                       CODED BY A. K. CLINE AND R. J. RENKA
C                            DEPARTMENT OF COMPUTER SCIENCES
C                              UNIVERSITY OF TEXAS AT AUSTIN
C
C THIS SUBROUTINE COMPUTES THE DIAGONAL AND SUPERDIAGONAL
C TERMS OF THE TRIDIAGONAL LINEAR SYSTEM ASSOCIATED WITH
C SPLINE UNDER TENSION INTERPOLATION.
C
C ON INPUT--
C
C   SIGMA CONTAINS THE TENSION FACTOR.
C
C AND
C
C   DEL CONTAINS THE STEP SIZE.
C
C ON OUTPUT--
C
C               (SIGMA*DEL*COSH(SIGMA*DEL) - SINH(SIGMA*DEL)
C   DIAG = DEL*--------------------------------------------.
C                     (SIGMA*DEL)**2 * SINH(SIGMA*DEL)
C
C                   SINH(SIGMA*DEL) - SIGMA*DEL
C   SDIAG = DEL*----------------------------------.
C                (SIGMA*DEL)**2 * SINH(SIGMA*DEL)
C
C AND
C
C   SIGMA AND DEL ARE UNALTERED.
C
C THIS SUBROUTINE REFERENCES PACKAGE MODULE SNHCSH.
C
C-----------------------------------------------------------
C
      IF (SIGMA .NE. 0.) GO TO 1
      DIAG = DEL/3.
      SDIAG = DEL/6.
      RETURN
    1 SIGDEL = SIGMA*DEL
      CALL SNHCSH (SINHM,COSHM,SIGDEL,0)
      DENOM = DEL/((SINHM+SIGDEL)*SIGDEL*SIGDEL)
      DIAG = DENOM*(SIGDEL*COSHM-SINHM)
      SDIAG = DENOM*SINHM
      RETURN
      END
      SUBROUTINE SNHCSH (SINHM,COSHM,X,ISW)
C
      INTEGER ISW
      REAL SINHM,COSHM,X,CUT(5)
C
C                      FROM THE SPLINE UNDER TENSION PACKAGE
C                       CODED BY A. K. CLINE AND R. J. RENKA
C                            DEPARTMENT OF COMPUTER SCIENCES
C                              UNIVERSITY OF TEXAS AT AUSTIN
C                          MODIFIED BY A.H. MORRIS (NSWC/DL)
C
C THIS SUBROUTINE RETURNS APPROXIMATIONS TO
C       SINHM(X) = SINH(X)-X
C       COSHM(X) = COSH(X)-1
C AND
C       COSHMM(X) = COSH(X)-1-X*X/2
C
C ON INPUT--
C
C   X CONTAINS THE VALUE OF THE INDEPENDENT VARIABLE.
C
C   ISW INDICATES THE FUNCTION DESIRED
C           = -1 IF ONLY SINHM IS DESIRED,
C           =  0 IF BOTH SINHM AND COSHM ARE DESIRED,
C           =  1 IF ONLY COSHM IS DESIRED,
C           =  2 IF ONLY COSHMM IS DESIRED,
C           =  3 IF BOTH SINHM AND COSHMM ARE DESIRED.
C
C ON OUTPUT--
C
C   SINHM CONTAINS THE VALUE OF SINHM(X) IF ISW .LE. 0 OR
C   ISW .EQ. 3 (SINHM IS UNALTERED IF ISW .EQ.1 OR ISW .EQ.
C   2).
C
C   COSHM CONTAINS THE VALUE OF COSHM(X) IF ISW .EQ. 0 OR
C   ISW .EQ. 1 AND CONTAINS THE VALUE OF COSHMM(X) IF ISW
C   .GE. 2 (COSHM IS UNALTERED IF ISW .EQ. -1).
C
C AND
C
C   X AND ISW ARE UNALTERED.
C
C-----------------------------------------------------------
C
      DATA SP5/.255251817302048E-09/,
     *     SP4/.723809046696880E-07/,
     *     SP3/.109233297700241E-04/,
     *     SP2/.954811583154274E-03/,
     *     SP1/.452867078563929E-01/,
     *     SQ1/-.471329214363072E-02/
      DATA CP5/.116744361560051E-08/,
     *     CP4/.280407224259429E-06/,
     *     CP3/.344417983443219E-04/,
     *     CP2/.232293648552398E-02/,
     *     CP1/.778752378267155E-01/,
     *     CQ1/-.545809550662099E-02/
      DATA ZP3/5.59297116264720E-07/,
     *     ZP2/1.77943488030894E-04/,
     *     ZP1/1.69800461894792E-02/,
     *     ZQ4/1.33412535492375E-09/,
     *     ZQ3/-5.80858944138663E-07/,
     *     ZQ2/1.27814964403863E-04/,
     *     ZQ1/-1.63532871439181E-02/
      DATA CUT(1)/1.65/, CUT(2)/1.2/, CUT(3)/1.2/, CUT(4)/2.7/,
     *     CUT(5)/1.65/
C
      XX = X
      AX = ABS(XX)
      XS = XX*XX
      IF (AX .GE. CUT(ISW+2)) EXPX = EXP(AX)
C
C SINHM APPROXIMATION
C
      IF (ISW .EQ. 1 .OR. ISW .EQ. 2) GO TO 2
      IF (AX .GE. 1.65) GO TO 1
      SINHM = ((((((SP5*XS+SP4)*XS+SP3)*XS+SP2)*XS+SP1)*XS+1.)
     *        *XS*XX)/((SQ1*XS+1.)*6.)
      GO TO 2
    1 SINHM = -(((AX+AX)+1./EXPX)-EXPX)/2.
      IF (XX .LT. 0.) SINHM = -SINHM
C
C COSHM APPROXIMATION
C
    2 IF (ISW .NE. 0 .AND. ISW .NE. 1) GO TO 4
      IF (AX .GE. 1.2) GO TO 3
      COSHM = ((((((CP5*XS+CP4)*XS+CP3)*XS+CP2)*XS+CP1)*XS+1.)
     *        *XS)/((CQ1*XS+1.)*2.)
      GO TO 4
    3 COSHM = ((1./EXPX-2.)+EXPX)/2.
C
C COSHMM APPROXIMATION
C
    4 IF (ISW .LE. 1) RETURN
      IF (AX .GE. 2.70) GO TO 5
      COSHM = ((((ZP3*XS+ZP2)*XS+ZP1)*XS+1.)*XS*XS)/(((((ZQ4
     *        *XS+ZQ3)*XS+ZQ2)*XS+ZQ1)*XS+1.)*24.)
      RETURN
    5 COSHM = (((1./EXPX-2.)-XS)+EXPX)/2.
      RETURN
      END
      INTEGER FUNCTION INTRVL (X, T, M)
      REAL X, T(M)
C-----------------------------------------------------------------------
C
C             LOCATION OF A VALUE X IN A SEQUENCE T
C
C                       ----------------
C
C     INPUT--
C
C        X IS A REAL NUMBER.
C
C        T IS AN ARRAY OF NONDECREASING VALUES. IT IS
C          ASSUMED THAT T(1) .LT. T(M).
C
C        M IS THE LENGTH OF T (M .GE. 2).
C
C     OUTPUT--
C
C        INTRVL HAS THE VALUE I WHEN  T(I) .LE. X .LT. T(I+1).
C        OTHERWISE, IF L IS THE INTEGER WHERE T(L) .LT. T(L+1)
C        AND T(L+1) = ... = T(M), THEN INTRVL HAS THE VALUE I
C        WHERE
C                  I = 1   IF X .LT. T(1)
C                  I = L   IF X .GE. T(L)
C
C-----------------------------------------------------------------------
      IF (X .LT. T(2)) GO TO 100
      TM = T(M)
      I = M - 1
   10    IF (T(I) .LT. TM) GO TO 20
         I = I - 1
         GO TO 10
   20 IF (X .GE. T(I)) GO TO 110
      IL = 2
      IR = I
C
C     BISECTION SEARCH
C
   30 I = (IL + IR)/2
      IF (I .EQ. IL) GO TO 110
      IF (X - T(I)) 40,60,50
   40 IR = I
      GO TO 30
   50 IL = I
      GO TO 30
C
C     CASE WHEN X = T(I) FOR SOME I
C
   60 IF (X .LT. T(I+1)) GO TO 110
      I = I + 1
      GO TO 60
C
C     LEFT END
C
  100 INTRVL = 1
      RETURN
C
C     NORMAL EXIT
C
  110 INTRVL = I
      RETURN
      END
