C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine CalcStaticToRemove( JJ, StaticAtMinOffset, 
     :     NrecInBlock1, StaticToRemove, NinBlock1, nreco )

#include <f77/lhdrsz.h>

      integer JJ, NrecInBlock1, NinBlock1
      integer Start, End, Index, nreco

      real StaticAtMinOffset(SZLNHD), StaticToRemove(SZLNHD)
      real Static

c initialize variables

      Static = 0.0

      IF ( JJ .gt. NrecInBlock1 .and. NinBlock1 .eq. NrecInBlock1 ) then

c calculate statics to apply 

         Index = JJ - NrecInBlock1 - ( (NrecInBlock1 -1 ) / 2 ) +  1
         Start = Index - ( (NrecInBlock1 -1 ) / 2 )
         End = Index + ( (NrecInBlock1 -1 ) / 2 )

         do i = 1, NrecInBlock1

            Static = 0.0

            do j = Start, End
               Static = Static + StaticAtMinOffset(j)
            enddo

            StaticToRemove(Index) = Static / float (NrecInBlock1)
            Index = Index + 1
            Start = Start + 1
            End = End + 1

         enddo

      ELSEIF ( JJ .eq. NrecInBlock1 ) then

c handle first time in

         do i = 1, NrecInBlock1

            Static = Static + StaticAtMinOffset(i)

         enddo

         Static = Static / float(NrecInBlock1)

c load this static to first few spots as required

         do i = 1, ( (NrecInBlock1 -1 ) / 2 + 1)
           StaticToRemove(i) = Static
         enddo

      ELSEIF ( NrecInBlock1 .ne. NinBlock1 ) then

         Index = JJ - NrecInBlock1 - ( (NrecInBlock1 -1 ) / 2 ) +  1
         Start = Index - ( (NrecInBlock1 -1 ) / 2 )
         End = Index + ( (NrecInBlock1 -1 ) / 2 )

         if ( End .gt. nreco ) End = nreco

         do i = 1, NinBlock1 + ( (NrecInBlock1 -1 ) / 2)

            Static = 0.0

            do j = Start, End
               Static = Static + StaticAtMinOffset(j)
            enddo

            StaticToRemove(Index) = Static / float (End - Start + 1)
            Index = Index + 1
            Start = Start + 1
            End = End + 1

            if ( End .gt. nreco ) then

c fill out final entries with same static

               do k = 1, ( (NrecInBlock1 -1 ) / 2)
                  StaticToRemove(Index) = Static / 
     :                 float (End - Start + 1)
                  Index = Index + 1
               enddo
               
               return

            endif

         enddo

      ENDIF

      return
      end
