C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
c                           arcsdatum
c
c  Adjacent Record Cummulative Static datum : remove distortion of datum
c                                             due to static application
c
c usp system variables
c

#include <localsys.h>
#include <save_defs.h>
#include <f77/iounit.h>
#include <f77/lhdrsz.h>
#include <f77/sisdef.h>

c basic USP variables

      integer     lhed( SZLNHD )
      integer     nsamp, nsampo, ntrc, ntrco, nrec, nreco, irs, ire
      integer     ns, ne, start, end, nsi, iform
      integer     luin, luout, lbytes, obytes, lbyout, KK, JJ, argis

      real        tri(SZLNHD)

      character   name*9, ntap*255, otap*255

      logical     verbos

c program variables defined with dynamic memory allocation

      integer     Headers
      integer     errcd1, errcd3, abort
      integer     itemHeader, itemTrace

      real        Traces

      pointer     (wkadr1, Headers(200000))
      pointer     (wkadr3, Traces(200000))

c program variables defined with static memory allocation

      integer ntnew, k2, ordfft, iomega, SmoothOrder
      integer GroupStatic, ifmt_Group, l_Group, ln_Group
      integer ShotStatic, ifmt_Shot, l_Shot, ln_Shot
      integer Static, ifmt_Static, l_Static, ln_Static
      integer StaCor, ifmt_StaCor, l_StaCor, ln_StaCor
      integer DstSgn, ifmt_DstSgn, l_DstSgn, ln_DstSgn
      integer DphInd, ifmt_DphInd, l_DphInd, ln_DphInd
      integer TVPT21, ifmt_TVPT21, l_TVPT21, ln_TVPT21
      integer MinOffset, IndexHeader
      integer IndexTrace, length, nsampxy

      real omega(SZLNHD), pi, domega, work(SZLNHD)
      real StaticToRemove(SZLNHD), StaticAtMinOffset(SZLNHD)
      real XgraphCdpAxis(2*SZLNHD), XgraphTimeAxis(2*SZLNHD)

      character ShotWord*6, GroupWord*6, StaticWord*6, xytap*255

      logical QC, done, stack

c Initialize Required Variables

      data name/'ARCSDATUM'/
      data abort/0/
      data lbytes/0/
      data verbos/.false./
      data QC/.false./
      data done/.false./
      data stack/.false./

      call vclr( StaticAtMinOffset, 1, SZLNHD)
      call vclr( StaticToRemove, 1, SZLNHD)
      call vclr( omega, 1, SZLNHD)
      call vclr( work, 1, SZLNHD)

c get online help if requested

      if ( argis('-?') .gt. 0 .or. 
     :     argis('-h') .gt. 0 .or. 
     :     argis('-help') .gt. 0 ) then
          call help()
          stop
      endif

c open printout

#include <f77/open.h>

c read program parameters from command line argument string

      call cmdln ( ntap, otap, xytap, irs, ire, ns, ne, start, end, 
     :     ShotWord, GroupWord, StaticWord, QC, 
     :     SmoothOrder, stack, verbos )

c open input dataset

      call getln ( luin, ntap, 'r', 0)

c open output dataset -- USP dataset unless in QC mode, then xgraph file

      if ( .not. QC ) then
         call getln ( luout, otap, 'w', 1)
      else

c send output out stdout unless a file is attached

         luout = 6
         if ( otap .ne. ' ' ) then

c file is attached so open the file

            length = lenth(otap)
            open ( luout, file=otap(1:length), status='unknown', 
     :           err=992 )
         endif
      endif

      if ( xytap .ne. ' ') then

c open Xgraph file if attached. 
 
         call alloclun(luxy)
         length = lenth(xytap)
	 if (length .eq. 0) go to 993
         open(unit=luxy,file=xytap(1:length), status='old', err=993 )
      endif

c read and update line header, write line header, save key parameters.

      lbytes=0

      call rtape  ( luin, lhed, lbytes )
      if(lbytes .eq. 0) then
         write(LERR,*)'ARCSDATUM: no header read on unit ',ntap
         write(LERR,*)'FATAL'
         write(LERR,*)'Check existence of file & rerun'
         stop
      endif

      call saver(lhed, 'NumSmp', nsamp, LINHED)
      call saver(lhed, 'SmpInt', nsi  , LINHED)
      call saver(lhed, 'Format', iform, LINHED)
      call saver(lhed, 'NumTrc', ntrc , LINHED)
      call saver(lhed, 'NumRec', nrec , LINHED)
      call saver(itr, 'UnitSc', unitsc, LINHED)
      if (unitsc .eq. 0.0) then
          write(LERR,*)'********************************************'
          write(LERR,*)'WARNING: sample unit scaler in LH = ',unitsc
          write(LERR,*)'         will set to .001 (millisec default)'
          write(LERR,*)'********************************************'
          unitsc = .001
          call savew(itr, 'UnitSc', unitsc, LINHED)
      endif

c define header pointers

      call savelu ( 'TVPT21',ifmt_TVPT21, l_TVPT21, ln_TVPT21, 
     :     TRACEHEADER ) 
      call savelu ( 'DphInd',ifmt_DphInd, l_DphInd, ln_DphInd, 
     :     TRACEHEADER ) 
      call savelu ( 'DstSgn',ifmt_DstSgn, l_DstSgn, ln_DstSgn, 
     :     TRACEHEADER ) 
      call savelu ( 'StaCor',ifmt_StaCor, l_StaCor, ln_StaCor, 
     :     TRACEHEADER ) 
      call savelu ( ShotWord,ifmt_Shot, l_Shot, ln_Shot, 
     :     TRACEHEADER ) 
      call savelu ( GroupWord,ifmt_Group, l_Group, ln_Group, 
     :     TRACEHEADER ) 
      call savelu ( StaticWord,ifmt_Static, l_Static, ln_Static, 
     :     TRACEHEADER ) 

c print Historical Line header to printfile and update to line header

      call hlhprt ( lhed , lbytes, name, 9, LERR )

c Check Defaults and validity of command line entries
      
      if ( irs .eq. 0 ) irs = 1
      if ( ire .eq. 0 ) ire = nrec
      nreco = ire - irs + 1

      if ( ns .eq. 0 ) ns = 1
      if ( ne .eq. 0 ) ne = ntrc
      ntrco = ne - ns + 1

      if ( start .eq. 0 ) then
         start = 1
      else
         start = start / nsi
      endif

      if ( end .eq. 0 ) then
         end = nsamp
      else
         end = end / nsi
      endif

      nsampo = end - start + 1
      
      if ( .not. QC ) then

c update historical line header & output header

         obytes = SZTRHD + SZSMPD * nsampo

         call savew ( lhed, 'NumRec', nreco, LINHED)
         call savew ( lhed, 'NumTrc' , ntrco, LINHED)
         call savew ( lhed, 'NumSmp' , nsampo, LINHED)

         call savhlh ( lhed, lbytes, lbyout )
         call wrtape ( luout, lhed, lbyout )
      endif

c echo input parameters to printout

      call verbal ( ntap, otap, xytap, irs, ire, ns, ne, start, end,  
     :     nsamp, nsampo, ntrc, ntrco, nsi, nrec, nreco, iform,  
     :     ShotWord, GroupWord, StaticWord,  
     :     QC, SmoothOrder, verbos ) 

c dynamic memory allocation

      itemHeader = ntrco * ITRWRD * SZSMPD
      itemTrace = ntrco * nsampo * SZSMPD

      call galloc (wkadr1, itemHeader, errcd1, abort)
      call galloc (wkadr3, itemTrace, errcd3, abort)

      if ( errcd1 .ne. 0 
     :     .or. errcd3 .ne. 0) then
         write(LERR,*)' '
         write(LERR,*)'Unable to allocate workspace:'
         write(LERR,*)itemHeader + itemTrace,' bytes'
         write(LERR,*)'FATAL'
         write(LERR,*)' '
         write(LER,*)'ARCSDATUM: Unable to allocate workspace:'
         write(LER,*)itemHeader + itemTrace,' bytes'
         write(LER,*)'FATAL'
         go to 990
      else
         write(LERR,*)' '
         write(LERR,*)'Allocating workspace:'
         write(LERR,*)itemHeader + itemTrace,' bytes'
         write(LERR,*)' '
         write(LER,*)' '
         write(LER,*)'ARCSDATUM: Allocating workspace:'
         write(LER,*)itemHeader + itemTrace,' bytes'
         write(LER,*)' '
      endif

c initialize dynamically allocated arrays

      do i = 1, ntrco*ITRWRD
         Headers(i) = 0
      enddo

      call vclr ( Traces, 1, ntrco*nsampo )

      if ( xytap .ne. ' ' ) then

c read xgraph file and smooth according to user specified smoothing
c order
         
         call ReadXgraph ( luxy, XgraphCdpAxis, XgraphTimeAxis, 
     :        nsampxy )
         call SmoothFit ( XgraphTimeAxis, nsampxy, SmoothOrder )
      endif

      if ( .not. QC ) then

c initialize variables required for static removal using fft

         pi = 4. * atan(1.0)
         k2 = ordfft ( nsampo )
         ntnew = 2**k2
         domega = 2. * pi / ntnew

         do iomega = 1, ntnew/2
            omega(iomega) = ( iomega - 1 ) * domega
         enddo 
      endif

c skip to start record

      call recskp( 1, irs-1, luin, ntrc, lhed )

      DO JJ = irs, ire

c skip to start trace in record

         call trcskp ( JJ, 1, ns-1, luin, ntrc, lhed )

c reset MinOffset and indices for header and trace arrays

         MinOffset = 999999
         IndexHeader = 1 - ITRWRD
         IndexTrace = 1 - nsampo
         done = .false.
        
         DO KK = ns, ne

c advance indices

            IndexHeader = IndexHeader + ITRWRD
            IndexTrace = IndexTrace + nsampo

c load trace

            lbytes = 0
            call rtape( luin, lhed, lbytes)
            if(lbytes .eq. 0) then
               write(LERR,*)'Unexpected End Of File on input:'
               write(LERR,*)'at rec= ',JJ,'  trace= ',KK
               go to 990
            endif
            
c find static associated with near offset of this record on a live trace

            call saver2 ( lhed, ifmt_DphInd, l_DphInd, ln_DphInd, 
     :           DphInd, TRACEHEADER )
            call saver2 ( lhed, ifmt_DstSgn, l_DstSgn, ln_DstSgn, 
     :           DstSgn, TRACEHEADER )
            call saver2 ( lhed, ifmt_Group, l_Group, ln_Group, 
     :           GroupStatic, TRACEHEADER )
            call saver2 ( lhed, ifmt_Shot, l_Shot, ln_Shot, 
     :           ShotStatic, TRACEHEADER )
            call saver2 ( lhed, ifmt_StaCor, l_StaCor, ln_StaCor, 
     :           StaCor, TRACEHEADER )
            
c if datum solution is derived from data [marine case usually] with no
c QC by the user then no Xgraph file will be attached.  In this case find
c the static at the near cdp offset within the record, remove from record
c and output the record.  If the Xgraph file is attached get the datum static
c from the smoothed input from the file. If the -stack option has been flagged
c then read the static from TVPT21 and remove from the trace.  One might argue
c that you could use rest for this [as I did] but Steve wants this as an 
c option in arcsdatum for clarity.

            if (stack) then

               call saver2(lhed, ifmt_TVPT21, l_TVPT21, ln_TVPT21, 
     :           TVPT21, TRACEHEADER )
               StaticAtMinOffset(1) = 0.0 - float(TVPT21) / 
     :              ( 10. * float(nsi) )

            elseif ( xytap .eq. ' ' .and. .not. done ) then

c obtain near offset static from data, remember that the shot and group
c statics are stored in the trace header in 10ths of milliseconds. 

               if ( iabs( DstSgn ) .lt. MinOffset .and. StaCor .ne. 
     :              30000 ) then
                  MinOffset = iabs( DstSgn )
                  StaticAtMinOffset(1) = 0.0 - 
     :                 float(GroupStatic + ShotStatic)/ 
     :                 ( 10. * float(nsi) )
                  if ( QC ) then
                     XgraphCdpAxis(JJ) = float(DphInd)
                     XgraphTimeAxis(JJ) = StaticAtMinOffset(1)
                  endif
               endif

            else

c obtain near offset static from smoothed xgraph data
               if ( StaCor .ne. 30000 ) then
                  call FindStaticToApply( XgraphTimeAxis, XgraphCdpAxis,  
     :                 DphInd, nsampxy, StaticAtMinOffset(1) )
                  done = .true.
               endif

            endif
               
            if ( .not. QC ) then

c load data to Block1 if really processing data and not just in QC mode

               call vmov ( lhed, 1, Headers(IndexHeader), 1, 
     :              ITRWRD )
               call vmov ( lhed( ITHWP1 + start - 1 ), 1, 
     :              Traces(IndexTrace), 1, nsampo )
            endif
         ENDDO

         IF ( .not. QC ) then

C REMOVE datum STATIC FROM ENTIRE RECORD IF NOT IN QC MODE

c reset indices

            IndexHeader = 1 - ITRWRD
            IndexTrace = 1 - nsampo
        
            DO KK = ns, ne

c advance indices

               IndexHeader = IndexHeader + ITRWRD
               IndexTrace = IndexTrace + nsampo

c retrieve header

               call vmov ( Headers(IndexHeader), 1, lhed(1), 1, 
     :              ITRWRD )

c load trace to work space 
                  
               call vmov( Traces(IndexTrace), 1, work, 1, 
     :              nsampo )

c remove static from trace if live

               call saver2 ( lhed, ifmt_StaCor, l_StaCor, ln_StaCor, 
     :              StaCor, TRACEHEADER )

               if ( StaCor .ne. 30000 ) then
                  call ApplyStatic( tri, work, omega, nsampo, 
     :                 ntnew, StaticAtMinOffset(1) )
               else
                  call vclr ( tri, 1, nsampo)
               endif

c write static to user defined trace header mnemonic in 10ths of milliseconds

               Static = nint (StaticAtMinOffset(1) * 10. * 
     :              float(nsi)) 
               call savew2(lhed, ifmt_Static, l_Static, ln_Static,
     :              Static, TRACEHEADER )

c output trace
               
               call vmov( tri, 1, lhed(ITHWP1), 1, nsampo )
               call wrtape ( luout, lhed, obytes )
            ENDDO

c skip to end of record

            call trcskp ( JJ, ne + 1, ntrc, luin, ntrc, lhed )

         ENDIF
      ENDDO

c output xgraph QC file if requested

      if ( QC) call XgraphOut ( luout, XgraphCdpAxis, XgraphTimeAxis, 
     :     nreco )

 999  continue

c clean up
      
      call lbclos ( luin )
      
      if ( .not. QC ) then
         call lbclos ( luout )
      else
         close(luout)
      endif

      write(LERR,*)'Normal Termination, processed ',nreco,' record(s)'
      write(LERR,*)'with ',ntrc,' traces'
      write(LER,*)'ARCSDATUM: Normal Termination'

      stop

 990  continue

c clean up
      
      call lbclos ( luin )
      call lbclos ( luout )

      write(LERR,*)'Abnormal Termination'
      write(LER,*)'ARCSDATUM: Abnormal Termination'

      stop

 992  continue

      write(LERR,*)' '
      write(LERR,*)' ARCSDATUM: Cannot open output xgraph file'
      write(LERR,*)'       Check write permissions in current '
      write(LERR,*)'       directory and try again.'
      write(LERR,*)'  '
      write(LERR,*)' FATAL'
      write(LER,*)' '
      write(LER,*)' ARCSDATUM: Cannot open output xgraph file'
      write(LER,*)'       Check write permissions in current '
      write(LER,*)'       directory and try again.'
      write(LER,*)'  '
      write(LER,*)' FATAL'
      stop

 993  continue

      write(LERR,*)' '
      write(LERR,*)' ARCSDATUM: Cannot open input xgraph or plotxy file'
      write(LERR,*)'       Check permissions/existence and try again.'
      write(LERR,*)'  '
      write(LERR,*)' FATAL'
      write(LER,*)' '
      write(LER,*)' ARCSDATUM: Cannot open input xgraph or plotxy file'
      write(LER,*)'       Check permissions/existence and try again.'
      write(LER,*)'  '
      write(LER,*)' FATAL'
      stop
      end

      



 
