C***********************************************************************
C                 copyright 2001, Amoco Production Company             *
C                             All Rights Reserved                      *
C                     an affiliate of BP America Inc.                  *
C***********************************************************************
      subroutine Feeder( luin, itr, tri, nsamp, ntrc, Record,
     :     ShotHeaders, JJ )

#include <f77/iounit.h>
#include <f77/lhdrsz.h>

      integer luin, itr( SZLNHD ), nsamp, ntrc, JJ
      integer KK, lbytes, index, hindex

      integer ShotHeaders(*)

      real tri( 2* SZLNHD ), Record(ntrc*nsamp)

c initialize variables

      index = 1 - nsamp
      hindex = 1 - ITRWRD

c read record from input

      do KK = 1, ntrc
         
         call rtape(luin,itr,lbytes)
         if(lbytes.eq.0)goto 999

c advance array indices

         index = index + nsamp
         hindex = hindex + ITRWRD

c move record and header to workspace

         call vmov (itr(ITHWP1), 1, Record(index), 1, nsamp)
         call vmov(itr, 1, ShotHeaders(hindex), 1, ITRWRD)
      enddo
      return

 999  continue

      write(LERR,*)' '
      write(LERR,*)' SARCS: Premature EOF on input data.'
      write(LERR,*)'        Check command line parameters and'
      write(LERR,*)'        and rerun.'
      write(LERR,*)' '
      write(LERR,*)' FATAL'
      
      write(LER,*)' '
      write(LER,*)' SARCS: Premature EOF on input data.'
      write(LER,*)'        Check command line parameters and'
      write(LER,*)'        and rerun.'
      write(LER,*)' '
      write(LER,*)' FATAL'

      stop
      end
      
